/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.faultSurface;

import java.util.Iterator;
import java.util.List;
import org.opensha.commons.exceptions.FaultException;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.geo.LocationVector;
import org.opensha.sha.faultSurface.AbstractEvenlyGriddedSurface;
import org.opensha.sha.faultSurface.EvenlyGriddedSurfFromSimpleFaultData;
import org.opensha.sha.faultSurface.FaultTrace;
import org.opensha.sha.faultSurface.SimpleFaultData;

public class StirlingGriddedSurface
extends EvenlyGriddedSurfFromSimpleFaultData {
    private static final long serialVersionUID = 1L;
    protected static final String C = "StirlingGriddedSurface";
    protected static final boolean D = false;
    protected double aveDipDir = Double.NaN;
    protected static final double PI_RADIANS = Math.PI / 180;
    protected static final String ERR = " is null, unable to process.";

    public StirlingGriddedSurface(SimpleFaultData simpleFaultData, double gridSpacing) throws FaultException {
        super(simpleFaultData, gridSpacing);
        this.aveDipDir = simpleFaultData.getAveDipDir();
        this.createEvenlyGriddedSurface();
    }

    public StirlingGriddedSurface(FaultTrace faultTrace, double aveDip, double upperSeismogenicDepth, double lowerSeismogenicDepth, double gridSpacing) throws FaultException {
        super(faultTrace, aveDip, upperSeismogenicDepth, lowerSeismogenicDepth, gridSpacing);
        this.createEvenlyGriddedSurface();
    }

    public StirlingGriddedSurface(SimpleFaultData simpleFaultData, double maxGridSpacingAlong, double maxGridSpacingDown) throws FaultException {
        super(simpleFaultData, maxGridSpacingAlong, maxGridSpacingDown);
        this.aveDipDir = simpleFaultData.getAveDipDir();
        this.createEvenlyGriddedSurface();
    }

    public StirlingGriddedSurface(FaultTrace faultTrace, double aveDip, double upperSeismogenicDepth, double lowerSeismogenicDepth, double gridSpacing, double aveDipDir) throws FaultException {
        super(faultTrace, aveDip, upperSeismogenicDepth, lowerSeismogenicDepth, gridSpacing);
        this.aveDipDir = aveDipDir;
        this.createEvenlyGriddedSurface();
    }

    public StirlingGriddedSurface(List<SimpleFaultData> simpleFaultData, double gridSpacing) throws FaultException {
        super(simpleFaultData, gridSpacing);
        this.createEvenlyGriddedSurface();
    }

    private StirlingGriddedSurface() {
    }

    @Override
    public double getAveDipDirection() {
        return this.aveDipDir;
    }

    private void createEvenlyGriddedSurface() throws FaultException {
        Location firstLoc;
        String S = "StirlingGriddedSurface: createEvenlyGriddedSurface():";
        this.assertValidData();
        int numSegments = this.faultTrace.getNumLocations() - 1;
        double avDipRadians = this.aveDip * (Math.PI / 180);
        double gridSpacingCosAveDipRadians = this.gridSpacingDown * Math.cos(avDipRadians);
        double gridSpacingSinAveDipRadians = this.gridSpacingDown * Math.sin(avDipRadians);
        double[] segmentLenth = new double[numSegments];
        double[] segmentAzimuth = new double[numSegments];
        double[] segmentCumLenth = new double[numSegments];
        double cumDistance = 0.0;
        int i = 0;
        double aveDipDirection = Double.isNaN(this.aveDipDir) ? this.faultTrace.getDipDirection() : this.aveDipDir;
        Iterator it = this.faultTrace.iterator();
        Location lastLoc = firstLoc = (Location)it.next();
        Location loc = null;
        LocationVector dir = null;
        while (it.hasNext()) {
            loc = (Location)it.next();
            dir = LocationUtils.vector(lastLoc, loc);
            double azimuth = dir.getAzimuth();
            double distance = dir.getHorzDistance();
            segmentLenth[i] = distance;
            segmentAzimuth[i] = azimuth;
            segmentCumLenth[i] = cumDistance += distance;
            ++i;
            lastLoc = loc;
        }
        double downDipWidth = (this.lowerSeismogenicDepth - this.upperSeismogenicDepth) / Math.sin(avDipRadians);
        int rows = 1 + Math.round((float)(downDipWidth / this.gridSpacingDown));
        int cols = 1 + Math.round((float)(segmentCumLenth[numSegments - 1] / this.gridSpacingAlong));
        this.setNumRowsAndNumCols(rows, cols);
        for (int ith_col = 0; ith_col < cols; ++ith_col) {
            int segmentNumber;
            double distanceAlong = (double)ith_col * this.gridSpacingAlong;
            for (segmentNumber = 1; segmentNumber <= numSegments && distanceAlong > segmentCumLenth[segmentNumber - 1]; ++segmentNumber) {
            }
            if (segmentNumber == numSegments + 1) {
                --segmentNumber;
            }
            double distance = segmentNumber > 1 ? distanceAlong - segmentCumLenth[segmentNumber - 2] : distanceAlong;
            Location location1 = (Location)this.faultTrace.get(segmentNumber - 1);
            dir = new LocationVector(segmentAzimuth[segmentNumber - 1], distance, 0.0);
            Location traceLocation = LocationUtils.location(location1, dir);
            Location topLocation = StirlingGriddedSurface.getTopLocation(traceLocation, this.upperSeismogenicDepth, avDipRadians, aveDipDirection);
            this.set(0, ith_col, topLocation.clone());
            for (int ith_row = 1; ith_row < rows; ++ith_row) {
                double hDistance = (double)ith_row * gridSpacingCosAveDipRadians;
                double vDistance = (double)ith_row * gridSpacingSinAveDipRadians;
                dir = new LocationVector(aveDipDirection, hDistance, vDistance);
                Location depthLocation = LocationUtils.location(topLocation, dir);
                this.set(ith_row, ith_col, depthLocation.clone());
            }
        }
    }

    public static Location getTopLocation(Location traceLoc, double upperSeismogenicDepth, double aveDipRadians, double aveDipDirection) {
        if (traceLoc.getDepth() < upperSeismogenicDepth) {
            double vDistance = upperSeismogenicDepth - traceLoc.getDepth();
            double hDistance = vDistance / Math.tan(aveDipRadians);
            LocationVector dir = new LocationVector(aveDipDirection, hDistance, vDistance);
            return LocationUtils.location(traceLoc, dir);
        }
        return traceLoc;
    }

    @Override
    public LocationList getPerimeter() {
        LocationList topTrace = new LocationList();
        LocationList botTrace = new LocationList();
        double avDipRadians = this.aveDip * (Math.PI / 180);
        double aveDipDirection = Double.isNaN(this.aveDipDir) ? this.faultTrace.getDipDirection() : this.aveDipDir;
        for (Location traceLoc : this.faultTrace) {
            double vDistance = this.upperSeismogenicDepth - traceLoc.getDepth();
            double hDistance = vDistance / Math.tan(avDipRadians);
            LocationVector dir = new LocationVector(aveDipDirection, hDistance, vDistance);
            Location topLoc = LocationUtils.location(traceLoc, dir);
            topTrace.add(topLoc);
            vDistance = this.lowerSeismogenicDepth - traceLoc.getDepth();
            hDistance = vDistance / Math.tan(avDipRadians);
            dir = new LocationVector(aveDipDirection, hDistance, vDistance);
            Location botLoc = LocationUtils.location(traceLoc, dir);
            botTrace.add(botLoc);
        }
        LocationList perimiter = new LocationList();
        perimiter.addAll(topTrace);
        botTrace.reverse();
        perimiter.addAll(botTrace);
        perimiter.add((Location)topTrace.get(0));
        return perimiter;
    }

    public static void main(String[] args) {
        double test = 4.0;
        System.out.println(test);
    }

    @Override
    protected AbstractEvenlyGriddedSurface getNewInstance() {
        StirlingGriddedSurface surf = new StirlingGriddedSurface();
        surf.setNumRowsAndNumCols(this.numRows, this.numCols);
        surf.aveDipDir = this.aveDipDir;
        surf.faultTrace = this.faultTrace;
        surf.aveDip = this.aveDip;
        surf.upperSeismogenicDepth = this.upperSeismogenicDepth;
        surf.lowerSeismogenicDepth = this.lowerSeismogenicDepth;
        surf.gridSpacingAlong = this.gridSpacingAlong;
        surf.gridSpacingDown = this.gridSpacingDown;
        surf.sameGridSpacing = this.sameGridSpacing;
        surf.name = this.name;
        return surf;
    }
}

