/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.faultSurface.cache;

import java.util.concurrent.TimeUnit;
import org.opensha.commons.geo.Location;
import org.opensha.sha.faultSurface.cache.CacheEnabledSurface;
import org.opensha.sha.faultSurface.cache.MultiDistanceCache;
import org.opensha.sha.faultSurface.cache.SingleLocDistanceCache;
import org.opensha.sha.faultSurface.cache.SurfaceDistanceCache;
import org.opensha.sha.faultSurface.cache.SurfaceDistances;

public class HybridDistanceCache
implements SurfaceDistanceCache {
    private SingleLocDistanceCache singleCache;
    private MultiDistanceCache multiCache;

    public HybridDistanceCache(CacheEnabledSurface surf) {
        this(surf, Runtime.getRuntime().availableProcessors() + 5);
    }

    public HybridDistanceCache(CacheEnabledSurface surf, int maxSize) {
        this(surf, maxSize, 0L, TimeUnit.HOURS);
    }

    public HybridDistanceCache(CacheEnabledSurface surf, int maxSize, long expirationTime, TimeUnit expirationUnit) {
        this.singleCache = new SingleLocDistanceCache(surf);
        this.multiCache = new MultiDistanceCache(surf, maxSize, expirationTime, expirationUnit);
    }

    @Override
    public SurfaceDistances getSurfaceDistances(Location loc) {
        SurfaceDistances surfDists = this.singleCache.getSurfaceDistancesIfPresent(loc);
        if (surfDists != null) {
            return surfDists;
        }
        surfDists = this.multiCache.getSurfaceDistances(loc);
        this.singleCache.putSurfaceDistances(loc, surfDists);
        return surfDists;
    }

    @Override
    public double getQuickDistance(Location loc) {
        Double quickDist = this.singleCache.getQuickDistanceIfPresent(loc);
        if (quickDist != null) {
            return quickDist;
        }
        quickDist = this.multiCache.getQuickDistance(loc);
        this.singleCache.putQuickDistance(loc, quickDist);
        return quickDist;
    }

    @Override
    public double getDistanceX(Location loc) {
        Double distX = this.singleCache.getDistanceXIfPresent(loc);
        if (distX != null) {
            return distX;
        }
        distX = this.multiCache.getDistanceX(loc);
        this.singleCache.putDistanceX(loc, distX);
        return distX;
    }

    @Override
    public void clearCache() {
        this.singleCache.clearCache();
        this.multiCache.clearCache();
    }
}

