/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.faultSurface.cache;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.opensha.commons.geo.Location;
import org.opensha.sha.faultSurface.cache.CacheEnabledSurface;
import org.opensha.sha.faultSurface.cache.SingleLocDistanceCache;
import org.opensha.sha.faultSurface.cache.SurfaceDistanceCache;
import org.opensha.sha.faultSurface.cache.SurfaceDistances;

public class ThreadLocalSingleLocDistanceCache
implements SurfaceDistanceCache {
    private CacheEnabledSurface surf;
    private ConcurrentMap<Thread, SingleLocDistanceCache> threadCaches;
    private int prefMaxSize;

    public ThreadLocalSingleLocDistanceCache(CacheEnabledSurface surf, int prefMaxSize) {
        this.surf = surf;
        this.prefMaxSize = prefMaxSize;
        this.threadCaches = new ConcurrentHashMap<Thread, SingleLocDistanceCache>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SurfaceDistanceCache getCache() {
        Thread thread = Thread.currentThread();
        SingleLocDistanceCache cache = (SingleLocDistanceCache)this.threadCaches.get(thread);
        if (cache == null) {
            this.threadCaches.putIfAbsent(thread, new SingleLocDistanceCache(this.surf));
            cache = (SingleLocDistanceCache)this.threadCaches.get(thread);
            Preconditions.checkNotNull((Object)cache);
            if (this.threadCaches.size() > this.prefMaxSize) {
                ConcurrentMap<Thread, SingleLocDistanceCache> concurrentMap = this.threadCaches;
                synchronized (concurrentMap) {
                    ArrayList<Thread> toRemove = null;
                    for (Thread oThread : this.threadCaches.keySet()) {
                        if (oThread.isAlive()) continue;
                        if (toRemove == null) {
                            toRemove = new ArrayList<Thread>();
                        }
                        toRemove.add(thread);
                    }
                    if (toRemove != null) {
                        for (Thread oThread : toRemove) {
                            this.threadCaches.remove(oThread);
                        }
                    }
                }
            }
        }
        return cache;
    }

    @Override
    public SurfaceDistances getSurfaceDistances(Location loc) {
        return this.getCache().getSurfaceDistances(loc);
    }

    @Override
    public double getQuickDistance(Location loc) {
        return this.getCache().getQuickDistance(loc);
    }

    @Override
    public double getDistanceX(Location loc) {
        return this.getCache().getDistanceX(loc);
    }

    @Override
    public synchronized void clearCache() {
        this.threadCaches.clear();
    }
}

