/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.gcim;

import java.util.HashMap;
import java.util.Map;
import org.opensha.sha.gcim.imCorrRel.ImCorrelationRelationship;
import org.opensha.sha.util.TectonicRegionType;

public class Utils {
    public static HashMap<TectonicRegionType, ImCorrelationRelationship> wrapInHashMap(ImCorrelationRelationship imCorrRel) {
        HashMap<TectonicRegionType, ImCorrelationRelationship> imCorrRelMap = new HashMap<TectonicRegionType, ImCorrelationRelationship>();
        imCorrRelMap.put(TectonicRegionType.ACTIVE_SHALLOW, imCorrRel);
        return imCorrRelMap;
    }

    public static ImCorrelationRelationship getIMCorrRelForTRT(Map<TectonicRegionType, ImCorrelationRelationship> imCorrRelMap, TectonicRegionType trt) {
        ImCorrelationRelationship imCorrRel;
        if (trt == null) {
            throw new IllegalArgumentException("Tectonic Region Type cannot be null!");
        }
        if (imCorrRelMap.size() > 1) {
            imCorrRel = imCorrRelMap.get(trt);
            if (imCorrRel.isTectonicRegionSupported(trt.toString())) {
                imCorrRel.getParameter("Tectonic Region").setValue(trt.toString());
            } else {
                imCorrRel.getParameter("Tectonic Region").setValueAsDefault();
            }
        } else {
            imCorrRel = Utils.getFirstIMCorrRel(imCorrRelMap);
        }
        return imCorrRel;
    }

    public static ImCorrelationRelationship getFirstIMCorrRel(Map<TectonicRegionType, ImCorrelationRelationship> imCorrRelMap) {
        return imCorrRelMap.values().iterator().next();
    }
}

