/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.gcim.calc;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.ListIterator;
import org.opensha.commons.data.Site;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.geo.Location;
import org.opensha.commons.param.Parameter;
import org.opensha.sha.calc.HazardCurveCalculator;
import org.opensha.sha.earthquake.ERF;
import org.opensha.sha.gcim.calc.FakeFrankel96;
import org.opensha.sha.gcim.calc.GcimCalculator;
import org.opensha.sha.gcim.imCorrRel.imCorrRelImpl.BakerJayaram08_ImCorrRel;
import org.opensha.sha.gcim.ui.infoTools.IMT_Info;
import org.opensha.sha.imr.ScalarIMR;
import org.opensha.sha.imr.attenRelImpl.CB_2008_AttenRel;
import org.opensha.sha.util.TectonicRegionType;

public class HardCodedGCIMTest {
    private static void setSAPeriodInIMR(ScalarIMR imr, double period) {
        imr.getIntensityMeasure().getIndependentParameter("SA Period").setValue(period);
    }

    private static void overrideSiteParams(ScalarIMR imri, Site site) {
        ListIterator<Parameter<?>> imriParamIt = imri.getSiteParamsIterator();
        ListIterator<Parameter<?>> siteParamIt = site.getParametersIterator();
        while (imriParamIt.hasNext()) {
            Parameter<?> siteParamImri = imriParamIt.next();
            while (siteParamIt.hasNext()) {
                Parameter<?> siteParam = siteParamIt.next();
                if (siteParamImri != siteParam) continue;
            }
        }
    }

    public static void main(String[] args) throws RemoteException {
        FakeFrankel96 erf = new FakeFrankel96();
        erf.updateForecast();
        ArbitrarilyDiscretizedFunc magDistFilter = null;
        CB_2008_AttenRel imr = new CB_2008_AttenRel(null);
        imr.setParamDefaults();
        HashMap<TectonicRegionType, ScalarIMR> imrMap = new HashMap<TectonicRegionType, ScalarIMR>();
        imrMap.put(TectonicRegionType.ACTIVE_SHALLOW, imr);
        double period_IMj = 1.0;
        double maxDist = 200.0;
        imr.setIntensityMeasure("SA");
        HardCodedGCIMTest.setSAPeriodInIMR(imr, period_IMj);
        Site site = new Site(new Location(34.0, -118.0));
        ListIterator<Parameter<?>> paramIt = imr.getSiteParamsIterator();
        while (paramIt.hasNext()) {
            Parameter<?> siteParam = paramIt.next();
            site.addParameter((Parameter)siteParam.clone());
        }
        IMT_Info imtInfo = new IMT_Info();
        ArbitrarilyDiscretizedFunc hazFunction = imtInfo.getDefaultHazardCurve("SA");
        double iml = Math.log(0.2);
        int numIMi = 6;
        ArrayList imiMapAttenRels = new ArrayList();
        ArrayList<String> imiTypes = new ArrayList<String>();
        ArrayList imijMapCorrRels = new ArrayList();
        ArrayList imiPeriods = new ArrayList();
        String imiType = "SA";
        double imiPeriod = 0.1;
        CB_2008_AttenRel imri = new CB_2008_AttenRel(null);
        HashMap<TectonicRegionType, CB_2008_AttenRel> imriMap = new HashMap<TectonicRegionType, CB_2008_AttenRel>();
        imriMap.put(TectonicRegionType.ACTIVE_SHALLOW, imri);
        BakerJayaram08_ImCorrRel imijCorrRel = new BakerJayaram08_ImCorrRel();
        HashMap<TectonicRegionType, BakerJayaram08_ImCorrRel> imijCorrRelMap = new HashMap<TectonicRegionType, BakerJayaram08_ImCorrRel>();
        imijCorrRelMap.put(TectonicRegionType.ACTIVE_SHALLOW, imijCorrRel);
        imri.setParamDefaults();
        imri.setIntensityMeasure(imiType);
        HardCodedGCIMTest.setSAPeriodInIMR(imri, imiPeriod);
        imiTypes.add(imiType);
        imiMapAttenRels.add(imriMap);
        imijMapCorrRels.add(imijCorrRelMap);
        imiType = "SA";
        imiPeriod = 0.2;
        imri = new CB_2008_AttenRel(null);
        imriMap = new HashMap();
        imriMap.put(TectonicRegionType.ACTIVE_SHALLOW, imri);
        imijCorrRel = new BakerJayaram08_ImCorrRel();
        imijCorrRelMap = new HashMap();
        imijCorrRelMap.put(TectonicRegionType.ACTIVE_SHALLOW, imijCorrRel);
        imri.setParamDefaults();
        imri.setIntensityMeasure(imiType);
        HardCodedGCIMTest.setSAPeriodInIMR(imri, imiPeriod);
        imiTypes.add(imiType);
        imiMapAttenRels.add(imriMap);
        imijMapCorrRels.add(imijCorrRelMap);
        imiType = "SA";
        imiPeriod = 1.0;
        imri = new CB_2008_AttenRel(null);
        imriMap = new HashMap();
        imriMap.put(TectonicRegionType.ACTIVE_SHALLOW, imri);
        imijCorrRel = new BakerJayaram08_ImCorrRel();
        imijCorrRelMap = new HashMap();
        imijCorrRelMap.put(TectonicRegionType.ACTIVE_SHALLOW, imijCorrRel);
        imri.setParamDefaults();
        imri.setIntensityMeasure(imiType);
        HardCodedGCIMTest.setSAPeriodInIMR(imri, imiPeriod);
        imiTypes.add(imiType);
        imiMapAttenRels.add(imriMap);
        imijMapCorrRels.add(imijCorrRelMap);
        HazardCurveCalculator curveCalc = new HazardCurveCalculator();
        curveCalc.getHazardCurve((DiscretizedFunc)hazFunction, site, imrMap, (ERF)erf);
        GcimCalculator gcimCalc = new GcimCalculator();
        HazardCurveCalculator hazardCalc = new HazardCurveCalculator();
        gcimCalc.getRuptureContributions(iml, site, imrMap, erf, hazardCalc.getSourceFilters(), hazardCalc.getAdjustableParams());
        gcimCalc.getMultipleGcims(numIMi, imiMapAttenRels, imiTypes, imijMapCorrRels, maxDist, magDistFilter);
        gcimCalc.printResultsToConsole();
        System.exit(0);
    }
}

