/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.gcim.imCorrRel.imCorrRelImpl;

import org.opensha.commons.param.constraint.impl.StringConstraint;
import org.opensha.sha.gcim.imCorrRel.ImCorrelationRelationship;
import org.opensha.sha.gcim.imr.param.IntensityMeasureParams.ASI_Param;
import org.opensha.sha.gcim.imr.param.IntensityMeasureParams.CAV_Param;
import org.opensha.sha.gcim.imr.param.IntensityMeasureParams.DSI_Param;
import org.opensha.sha.gcim.imr.param.IntensityMeasureParams.Ds575_Param;
import org.opensha.sha.gcim.imr.param.IntensityMeasureParams.Ds595_Param;
import org.opensha.sha.gcim.imr.param.IntensityMeasureParams.SI_Param;
import org.opensha.sha.imr.param.IntensityMeasureParams.DampingParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.PGA_Param;
import org.opensha.sha.imr.param.IntensityMeasureParams.PGV_Param;
import org.opensha.sha.imr.param.IntensityMeasureParams.PeriodInterpolatedParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.SA_InterpolatedParam;
import org.opensha.sha.imr.param.OtherParams.TectonicRegionTypeParam;
import org.opensha.sha.util.TectonicRegionType;

public class Bradley11_ImCorrRel
extends ImCorrelationRelationship {
    static final String C = "Bradley11_ImCorrRel";
    public static final String NAME = "Bradley (2011)";
    public static final String SHORT_NAME = "Bradley2011";
    private static final long serialVersionUID = 1234567890987654353L;
    public static final String TRT_ACTIVE_SHALLOW = TectonicRegionType.ACTIVE_SHALLOW.toString();
    private double t_min = 0.01;
    private double t_max = 10.0;

    public Bradley11_ImCorrRel() {
        this.initOtherParams();
        this.initSupportedIntensityMeasureParams();
        this.ti = Double.NaN;
    }

    @Override
    public double getImCorrelation() {
        if (this.imi.getName() == "SA Interpolated" && this.imj.getName() == "PGA" || this.imi.getName() == "PGA" && this.imj.getName() == "SA Interpolated") {
            double[] a = new double[]{1.0, 0.97};
            double[] b = new double[]{0.895, 0.25};
            double[] c = new double[]{0.06, 0.8};
            double[] d = new double[]{1.6, 0.8};
            double[] e = new double[]{0.2, 10.0};
            if (this.imi.getName() == "SA Interpolated") {
                this.ti = (Double)((SA_InterpolatedParam)this.imi).getPeriodInterpolatedParam().getValue();
            } else if (this.imj.getName() == "SA Interpolated") {
                this.ti = (Double)((SA_InterpolatedParam)this.imj).getPeriodInterpolatedParam().getValue();
            }
            for (int i = 0; i < a.length; ++i) {
                if (!(this.ti <= e[i])) continue;
                return (a[i] + b[i]) / 2.0 - (a[i] - b[i]) / 2.0 * Math.tanh(d[i] * Math.log(this.ti / c[i]));
            }
            return Double.NaN;
        }
        if (this.imi.getName() == "SA Interpolated" && this.imj.getName() == "SI" || this.imi.getName() == "SI" && this.imj.getName() == "SA Interpolated") {
            double[] a = new double[]{0.6, 0.38, 0.95};
            double[] b = new double[]{0.38, 0.94, 0.68};
            double[] c = new double[]{0.045, 0.33, 3.1};
            double[] d = new double[]{1.5, 1.4, 1.6};
            double[] e = new double[]{0.1, 1.4, 10.0};
            if (this.imi.getName() == "SA Interpolated") {
                this.ti = (Double)((SA_InterpolatedParam)this.imi).getPeriodInterpolatedParam().getValue();
            } else if (this.imj.getName() == "SA Interpolated") {
                this.ti = (Double)((SA_InterpolatedParam)this.imj).getPeriodInterpolatedParam().getValue();
            }
            for (int i = 0; i < a.length; ++i) {
                if (!(this.ti <= e[i])) continue;
                return (a[i] + b[i]) / 2.0 - (a[i] - b[i]) / 2.0 * Math.tanh(d[i] * Math.log(this.ti / c[i]));
            }
            return Double.NaN;
        }
        if (this.imi.getName() == "SA Interpolated" && this.imj.getName() == "ASI" || this.imi.getName() == "ASI" && this.imj.getName() == "SA Interpolated") {
            double[] a = new double[]{0.927, 0.823, 1.05};
            double[] b = new double[]{0.823, 0.962, 0.29};
            double[] c = new double[]{0.04, 0.14, 0.8};
            double[] d = new double[]{1.8, 2.2, 1.0};
            double[] e = new double[]{0.075, 0.3, 10.0};
            if (this.imi.getName() == "SA Interpolated") {
                this.ti = (Double)((SA_InterpolatedParam)this.imi).getPeriodInterpolatedParam().getValue();
            } else if (this.imj.getName() == "SA Interpolated") {
                this.ti = (Double)((SA_InterpolatedParam)this.imj).getPeriodInterpolatedParam().getValue();
            }
            for (int i = 0; i < a.length; ++i) {
                if (!(this.ti <= e[i])) continue;
                return (a[i] + b[i]) / 2.0 - (a[i] - b[i]) / 2.0 * Math.tanh(d[i] * Math.log(this.ti / c[i]));
            }
            return Double.NaN;
        }
        if (this.imi.getName() == "PGA" && this.imj.getName() == "SI" || this.imi.getName() == "SI" && this.imj.getName() == "PGA") {
            return 0.599;
        }
        if (this.imi.getName() == "ASI" && this.imj.getName() == "PGA" || this.imi.getName() == "PGA" && this.imj.getName() == "ASI") {
            return 0.928;
        }
        if (this.imi.getName() == "ASI" && this.imj.getName() == "SI" || this.imi.getName() == "SI" && this.imj.getName() == "ASI") {
            return 0.641;
        }
        if (this.imi.getName() == "PGV" && this.imj.getName() == "PGA" || this.imi.getName() == "PGA" && this.imj.getName() == "PGV") {
            return 0.733;
        }
        if (this.imi.getName() == "PGV" && this.imj.getName() == "SI" || this.imi.getName() == "SI" && this.imj.getName() == "PGV") {
            return 0.886;
        }
        if (this.imi.getName() == "PGV" && this.imj.getName() == "ASI" || this.imi.getName() == "ASI" && this.imj.getName() == "PGV") {
            return 0.73;
        }
        if (this.imi.getName() == "SA Interpolated" && this.imj.getName() == "PGV" || this.imi.getName() == "PGV" && this.imj.getName() == "SA Interpolated") {
            double[] a = new double[]{0.73, 0.54, 0.8, 0.76};
            double[] b = new double[]{0.54, 0.81, 0.76, 0.7};
            double[] c = new double[]{0.045, 0.28, 1.1, 5.0};
            double[] d = new double[]{1.8, 1.5, 3.0, 3.2};
            double[] e = new double[]{0.1, 0.75, 2.5, 10.0};
            if (this.imi.getName() == "SA Interpolated") {
                this.ti = (Double)((SA_InterpolatedParam)this.imi).getPeriodInterpolatedParam().getValue();
            } else if (this.imj.getName() == "SA Interpolated") {
                this.ti = (Double)((SA_InterpolatedParam)this.imj).getPeriodInterpolatedParam().getValue();
            }
            for (int i = 0; i < a.length; ++i) {
                if (!(this.ti <= e[i])) continue;
                return (a[i] + b[i]) / 2.0 - (a[i] - b[i]) / 2.0 * Math.tanh(d[i] * Math.log(this.ti / c[i]));
            }
            return Double.NaN;
        }
        if (this.imi.getName() == "DSI" && this.imj.getName() == "PGA" || this.imi.getName() == "PGA" && this.imj.getName() == "DSI") {
            return 0.395;
        }
        if (this.imi.getName() == "DSI" && this.imj.getName() == "PGV" || this.imi.getName() == "PGV" && this.imj.getName() == "DSI") {
            return 0.8;
        }
        if (this.imi.getName() == "DSI" && this.imj.getName() == "ASI" || this.imi.getName() == "ASI" && this.imj.getName() == "DSI") {
            return 0.376;
        }
        if (this.imi.getName() == "DSI" && this.imj.getName() == "SI" || this.imi.getName() == "SI" && this.imj.getName() == "DSI") {
            return 0.782;
        }
        if (this.imi.getName() == "SA Interpolated" && this.imj.getName() == "DSI" || this.imi.getName() == "DSI" && this.imj.getName() == "SA Interpolated") {
            double[] a = new double[]{0.39, 0.19, 0.98};
            double[] b = new double[]{0.265, 1.2, 0.82};
            double[] c = new double[]{0.04, 1.2, 6.1};
            double[] d = new double[]{1.8, 0.6, 3.0};
            double[] e = new double[]{0.15, 3.4, 10.0};
            if (this.imi.getName() == "SA Interpolated") {
                this.ti = (Double)((SA_InterpolatedParam)this.imi).getPeriodInterpolatedParam().getValue();
            } else if (this.imj.getName() == "SA Interpolated") {
                this.ti = (Double)((SA_InterpolatedParam)this.imj).getPeriodInterpolatedParam().getValue();
            }
            for (int i = 0; i < a.length; ++i) {
                if (!(this.ti <= e[i])) continue;
                return (a[i] + b[i]) / 2.0 - (a[i] - b[i]) / 2.0 * Math.tanh(d[i] * Math.log(this.ti / c[i]));
            }
            return Double.NaN;
        }
        if (this.imi.getName() == "CAV" && this.imj.getName() == "PGA" || this.imi.getName() == "PGA" && this.imj.getName() == "CAV") {
            return 0.7;
        }
        if (this.imi.getName() == "CAV" && this.imj.getName() == "PGV" || this.imi.getName() == "PGV" && this.imj.getName() == "CAV") {
            return 0.691;
        }
        if (this.imi.getName() == "CAV" && this.imj.getName() == "ASI" || this.imi.getName() == "ASI" && this.imj.getName() == "CAV") {
            return 0.703;
        }
        if (this.imi.getName() == "CAV" && this.imj.getName() == "SI" || this.imi.getName() == "SI" && this.imj.getName() == "CAV") {
            return 0.681;
        }
        if (this.imi.getName() == "CAV" && this.imj.getName() == "DSI" || this.imi.getName() == "DSI" && this.imj.getName() == "CAV") {
            return 0.565;
        }
        if (this.imi.getName() == "SA Interpolated" && this.imj.getName() == "CAV" || this.imi.getName() == "CAV" && this.imj.getName() == "SA Interpolated") {
            double[] a = new double[]{0.7, 0.635, 0.525};
            double[] b = new double[]{0.635, 0.525, 0.39};
            double[] c = new double[]{0.043, 0.95, 6.2};
            double[] d = new double[]{2.5, 3.0, 4.0};
            double[] e = new double[]{0.2, 3.0, 10.0};
            if (this.imi.getName() == "SA Interpolated") {
                this.ti = (Double)((SA_InterpolatedParam)this.imi).getPeriodInterpolatedParam().getValue();
            } else if (this.imj.getName() == "SA Interpolated") {
                this.ti = (Double)((SA_InterpolatedParam)this.imj).getPeriodInterpolatedParam().getValue();
            }
            for (int i = 1; i < a.length; ++i) {
                if (!(this.ti <= e[i])) continue;
                return (a[i] + b[i]) / 2.0 - (a[i] - b[i]) / 2.0 * Math.tanh(d[i] * Math.log(this.ti / c[i]));
            }
            return Double.NaN;
        }
        if (this.imi.getName() == "Ds575" && this.imj.getName() == "PGA" || this.imi.getName() == "PGA" && this.imj.getName() == "Ds575") {
            return -0.442;
        }
        if (this.imi.getName() == "Ds575" && this.imj.getName() == "PGV" || this.imi.getName() == "PGV" && this.imj.getName() == "Ds575") {
            return -0.259;
        }
        if (this.imi.getName() == "Ds575" && this.imj.getName() == "ASI" || this.imi.getName() == "ASI" && this.imj.getName() == "Ds575") {
            return -0.411;
        }
        if (this.imi.getName() == "Ds575" && this.imj.getName() == "SI" || this.imi.getName() == "SI" && this.imj.getName() == "Ds575") {
            return -0.131;
        }
        if (this.imi.getName() == "Ds575" && this.imj.getName() == "DSI" || this.imi.getName() == "DSI" && this.imj.getName() == "Ds575") {
            return 0.074;
        }
        if (this.imi.getName() == "Ds575" && this.imj.getName() == "CAV" || this.imi.getName() == "CAV" && this.imj.getName() == "Ds575") {
            return 0.077;
        }
        if (this.imi.getName() == "SA Interpolated" && this.imj.getName() == "Ds575" || this.imi.getName() == "Ds575" && this.imj.getName() == "SA Interpolated") {
            double[] a = new double[]{-0.45, -0.39, -0.39, -0.06, 0.16, 0.0};
            double[] b = new double[]{0.01, 0.09, 0.3, 1.4, 6.5, 10.0};
            if (this.imi.getName() == "SA Interpolated") {
                this.ti = (Double)((SA_InterpolatedParam)this.imi).getPeriodInterpolatedParam().getValue();
            } else if (this.imj.getName() == "SA Interpolated") {
                this.ti = (Double)((SA_InterpolatedParam)this.imj).getPeriodInterpolatedParam().getValue();
            }
            for (int i = 1; i < a.length; ++i) {
                if (!(this.ti <= b[i])) continue;
                return a[i - 1] + (a[i] - a[i - 1]) / Math.log(b[i] / b[i - 1]) * Math.log(this.ti / b[i - 1]);
            }
            return Double.NaN;
        }
        if (this.imi.getName() == "Ds595" && this.imj.getName() == "PGA" || this.imi.getName() == "PGA" && this.imj.getName() == "Ds595") {
            return -0.405;
        }
        if (this.imi.getName() == "Ds595" && this.imj.getName() == "PGV" || this.imi.getName() == "PGV" && this.imj.getName() == "Ds595") {
            return -0.211;
        }
        if (this.imi.getName() == "Ds595" && this.imj.getName() == "ASI" || this.imi.getName() == "ASI" && this.imj.getName() == "Ds595") {
            return -0.37;
        }
        if (this.imi.getName() == "Ds595" && this.imj.getName() == "SI" || this.imi.getName() == "SI" && this.imj.getName() == "Ds595") {
            return -0.079;
        }
        if (this.imi.getName() == "Ds595" && this.imj.getName() == "DSI" || this.imi.getName() == "DSI" && this.imj.getName() == "Ds595") {
            return 0.163;
        }
        if (this.imi.getName() == "Ds595" && this.imj.getName() == "CAV" || this.imi.getName() == "CAV" && this.imj.getName() == "Ds595") {
            return 0.122;
        }
        if (this.imi.getName() == "SA Interpolated" && this.imj.getName() == "Ds595" || this.imi.getName() == "Ds595" && this.imj.getName() == "SA Interpolated") {
            double[] a = new double[]{-0.41, -0.41, -0.38, -0.35, -0.02, 0.23, 0.02};
            double[] b = new double[]{0.01, 0.04, 0.08, 0.26, 1.4, 6.0, 10.0};
            if (this.imi.getName() == "SA Interpolated") {
                this.ti = (Double)((SA_InterpolatedParam)this.imi).getPeriodInterpolatedParam().getValue();
            } else if (this.imj.getName() == "SA Interpolated") {
                this.ti = (Double)((SA_InterpolatedParam)this.imj).getPeriodInterpolatedParam().getValue();
            }
            for (int i = 1; i < a.length; ++i) {
                if (!(this.ti <= b[i])) continue;
                return a[i - 1] + (a[i] - a[i - 1]) / Math.log(b[i] / b[i - 1]) * Math.log(this.ti / b[i - 1]);
            }
            return Double.NaN;
        }
        if (this.imi.getName() == "Ds575" && this.imj.getName() == "Ds595" || this.imi.getName() == "Ds595" && this.imj.getName() == "Ds575") {
            return 0.843;
        }
        return Double.NaN;
    }

    @Override
    protected void initOtherParams() {
        super.initOtherParams();
        StringConstraint trtConstraint = new StringConstraint();
        trtConstraint.addString(TRT_ACTIVE_SHALLOW);
        this.tectonicRegionTypeParam = new TectonicRegionTypeParam(trtConstraint, TRT_ACTIVE_SHALLOW);
        this.tectonicRegionTypeParam.setValueAsDefault();
        this.otherParams.replaceParameter("Tectonic Region", this.tectonicRegionTypeParam);
    }

    protected void initSupportedIntensityMeasureParams() {
        this.InterpPeriodiParam = new PeriodInterpolatedParam(this.t_min, this.t_max, 1.0, false);
        this.saiDampingParam = new DampingParam();
        this.saiInterpParam = new SA_InterpolatedParam(this.InterpPeriodiParam, this.saiDampingParam);
        this.saiInterpParam.setNonEditable();
        this.pgaParam = new PGA_Param();
        this.pgaParam.setNonEditable();
        this.siParam = new SI_Param();
        this.siParam.setNonEditable();
        this.asiParam = new ASI_Param();
        this.asiParam.setNonEditable();
        this.pgvParam = new PGV_Param();
        this.pgvParam.setNonEditable();
        this.dsiParam = new DSI_Param();
        this.dsiParam.setNonEditable();
        this.cavParam = new CAV_Param();
        this.cavParam.setNonEditable();
        this.ds575Param = new Ds575_Param();
        this.ds575Param.setNonEditable();
        this.ds595Param = new Ds595_Param();
        this.ds595Param.setNonEditable();
        this.supportedIMiParams.clear();
        this.supportedIMjParams.clear();
        this.supportedIMiParams.add(this.saiInterpParam);
        this.supportedIMjParams.add(this.pgaParam);
        this.supportedIMiParams.add(this.pgaParam);
        this.supportedIMjParams.add(this.saiInterpParam);
        this.supportedIMiParams.add(this.saiInterpParam);
        this.supportedIMjParams.add(this.siParam);
        this.supportedIMiParams.add(this.siParam);
        this.supportedIMjParams.add(this.saiInterpParam);
        this.supportedIMiParams.add(this.saiInterpParam);
        this.supportedIMjParams.add(this.asiParam);
        this.supportedIMiParams.add(this.asiParam);
        this.supportedIMjParams.add(this.saiInterpParam);
        this.supportedIMiParams.add(this.pgaParam);
        this.supportedIMjParams.add(this.siParam);
        this.supportedIMiParams.add(this.siParam);
        this.supportedIMjParams.add(this.pgaParam);
        this.supportedIMiParams.add(this.pgaParam);
        this.supportedIMjParams.add(this.asiParam);
        this.supportedIMiParams.add(this.asiParam);
        this.supportedIMjParams.add(this.pgaParam);
        this.supportedIMiParams.add(this.siParam);
        this.supportedIMjParams.add(this.asiParam);
        this.supportedIMiParams.add(this.asiParam);
        this.supportedIMjParams.add(this.siParam);
        this.supportedIMiParams.add(this.pgvParam);
        this.supportedIMjParams.add(this.pgaParam);
        this.supportedIMiParams.add(this.pgaParam);
        this.supportedIMjParams.add(this.pgvParam);
        this.supportedIMiParams.add(this.pgvParam);
        this.supportedIMjParams.add(this.siParam);
        this.supportedIMiParams.add(this.siParam);
        this.supportedIMjParams.add(this.pgvParam);
        this.supportedIMiParams.add(this.pgvParam);
        this.supportedIMjParams.add(this.asiParam);
        this.supportedIMiParams.add(this.asiParam);
        this.supportedIMjParams.add(this.pgvParam);
        this.supportedIMiParams.add(this.pgvParam);
        this.supportedIMjParams.add(this.saiInterpParam);
        this.supportedIMiParams.add(this.saiInterpParam);
        this.supportedIMjParams.add(this.pgvParam);
        this.supportedIMiParams.add(this.dsiParam);
        this.supportedIMjParams.add(this.pgaParam);
        this.supportedIMiParams.add(this.pgaParam);
        this.supportedIMjParams.add(this.dsiParam);
        this.supportedIMiParams.add(this.dsiParam);
        this.supportedIMjParams.add(this.pgvParam);
        this.supportedIMiParams.add(this.pgvParam);
        this.supportedIMjParams.add(this.dsiParam);
        this.supportedIMiParams.add(this.dsiParam);
        this.supportedIMjParams.add(this.asiParam);
        this.supportedIMiParams.add(this.asiParam);
        this.supportedIMjParams.add(this.dsiParam);
        this.supportedIMiParams.add(this.dsiParam);
        this.supportedIMjParams.add(this.siParam);
        this.supportedIMiParams.add(this.siParam);
        this.supportedIMjParams.add(this.dsiParam);
        this.supportedIMiParams.add(this.dsiParam);
        this.supportedIMjParams.add(this.saiInterpParam);
        this.supportedIMiParams.add(this.saiInterpParam);
        this.supportedIMjParams.add(this.dsiParam);
        this.supportedIMiParams.add(this.cavParam);
        this.supportedIMjParams.add(this.pgaParam);
        this.supportedIMiParams.add(this.pgaParam);
        this.supportedIMjParams.add(this.cavParam);
        this.supportedIMiParams.add(this.cavParam);
        this.supportedIMjParams.add(this.pgvParam);
        this.supportedIMiParams.add(this.pgvParam);
        this.supportedIMjParams.add(this.cavParam);
        this.supportedIMiParams.add(this.cavParam);
        this.supportedIMjParams.add(this.asiParam);
        this.supportedIMiParams.add(this.asiParam);
        this.supportedIMjParams.add(this.cavParam);
        this.supportedIMiParams.add(this.cavParam);
        this.supportedIMjParams.add(this.siParam);
        this.supportedIMiParams.add(this.siParam);
        this.supportedIMjParams.add(this.cavParam);
        this.supportedIMiParams.add(this.cavParam);
        this.supportedIMjParams.add(this.dsiParam);
        this.supportedIMiParams.add(this.dsiParam);
        this.supportedIMjParams.add(this.cavParam);
        this.supportedIMiParams.add(this.cavParam);
        this.supportedIMjParams.add(this.saiInterpParam);
        this.supportedIMiParams.add(this.saiInterpParam);
        this.supportedIMjParams.add(this.cavParam);
        this.supportedIMiParams.add(this.ds575Param);
        this.supportedIMjParams.add(this.pgaParam);
        this.supportedIMiParams.add(this.pgaParam);
        this.supportedIMjParams.add(this.ds575Param);
        this.supportedIMiParams.add(this.ds575Param);
        this.supportedIMjParams.add(this.pgvParam);
        this.supportedIMiParams.add(this.pgvParam);
        this.supportedIMjParams.add(this.ds575Param);
        this.supportedIMiParams.add(this.ds575Param);
        this.supportedIMjParams.add(this.asiParam);
        this.supportedIMiParams.add(this.asiParam);
        this.supportedIMjParams.add(this.ds575Param);
        this.supportedIMiParams.add(this.ds575Param);
        this.supportedIMjParams.add(this.siParam);
        this.supportedIMiParams.add(this.siParam);
        this.supportedIMjParams.add(this.ds575Param);
        this.supportedIMiParams.add(this.ds575Param);
        this.supportedIMjParams.add(this.dsiParam);
        this.supportedIMiParams.add(this.dsiParam);
        this.supportedIMjParams.add(this.ds575Param);
        this.supportedIMiParams.add(this.ds575Param);
        this.supportedIMjParams.add(this.cavParam);
        this.supportedIMiParams.add(this.cavParam);
        this.supportedIMjParams.add(this.ds575Param);
        this.supportedIMiParams.add(this.ds575Param);
        this.supportedIMjParams.add(this.saiInterpParam);
        this.supportedIMiParams.add(this.saiInterpParam);
        this.supportedIMjParams.add(this.ds575Param);
        this.supportedIMiParams.add(this.ds595Param);
        this.supportedIMjParams.add(this.pgaParam);
        this.supportedIMiParams.add(this.pgaParam);
        this.supportedIMjParams.add(this.ds595Param);
        this.supportedIMiParams.add(this.ds595Param);
        this.supportedIMjParams.add(this.pgvParam);
        this.supportedIMiParams.add(this.pgvParam);
        this.supportedIMjParams.add(this.ds595Param);
        this.supportedIMiParams.add(this.ds595Param);
        this.supportedIMjParams.add(this.asiParam);
        this.supportedIMiParams.add(this.asiParam);
        this.supportedIMjParams.add(this.ds595Param);
        this.supportedIMiParams.add(this.ds595Param);
        this.supportedIMjParams.add(this.siParam);
        this.supportedIMiParams.add(this.siParam);
        this.supportedIMjParams.add(this.ds595Param);
        this.supportedIMiParams.add(this.ds595Param);
        this.supportedIMjParams.add(this.dsiParam);
        this.supportedIMiParams.add(this.dsiParam);
        this.supportedIMjParams.add(this.ds595Param);
        this.supportedIMiParams.add(this.ds595Param);
        this.supportedIMjParams.add(this.cavParam);
        this.supportedIMiParams.add(this.cavParam);
        this.supportedIMjParams.add(this.ds595Param);
        this.supportedIMiParams.add(this.ds595Param);
        this.supportedIMjParams.add(this.saiInterpParam);
        this.supportedIMiParams.add(this.saiInterpParam);
        this.supportedIMjParams.add(this.ds595Param);
        this.supportedIMiParams.add(this.ds595Param);
        this.supportedIMjParams.add(this.ds575Param);
        this.supportedIMiParams.add(this.ds575Param);
        this.supportedIMjParams.add(this.ds595Param);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getShortName() {
        return SHORT_NAME;
    }
}

