/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.gcim.imr.attenRelImpl;

import org.opensha.commons.data.Named;
import org.opensha.commons.data.Site;
import org.opensha.commons.exceptions.InvalidRangeException;
import org.opensha.commons.exceptions.ParameterException;
import org.opensha.commons.param.constraint.impl.DoubleConstraint;
import org.opensha.commons.param.constraint.impl.StringConstraint;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.event.ParameterChangeWarningListener;
import org.opensha.sha.earthquake.EqkRupture;
import org.opensha.sha.gcim.imr.param.IntensityMeasureParams.Ds575_Param;
import org.opensha.sha.gcim.imr.param.IntensityMeasureParams.Ds595_Param;
import org.opensha.sha.imr.AttenuationRelationship;
import org.opensha.sha.imr.ScalarIMR;
import org.opensha.sha.imr.param.EqkRuptureParams.MagParam;
import org.opensha.sha.imr.param.EqkRuptureParams.RupTopDepthParam;
import org.opensha.sha.imr.param.OtherParams.Component;
import org.opensha.sha.imr.param.OtherParams.ComponentParam;
import org.opensha.sha.imr.param.OtherParams.StdDevTypeParam;
import org.opensha.sha.imr.param.PropagationEffectParams.DistanceRupParameter;
import org.opensha.sha.imr.param.SiteParams.Vs30_Param;

public class BommerEtAl_2009_AttenRel
extends AttenuationRelationship
implements ScalarIMR,
Named,
ParameterChangeListener {
    private static final String C = "BommerEtAl_2009_AttenRel";
    private static final boolean D = false;
    public static final String SHORT_NAME = "BommerEtAl2009";
    private static final long serialVersionUID = 1234567890987654358L;
    public static final String NAME = "Bommer et al. (2009)";
    double[] c0 = new double[]{-5.6298, -2.2393};
    double[] m1 = new double[]{1.2619, 0.9368};
    double[] r1 = new double[]{2.0063, 1.5686};
    double[] r2 = new double[]{-0.252, -0.1953};
    double[] h1 = new double[]{2.3316, 2.5};
    double[] v1 = new double[]{-0.29, -0.3478};
    double[] z1 = new double[]{-0.0522, -0.0365};
    double[] tau = new double[]{0.3527, 0.3252};
    double[] sigma = new double[]{0.4304, 0.346};
    double[] sigmaC = new double[]{0.1729, 0.1114};
    double[] sigmaT_arb = new double[]{0.5564, 0.4748};
    double[] sigmaT_gm = new double[]{0.5289, 0.4616};
    private int imIndex;
    private double vs30;
    private double rRup;
    private double mag;
    private double depthTop;
    private String stdDevType;
    private Component component;
    private boolean parameterChange;
    protected static final Double MAG_WARN_MIN = 4.8;
    protected static final Double MAG_WARN_MAX = 7.9;
    protected static final Double DISTANCE_RUP_WARN_MIN = 0.0;
    protected static final Double DISTANCE_RUP_WARN_MAX = 100.0;
    protected static final Double VS30_WARN_MIN = 150.0;
    protected static final Double VS30_WARN_MAX = 1500.0;
    protected static final Double RUP_TOP_WARN_MIN = 0.0;
    protected static final Double RUP_TOP_WARN_MAX = 15.0;
    private transient ParameterChangeWarningListener warningListener = null;

    public BommerEtAl_2009_AttenRel(ParameterChangeWarningListener warningListener) {
        this.warningListener = warningListener;
        this.initSupportedIntensityMeasureParams();
        this.initEqkRuptureParams();
        this.initPropagationEffectParams();
        this.initSiteParams();
        this.initOtherParams();
        this.initIndependentParamLists();
        this.initParameterEventListeners();
    }

    @Override
    public void setEqkRupture(EqkRupture eqkRupture) throws InvalidRangeException {
        this.magParam.setValueIgnoreWarning(eqkRupture.getMag());
        this.rupTopDepthParam.setValueIgnoreWarning(eqkRupture.getRuptureSurface().getAveRupTopDepth());
        this.eqkRupture = eqkRupture;
        this.setPropagationEffectParams();
    }

    @Override
    public void setSite(Site site) throws ParameterException {
        this.vs30Param.setValue((Double)site.getParameter("Vs30").getValue());
        this.site = site;
        this.setPropagationEffectParams();
    }

    @Override
    protected void setPropagationEffectParams() {
        if (this.site != null && this.eqkRupture != null) {
            this.distanceRupParam.setValue(this.eqkRupture, this.site);
        }
    }

    protected void setCoeffIndex() throws ParameterException {
        if (this.im == null) {
            throw new ParameterException("BommerEtAl_2009_AttenRel: updateCoefficients(): The Intensity Measusre Parameter has not been set yet, unable to process.");
        }
        if (this.im.getName().equalsIgnoreCase("Ds575")) {
            this.imIndex = 0;
        } else if (this.im.getName().equalsIgnoreCase("Ds595")) {
            this.imIndex = 1;
        }
        this.parameterChange = true;
        this.intensityMeasureChanged = false;
    }

    @Override
    public double getMean() {
        if (this.rRup > this.USER_MAX_DISTANCE) {
            return -35.0;
        }
        if (this.intensityMeasureChanged) {
            this.setCoeffIndex();
        }
        double mean = this.getMean(this.imIndex, this.vs30, this.rRup, this.mag, this.depthTop);
        return mean;
    }

    @Override
    public double getStdDev() {
        if (this.intensityMeasureChanged) {
            this.setCoeffIndex();
        }
        this.component = (Component)this.componentParam.getValue();
        double stdDev = this.getStdDev(this.imIndex, this.stdDevType, this.component);
        return stdDev;
    }

    @Override
    public void setParamDefaults() {
        this.vs30Param.setValueAsDefault();
        this.magParam.setValueAsDefault();
        this.rupTopDepthParam.setValueAsDefault();
        this.distanceRupParam.setValueAsDefault();
        this.ds575Param.setValueAsDefault();
        this.ds595Param.setValueAsDefault();
        this.componentParam.setValueAsDefault();
        this.stdDevTypeParam.setValueAsDefault();
        this.vs30 = (Double)this.vs30Param.getValue();
        this.mag = (Double)this.magParam.getValue();
        this.stdDevType = (String)this.stdDevTypeParam.getValue();
    }

    protected void initIndependentParamLists() {
        this.meanIndependentParams.clear();
        this.meanIndependentParams.addParameter(this.distanceRupParam);
        this.meanIndependentParams.addParameter(this.vs30Param);
        this.meanIndependentParams.addParameter(this.magParam);
        this.meanIndependentParams.addParameter(this.rupTopDepthParam);
        this.meanIndependentParams.addParameter(this.componentParam);
        this.stdDevIndependentParams.clear();
        this.stdDevIndependentParams.addParameter(this.stdDevTypeParam);
        this.stdDevIndependentParams.addParameter(this.componentParam);
        this.exceedProbIndependentParams.clear();
        this.exceedProbIndependentParams.addParameterList(this.meanIndependentParams);
        this.exceedProbIndependentParams.addParameter(this.stdDevTypeParam);
        this.exceedProbIndependentParams.addParameter(this.sigmaTruncTypeParam);
        this.exceedProbIndependentParams.addParameter(this.sigmaTruncLevelParam);
        this.imlAtExceedProbIndependentParams.addParameterList(this.exceedProbIndependentParams);
        this.imlAtExceedProbIndependentParams.addParameter(this.exceedProbParam);
    }

    @Override
    protected void initSiteParams() {
        this.vs30Param = new Vs30_Param(VS30_WARN_MIN, (double)VS30_WARN_MAX);
        this.siteParams.clear();
        this.siteParams.addParameter(this.vs30Param);
    }

    @Override
    protected void initEqkRuptureParams() {
        this.magParam = new MagParam(MAG_WARN_MIN, (double)MAG_WARN_MAX);
        this.rupTopDepthParam = new RupTopDepthParam(RUP_TOP_WARN_MIN, (double)RUP_TOP_WARN_MAX);
        this.eqkRuptureParams.clear();
        this.eqkRuptureParams.addParameter(this.magParam);
        this.eqkRuptureParams.addParameter(this.rupTopDepthParam);
    }

    @Override
    protected void initPropagationEffectParams() {
        this.distanceRupParam = new DistanceRupParameter(0.0);
        DoubleConstraint warn = new DoubleConstraint(DISTANCE_RUP_WARN_MIN, DISTANCE_RUP_WARN_MAX);
        warn.setNonEditable();
        this.distanceRupParam.setWarningConstraint(warn);
        this.distanceRupParam.addParameterChangeWarningListener(this.warningListener);
        this.distanceRupParam.setNonEditable();
        this.propagationEffectParams.addParameter(this.distanceRupParam);
    }

    @Override
    protected void initSupportedIntensityMeasureParams() {
        this.ds575Param = new Ds575_Param();
        this.ds575Param.setNonEditable();
        this.ds595Param = new Ds595_Param();
        this.ds595Param.setNonEditable();
        this.ds575Param.addParameterChangeWarningListener(this.warningListener);
        this.ds595Param.addParameterChangeWarningListener(this.warningListener);
        this.supportedIMParams.clear();
        this.supportedIMParams.addParameter(this.ds575Param);
        this.supportedIMParams.addParameter(this.ds595Param);
    }

    @Override
    protected void initOtherParams() {
        super.initOtherParams();
        this.componentParam = new ComponentParam(Component.AVE_HORZ, Component.AVE_HORZ, Component.RANDOM_HORZ);
        StringConstraint stdDevTypeConstraint = new StringConstraint();
        stdDevTypeConstraint.addString("Total");
        stdDevTypeConstraint.addString("None (zero)");
        stdDevTypeConstraint.addString("Inter-Event");
        stdDevTypeConstraint.addString("Intra-Event");
        stdDevTypeConstraint.setNonEditable();
        this.stdDevTypeParam = new StdDevTypeParam(stdDevTypeConstraint);
        this.otherParams.addParameter(this.componentParam);
        this.otherParams.addParameter(this.stdDevTypeParam);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getShortName() {
        return SHORT_NAME;
    }

    public double getMean(int imIndex, double vs30, double rRup, double mag, double depthTop) {
        double lnDs = this.c0[imIndex] + this.m1[imIndex] * mag + (this.r1[imIndex] + this.r2[imIndex] * mag) * Math.log(Math.sqrt(rRup * rRup + Math.pow(this.h1[imIndex], 2.0))) + this.v1[imIndex] * Math.log(vs30) + this.z1[imIndex] * depthTop;
        return lnDs;
    }

    public double getStdDev(int imIndex, String stdDevType, Component component) {
        if (stdDevType.equals("None (zero)")) {
            return 0.0;
        }
        if (stdDevType.equals("Total")) {
            if (component == Component.AVE_HORZ) {
                return this.sigmaT_gm[imIndex];
            }
            return this.sigmaT_arb[imIndex];
        }
        if (stdDevType.equals("None (zero)")) {
            return 0.0;
        }
        if (stdDevType.equals("Inter-Event")) {
            return this.tau[imIndex];
        }
        if (stdDevType.equals("Intra-Event")) {
            if (component == Component.AVE_HORZ) {
                return this.sigma[imIndex];
            }
            return Math.sqrt(Math.pow(this.sigma[imIndex], 2.0) + Math.pow(this.sigmaC[imIndex], 2.0));
        }
        return Double.NaN;
    }

    @Override
    public void parameterChange(ParameterChangeEvent e) {
        String pName = e.getParameterName();
        Object val = e.getNewValue();
        this.parameterChange = true;
        if (pName.equals("DistanceRup")) {
            this.rRup = (Double)val;
        } else if (pName.equals("Vs30")) {
            this.vs30 = (Double)val;
        } else if (pName.equals("Magnitude")) {
            this.mag = (Double)val;
        } else if (pName.equals("Rupture Top Depth")) {
            this.depthTop = (Double)val;
        } else if (pName.equals("Std Dev Type")) {
            this.stdDevType = (String)val;
        } else if (pName.equals("Component")) {
            this.component = (Component)this.componentParam.getValue();
        }
    }

    @Override
    public void resetParameterEventListeners() {
        this.distanceRupParam.removeParameterChangeListener(this);
        this.vs30Param.removeParameterChangeListener(this);
        this.magParam.removeParameterChangeListener(this);
        this.rupTopDepthParam.removeParameterChangeListener(this);
        this.stdDevTypeParam.removeParameterChangeListener(this);
        this.initParameterEventListeners();
    }

    @Override
    protected void initParameterEventListeners() {
        this.distanceRupParam.addParameterChangeListener(this);
        this.vs30Param.addParameterChangeListener(this);
        this.magParam.addParameterChangeListener(this);
        this.rupTopDepthParam.addParameterChangeListener(this);
        this.stdDevTypeParam.addParameterChangeListener(this);
    }
}

