/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.gcim.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.opensha.commons.data.Site;
import org.opensha.commons.gui.ControlPanel;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.constraint.ParameterConstraint;
import org.opensha.commons.param.constraint.impl.StringConstraint;
import org.opensha.commons.param.editor.impl.ParameterListEditor;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeFailEvent;
import org.opensha.commons.param.event.ParameterChangeFailListener;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.impl.DoubleParameter;
import org.opensha.commons.param.impl.IntegerParameter;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.sha.gcim.imCorrRel.ImCorrelationRelationship;
import org.opensha.sha.gcim.ui.GcimEditIMiControlPanel;
import org.opensha.sha.gcim.ui.infoTools.AttenuationRelationshipsInstance;
import org.opensha.sha.gcim.ui.infoTools.ImCorrelationRelationshipsInstance;
import org.opensha.sha.gui.HazardCurveApplication;
import org.opensha.sha.imr.ScalarIMR;
import org.opensha.sha.imr.param.IntensityMeasureParams.SA_InterpolatedParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.SA_Param;
import org.opensha.sha.util.TRTUtils;
import org.opensha.sha.util.TectonicRegionType;

public class GcimControlPanel
extends ControlPanel
implements ParameterChangeFailListener,
ParameterChangeListener,
ActionListener {
    public static final String NAME = "GCIM distributions";
    private static final boolean D = false;
    private static final String GCIM_SUPPORTED_PARAM_NAME = "Gcim Support";
    private static final String GCIM_PROB_PARAM_NAME = "Gcim Prob";
    private static final String GCIM_IML_PARAM_NAME = "Gcim IML";
    private DoubleParameter gcimProbParam = new DoubleParameter("Gcim Prob", 0.0, 1.0, (Double)0.01);
    private DoubleParameter gcimIMLParam = new DoubleParameter("Gcim IML", 0.0, 11.0, (Double)0.1);
    public boolean gcimSupportedIMj = false;
    private StringParameter gcimSupportParameter;
    private StringParameter gcimParameter;
    private StringParameter gcimImisParameter;
    private boolean isGUIInitialized = false;
    private static final String GCIM_PARAM_NAME = "Get GCIM distributions";
    public static final String NO_GCIM = "No GCIM Distributions";
    public static final String GCIM_USING_PROB = "Probability";
    public static final String GCIM_USING_IML = "IML";
    public static final String IMI_LIST_NAME = "IMIs";
    public static final String IMI_LIST_DEFAULT = "(none)";
    private static final String MIN_APPROXZ_PARAM_NAME = "Min Approx. Z value for CDF";
    private static final String MAX_APPROXZ_PARAM_NAME = "Max Approx. Z value for CDF";
    private static final String DELTA_APPROXZ_PARAM_NAME = "Delta Approx. Z value for CDF";
    private DoubleParameter minApproxZParam = new DoubleParameter("Min Approx. Z value for CDF", -3.0);
    private DoubleParameter maxApproxZParam = new DoubleParameter("Max Approx. Z value for CDF", 3.0);
    private DoubleParameter deltaApproxZParam = new DoubleParameter("Delta Approx. Z value for CDF", 0.2);
    private static final String NUM_GCIM_REALIZATIONS_NAME = "Num. GCIM realizations";
    private IntegerParameter numGcimRealizationsParam = new IntegerParameter("Num. GCIM realizations", 0);
    private ArrayList<String> imiTypes = new ArrayList();
    private ArrayList<Map<TectonicRegionType, ScalarIMR>> imiMapAttenRels = new ArrayList();
    private ArrayList<Map<TectonicRegionType, ImCorrelationRelationship>> imijMapCorrRels = new ArrayList();
    private ArrayList<ArrayList<? extends Map<TectonicRegionType, ImCorrelationRelationship>>> imikjMapCorrRels = new ArrayList();
    private Site parentSite;
    private Site gcimSite;
    private Parameter<Double> parentIMj;
    private static final String GCIM_SUPPORTED_NAME = "Gcim Distributions";
    private static final String GCIM_NOT_SUPPORTED_IMJ = "Not supported for this IMj";
    private int imiIndex;
    private ParameterListEditor paramListEditor;
    private boolean isGcimSelected;
    private GcimEditIMiControlPanel gcimEditIMiControlPanel;
    HazardCurveApplication parent;
    private JFrame frame;
    private Component parentComponent;
    private JButton addButton = new JButton("Add IMi");
    private JButton removeButton = new JButton("Remove IMi");
    private JButton editButton = new JButton("Edit IMi");

    public GcimControlPanel(HazardCurveApplication parent, Component parentComponent) {
        super(NAME);
        this.parent = parent;
        this.parentComponent = parentComponent;
        this.initWithParentDetails();
    }

    @Override
    public void doinit() {
        this.frame = new JFrame();
        this.minApproxZParam.setInfo("The approx. min Z value to construct the GCIM CDF");
        this.maxApproxZParam.setInfo("The approx. max Z value to construct the GCIM CDF");
        this.deltaApproxZParam.setInfo("The increment in approx. min Z values to construct the GCIM CDF");
        this.numGcimRealizationsParam.setInfo("The number of realizations from the GCIM distributions");
        try {
            ArrayList<String> gcimSupportList = new ArrayList<String>();
            gcimSupportList.add(GCIM_NOT_SUPPORTED_IMJ);
            this.gcimSupportParameter = new StringParameter(GCIM_SUPPORTED_NAME, gcimSupportList, (String)gcimSupportList.get(0));
            ArrayList<String> gcimList = new ArrayList<String>();
            gcimList.add(NO_GCIM);
            gcimList.add(GCIM_USING_PROB);
            gcimList.add(GCIM_USING_IML);
            this.gcimParameter = new StringParameter(GCIM_PARAM_NAME, gcimList, (String)gcimList.get(0));
            ArrayList<String> gcimImisList = new ArrayList<String>();
            gcimImisList.add(IMI_LIST_DEFAULT);
            this.gcimImisParameter = new StringParameter(IMI_LIST_NAME, gcimImisList, (String)gcimImisList.get(0));
            this.gcimParameter.addParameterChangeListener(this);
            this.gcimImisParameter.addParameterChangeListener(this);
            this.gcimProbParam.addParameterChangeFailListener(this);
            this.gcimIMLParam.addParameterChangeFailListener(this);
            ParameterList paramList = new ParameterList();
            paramList.addParameter(this.gcimSupportParameter);
            paramList.addParameter(this.gcimParameter);
            paramList.addParameter(this.gcimProbParam);
            paramList.addParameter(this.gcimIMLParam);
            paramList.addParameter(this.gcimImisParameter);
            paramList.addParameter(this.minApproxZParam);
            paramList.addParameter(this.maxApproxZParam);
            paramList.addParameter(this.deltaApproxZParam);
            paramList.addParameter(this.numGcimRealizationsParam);
            this.paramListEditor = new ParameterListEditor(paramList);
            if (this.gcimSupportedIMj) {
                this.setParamsVisible((String)this.gcimParameter.getValue());
            } else {
                this.setParamsVisible((String)this.gcimSupportParameter.getValue());
            }
            this.jbInit();
            this.frame.setLocation(this.parentComponent.getX() + this.parentComponent.getWidth() / 2, 0);
            this.parent.setGcimSelected(this.isGcimSelected);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.isGUIInitialized = true;
    }

    private void jbInit() throws Exception {
        this.frame.getContentPane().setLayout(new BorderLayout());
        this.frame.getContentPane().add((Component)this.paramListEditor, "Center");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.add(this.addButton);
        buttonPanel.add(this.removeButton);
        buttonPanel.add(this.editButton);
        this.addButton.addActionListener(this);
        this.removeButton.addActionListener(this);
        this.editButton.addActionListener(this);
        this.addButton.setEnabled(false);
        this.removeButton.setEnabled(false);
        this.editButton.setEnabled(false);
        this.frame.getContentPane().add((Component)buttonPanel, "South");
        this.frame.setTitle("GCIM Control Panel");
        this.paramListEditor.setTitle("Set GCIM Params");
        this.frame.setSize(300, 200);
    }

    @Override
    public void parameterChangeFailed(ParameterChangeFailEvent e) {
        StringBuffer b = new StringBuffer();
        Parameter param = (Parameter)e.getSource();
        ParameterConstraint constraint = param.getConstraint();
        String oldValueStr = e.getOldValue().toString();
        String badValueStr = e.getBadValue().toString();
        String name = param.getName();
        b.append("The value ");
        b.append(badValueStr);
        b.append(" is not permitted for '");
        b.append(name);
        b.append("'.\n");
        b.append("Resetting to ");
        b.append(oldValueStr);
        b.append(". The constraints are: \n");
        b.append(constraint.toString());
        JOptionPane.showMessageDialog(this.frame, b.toString(), "Cannot Change Value", 1);
    }

    @Override
    public void parameterChange(ParameterChangeEvent e) {
        String paramName = e.getParameterName();
        if (paramName.equals(GCIM_PARAM_NAME)) {
            this.setParamsVisible((String)this.gcimParameter.getValue());
        }
    }

    public int getNumIMi() {
        StringConstraint stringConst = (StringConstraint)this.gcimImisParameter.getConstraint();
        int imiListSize = stringConst.size();
        if (imiListSize == 0) {
            throw new RuntimeException("gcimImisParameter is empty!");
        }
        if (imiListSize == 1 && ((ArrayList)stringConst.getAllowedValues()).get(0) == IMI_LIST_DEFAULT) {
            System.out.println(0);
            return 0;
        }
        return imiListSize;
    }

    public ArrayList<String> getImiTypes() {
        return this.imiTypes;
    }

    public ArrayList<? extends Map<TectonicRegionType, ScalarIMR>> getImris() {
        return this.imiMapAttenRels;
    }

    public ArrayList<? extends Map<TectonicRegionType, ImCorrelationRelationship>> getImCorrRels() {
        return this.imijMapCorrRels;
    }

    public ArrayList<? extends Map<TectonicRegionType, ImCorrelationRelationship>> getImikCorrRels() {
        ArrayList flattened = (ArrayList)this.imikjMapCorrRels.stream().flatMap(Collection::stream).collect(Collectors.toList());
        return flattened;
    }

    public double getMinApproxZ() {
        return (Double)this.minApproxZParam.getValue();
    }

    public double getMaxApproxZ() {
        return (Double)this.maxApproxZParam.getValue();
    }

    public double getDeltaApproxZ() {
        return (Double)this.deltaApproxZParam.getValue();
    }

    public int getNumGcimRealizations() {
        return (Integer)this.numGcimRealizationsParam.getValue();
    }

    public void setParamsVisible(String paramValue) {
        if (paramValue.equals(GCIM_NOT_SUPPORTED_IMJ)) {
            this.paramListEditor.getParameterEditor(GCIM_SUPPORTED_NAME).setVisible(true);
            this.paramListEditor.getParameterEditor(GCIM_PARAM_NAME).setVisible(false);
            this.paramListEditor.getParameterEditor(GCIM_PROB_PARAM_NAME).setVisible(false);
            this.paramListEditor.getParameterEditor(GCIM_IML_PARAM_NAME).setVisible(false);
            this.isGcimSelected = false;
            this.paramListEditor.getParameterEditor(IMI_LIST_NAME).setVisible(false);
            this.paramListEditor.getParameterEditor(MIN_APPROXZ_PARAM_NAME).setVisible(false);
            this.paramListEditor.getParameterEditor(MAX_APPROXZ_PARAM_NAME).setVisible(false);
            this.paramListEditor.getParameterEditor(DELTA_APPROXZ_PARAM_NAME).setVisible(false);
            this.paramListEditor.getParameterEditor(NUM_GCIM_REALIZATIONS_NAME).setVisible(false);
            this.addButton.setEnabled(false);
            this.editButton.setEnabled(false);
            this.removeButton.setEnabled(false);
            this.frame.setSize(300, 200);
        } else if (paramValue.equals(NO_GCIM)) {
            this.paramListEditor.getParameterEditor(GCIM_PARAM_NAME).setVisible(true);
            this.paramListEditor.getParameterEditor(GCIM_SUPPORTED_NAME).setVisible(false);
            this.paramListEditor.getParameterEditor(GCIM_PROB_PARAM_NAME).setVisible(false);
            this.paramListEditor.getParameterEditor(GCIM_IML_PARAM_NAME).setVisible(false);
            this.isGcimSelected = false;
            this.paramListEditor.getParameterEditor(IMI_LIST_NAME).setVisible(false);
            this.paramListEditor.getParameterEditor(MIN_APPROXZ_PARAM_NAME).setVisible(false);
            this.paramListEditor.getParameterEditor(MAX_APPROXZ_PARAM_NAME).setVisible(false);
            this.paramListEditor.getParameterEditor(DELTA_APPROXZ_PARAM_NAME).setVisible(false);
            this.paramListEditor.getParameterEditor(NUM_GCIM_REALIZATIONS_NAME).setVisible(false);
            this.addButton.setEnabled(false);
            this.editButton.setEnabled(false);
            this.removeButton.setEnabled(false);
            this.frame.setSize(300, 200);
        } else {
            if (paramValue.equals(GCIM_USING_PROB)) {
                this.paramListEditor.getParameterEditor(GCIM_PROB_PARAM_NAME).setVisible(true);
                this.paramListEditor.getParameterEditor(GCIM_IML_PARAM_NAME).setVisible(false);
                this.isGcimSelected = true;
            } else if (paramValue.equals(GCIM_USING_IML)) {
                this.paramListEditor.getParameterEditor(GCIM_PROB_PARAM_NAME).setVisible(false);
                this.paramListEditor.getParameterEditor(GCIM_IML_PARAM_NAME).setVisible(true);
                this.isGcimSelected = true;
            }
            this.addButton.setEnabled(true);
            if (this.getNumIMi() > 0) {
                this.paramListEditor.getParameterEditor(IMI_LIST_NAME).setVisible(true);
                this.paramListEditor.getParameterEditor(MIN_APPROXZ_PARAM_NAME).setVisible(true);
                this.paramListEditor.getParameterEditor(MAX_APPROXZ_PARAM_NAME).setVisible(true);
                this.paramListEditor.getParameterEditor(DELTA_APPROXZ_PARAM_NAME).setVisible(true);
                this.paramListEditor.getParameterEditor(NUM_GCIM_REALIZATIONS_NAME).setVisible(true);
                this.editButton.setEnabled(true);
                this.removeButton.setEnabled(true);
            } else {
                this.paramListEditor.getParameterEditor(IMI_LIST_NAME).setVisible(true);
                this.paramListEditor.getParameterEditor(MIN_APPROXZ_PARAM_NAME).setVisible(false);
                this.paramListEditor.getParameterEditor(MAX_APPROXZ_PARAM_NAME).setVisible(false);
                this.paramListEditor.getParameterEditor(DELTA_APPROXZ_PARAM_NAME).setVisible(false);
                this.paramListEditor.getParameterEditor(NUM_GCIM_REALIZATIONS_NAME).setVisible(false);
                this.editButton.setEnabled(false);
                this.removeButton.setEnabled(false);
            }
            Dimension curDims = this.frame.getSize();
            int width = 300;
            int height = 500;
            if (curDims.width > width) {
                width = curDims.width;
            }
            if (curDims.height > height) {
                height = curDims.height;
            }
            this.frame.setSize(width, height);
        }
        this.frame.repaint();
        this.frame.validate();
        this.parent.setGcimSelected(this.isGcimSelected);
    }

    public String getGcimParamValue() {
        return (String)this.gcimParameter.getValue();
    }

    public double getGcimVal() {
        if (this.isGcimSelected) {
            String paramValue = this.getGcimParamValue();
            if (paramValue.equals(GCIM_USING_PROB)) {
                return (Double)this.gcimProbParam.getValue();
            }
            if (paramValue.equals(GCIM_USING_IML)) {
                return (Double)this.gcimIMLParam.getValue();
            }
        }
        return -1.0;
    }

    @Override
    public Window getComponent() {
        return this.frame;
    }

    public void updateIMiNames() {
        int i;
        int numIMi = this.getNumIMi();
        StringConstraint stringConst = (StringConstraint)this.gcimImisParameter.getConstraint();
        ArrayList<String> strings = stringConst.getAllowedStrings();
        for (i = 0; i < strings.size(); ++i) {
            String oldName = strings.get(i);
            stringConst.removeString(oldName);
        }
        if (numIMi == 0) {
            stringConst.addString(IMI_LIST_DEFAULT);
            this.updateIMiListGuiDisplay();
        } else {
            for (i = 0; i < numIMi; ++i) {
                String periodVal;
                String imtName = this.imiTypes.get(i);
                String newName = i + 1 + ". " + imtName;
                Parameter imti = TRTUtils.getFirstIMR(this.imiMapAttenRels.get(i)).getIntensityMeasure();
                if (imtName == "SA") {
                    periodVal = "";
                    try {
                        periodVal = ((Double)((SA_Param)imti).getPeriodParam().getValue()).toString();
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                    newName = i + 1 + ". SA (" + periodVal + "s)";
                } else if (imtName == "SA Interpolated") {
                    periodVal = "";
                    try {
                        periodVal = ((Double)((SA_InterpolatedParam)imti).getPeriodInterpolatedParam().getValue()).toString();
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                    newName = i + 1 + ". SA (" + periodVal + "s)";
                }
                strings.set(i, newName);
                stringConst.addString(newName);
                this.gcimImisParameter.setValue(newName);
                this.updateIMiListGuiDisplay();
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        StringConstraint stringConst = (StringConstraint)this.gcimImisParameter.getConstraint();
        if (e.getSource().equals(this.addButton)) {
            this.imiIndex = this.getNumIMi();
            String newIMIName = "IMi " + (this.getNumIMi() + 1);
            stringConst.addString(newIMIName);
            if (stringConst.getAllowedStrings().get(0).equals(IMI_LIST_DEFAULT)) {
                stringConst.removeString(IMI_LIST_DEFAULT);
            }
            this.gcimImisParameter.setValue(newIMIName);
            this.updateIMiListGuiDisplay();
            this.gcimEditIMiControlPanel = new GcimEditIMiControlPanel(this, this.frame, this.imiIndex);
            this.gcimEditIMiControlPanel.init();
            this.gcimEditIMiControlPanel.setVisible(true);
            this.updateIMiNames();
        } else if (e.getSource().equals(this.removeButton)) {
            String selectedIMI = (String)this.gcimImisParameter.getValue();
            this.imiIndex = stringConst.getAllowedStrings().indexOf(this.gcimImisParameter.getValue());
            if (this.getNumIMi() == 1) {
                stringConst.addString(IMI_LIST_DEFAULT);
                this.removeButton.setEnabled(false);
                this.editButton.setEnabled(false);
            }
            this.removeIMiDetailsInArrayLists(this.imiIndex);
            stringConst.removeString(selectedIMI);
            ArrayList<String> strings = stringConst.getAllowedStrings();
            this.gcimImisParameter.setValue(strings.get(0));
            this.updateIMiListGuiDisplay();
            this.updateIMiNames();
        } else if (e.getSource().equals(this.editButton)) {
            this.imiIndex = stringConst.getAllowedStrings().indexOf(this.gcimImisParameter.getValue());
            this.gcimEditIMiControlPanel = new GcimEditIMiControlPanel(this, this.frame, this.imiIndex);
            this.gcimEditIMiControlPanel.init(this.imiIndex);
            this.gcimEditIMiControlPanel.setVisible(true);
            this.updateIMiNames();
            this.updateIMiListGuiDisplay();
        }
        this.setParamsVisible((String)this.gcimParameter.getValue());
    }

    public void addIMiDetailsInArrayLists() {
        this.imiTypes.add(this.gcimEditIMiControlPanel.getSelectedIMT());
        this.imiMapAttenRels.add(this.gcimEditIMiControlPanel.getSelectedIMRMap());
        this.imijMapCorrRels.add(this.gcimEditIMiControlPanel.getSelectedIMCorrRelMap());
        this.imikjMapCorrRels.add(this.gcimEditIMiControlPanel.getSelectedIMikjCorrRelMap());
    }

    public void removeIMiDetailsInArrayLists(int i) {
        this.imiTypes.remove(i);
        this.imiMapAttenRels.remove(i);
        this.imijMapCorrRels.remove(i);
        this.imikjMapCorrRels.remove(i);
    }

    public void updateIMiDetailsInArrayLists(int i) {
        int sizeIMi = this.getNumIMi();
        if (i > this.imiTypes.size() - 1) {
            this.addIMiDetailsInArrayLists();
        } else {
            this.imiTypes.set(i, this.gcimEditIMiControlPanel.getSelectedIMT());
            this.imiMapAttenRels.set(i, this.gcimEditIMiControlPanel.getSelectedIMRMap());
            this.imijMapCorrRels.set(i, this.gcimEditIMiControlPanel.getSelectedIMCorrRelMap());
            int numIMikCorrRels = (i + 1) * (i + 1 - 1) / 2 - i * (i - 1) / 2;
            ArrayList<Object> IMikCorrRels = new ArrayList();
            if (numIMikCorrRels > 0) {
                IMikCorrRels = this.gcimEditIMiControlPanel.getSelectedIMikjCorrRelMap();
            }
            this.imikjMapCorrRels.set(i, IMikCorrRels);
        }
    }

    public String getImiType(int index) {
        return this.imiTypes.get(index);
    }

    public Parameter<Double> getImiParam(int index) {
        return TRTUtils.getFirstIMR(this.imiMapAttenRels.get(index)).getIntensityMeasure();
    }

    public Map<TectonicRegionType, ScalarIMR> getImiAttenRel(int index) {
        return this.imiMapAttenRels.get(index);
    }

    public Map<TectonicRegionType, ImCorrelationRelationship> getImijCorrRel(int index) {
        return this.imijMapCorrRels.get(index);
    }

    public ArrayList<? extends Map<TectonicRegionType, ImCorrelationRelationship>> getImikjCorrRel(int index) {
        return this.imikjMapCorrRels.get(index);
    }

    public ArrayList<TectonicRegionType> getIncludedTectonicRegionTypes() {
        return this.parent.getIncludedTectonicRegionTypes();
    }

    public void getParentSite() {
        this.parentSite = this.parent.getSiteGuiBeanInstance().getSite();
    }

    public Site getSite() {
        return this.parentSite;
    }

    public Site getGcimSite() {
        return this.gcimSite;
    }

    public void initGcimSite() {
        this.gcimSite = (Site)this.parentSite.clone();
    }

    public void updateGcimSite() {
        Site oldGcimSite = (Site)this.gcimSite.clone();
        this.gcimSite = (Site)this.parentSite.clone();
        ListIterator<String> oldGcimSiteParamIt = oldGcimSite.getParameterNamesIterator();
        while (oldGcimSiteParamIt.hasNext()) {
            boolean oldGcimSiteParamInNewGcimSite = false;
            String oldGcimSiteParamName = oldGcimSiteParamIt.next().toString();
            ListIterator<String> gcimSiteParamIt = this.gcimSite.getParameterNamesIterator();
            while (gcimSiteParamIt.hasNext() & !oldGcimSiteParamInNewGcimSite) {
                String gcimSiteParamName = gcimSiteParamIt.next().toString();
                if (oldGcimSiteParamName != gcimSiteParamName) continue;
                oldGcimSiteParamInNewGcimSite = true;
            }
            if (oldGcimSiteParamInNewGcimSite) continue;
            this.gcimSite.addParameter(oldGcimSite.getParameter(oldGcimSiteParamName));
        }
    }

    public void updateGcimSite(Site gcimSite) {
        this.gcimSite = gcimSite;
    }

    public Parameter<Double> getParentIMj() {
        this.parentIMj = this.parent.getIMTGuiBeanInstance().getSelectedIM();
        return this.parentIMj;
    }

    public void checkParentIMj() {
        Parameter<Double> oldParentIMj = this.parentIMj;
        Parameter<Double> newParentIMj = this.parent.getIMTGuiBeanInstance().getSelectedIM();
        boolean oldNewIMjSame = true;
        if (!oldParentIMj.getName().equalsIgnoreCase(newParentIMj.getName())) {
            oldNewIMjSame = false;
        } else {
            Iterator<Parameter<?>> oldParentIMjParamsIt = oldParentIMj.getIndependentParameterList().iterator();
            while (oldParentIMjParamsIt.hasNext()) {
                boolean newOldParentIMjContainParam = false;
                String oldParentIMjParamName = oldParentIMjParamsIt.next().toString();
                Iterator<Parameter<?>> newParentIMjParamsIt = newParentIMj.getIndependentParameterList().iterator();
                while (newParentIMjParamsIt.hasNext()) {
                    String newParentIMjParamName = newParentIMjParamsIt.next().toString();
                    if (!oldParentIMjParamName.equalsIgnoreCase(newParentIMjParamName) || !newParentIMjParamsIt.next().getValue().equals(oldParentIMjParamsIt.next().getValue())) continue;
                    newOldParentIMjContainParam = true;
                    break;
                }
                if (newOldParentIMjContainParam) continue;
                oldNewIMjSame = false;
                break;
            }
        }
        if (!oldNewIMjSame) {
            this.resetGcimControlPanelArrays();
        }
        this.parentIMj = newParentIMj;
    }

    private void resetGcimControlPanelArrays() {
        this.imiTypes = new ArrayList();
        this.imiMapAttenRels = new ArrayList();
        this.imijMapCorrRels = new ArrayList();
        this.imikjMapCorrRels = new ArrayList();
        ArrayList<String> gcimImisList = new ArrayList<String>();
        gcimImisList.add(IMI_LIST_DEFAULT);
        this.gcimImisParameter = new StringParameter(IMI_LIST_NAME, gcimImisList, (String)gcimImisList.get(0));
        this.gcimImisParameter.getEditor().setParameter(this.gcimImisParameter);
    }

    public boolean isParentIMjGcimSupported() {
        AttenuationRelationshipsInstance imrInstances = new AttenuationRelationshipsInstance();
        ArrayList<ScalarIMR> imrs = imrInstances.createIMRClassInstance(null);
        ImCorrelationRelationshipsInstance imCorrRelInstances = new ImCorrelationRelationshipsInstance();
        ArrayList<ImCorrelationRelationship> imCorrRels = imCorrRelInstances.createImCorrRelClassInstance(null);
        for (ImCorrelationRelationship imCorrRel : imCorrRels) {
            ArrayList<Parameter<?>> imjImCorrRelParamList = imCorrRel.getSupportedIntensityMeasuresjList();
            for (int i = 0; i < imjImCorrRelParamList.size(); ++i) {
                Parameter<?> imjImCorrRelParam = imjImCorrRelParamList.get(i);
                if (imjImCorrRelParam.getName() != this.parentIMj.getName()) continue;
                for (ScalarIMR imr : imrs) {
                    ParameterList imjImrParamList = imr.getSupportedIntensityMeasures();
                    for (Parameter<?> imjImrParam : imjImrParamList) {
                        if (imjImCorrRelParam.getName() != this.parentIMj.getName()) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public void initWithParentDetails() {
        this.getParentSite();
        this.initGcimSite();
        this.getParentIMj();
        this.gcimSupportedIMj = this.isParentIMjGcimSupported();
        if (this.gcimSupportedIMj && this.isGUIInitialized) {
            this.setParamsVisible((String)this.gcimParameter.getValue());
        }
    }

    public void updateWithParentDetails() {
        this.getParentSite();
        this.updateGcimSite();
        this.checkParentIMj();
        this.gcimSupportedIMj = this.isParentIMjGcimSupported();
        if (this.gcimSupportedIMj && this.isGUIInitialized) {
            this.setParamsVisible((String)this.gcimParameter.getValue());
        }
    }

    public void updateIMiListGuiDisplay() {
        this.gcimImisParameter.getEditor().setParameter(this.gcimImisParameter);
        String blank = "blank";
        this.setParamsVisible(blank);
    }
}

