/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.gcim.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Iterator;
import java.util.ListIterator;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.opensha.commons.data.Site;
import org.opensha.commons.param.AbstractParameter;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.constraint.ParameterConstraint;
import org.opensha.commons.param.editor.impl.ParameterListEditor;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeFailEvent;
import org.opensha.commons.param.event.ParameterChangeFailListener;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.impl.DoubleParameter;
import org.opensha.sha.gcim.ui.GcimEditIMiControlPanel;

public class GcimSite_GuiBean
extends JPanel
implements ParameterChangeListener,
ParameterChangeFailListener {
    protected static final String C = "SiteParamList";
    public static final String LONGITUDE = "Longitude";
    public static final String LATITUDE = "Latitude";
    GcimEditIMiControlPanel parent;
    private Site parentSite;
    private Site gcimSite;
    protected static final String SITE_PARAMS = "Set Site Params";
    private ParameterList parameterList = new ParameterList();
    private ParameterListEditor parameterEditor;
    private DoubleParameter longitude = new DoubleParameter("Longitude", (Double)-360.0, (Double)360.0, (Double)-118.243);
    private DoubleParameter latitude = new DoubleParameter("Latitude", (Double)-90.0, (Double)90.0, (Double)34.053);
    private GridBagLayout gridBagLayout1 = new GridBagLayout();

    public GcimSite_GuiBean(GcimEditIMiControlPanel parent, Site parentSite, Site gcimSite) {
        this.parent = parent;
        this.parentSite = parentSite;
        this.gcimSite = gcimSite;
        this.setMinimumSize(new Dimension(140, 100));
        this.setPreferredSize(new Dimension(160, 100));
        this.longitude.setValue(parentSite.getLocation().getLongitude());
        this.latitude.setValue(parentSite.getLocation().getLatitude());
        this.parameterList.addParameter(this.longitude);
        this.parameterList.addParameter(this.latitude);
        this.latitude.addParameterChangeListener(this);
        this.longitude.addParameterChangeListener(this);
        this.latitude.addParameterChangeFailListener(this);
        this.longitude.addParameterChangeFailListener(this);
        this.parameterEditor = new ParameterListEditor(this.parameterList);
        this.parameterEditor.setEnabled(false);
        this.parameterEditor.setTitle(SITE_PARAMS);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.add((Component)this.parameterEditor, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void addSiteParams(Iterator it) {
        while (it.hasNext()) {
            AbstractParameter tempParam = (AbstractParameter)it.next();
            if (this.parameterList.containsParameter(tempParam)) continue;
            tempParam.addParameterChangeListener(this);
            this.parameterList.addParameter(tempParam);
        }
        this.remove(this.parameterEditor);
        this.constrainSiteParams();
        this.parameterEditor = new ParameterListEditor(this.parameterList);
        this.disableSiteParams();
        this.parameterEditor.setTitle(SITE_PARAMS);
        this.add((Component)this.parameterEditor, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void constrainSiteParams() {
        ListIterator<String> SiteIt = this.parameterList.getParameterNamesIterator();
        while (SiteIt.hasNext()) {
            String paramName = ((String)SiteIt.next()).toString();
            if (paramName.equalsIgnoreCase(LATITUDE) || paramName.equalsIgnoreCase(LONGITUDE)) continue;
            boolean siteParamInParentSiteParam = false;
            ListIterator<String> parentSiteParamIt = this.parentSite.getParameterNamesIterator();
            while (parentSiteParamIt.hasNext()) {
                String parentSiteParamName = parentSiteParamIt.next().toString();
                if (paramName != parentSiteParamName) continue;
                siteParamInParentSiteParam = true;
                this.parameterList.setValue(parentSiteParamName, this.parentSite.getParameter(parentSiteParamName).getValue());
            }
            if (siteParamInParentSiteParam) continue;
            boolean siteParamInGcimSiteParam = false;
            ListIterator<String> gcimSiteParamIt = this.gcimSite.getParameterNamesIterator();
            while (gcimSiteParamIt.hasNext()) {
                String gcimSiteParamName = gcimSiteParamIt.next().toString();
                if (paramName != gcimSiteParamName) continue;
                siteParamInGcimSiteParam = true;
                this.parameterList.setValue(gcimSiteParamName, this.gcimSite.getParameter(gcimSiteParamName).getValue());
                break;
            }
            if (siteParamInGcimSiteParam) continue;
            ListIterator<Parameter<?>> it = this.parameterList.getParametersIterator();
            while (it.hasNext()) {
                Parameter siteParam = (Parameter)it.next();
                if (siteParam.getName() != paramName) continue;
                siteParam.addParameterChangeListener(this);
                this.gcimSite.addParameter(siteParam);
            }
        }
        this.parent.updateGcimSite(this.gcimSite);
    }

    public void disableSiteParams() {
        ListIterator<String> SiteIt = this.parameterList.getParameterNamesIterator();
        block0: while (SiteIt.hasNext()) {
            String paramName = ((String)SiteIt.next()).toString();
            if (paramName.equalsIgnoreCase(LATITUDE) || paramName.equalsIgnoreCase(LONGITUDE)) continue;
            boolean siteParamInParentSiteParam = false;
            ListIterator<String> parentSiteParamIt = this.parentSite.getParameterNamesIterator();
            while (parentSiteParamIt.hasNext()) {
                String parentSiteParamName = parentSiteParamIt.next().toString();
                if (paramName != parentSiteParamName) continue;
                this.parameterList.getParameter(parentSiteParamName).getEditor().setEnabled(false);
                continue block0;
            }
        }
    }

    public void replaceSiteParams(Iterator it) {
        ListIterator<String> siteIt = this.parameterList.getParameterNamesIterator();
        while (siteIt.hasNext()) {
            String paramName = (String)siteIt.next();
            if (paramName.equalsIgnoreCase(LATITUDE) || paramName.equalsIgnoreCase(LONGITUDE)) continue;
            this.parameterList.removeParameter(paramName);
        }
        this.addSiteParams(it);
    }

    @Override
    public void parameterChange(ParameterChangeEvent e) {
        this.parent.updateGcimSite(this.gcimSite);
    }

    @Override
    public void parameterChangeFailed(ParameterChangeFailEvent e) {
        String S = "SiteParamList : parameterChangeFailed(): ";
        StringBuffer b = new StringBuffer();
        Parameter param = (Parameter)e.getSource();
        ParameterConstraint constraint = param.getConstraint();
        String oldValueStr = e.getOldValue().toString();
        String badValueStr = e.getBadValue().toString();
        String name = param.getName();
        b.append("The value ");
        b.append(badValueStr);
        b.append(" is not permitted for '");
        b.append(name);
        b.append("'.\n");
        b.append("Resetting to ");
        b.append(oldValueStr);
        b.append(". The constraints are: \n");
        b.append(constraint.toString());
        JOptionPane.showMessageDialog(this, b.toString(), "Cannot Change Value", 1);
    }

    private void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout1);
        this.setBackground(Color.white);
    }

    public ParameterListEditor getParameterListEditor() {
        return this.parameterEditor;
    }
}

