/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.gcim.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.opensha.commons.param.AbstractParameter;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.constraint.impl.DoubleDiscreteConstraint;
import org.opensha.commons.param.editor.impl.ParameterListEditor;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.impl.DoubleDiscreteParameter;
import org.opensha.commons.param.impl.DoubleParameter;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.sha.gcim.imCorrRel.ImCorrelationRelationship;
import org.opensha.sha.gcim.ui.IMCorrRel_MultiGuiBean;
import org.opensha.sha.gui.beans.IMR_MultiGuiBean;
import org.opensha.sha.gui.beans.event.IMTChangeEvent;
import org.opensha.sha.gui.beans.event.IMTChangeListener;
import org.opensha.sha.imr.ScalarIMR;
import org.opensha.sha.imr.event.ScalarIMRChangeEvent;
import org.opensha.sha.imr.event.ScalarIMRChangeListener;
import org.opensha.sha.imr.param.IntensityMeasureParams.PeriodInterpolatedParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.PeriodParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.SA_InterpolatedParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.SA_Param;
import org.opensha.sha.util.TectonicRegionType;

public class IMT_GcimGuiBean
extends ParameterListEditor
implements ParameterChangeListener,
ScalarIMRChangeListener {
    private static final long serialVersionUID = 1L;
    private static final boolean D = false;
    private static double default_period = 1.0;
    public static final String IMT_PARAM_NAME = "IMT";
    public static final String TITLE = "Set IMT";
    private boolean commonParamsOnly = false;
    private ParameterList imtParams;
    private StringParameter imtParameter;
    private Parameter<Double> imj;
    private ArrayList<String> currentIMiList;
    private List<? extends ScalarIMR> imrs;
    private ArrayList<ImCorrelationRelationship> imCorrRels;
    private ArrayList<IMTChangeListener> listeners = new ArrayList();
    private ArrayList<Double> allPeriods;
    private ArrayList<Double> currentSupportedPeriods;

    public IMT_GcimGuiBean(ScalarIMR imr, ImCorrelationRelationship imCorrRel, Parameter<Double> imj, ArrayList<String> currentIMiList) {
        this(IMT_GcimGuiBean.wrapInList(imr), IMT_GcimGuiBean.wrapInList(imCorrRel), imj, currentIMiList);
    }

    public IMT_GcimGuiBean(IMR_MultiGuiBean imrGuiBean, IMCorrRel_MultiGuiBean imCorrRelGuiBean, Parameter<Double> imj, ArrayList<String> currentIMiList) {
        this(imrGuiBean.getIMRs(), imCorrRelGuiBean.getIMCorrRels(), imj, currentIMiList);
        this.addIMTChangeListener(imrGuiBean);
        this.addIMTChangeListener(imCorrRelGuiBean);
        imrGuiBean.addIMRChangeListener(this);
        this.fireIMTChangeEvent();
    }

    public IMT_GcimGuiBean(List<? extends ScalarIMR> imrs, ArrayList<ImCorrelationRelationship> imCorrRels, Parameter<Double> imj, ArrayList<String> currentIMiList) {
        this.setTitle(TITLE);
        this.imj = imj;
        this.currentIMiList = currentIMiList;
        this.setIMRsIMCorrRels(imrs, imCorrRels);
    }

    private static ArrayList<ScalarIMR> wrapInList(ScalarIMR imr) {
        ArrayList<ScalarIMR> imrs = new ArrayList<ScalarIMR>();
        imrs.add(imr);
        return imrs;
    }

    private static ArrayList<ImCorrelationRelationship> wrapInList(ImCorrelationRelationship imCorrRel) {
        ArrayList<ImCorrelationRelationship> imCorrRels = new ArrayList<ImCorrelationRelationship>();
        imCorrRels.add(imCorrRel);
        return imCorrRels;
    }

    public void setIMRIMCorrRel(ScalarIMR imr, ImCorrelationRelationship imCorrRel) {
        this.setIMRsIMCorrRels(IMT_GcimGuiBean.wrapInList(imr), IMT_GcimGuiBean.wrapInList(imCorrRel));
    }

    public void setIMRsIMCorrRels(List<? extends ScalarIMR> imrs, ArrayList<ImCorrelationRelationship> imCorrRels) {
        ArrayList<Double> saPeriods;
        this.imrs = imrs;
        this.imCorrRels = imCorrRels;
        ParameterList imiParamList_IMjSupport = new ParameterList();
        for (ImCorrelationRelationship imCorrRel : imCorrRels) {
            ArrayList<Parameter<?>> imjParamList = imCorrRel.getSupportedIntensityMeasuresjList();
            for (int i = 0; i < imjParamList.size(); ++i) {
                Parameter<?> imjParam = imjParamList.get(i);
                if (imjParam.getName() != this.imj.getName()) continue;
                Parameter<?> imiParam = imCorrRel.getSupportedIntensityMeasuresiList().get(i);
                for (ScalarIMR scalarIMR : imrs) {
                    ParameterList imiIMRParamList = scalarIMR.getSupportedIntensityMeasures();
                    for (Parameter<?> imiIMRParam : imiIMRParamList) {
                        if (imiIMRParam.getName() != imiParam.getName() || imiParamList_IMjSupport.containsParameter(imiParam.getName())) continue;
                        if (imiIMRParam.getName() == "SA Interpolated") {
                            PeriodInterpolatedParam periodInterpolatedParam = ((SA_InterpolatedParam)imiIMRParam).getPeriodInterpolatedParam();
                            periodInterpolatedParam.addParameterChangeListener(this);
                        }
                        imiParamList_IMjSupport.addParameter(imiIMRParam);
                    }
                }
            }
        }
        ParameterList imiParamList = new ParameterList();
        int numIMiWithIMjSupport = imiParamList_IMjSupport.size();
        int numCurrentIMis = this.currentIMiList.size();
        imiParamList = imiParamList_IMjSupport;
        ArrayList<String> imiParamList_IMkNoSupport = new ArrayList<String>();
        if (numCurrentIMis > 0) {
            for (Parameter<?> imiParam : imiParamList_IMjSupport) {
                String imiName = imiParamList_IMjSupport.getParameterName(imiParam.getName());
                for (int i = 0; i < numCurrentIMis; ++i) {
                    boolean imiHasIMkSupport = false;
                    String imkName = this.currentIMiList.get(i);
                    for (ImCorrelationRelationship imCorrelationRelationship : imCorrRels) {
                        ArrayList<Parameter<?>> imkParamList = imCorrelationRelationship.getSupportedIntensityMeasuresjList();
                        for (int m = 0; m < imkParamList.size(); ++m) {
                            Parameter<?> imiParamM;
                            Parameter<?> imkParam = imkParamList.get(m);
                            if (imkParam.getName() != imkName || (imiParamM = imCorrelationRelationship.getSupportedIntensityMeasuresiList().get(m)).getName() != imiName) continue;
                            imiHasIMkSupport = true;
                        }
                    }
                    if (imiHasIMkSupport) continue;
                    imiParamList_IMkNoSupport.add(imiName);
                }
            }
            for (int k = 0; k < imiParamList_IMkNoSupport.size(); ++k) {
                imiParamList.removeParameter((String)imiParamList_IMkNoSupport.get(k));
            }
        }
        AbstractParameter oldSAParam = null;
        SA_InterpolatedParam oldSAInterpolatedParam = null;
        if (this.commonParamsOnly) {
            ParameterList toBeRemoved = new ParameterList();
            for (Parameter<?> param : imiParamList) {
                boolean remove = false;
                for (ScalarIMR scalarIMR : imrs) {
                    if (scalarIMR.getSupportedIntensityMeasures().containsParameter(param.getName())) continue;
                    remove = true;
                    break;
                }
                if (remove) {
                    if (toBeRemoved.containsParameter(param.getName())) continue;
                    toBeRemoved.addParameter(param);
                    continue;
                }
                ArrayList badPeriods = new ArrayList();
                if (!param.getName().equals("SA")) continue;
                oldSAParam = (SA_Param)param;
            }
            Iterator<Parameter<?>> iterator = toBeRemoved.iterator();
            while (iterator.hasNext()) {
                Parameter<?> badParam = iterator.next();
                imiParamList.removeParameter(badParam.getName());
            }
            saPeriods = IMT_GcimGuiBean.getCommonPeriods(imrs);
        } else {
            for (Parameter parameter : imiParamList) {
                if (parameter.getName().equals("SA")) {
                    oldSAParam = (SA_Param)parameter;
                    break;
                }
                if (!parameter.getName().equals("SA Interpolated")) continue;
                oldSAInterpolatedParam = (SA_InterpolatedParam)parameter;
                break;
            }
            saPeriods = IMT_GcimGuiBean.getAllSupportedPeriods(imrs);
        }
        if (oldSAParam != null && imiParamList.containsParameter(oldSAParam.getName())) {
            Collections.sort(saPeriods);
            this.allPeriods = saPeriods;
            DoubleDiscreteConstraint pConst = new DoubleDiscreteConstraint(saPeriods);
            double d = default_period;
            if (!pConst.isAllowed(d)) {
                d = saPeriods.get(0);
            }
            PeriodParam periodParam = new PeriodParam(pConst, d, true);
            periodParam.addParameterChangeListener(this);
            SA_Param replaceSA = new SA_Param(periodParam, ((SA_Param)oldSAParam).getDampingParam());
            replaceSA.setValue(d);
            imiParamList.replaceParameter(replaceSA.getName(), replaceSA);
        }
        this.imtParams = imiParamList;
        ParameterList finalParamList = new ParameterList();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Parameter<?> param : imiParamList) {
            arrayList.add(param.getName());
        }
        this.imtParameter = new StringParameter(IMT_PARAM_NAME, arrayList, (String)arrayList.get(0));
        this.imtParameter.addParameterChangeListener(this);
        finalParamList.addParameter(this.imtParameter);
        for (Parameter<?> param : imiParamList) {
            finalParamList.addParameter(param);
        }
        this.updateGUI();
        this.fireIMTChangeEvent();
    }

    private void updateGUI() {
        ParameterList params = new ParameterList();
        params.addParameter(this.imtParameter);
        String imtName = (String)this.imtParameter.getValue();
        Parameter imtParam = this.imtParams.getParameter(imtName);
        for (Parameter<?> param : imtParam.getIndependentParameterList()) {
            if (param.getName().equals("SA Period")) {
                PeriodParam periodParam = (PeriodParam)param;
                ArrayList<Double> periods = this.currentSupportedPeriods;
                if (periods == null) {
                    periods = this.allPeriods;
                }
                DoubleDiscreteConstraint pConst = new DoubleDiscreteConstraint(periods);
                periodParam.setConstraint(pConst);
                if (periodParam.getValue() == null) {
                    if (periodParam.isAllowed(default_period)) {
                        periodParam.setValue(default_period);
                    } else {
                        periodParam.setValue(periods.get(0));
                    }
                }
                periodParam.getEditor().setParameter(periodParam);
            }
            params.addParameter(param);
        }
        this.setParameterList(params);
        this.refreshParamEditor();
        this.revalidate();
        this.repaint();
    }

    public String getSelectedIMT() {
        return (String)((StringParameter)this.imtParameter.clone()).getValue();
    }

    public void setSelectedIMT(String imtName) {
        if (!imtName.equals(this.getSelectedIMT())) {
            this.imtParameter.setValue(imtName);
        }
    }

    public void setSelectedIMTPeriod(double period) {
        ParameterList params = new ParameterList();
        params.addParameter(this.imtParameter);
        String imtName = (String)this.imtParameter.getValue();
        Parameter imtParam = this.imtParams.getParameter(imtName);
        for (Parameter<?> param : imtParam.getIndependentParameterList()) {
            AbstractParameter periodParam;
            if (param.getName().equals("SA Period")) {
                periodParam = (PeriodParam)param;
                periodParam.setValue(period);
                ((DoubleDiscreteParameter)periodParam).getEditor().setParameter(periodParam);
            } else if (param.getName().equals("SA Interpolated Period")) {
                periodParam = (PeriodInterpolatedParam)param;
                ((DoubleParameter)periodParam).setValue(period);
                ((DoubleParameter)periodParam).getEditor().setParameter(periodParam);
            }
            params.addParameter(param);
        }
        this.updateGUI();
    }

    public ArrayList<String> getSupportedIMTs() {
        return this.imtParameter.getAllowedStrings();
    }

    public Parameter<Double> getSelectedIM() {
        return this.imtParams.getParameter(this.getSelectedIMT());
    }

    @Override
    public void parameterChange(ParameterChangeEvent event) {
        String paramName = event.getParameterName();
        if (paramName.equals(IMT_PARAM_NAME)) {
            this.fireIMTChangeEvent();
            this.updateGUI();
        } else if (paramName.equals("SA Period")) {
            if (this.getSelectedIMT().equals("SA")) {
                this.fireIMTChangeEvent();
            }
        } else if (paramName.equals("SA Interpolated Period") && this.getSelectedIMT().equals("SA Interpolated")) {
            this.fireIMTChangeEvent();
        }
    }

    public void addIMTChangeListener(IMTChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeIMTChangeListener(IMTChangeListener listener) {
        this.listeners.remove(listener);
    }

    public void clearIMTChangeListeners(IMTChangeListener listener) {
        this.listeners.clear();
    }

    private void fireIMTChangeEvent() {
        IMTChangeEvent event = new IMTChangeEvent(this, this.getSelectedIM());
        for (IMTChangeListener listener : this.listeners) {
            listener.imtChange(event);
        }
    }

    public void setIMTinIMR(ScalarIMR imr) {
        IMT_GcimGuiBean.setIMTinIMR(this.getSelectedIM(), imr);
    }

    public void setIMTsInIMCorrRel(ImCorrelationRelationship imCorrRel, Parameter<Double> imj) {
        IMT_GcimGuiBean.setIMTsinIMCorrRel(this.getSelectedIM(), imj, imCorrRel);
    }

    public void setIMTinIMRs(Map<TectonicRegionType, ScalarIMR> imrMap) {
        IMT_GcimGuiBean.setIMTinIMRs(this.getSelectedIM(), imrMap);
    }

    public void setIMTsinIMCorrRels(Map<TectonicRegionType, ImCorrelationRelationship> imCorrRelMap, Parameter<Double> imj) {
        IMT_GcimGuiBean.setIMTsInIMCorrRels(this.getSelectedIM(), imj, imCorrRelMap);
    }

    public static void setIMTinIMR(Parameter<Double> imt, ScalarIMR imr) {
        imr.setIntensityMeasure(imt.getName());
        Parameter newIMT = imr.getIntensityMeasure();
        for (Parameter<?> toBeSet : newIMT.getIndependentParameterList()) {
            Parameter newVal = imt.getIndependentParameter(toBeSet.getName());
            toBeSet.setValue(newVal.getValue());
        }
    }

    public static void setIMTsinIMCorrRel(Parameter<Double> imti, Parameter<Double> imtj, ImCorrelationRelationship imCorrRel) {
        imCorrRel.setIntensityMeasurei(imti.getName());
        Parameter newIMTi = imCorrRel.getIntensityMeasurei();
        for (Parameter<?> toBeSet : newIMTi.getIndependentParameterList()) {
            Parameter newVal = imti.getIndependentParameter(toBeSet.getName());
            toBeSet.setValue(newVal.getValue());
        }
        imCorrRel.setIntensityMeasurej(imtj.getName());
        Parameter newIMTj = imCorrRel.getIntensityMeasurej();
        for (Parameter<?> toBeSet : newIMTj.getIndependentParameterList()) {
            Parameter newVal = imtj.getIndependentParameter(toBeSet.getName());
            toBeSet.setValue(newVal.getValue());
        }
    }

    public static void setIMTinIMRs(Parameter<Double> imt, Map<TectonicRegionType, ScalarIMR> imrMap) {
        for (TectonicRegionType trt : imrMap.keySet()) {
            ScalarIMR imr = imrMap.get(trt);
            IMT_GcimGuiBean.setIMTinIMR(imt, imr);
        }
    }

    public static void setIMTsInIMCorrRels(Parameter<Double> imti, Parameter<Double> imtj, Map<TectonicRegionType, ImCorrelationRelationship> imCorrRelMap) {
        for (TectonicRegionType trt : imCorrRelMap.keySet()) {
            ImCorrelationRelationship imCorrRel = imCorrRelMap.get(trt);
            IMT_GcimGuiBean.setIMTsinIMCorrRel(imti, imtj, imCorrRel);
        }
    }

    public void setSupportedPeriods(ArrayList<Double> supportedPeriods) {
        this.currentSupportedPeriods = supportedPeriods;
        Collections.sort(this.currentSupportedPeriods);
        this.updateGUI();
    }

    public static ArrayList<Double> getCommonPeriods(Collection<? extends ScalarIMR> imrs) {
        ArrayList<Double> allPeriods = IMT_GcimGuiBean.getAllSupportedPeriods(imrs);
        ArrayList<Double> commonPeriods = new ArrayList<Double>();
        for (Double period : allPeriods) {
            boolean include = true;
            for (ScalarIMR scalarIMR : imrs) {
                scalarIMR.setIntensityMeasure("SA");
                SA_Param saParam = (SA_Param)scalarIMR.getIntensityMeasure();
                PeriodParam periodParam = saParam.getPeriodParam();
                if (periodParam.isAllowed(period)) continue;
                include = false;
                break;
            }
            if (!include) continue;
            commonPeriods.add(period);
        }
        return commonPeriods;
    }

    public static ArrayList<Double> getAllSupportedPeriods(Collection<? extends ScalarIMR> imrs) {
        ArrayList<Double> periods = new ArrayList<Double>();
        for (ScalarIMR scalarIMR : imrs) {
            if (!scalarIMR.isIntensityMeasureSupported("SA")) continue;
            scalarIMR.setIntensityMeasure("SA");
            SA_Param saParam = (SA_Param)scalarIMR.getIntensityMeasure();
            PeriodParam periodParam = saParam.getPeriodParam();
            for (double period : periodParam.getAllowedDoubles()) {
                if (periods.contains(period)) continue;
                periods.add(period);
            }
        }
        return periods;
    }

    @Override
    public void imrChange(ScalarIMRChangeEvent event) {
        this.setSupportedPeriods(IMT_GcimGuiBean.getCommonPeriods(event.getNewIMRs().values()));
        this.setIMTinIMRs(event.getNewIMRs());
    }

    public ParameterList getIMTParams() {
        return this.imtParams;
    }
}

