/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import org.opensha.commons.data.region.SitesInGriddedRegion;
import org.opensha.commons.data.siteData.OrderedSiteDataProviderList;
import org.opensha.commons.data.siteData.gui.beans.OrderedSiteDataGUIBean;
import org.opensha.commons.data.xyz.GeoDataSet;
import org.opensha.commons.exceptions.ParameterException;
import org.opensha.commons.gui.ControlPanel;
import org.opensha.commons.gui.DisclaimerDialog;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.util.ApplicationVersion;
import org.opensha.commons.util.ListUtils;
import org.opensha.commons.util.ServerPrefUtils;
import org.opensha.commons.util.bugReports.BugReport;
import org.opensha.commons.util.bugReports.BugReportDialog;
import org.opensha.commons.util.bugReports.DefaultExceptionHandler;
import org.opensha.sha.calc.ScenarioShakeMapCalculator;
import org.opensha.sha.earthquake.ERF_Ref;
import org.opensha.sha.earthquake.EqkRupture;
import org.opensha.sha.gui.beans.AttenuationRelationshipGuiBean;
import org.opensha.sha.gui.beans.AttenuationRelationshipSiteParamsRegionAPI;
import org.opensha.sha.gui.beans.EqkRupSelectorGuiBean;
import org.opensha.sha.gui.beans.IMLorProbSelectorGuiBean;
import org.opensha.sha.gui.beans.MapGuiBean;
import org.opensha.sha.gui.beans.SitesInGriddedRectangularRegionGuiBean;
import org.opensha.sha.gui.controls.CalculationSettingsControlPanel;
import org.opensha.sha.gui.controls.CalculationSettingsControlPanelAPI;
import org.opensha.sha.gui.controls.GenerateHazusControlPanelForSingleMultipleIMRs;
import org.opensha.sha.gui.controls.PuenteHillsScenarioControlPanelUsingEqkRuptureCreation;
import org.opensha.sha.gui.controls.RegionsOfInterestControlPanel;
import org.opensha.sha.gui.controls.SanAndreasScenarioControlPanel;
import org.opensha.sha.gui.infoTools.CalcProgressBar;
import org.opensha.sha.gui.infoTools.IMT_Info;
import org.opensha.sha.gui.util.IconFetcher;
import org.opensha.sha.imr.event.ScalarIMRChangeEvent;
import org.opensha.sha.imr.event.ScalarIMRChangeListener;

public class ScenarioShakeMapApp
extends JFrame
implements ParameterChangeListener,
AttenuationRelationshipSiteParamsRegionAPI,
CalculationSettingsControlPanelAPI,
Runnable,
ScalarIMRChangeListener {
    private static final long serialVersionUID = 1L;
    public static final String APP_NAME = "Scenario ShakeMap Application";
    public static final String APP_SHORT_NAME = "ScenarioShakeMapLocal";
    protected String appShortName;
    protected static final String C = "ScenarioShakeMapApp";
    private static ApplicationVersion version;
    protected static final boolean D = false;
    protected static final int W = 550;
    protected static final int H = 760;
    protected Insets defaultInsets = new Insets(4, 4, 4, 4);
    protected String serverRegionFilePath;
    protected String serverXYZDataSetFilePath;
    protected GeoDataSet xyzDataSet;
    protected SitesInGriddedRegion griddedRegionSites;
    protected boolean probAtIML = false;
    protected double imlProbValue;
    protected EqkRupture eqkRupture;
    protected ArrayList attenRel;
    protected ArrayList attenRelWts;
    protected ScenarioShakeMapCalculator shakeMapCalc = new ScenarioShakeMapCalculator();
    protected Timer timer;
    protected String mapParametersInfo = null;
    protected static final String CONTROL_PANELS = "Control Panels";
    private ArrayList<ControlPanel> controlPanels;
    protected RegionsOfInterestControlPanel regionsOfInterest;
    protected PuenteHillsScenarioControlPanelUsingEqkRuptureCreation puenteHillsControlUsingEqkRupture;
    protected SanAndreasScenarioControlPanel sanAndreasControlUsingEqkRupture;
    protected GenerateHazusControlPanelForSingleMultipleIMRs hazusControl;
    protected EqkRupSelectorGuiBean erfGuiBean;
    protected AttenuationRelationshipGuiBean imrGuiBean;
    protected SitesInGriddedRectangularRegionGuiBean sitesGuiBean;
    protected OrderedSiteDataGUIBean siteDataGUIBean;
    protected IMLorProbSelectorGuiBean imlProbGuiBean;
    protected MapGuiBean mapGuiBean;
    protected boolean isStandalone = false;
    protected JPanel mainPanel = new JPanel();
    protected Border border1;
    protected JSplitPane mainSplitPane = new JSplitPane();
    protected JPanel buttonPanel = new JPanel();
    protected JPanel eqkRupPanel = new JPanel();
    protected GridBagLayout gridBagLayout3 = new GridBagLayout();
    protected GridBagLayout gridBagLayout2 = new GridBagLayout();
    protected JPanel gmtPanel = new JPanel();
    protected JTabbedPane parameterTabbedPanel = new JTabbedPane();
    protected JPanel imrPanel = new JPanel();
    protected JPanel imtPanel = new JPanel();
    protected JPanel prob_IMLPanel = new JPanel();
    protected BorderLayout borderLayout2 = new BorderLayout();
    protected GridBagLayout gridBagLayout9 = new GridBagLayout();
    protected GridBagLayout gridBagLayout8 = new GridBagLayout();
    protected JButton addButton = new JButton();
    protected JPanel gridRegionSitePanel = new JPanel();
    protected GridLayout gridLayout1 = new GridLayout();
    protected GridBagLayout gridBagLayout1 = new GridBagLayout();
    protected GridBagLayout gridBagLayout5 = new GridBagLayout();
    protected JComboBox<String> controlComboBox = new JComboBox();
    protected GridBagLayout gridBagLayout6 = new GridBagLayout();
    protected BorderLayout borderLayout1 = new BorderLayout();
    protected CalcProgressBar calcProgress;
    protected int step;
    protected GridBagLayout gridBagLayout4 = new GridBagLayout();

    public ScenarioShakeMapApp(String appShortName) {
        this.appShortName = appShortName;
    }

    public void init() {
        BugReportDialog bugDialog;
        BugReport bug;
        try {
            this.initSiteDataGuiBean();
        }
        catch (RuntimeException ex) {
            this.step = 0;
            ex.printStackTrace();
            bug = new BugReport(ex, "Exception occured while initializing the Site Data providers in ScenarioShakeMap application.Parameters values have not been set yet.", this.appShortName, ScenarioShakeMapApp.getAppVersion(), this);
            bugDialog = new BugReportDialog((Component)this, bug, true);
            bugDialog.setVisible(true);
        }
        try {
            this.jbInit();
        }
        catch (Exception e) {
            this.step = 0;
            e.printStackTrace();
            bug = new BugReport(e, "Exception during initializing the application.\nParameters values not yet set.", this.appShortName, ScenarioShakeMapApp.getAppVersion(), this);
            bugDialog = new BugReportDialog((Component)this, bug, true);
            bugDialog.setVisible(true);
        }
        try {
            this.initIMRGuiBean();
        }
        catch (RuntimeException e) {
            this.step = 0;
            e.printStackTrace();
            bug = new BugReport(e, "Exception occured initializing the IMR with default parameters value", this.appShortName, ScenarioShakeMapApp.getAppVersion(), this);
            bugDialog = new BugReportDialog((Component)this, bug, true);
            bugDialog.setVisible(true);
        }
        try {
            this.initGriddedRegionGuiBean();
        }
        catch (Exception ex) {
            this.step = 0;
            ex.printStackTrace();
            bug = new BugReport(ex, "Exception occured while initializing the  region parameters in ScenarioShakeMap application.Parameters values have not been set yet.", this.appShortName, ScenarioShakeMapApp.getAppVersion(), this);
            bugDialog = new BugReportDialog((Component)this, bug, true);
            bugDialog.setVisible(true);
        }
        try {
            this.initERFSelector_GuiBean();
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            this.step = 0;
            JOptionPane.showMessageDialog(this, "Could not create ERF Object", "Error occurred in ERF", 0);
            System.exit(0);
        }
        this.initImlProb_GuiBean();
        this.initMapGuiBean();
        this.initControlList();
        SwingUtilities.invokeLater(() -> {
            String selected = (String)this.controlComboBox.getSelectedItem();
            if (selected != null) {
                FontMetrics fm = this.controlComboBox.getFontMetrics(this.controlComboBox.getFont());
                int textWidth = fm.stringWidth(selected);
                int totalWidth = textWidth + 50;
                Dimension size = new Dimension(totalWidth, this.controlComboBox.getPreferredSize().height);
                this.controlComboBox.setPreferredSize(size);
                this.controlComboBox.setMinimumSize(size);
                this.controlComboBox.revalidate();
                this.buttonPanel.revalidate();
                this.mainPanel.revalidate();
            }
        });
    }

    public static ApplicationVersion getAppVersion() {
        if (version == null) {
            try {
                version = ApplicationVersion.loadBuildVersion();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return version;
    }

    protected void jbInit() throws Exception {
        this.border1 = new EtchedBorder(0, new Color(248, 254, 255), new Color(121, 124, 136));
        this.setSize(new Dimension(564, 752));
        this.getContentPane().setLayout(this.borderLayout1);
        this.mainPanel.setBorder(this.border1);
        this.mainPanel.setLayout(this.gridBagLayout6);
        this.mainSplitPane.setOrientation(0);
        this.mainSplitPane.setLastDividerLocation(610);
        this.buttonPanel.setLayout(this.gridBagLayout4);
        this.eqkRupPanel.setLayout(this.gridBagLayout1);
        this.gmtPanel.setLayout(this.gridBagLayout9);
        this.imrPanel.setLayout(this.borderLayout2);
        this.imtPanel.setLayout(this.gridBagLayout8);
        this.prob_IMLPanel.setLayout(this.gridBagLayout2);
        this.addButton.setText("Make Map");
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScenarioShakeMapApp.this.addButton_actionPerformed(e);
            }
        });
        this.buttonPanel.setMinimumSize(new Dimension(391, 50));
        this.gridRegionSitePanel.setLayout(this.gridLayout1);
        this.imrPanel.setLayout(this.gridBagLayout5);
        this.controlComboBox.setBackground(SystemColor.control);
        this.controlComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScenarioShakeMapApp.this.controlComboBox_actionPerformed(e);
            }
        });
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.mainPanel.add((Component)this.mainSplitPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(1, 1, 2, 3), 0, 431));
        this.mainSplitPane.add((Component)this.buttonPanel, "bottom");
        this.buttonPanel.add(this.controlComboBox, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(64, 32, 47, 0), 8, 2));
        this.buttonPanel.add((Component)this.addButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(48, 88, 39, 139), 26, 9));
        this.mainSplitPane.add((Component)this.parameterTabbedPanel, "top");
        this.parameterTabbedPanel.addTab("Intensity-Measure Relationship", this.imrPanel);
        this.parameterTabbedPanel.addTab("Region & Site Params", this.gridRegionSitePanel);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.siteDataGUIBean, "Center");
        this.parameterTabbedPanel.addTab("Site Data Providers", panel);
        this.parameterTabbedPanel.addTab("Earthquake Rupture", this.eqkRupPanel);
        this.parameterTabbedPanel.addTab("Exceedance Level/Probability", this.prob_IMLPanel);
        this.parameterTabbedPanel.addTab("Map Attributes", this.gmtPanel);
        this.mainSplitPane.setDividerLocation(630);
        this.setSize(550, 760);
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dim.width - this.getSize().width) / 2, (dim.height - this.getSize().height) / 2);
        this.setDefaultCloseOperation(3);
        this.setTitle("Scenario ShakeMap Application (" + String.valueOf(ScenarioShakeMapApp.getAppVersion()) + ")");
    }

    public static void main(String[] args) throws IOException {
        new DisclaimerDialog(APP_NAME, APP_SHORT_NAME, ScenarioShakeMapApp.getAppVersion());
        DefaultExceptionHandler exp = new DefaultExceptionHandler(APP_SHORT_NAME, ScenarioShakeMapApp.getAppVersion(), null, null);
        Thread.setDefaultUncaughtExceptionHandler(exp);
        ScenarioShakeMapApp.launch(exp);
    }

    public static ScenarioShakeMapApp launch(DefaultExceptionHandler handler) {
        ScenarioShakeMapApp applet = new ScenarioShakeMapApp(APP_SHORT_NAME);
        if (handler != null) {
            handler.setApp(applet);
            handler.setParent(applet);
        }
        applet.init();
        applet.setIconImages(IconFetcher.fetchIcons(APP_SHORT_NAME));
        applet.setVisible(true);
        return applet;
    }

    protected void initGriddedRegionGuiBean() {
        this.sitesGuiBean = new SitesInGriddedRectangularRegionGuiBean(this.siteDataGUIBean);
        this.setGriddedRegionSiteParams();
        this.gridRegionSitePanel.add((Component)this.sitesGuiBean, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, this.defaultInsets, 0, 0));
    }

    protected void initSiteDataGuiBean() {
        OrderedSiteDataProviderList provs = OrderedSiteDataProviderList.createSiteDataProviderDefaults();
        for (int i = 0; i < provs.size(); ++i) {
            String name = provs.getProvider(i).getName();
            if (name.equals("SCEC Community Velocity Model Version 4 Basin Depth")) {
                provs.setEnabled(i, true);
                continue;
            }
            if (name.equals("CGS/Wills Site Classification Map (2006)")) {
                provs.setEnabled(i, true);
                continue;
            }
            if (name.equals("Global Vs30 from Topographic Slope (Wald & Allen 2008)")) {
                provs.setEnabled(i, true);
                continue;
            }
            provs.setEnabled(i, false);
        }
        this.siteDataGUIBean = new OrderedSiteDataGUIBean(provs);
    }

    protected void initIMRGuiBean() {
        this.imrGuiBean = new AttenuationRelationshipGuiBean(this);
        this.imrGuiBean.getIntensityMeasureParamEditor().getParameterEditor("IMT").getParameter().addParameterChangeListener(this);
        this.imrPanel.add((Component)this.imrGuiBean, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, this.defaultInsets, 0, 0));
        this.imrGuiBean.addAttenuationRelationshipChangeListener(this);
        this.siteDataGUIBean.setIMR(this.imrGuiBean.getSelectedIMR_Instance());
    }

    protected void initERFSelector_GuiBean() {
        try {
            this.erfGuiBean = new EqkRupSelectorGuiBean(ERF_Ref.get(false, ServerPrefUtils.SERVER_PREFS));
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Connection to ERF's failed");
        }
        this.eqkRupPanel.add((Component)this.erfGuiBean, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, this.defaultInsets, 0, 0));
    }

    protected void initImlProb_GuiBean() {
        this.imlProbGuiBean = new IMLorProbSelectorGuiBean();
        this.imlProbGuiBean.setIMLConstraintBasedOnSelectedIMT(this.imrGuiBean.getSelectedIMT());
        this.prob_IMLPanel.add((Component)this.imlProbGuiBean, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, this.defaultInsets, 0, 0));
    }

    protected void initMapGuiBean() {
        this.mapGuiBean = new MapGuiBean();
        this.mapGuiBean.showRegionParams(false);
        this.gmtPanel.add((Component)this.mapGuiBean, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, this.defaultInsets, 0, 0));
        double minLat = (Double)this.sitesGuiBean.getParameterList().getParameter("Min  Latitude").getValue();
        double maxLat = (Double)this.sitesGuiBean.getParameterList().getParameter("Max  Latitude").getValue();
        double minLon = (Double)this.sitesGuiBean.getParameterList().getParameter("Min Longitude").getValue();
        double maxLon = (Double)this.sitesGuiBean.getParameterList().getParameter("Max Longitude").getValue();
        double gridSpacing = (Double)this.sitesGuiBean.getParameterList().getParameter("Grid Spacing").getValue();
        this.mapGuiBean.setRegionParams(minLat, maxLat, minLon, maxLon, gridSpacing);
    }

    @Override
    public void parameterChange(ParameterChangeEvent event) {
        String S = "ScenarioShakeMapApp: parameterChange(): ";
        String name1 = event.getParameterName();
        if (name1.equalsIgnoreCase("IMT")) {
            this.imlProbGuiBean.setIMLConstraintBasedOnSelectedIMT(this.imrGuiBean.getSelectedIMT());
        }
    }

    @Override
    public void run() {
        try {
            this.addButton();
        }
        catch (ParameterException ee) {
            this.step = 0;
            JOptionPane.showMessageDialog(this, ee.getMessage(), "Invalid Parameters", 0);
            return;
        }
        catch (RuntimeException ee) {
            this.step = 0;
            JOptionPane.showMessageDialog(this, ee.getMessage(), "Input Error", 0);
            ee.printStackTrace();
            return;
        }
        catch (Exception ee) {
            this.step = 0;
            ee.printStackTrace();
            BugReport bug = new BugReport(ee, this.mapParametersInfo, this.appShortName, ScenarioShakeMapApp.getAppVersion(), this);
            BugReportDialog bugDialog = new BugReportDialog((Component)this, bug, false);
            bugDialog.setVisible(true);
            this.addButton.setEnabled(true);
            return;
        }
    }

    @Override
    public void setGriddedRegionSiteParams() {
        if (this.sitesGuiBean != null) {
            this.sitesGuiBean.replaceSiteParams(this.imrGuiBean.getSelectedAttenRelSiteParams());
            this.sitesGuiBean.refreshParamEditor();
        }
    }

    protected void getGriddedRegionSites() {
        this.griddedRegionSites = this.sitesGuiBean.getGriddedRegionSite();
    }

    protected void getIMLorProb() {
        this.imlProbValue = this.imlProbGuiBean.getIML_Prob();
        String imlOrProb = this.imlProbGuiBean.getSelectedOption();
        this.probAtIML = imlOrProb.equalsIgnoreCase("Prob@IML");
    }

    public Object generateShakeMap(ArrayList attenRel, ArrayList attenRelWts, String imt) throws ParameterException {
        try {
            double value = this.imlProbValue;
            if (IMT_Info.isIMT_LogNormalDist(this.imrGuiBean.getSelectedIMT()) && this.probAtIML) {
                value = Math.log(this.imlProbValue);
            }
            this.xyzDataSet = this.shakeMapCalc.getScenarioShakeMapData(attenRel, attenRelWts, this.griddedRegionSites, this.eqkRupture, this.probAtIML, value);
            if (IMT_Info.isIMT_LogNormalDist(imt) && !this.probAtIML) {
                this.xyzDataSet.exp();
            }
            return this.xyzDataSet;
        }
        catch (ParameterException e) {
            throw new ParameterException(e.getMessage());
        }
    }

    public void getEqkRupture() {
        this.eqkRupture = this.erfGuiBean.getRupture();
    }

    protected void setRegionForGMT() {
        double minLat = (Double)this.sitesGuiBean.getParameterList().getParameter("Min  Latitude").getValue();
        double maxLat = (Double)this.sitesGuiBean.getParameterList().getParameter("Max  Latitude").getValue();
        double minLon = (Double)this.sitesGuiBean.getParameterList().getParameter("Min Longitude").getValue();
        double maxLon = (Double)this.sitesGuiBean.getParameterList().getParameter("Max Longitude").getValue();
        double gridSpacing = (Double)this.sitesGuiBean.getParameterList().getParameter("Grid Spacing").getValue();
        this.mapGuiBean.setRegionParams(minLat, maxLat, minLon, maxLon, gridSpacing);
    }

    public Parameter getSelectedIntensityMeasure() {
        return this.imrGuiBean.getSelectedIntensityMeasure();
    }

    public void makeMapForHazus(Object datasetForSA_03, Object datasetForSA_1, Object datasetForPGA, Object datasetForPGV) {
        this.setRegionForGMT();
        this.mapGuiBean.setGMT_ParamsForHazus();
        this.mapParametersInfo = this.getMapParametersInfoAsHTML();
        this.mapGuiBean.makeHazusShapeFilesAndMap((GeoDataSet)datasetForSA_03, (GeoDataSet)datasetForSA_1, (GeoDataSet)datasetForPGA, (GeoDataSet)datasetForPGV, this.eqkRupture, this.mapParametersInfo);
        this.mapGuiBean.setGMT_ParamsChangedForHazusToOriginalValue();
        this.hazusControl.setGenerateShapeFilesForHazus(false);
        System.gc();
    }

    public void getGriddedSitesMapTypeAndSelectedAttenRels() {
        this.getIMLorProb();
        this.getGriddedRegionSites();
        this.attenRelWts = this.imrGuiBean.getSelectedIMR_Weights();
        this.attenRel = this.imrGuiBean.getSelectedIMRs();
    }

    protected void addButton_actionPerformed(ActionEvent e) {
        this.addButton.setEnabled(false);
        this.calcProgress = new CalcProgressBar(C, "Initializing ShakeMap Calculation");
        this.getEqkRupture();
        this.mapParametersInfo = this.getMapParametersInfoAsHTML();
        try {
            this.getGriddedSitesMapTypeAndSelectedAttenRels();
        }
        catch (RuntimeException ee) {
            JOptionPane.showMessageDialog(this, ee.getMessage(), "Input or Server Problem", 1);
            ee.printStackTrace();
            this.addButton.setEnabled(true);
            return;
        }
        this.imrGuiBean.setIMT();
        this.timer = new Timer(200, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (ScenarioShakeMapApp.this.step == 1) {
                    ScenarioShakeMapApp.this.calcProgress.setProgressMessage("Computing the ShakeMap Data ...");
                } else if (ScenarioShakeMapApp.this.step == 2) {
                    ScenarioShakeMapApp.this.calcProgress.setProgressMessage("Generating the ShakeMap Image ...");
                } else if (ScenarioShakeMapApp.this.step == 0) {
                    ScenarioShakeMapApp.this.addButton.setEnabled(true);
                    ScenarioShakeMapApp.this.timer.stop();
                    ScenarioShakeMapApp.this.calcProgress.dispose();
                    ScenarioShakeMapApp.this.calcProgress = null;
                }
            }
        });
        Thread t = new Thread(this);
        t.start();
    }

    protected void addButton() throws ParameterException, RuntimeException {
        this.timer.start();
        this.step = 1;
        this.generateShakeMap(this.attenRel, this.attenRelWts, this.imrGuiBean.getSelectedIMT());
        this.setRegionForGMT();
        ++this.step;
        String label = this.getMapLabel();
        this.mapGuiBean.makeMap(this.xyzDataSet, this.eqkRupture, label, this.mapParametersInfo);
        System.gc();
        this.step = 0;
    }

    protected String getMapLabel() {
        String label = this.probAtIML ? "Prob" : this.imrGuiBean.getSelectedIMT();
        return label;
    }

    @Override
    public ParameterList getCalcAdjustableParams() {
        return this.shakeMapCalc.getAdjustableParams();
    }

    @Override
    public String getCalcParamMetadataString() {
        ParameterList params = this.getCalcAdjustableParams();
        if (params == null || params.size() == 0) {
            return "";
        }
        return params.getParameterListMetadataString();
    }

    protected void initControlList() {
        this.controlPanels = new ArrayList();
        this.controlComboBox.addItem(CONTROL_PANELS);
        this.controlComboBox.addItem("Regions of Interest");
        this.controlPanels.add(new RegionsOfInterestControlPanel(this, this.sitesGuiBean));
        this.controlComboBox.addItem("Generate Hazus Shape files for Scenario");
        this.hazusControl = new GenerateHazusControlPanelForSingleMultipleIMRs(this, this);
        this.controlPanels.add(this.hazusControl);
        this.controlComboBox.addItem("Set Params for Puente Hills Scenario");
        this.controlPanels.add(new PuenteHillsScenarioControlPanelUsingEqkRuptureCreation(this.erfGuiBean, this.imrGuiBean, this.sitesGuiBean, this.mapGuiBean, this));
        this.controlComboBox.addItem("Set Params for SAF Shakeout Quake Scenario");
        this.controlPanels.add(new SanAndreasScenarioControlPanel(this.erfGuiBean, this.imrGuiBean, this.sitesGuiBean, this.mapGuiBean, this));
        ParameterList params = this.getCalcAdjustableParams();
        if (params != null && params.size() > 0) {
            this.controlComboBox.addItem("Calculation Settings");
            this.controlPanels.add(new CalculationSettingsControlPanel(this, this));
        }
    }

    protected void showControlPanel(String controlName) {
        ControlPanel control = (ControlPanel)ListUtils.getObjectByName(this.controlPanels, controlName);
        if (control == null) {
            throw new NullPointerException("Control Panel '" + controlName + "' not found!");
        }
        this.showControlPanel(control);
    }

    protected void showControlPanel(ControlPanel control) {
        control.showControlPanel();
    }

    protected void controlComboBox_actionPerformed(ActionEvent e) {
        if (this.controlComboBox.getItemCount() <= 0) {
            return;
        }
        if (this.controlComboBox.getSelectedIndex() == 0) {
            return;
        }
        String selectedControl = this.controlComboBox.getSelectedItem().toString();
        this.showControlPanel(selectedControl);
        this.controlComboBox.setSelectedItem(CONTROL_PANELS);
    }

    public ArrayList getSelectedAttenuationRelationships() {
        this.attenRel = this.imrGuiBean.getSelectedIMRs();
        return this.attenRel;
    }

    public ArrayList getSelectedAttenuationRelationshipsWts() {
        this.attenRelWts = this.imrGuiBean.getSelectedIMR_Weights();
        return this.attenRelWts;
    }

    public String getMapParametersInfoAsHTML() {
        Object imrMetadata = "IMR Param List:<br>\n ---------------<br>\n";
        imrMetadata = this.hazusControl != null && this.hazusControl.isGenerateShapeFilesForHazus() ? (String)imrMetadata + this.imrGuiBean.getIMR_ParameterListMetadataString() + this.hazusControl.getIMT_Metadata() + "\n" : (String)imrMetadata + this.imrGuiBean.getIMR_ParameterListMetadataString() + this.imrGuiBean.getIMT_ParameterListMetadataString() + "\n";
        String calculationSettingsParamsMetadata = "<br><br>Calculation Param List:<br>\n ------------------<br>\n" + this.getCalcParamMetadataString() + "\n";
        return (String)imrMetadata + "<br><br>Region Param List: <br>\n----------------<br>\n" + this.sitesGuiBean.getVisibleParameters().getParameterListMetadataString() + "\n" + this.erfGuiBean.getParameterListMetadataString() + "\n<br><br>TimeSpan Param List: <br>\n--------------------<br>\n" + this.erfGuiBean.getTimespanMetadataString() + "\n<br><br>GMT Param List: <br>\n--------------------<br>\n" + this.mapGuiBean.getVisibleParameters().getParameterListMetadataString() + "\n" + calculationSettingsParamsMetadata;
    }

    @Override
    public void imrChange(ScalarIMRChangeEvent event) {
        this.siteDataGUIBean.setIMR(event.getNewIMRs().values());
    }

    static {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

