/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.gui.beans;

import com.google.common.base.Preconditions;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.ListIterator;
import javax.swing.JPanel;
import org.opensha.commons.data.WeightedList;
import org.opensha.commons.geo.Location;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.editor.ParameterEditor;
import org.opensha.commons.param.editor.impl.ParameterListEditor;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.impl.BooleanParameter;
import org.opensha.commons.param.impl.DoubleParameter;
import org.opensha.commons.param.impl.LocationParameter;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.sha.earthquake.EqkRupture;
import org.opensha.sha.earthquake.param.PointSourceDistanceCorrectionParam;
import org.opensha.sha.faultSurface.AbstractEvenlyGriddedSurface;
import org.opensha.sha.faultSurface.PointSurface;
import org.opensha.sha.faultSurface.RuptureSurface;
import org.opensha.sha.faultSurface.utils.PointSourceDistanceCorrection;
import org.opensha.sha.faultSurface.utils.PointSourceDistanceCorrections;
import org.opensha.sha.gui.beans.EqkRupSelectorGuiBeanAPI;
import org.opensha.sha.param.SimpleFaultParameter;

public class EqkRuptureCreationPanel
extends JPanel
implements EqkRupSelectorGuiBeanAPI,
ParameterChangeListener {
    private static final long serialVersionUID = 1L;
    public static final String MAG_PARAM_NAME = "Magnitude";
    private static final String MAG_PARAM_INFO = "The  magnitude of the rupture";
    private static final String MAG_PARAM_UNITS = null;
    private Double MAG_PARAM_MIN = 0.0;
    private Double MAG_PARAM_MAX = 10.0;
    private Double MAG_PARAM_DEFAULT = 7.0;
    public static final String RAKE_PARAM_NAME = "Rake";
    private static final String RAKE_PARAM_INFO = "The rake of the rupture (direction of slip)";
    private static final String RAKE_PARAM_UNITS = "degrees";
    private Double RAKE_PARAM_MIN = -180.0;
    private Double RAKE_PARAM_MAX = 180.0;
    private Double RAKE_PARAM_DEFAULT = 0.0;
    public static final String DIP_PARAM_NAME = "Dip";
    private static final String DIP_PARAM_INFO = "The dip of the rupture surface";
    private static final String DIP_PARAM_UNITS = "degrees";
    private Double DIP_PARAM_MIN = 0.0;
    private Double DIP_PARAM_MAX = 90.0;
    private Double DIP_PARAM_DEFAULT = 90.0;
    private Double SRC_LAT_PARAM_DEFAULT = 35.71;
    private Double SRC_LON_PARAM_DEFAULT = -121.1;
    private Double SRC_DEPTH_PARAM_DEFAULT = 7.6;
    public static final String SRC_TYP_PARAM_NAME = "Rupture Type";
    private static final String SRC_TYP_PARAM_INFO = "Type of rupture";
    public static final String POINT_SRC_NAME = "Point source rupture";
    public static final String FINITE_SRC_NAME = "Finite source rupture";
    public static final String FAULT_PARAM_NAME = "Set Fault Surface";
    private static final String FAULT_PARAM_INFO = "Source location parameters for finite rupture";
    public static final String LOCATION_PARAM_NAME = "Location";
    private static final String LOCATION_PARAM_INFO = "Set Location for the point source";
    public static final String HYPOCENTER_LOCATION_PARAM_NAME = "Hypocenter Location";
    public static final String SHOW_HYPOCENTER_LOCATION_PARAM_NAME = "Set Hypocenter Location";
    public static final String NULL_HYPOCENTER_STRING = "Null Hypocenter";
    private static final String TITLE = "";
    private StringParameter sourceTypeParam;
    private DoubleParameter magParam;
    private DoubleParameter dipParam;
    private DoubleParameter rakeParam;
    private LocationParameter locationParam;
    private LocationParameter hypocenterLocationParam;
    private BooleanParameter showHypocenterLocationParam = new BooleanParameter("Set Hypocenter Location", false);
    private SimpleFaultParameter faultParam;
    private PointSourceDistanceCorrectionParam distCorrParam;
    private boolean parameterChangeFlag = true;
    private ParameterList parameterList;
    private ParameterListEditor listEditor;
    private EqkRupture eqkRupture;
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private ArrayList<Location> hypocenterList;
    private RuptureSurface ruptureSurface = null;

    public EqkRuptureCreationPanel() {
        this.magParam = new DoubleParameter(MAG_PARAM_NAME, this.MAG_PARAM_MIN, this.MAG_PARAM_MAX, MAG_PARAM_UNITS, this.MAG_PARAM_DEFAULT);
        this.magParam.setInfo(MAG_PARAM_INFO);
        this.rakeParam = new DoubleParameter(RAKE_PARAM_NAME, this.RAKE_PARAM_MIN, this.RAKE_PARAM_MAX, "degrees", this.RAKE_PARAM_DEFAULT);
        this.rakeParam.setInfo(RAKE_PARAM_INFO);
        this.dipParam = new DoubleParameter(DIP_PARAM_NAME, this.DIP_PARAM_MIN, this.DIP_PARAM_MAX, "degrees", this.DIP_PARAM_DEFAULT);
        this.dipParam.setInfo(DIP_PARAM_INFO);
        this.locationParam = new LocationParameter(LOCATION_PARAM_NAME, new Location(this.SRC_LAT_PARAM_DEFAULT, this.SRC_LON_PARAM_DEFAULT, this.SRC_DEPTH_PARAM_DEFAULT));
        this.faultParam = new SimpleFaultParameter(FAULT_PARAM_NAME);
        this.faultParam.setInfo(FAULT_PARAM_INFO);
        ArrayList<String> ruptureTypeList = new ArrayList<String>();
        ruptureTypeList.add(POINT_SRC_NAME);
        ruptureTypeList.add(FINITE_SRC_NAME);
        this.sourceTypeParam = new StringParameter(SRC_TYP_PARAM_NAME, ruptureTypeList, (String)ruptureTypeList.get(0));
        this.sourceTypeParam.setInfo(SRC_TYP_PARAM_INFO);
        this.distCorrParam = new PointSourceDistanceCorrectionParam(PointSourceDistanceCorrections.SINGLE_CORRS, PointSourceDistanceCorrections.NONE);
        this.parameterList = new ParameterList();
        this.parameterList.addParameter(this.sourceTypeParam);
        this.parameterList.addParameter(this.magParam);
        this.parameterList.addParameter(this.rakeParam);
        this.parameterList.addParameter(this.dipParam);
        this.parameterList.addParameter(this.faultParam);
        this.parameterList.addParameter(this.locationParam);
        this.parameterList.addParameter(this.showHypocenterLocationParam);
        this.parameterList.addParameter(this.distCorrParam);
        this.sourceTypeParam.addParameterChangeListener(this);
        this.magParam.addParameterChangeListener(this);
        this.rakeParam.addParameterChangeListener(this);
        this.locationParam.addParameterChangeListener(this);
        this.dipParam.addParameterChangeListener(this);
        this.faultParam.addParameterChangeListener(this);
        this.showHypocenterLocationParam.addParameterChangeListener(this);
        this.distCorrParam.addParameterChangeListener(this);
        this.createGriddedRuptureSurface();
        this.listEditor = new ParameterListEditor(this.parameterList);
        this.listEditor.setTitle(TITLE);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.validate();
        this.repaint();
        this.setParameterVisibleBasedOnSelectedRuptureType();
        this.setHypocenterLocationParamVisible();
    }

    private void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout1);
        this.add((Component)this.listEditor, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(4, 4, 4, 4), 0, 0));
    }

    private void createGriddedRuptureSurface() {
        String ruptureType = (String)this.sourceTypeParam.getValue();
        if (ruptureType.equals(POINT_SRC_NAME)) {
            PointSourceDistanceCorrection corr;
            this.ruptureSurface = new PointSurface((Location)this.locationParam.getValue());
            double aveDip = (Double)this.dipParam.getValue();
            ((PointSurface)this.ruptureSurface).setAveDip(aveDip);
            Object corrs = ((PointSourceDistanceCorrections)this.distCorrParam.getValue()).get();
            if (corrs == null) {
                corr = null;
            } else {
                Preconditions.checkState((corrs == null || ((WeightedList)corrs).size() == 1 ? 1 : 0) != 0, (Object)"Should only have a single correction");
                corr = (PointSourceDistanceCorrection)((WeightedList)corrs).getValue(0);
            }
            ((PointSurface)this.ruptureSurface).setDistanceCorrection(corr, (Double)this.magParam.getValue());
        } else if (ruptureType.equals(FINITE_SRC_NAME)) {
            this.faultParam.setEvenlyGriddedSurfaceFromParams();
            this.ruptureSurface = (AbstractEvenlyGriddedSurface)this.faultParam.getValue();
        }
        ListIterator hypoLocationsIt = this.ruptureSurface.getEvenlyDiscritizedUpperEdge().listIterator();
        if (this.hypocenterList == null) {
            this.hypocenterList = new ArrayList();
        } else {
            this.hypocenterList.clear();
        }
        while (hypoLocationsIt.hasNext()) {
            Location loc = (Location)hypoLocationsIt.next();
            this.hypocenterList.add(loc);
        }
        this.hypocenterLocationParam = new LocationParameter(HYPOCENTER_LOCATION_PARAM_NAME, this.hypocenterList, this.hypocenterList.get(0));
        this.hypocenterLocationParam.setValue(this.hypocenterList.get(0));
        if (this.parameterList.containsParameter(this.hypocenterLocationParam)) {
            this.listEditor.replaceParameterForEditor(HYPOCENTER_LOCATION_PARAM_NAME, this.hypocenterLocationParam);
        } else {
            this.parameterList.addParameter(this.hypocenterLocationParam);
        }
        if (this.listEditor != null) {
            this.listEditor.getParameterEditor(SHOW_HYPOCENTER_LOCATION_PARAM_NAME).setValue(false);
            this.listEditor.refreshParamEditor();
        }
    }

    private void createRupture() {
        if (this.parameterChangeFlag) {
            this.eqkRupture = new EqkRupture();
            this.eqkRupture.setMag((Double)this.magParam.getValue());
            this.eqkRupture.setAveRake((Double)this.rakeParam.getValue());
            this.eqkRupture.setRuptureSurface(this.ruptureSurface);
            boolean hypocenterLocVisible = (Boolean)this.showHypocenterLocationParam.getValue();
            if (hypocenterLocVisible) {
                this.eqkRupture.setHypocenterLocation(this.getHypocenterLocation());
            }
            this.parameterChangeFlag = false;
        }
    }

    @Override
    public void parameterChange(ParameterChangeEvent event) {
        String name1 = event.getParameterName();
        if (name1.equals(SRC_TYP_PARAM_NAME)) {
            this.setParameterVisibleBasedOnSelectedRuptureType();
            this.createGriddedRuptureSurface();
            this.updateUI();
        } else if (name1.equals(LOCATION_PARAM_NAME) || name1.equals(FAULT_PARAM_NAME) || name1.equals(this.distCorrParam.getName()) || name1.equals(MAG_PARAM_NAME)) {
            this.createGriddedRuptureSurface();
        } else if (name1.equals(SHOW_HYPOCENTER_LOCATION_PARAM_NAME)) {
            this.setHypocenterLocationParamVisible();
        }
        this.parameterChangeFlag = true;
        this.listEditor.refreshParamEditor();
    }

    @Override
    public Location getHypocenterLocation() {
        return (Location)this.hypocenterLocationParam.getValue();
    }

    private void setHypocenterLocationParamVisible() {
        boolean hypocenterLocVisible = (Boolean)this.showHypocenterLocationParam.getValue();
        this.listEditor.setParameterVisible(HYPOCENTER_LOCATION_PARAM_NAME, hypocenterLocVisible);
        this.listEditor.repaint();
        this.listEditor.validate();
    }

    @Override
    public EqkRupture getRupture() {
        this.createRupture();
        return this.eqkRupture;
    }

    @Override
    public String getTimespanMetadataString() {
        return "No Timespan exists for the selected Rupture";
    }

    private void setParameterVisibleBasedOnSelectedRuptureType() {
        String selectedRuptureType = (String)this.sourceTypeParam.getValue();
        if (selectedRuptureType.equals(POINT_SRC_NAME)) {
            this.listEditor.setParameterVisible(LOCATION_PARAM_NAME, true);
            this.listEditor.setParameterVisible(DIP_PARAM_NAME, true);
            this.listEditor.setParameterVisible(FAULT_PARAM_NAME, false);
            this.listEditor.setParameterVisible(this.distCorrParam.getName(), true);
        } else if (selectedRuptureType.equals(FINITE_SRC_NAME)) {
            this.listEditor.setParameterVisible(LOCATION_PARAM_NAME, false);
            this.listEditor.setParameterVisible(DIP_PARAM_NAME, false);
            this.listEditor.setParameterVisible(FAULT_PARAM_NAME, true);
            this.listEditor.setParameterVisible(this.distCorrParam.getName(), false);
        }
        this.listEditor.refreshParamEditor();
        this.validate();
        this.repaint();
    }

    @Override
    public EqkRupSelectorGuiBeanAPI getEqkRuptureSelectorPanel() {
        return this;
    }

    @Override
    public String getParameterListMetadataString() {
        String metadata = "<br><br>Custom Eqk Rupture Param List: <br>\n-------------------------<br>\n" + this.listEditor.getVisibleParameters().getParameterListMetadataString();
        return metadata;
    }

    @Override
    public Parameter getParameter(String paramName) {
        if (this.parameterList.containsParameter(paramName) && this.listEditor.getParameterEditor(paramName).isVisible()) {
            return this.parameterList.getParameter(paramName);
        }
        return null;
    }

    @Override
    public ParameterEditor getParameterEditor(String paramName) {
        if (this.parameterList.containsParameter(paramName) && this.listEditor.getParameterEditor(paramName).isVisible()) {
            return this.listEditor.getParameterEditor(paramName);
        }
        return null;
    }

    @Override
    public ParameterList getVisibleParameterList() {
        return this.listEditor.getVisibleParameters();
    }

    @Override
    public ParameterListEditor getParameterListEditor() {
        return this.listEditor;
    }
}

