/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.gui.beans;

import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.swing.BorderFactory;
import javax.swing.JOptionPane;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.WarningParameter;
import org.opensha.commons.param.constraint.ParameterConstraint;
import org.opensha.commons.param.editor.ParameterEditor;
import org.opensha.commons.param.editor.impl.ParameterListEditor;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeFailEvent;
import org.opensha.commons.param.event.ParameterChangeFailListener;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.event.ParameterChangeWarningEvent;
import org.opensha.commons.param.event.ParameterChangeWarningListener;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.sha.gui.beans.IMR_GuiBeanAPI;
import org.opensha.sha.imr.AttenRelRef;
import org.opensha.sha.imr.AttenuationRelationship;
import org.opensha.sha.imr.ScalarIMR;
import org.opensha.sha.imr.event.ScalarIMRChangeEvent;
import org.opensha.sha.imr.event.ScalarIMRChangeListener;
import org.opensha.sha.util.TectonicRegionType;

@Deprecated
public class IMR_GuiBean
extends ParameterListEditor
implements ParameterChangeListener,
ParameterChangeWarningListener,
ParameterChangeFailListener {
    private ArrayList<ScalarIMRChangeListener> listeners = new ArrayList();
    public static final String IMR_PARAM_NAME = "IMR";
    public static final String IMR_EDITOR_TITLE = "Set IMR";
    private List<? extends ScalarIMR> supportedAttenRels;
    private boolean inParameterChangeWarning = false;
    private IMR_GuiBeanAPI application;
    private boolean isFirstTimeLaunched = true;
    private ScalarIMR currentAttenRel = null;

    public IMR_GuiBean(IMR_GuiBeanAPI api) {
        this(api, AttenRelRef.getAll());
    }

    public IMR_GuiBean(IMR_GuiBeanAPI api, Collection<AttenRelRef> imrRefs) {
        this.init(api, imrRefs);
        this.parameterList = new ParameterList();
        this.init_imrParamListAndEditor();
    }

    public IMR_GuiBean(IMR_GuiBeanAPI api, String currentIMT, String retroIMT, double currentPeriod, double retroPeriod) {
        this.init(api, AttenRelRef.getAll());
        this.setIMRParamListAndEditor(currentIMT, retroIMT, currentPeriod, retroPeriod);
    }

    private void init(IMR_GuiBeanAPI api, Collection<AttenRelRef> imrRefs) {
        this.application = api;
        this.supportedAttenRels = AttenRelRef.instanceList((ParameterChangeWarningListener)this, true, imrRefs);
        for (ScalarIMR scalarIMR : this.supportedAttenRels) {
            scalarIMR.setParamDefaults();
        }
    }

    public void setIMRParamListAndEditor(String currentIMT, String retroIMT, double currentPeriod, double retroPeriod) {
        String selectedAttenRel = null;
        if (this.parameterList != null) {
            selectedAttenRel = (String)this.parameterList.getParameter(IMR_PARAM_NAME).getValue();
        }
        ArrayList attenRels = this.getAttenRelsSupportedForSelectedIM(currentIMT, retroIMT, currentPeriod, retroPeriod);
        this.parameterList = new ParameterList();
        Iterator it = attenRels.iterator();
        ArrayList<String> supportedIMRNames = new ArrayList<String>();
        while (it.hasNext()) {
            ScalarIMR imr = (ScalarIMR)it.next();
            if (this.isFirstTimeLaunched) {
                imr.setParamDefaults();
            }
            supportedIMRNames.add(imr.getName());
            ListIterator<Parameter<?>> it1 = imr.getSiteParamsIterator();
            while (it1.hasNext()) {
                Parameter param = (Parameter)it1.next();
                param.addParameterChangeFailListener(this);
            }
        }
        int index = -1;
        if (selectedAttenRel != null) {
            index = supportedIMRNames.indexOf(selectedAttenRel);
        }
        StringParameter selectIMR = null;
        selectIMR = index != -1 ? new StringParameter(IMR_PARAM_NAME, supportedIMRNames, (String)supportedIMRNames.get(index)) : new StringParameter(IMR_PARAM_NAME, supportedIMRNames, (String)supportedIMRNames.get(0));
        selectIMR.addParameterChangeListener(this);
        this.parameterList.addParameter(selectIMR);
        ScalarIMR imr = (ScalarIMR)attenRels.get(0);
        imr = this.getSelectedIMR_Instance();
        ListIterator<Parameter<?>> lt = imr.getOtherParamsIterator();
        while (lt.hasNext()) {
            Parameter<?> tempParam = lt.next();
            tempParam.addParameterChangeListener(this);
            this.parameterList.addParameter(tempParam);
            tempParam.addParameterChangeListener(this);
        }
        this.editorPanel.removeAll();
        this.addParameters();
        this.setTitle(IMR_EDITOR_TITLE);
        ParameterEditor paramEdit = this.getParameterEditor(IMR_PARAM_NAME);
        TitledBorder titledBorder1 = new TitledBorder(BorderFactory.createLineBorder(new Color(80, 80, 140), 3), "");
        titledBorder1.setTitleColor(new Color(80, 80, 140));
        Font DEFAULT_LABEL_FONT = new Font("SansSerif", 1, 13);
        titledBorder1.setTitleFont(DEFAULT_LABEL_FONT);
        titledBorder1.setTitle(IMR_PARAM_NAME);
        CompoundBorder border1 = BorderFactory.createCompoundBorder(titledBorder1, BorderFactory.createEmptyBorder(0, 0, 3, 0));
        paramEdit.setEditorBorder(border1);
        String value = (String)this.parameterList.getParameter("Gaussian Truncation").getValue();
        this.toggleSigmaLevelBasedOnTypeValue(value);
        this.isFirstTimeLaunched = false;
    }

    private ArrayList getAttenRelsSupportedForSelectedIM(String currentIMT, String retroIMT, double currentPeriod, double retroPeriod) {
        ArrayList<AttenuationRelationship> attenRelsSupportedForIM = new ArrayList<AttenuationRelationship>();
        int numSupportedAttenRels = this.supportedAttenRels.size();
        for (int i = 0; i < numSupportedAttenRels; ++i) {
            AttenuationRelationship attenRel = (AttenuationRelationship)this.supportedAttenRels.get(i);
            System.out.println("Getting IMRs for IMTs: " + currentIMT + ", " + retroIMT);
            if (!this.isIntensityMeasureSupported(attenRel, currentIMT, currentPeriod) || !this.isIntensityMeasureSupported(attenRel, retroIMT, retroPeriod)) continue;
            attenRelsSupportedForIM.add(attenRel);
        }
        return attenRelsSupportedForIM;
    }

    public boolean isIntensityMeasureSupported(AttenuationRelationship attenRel, String intensityMeasure, double period) {
        if (attenRel.isIntensityMeasureSupported(intensityMeasure)) {
            Parameter imParam = attenRel.getSupportedIntensityMeasures().getParameter(intensityMeasure);
            if (imParam.getName().equals("SA")) {
                return attenRel.getParameter("SA Period").isAllowed(period);
            }
            return true;
        }
        return false;
    }

    private void init_imrParamListAndEditor() {
        Iterator<Object> it;
        if (!this.parameterList.containsParameter(IMR_PARAM_NAME)) {
            this.parameterList = new ParameterList();
            it = this.supportedAttenRels.iterator();
            ArrayList<String> supportedIMRNames = new ArrayList<String>();
            while (it.hasNext()) {
                ScalarIMR imr = (ScalarIMR)it.next();
                imr.setParamDefaults();
                supportedIMRNames.add(imr.getName());
                ListIterator<Parameter<?>> it1 = imr.getSiteParamsIterator();
                while (it1.hasNext()) {
                    Parameter param = (Parameter)it1.next();
                    param.addParameterChangeFailListener(this);
                }
            }
            StringParameter selectIMR = new StringParameter(IMR_PARAM_NAME, supportedIMRNames, (String)supportedIMRNames.get(0));
            selectIMR.addParameterChangeListener(this);
            this.parameterList.addParameter(selectIMR);
        }
        it = this.parameterList.getParameterNamesIterator();
        while (it.hasNext()) {
            String paramName = it.next();
            if (paramName.equalsIgnoreCase(IMR_PARAM_NAME)) continue;
            this.parameterList.removeParameter(paramName);
        }
        ScalarIMR imr = this.supportedAttenRels.get(0);
        imr = this.getSelectedIMR_Instance();
        ListIterator<Parameter<?>> lt = imr.getOtherParamsIterator();
        while (lt.hasNext()) {
            Parameter<?> tempParam = lt.next();
            tempParam.addParameterChangeListener(this);
            this.parameterList.addParameter(tempParam);
            tempParam.addParameterChangeListener(this);
        }
        this.editorPanel.removeAll();
        this.addParameters();
        this.setTitle(IMR_EDITOR_TITLE);
        ParameterEditor paramEdit = this.getParameterEditor(IMR_PARAM_NAME);
        TitledBorder titledBorder1 = new TitledBorder(BorderFactory.createLineBorder(new Color(80, 80, 140), 3), "");
        titledBorder1.setTitleColor(new Color(80, 80, 140));
        Font DEFAULT_LABEL_FONT = new Font("SansSerif", 1, 13);
        titledBorder1.setTitleFont(DEFAULT_LABEL_FONT);
        titledBorder1.setTitle(IMR_PARAM_NAME);
        CompoundBorder border1 = BorderFactory.createCompoundBorder(titledBorder1, BorderFactory.createEmptyBorder(0, 0, 3, 0));
        paramEdit.setEditorBorder(border1);
        String value = (String)this.parameterList.getParameter("Gaussian Truncation").getValue();
        this.toggleSigmaLevelBasedOnTypeValue(value);
        this.fireAttenuationRelationshipChangedEvent(this.currentAttenRel, imr);
        this.currentAttenRel = imr;
    }

    @Override
    public void parameterChange(ParameterChangeEvent event) {
        String S = "ParameterListEditor: parameterChange(): ";
        String name1 = event.getParameterName();
        if (name1.equals("Gaussian Truncation")) {
            String value = event.getNewValue().toString();
            this.toggleSigmaLevelBasedOnTypeValue(value);
        }
        this.init_imrParamListAndEditor();
        this.updateUI();
        this.application.updateIM();
        this.application.updateSiteParams();
    }

    protected void toggleSigmaLevelBasedOnTypeValue(String value) {
        if (value.equalsIgnoreCase("None")) {
            this.setParameterVisible("Truncation Level", false);
        } else {
            this.setParameterVisible("Truncation Level", true);
        }
    }

    @Override
    public void parameterChangeWarning(ParameterChangeWarningEvent e) {
        System.out.println("yo - pcw");
        String S = "ParameterListEditor : parameterChangeWarning(): ";
        WarningParameter param = e.getWarningParameter();
        ListIterator<Parameter<?>> it = this.getSelectedIMR_Instance().getSiteParamsIterator();
        boolean found = false;
        while (it.hasNext() && !found) {
            if (!param.getName().equalsIgnoreCase(((Parameter)it.next()).getName())) continue;
            found = true;
        }
        if (!found) {
            param.setValueIgnoreWarning(e.getNewValue());
            return;
        }
        if (this.inParameterChangeWarning) {
            return;
        }
        this.inParameterChangeWarning = true;
        StringBuffer b = new StringBuffer();
        try {
            Double min = (Double)param.getWarningMin();
            Double max = (Double)param.getWarningMax();
            String name = param.getName();
            b.append("You have exceeded the recommended range for ");
            b.append(name);
            b.append(": (");
            b.append(min.toString());
            b.append(" to ");
            b.append(max.toString());
            b.append(")\n");
            b.append("Click Yes to accept the new value: ");
            b.append(e.getNewValue().toString());
        }
        catch (Exception ee) {
            String name = param.getName();
            b.append("You have exceeded the recommended range for: \n");
            b.append(name + "\n");
            b.append("Click Yes to accept the new value: ");
            b.append(e.getNewValue().toString());
            b.append(name);
        }
        int result = 0;
        result = JOptionPane.showConfirmDialog(this, b.toString(), "Exceeded Recommended Values", 0, 3);
        switch (result) {
            case 0: {
                param.setValueIgnoreWarning(e.getNewValue());
                break;
            }
            case 1: {
                param.setValueIgnoreWarning(e.getOldValue());
                break;
            }
            default: {
                param.setValueIgnoreWarning(e.getOldValue());
            }
        }
        this.inParameterChangeWarning = false;
    }

    public void showWarningMessages(boolean show) {
        this.inParameterChangeWarning = !show;
    }

    @Override
    public void parameterChangeFailed(ParameterChangeFailEvent e) {
        String S = "ParameterListEditor : parameterChangeWarning(): ";
        StringBuffer b = new StringBuffer();
        Parameter param = (Parameter)e.getSource();
        ParameterConstraint constraint = param.getConstraint();
        String oldValueStr = e.getOldValue().toString();
        String badValueStr = e.getBadValue().toString();
        String name = param.getName();
        ScalarIMR imr = this.getSelectedIMR_Instance();
        ListIterator<Parameter<?>> it = imr.getSiteParamsIterator();
        boolean found = false;
        while (it.hasNext() && !found) {
            if (!it.next().getName().equalsIgnoreCase(name)) continue;
            found = true;
        }
        if (!found) {
            return;
        }
        b.append("The value ");
        b.append(badValueStr);
        b.append(" is not permitted for '");
        b.append(name);
        b.append("'.\n");
        b.append("Resetting to ");
        b.append(oldValueStr);
        b.append(". The constraints are: \n");
        b.append(constraint.toString());
        JOptionPane.showMessageDialog(this, b.toString(), "Cannot Change Value", 1);
    }

    public String getSelectedIMR_Name() {
        return this.parameterList.getValue(IMR_PARAM_NAME).toString();
    }

    public ScalarIMR getSelectedIMR_Instance() {
        String selectedIMR = this.getSelectedIMR_Name();
        return this.getIMR_Instance(selectedIMR);
    }

    public ScalarIMR getIMR_Instance(String name) {
        ScalarIMR imr = null;
        int size = this.supportedAttenRels.size();
        for (int i = 0; i < size && !(imr = this.supportedAttenRels.get(i)).getName().equalsIgnoreCase(name); ++i) {
        }
        return imr;
    }

    public List<? extends ScalarIMR> getSupportedIMRs() {
        return this.supportedAttenRels;
    }

    public void addAttenuationRelationshipChangeListener(ScalarIMRChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeAttenuationRelationshipChangeListener(ScalarIMRChangeListener listener) {
        this.listeners.remove(listener);
    }

    public void fireAttenuationRelationshipChangedEvent(ScalarIMR oldAttenRel, ScalarIMR newAttenRel) {
        if (this.listeners.size() == 0) {
            return;
        }
        HashMap<TectonicRegionType, ScalarIMR> oldMap = new HashMap<TectonicRegionType, ScalarIMR>();
        oldMap.put(TectonicRegionType.ACTIVE_SHALLOW, oldAttenRel);
        HashMap<TectonicRegionType, ScalarIMR> newMap = new HashMap<TectonicRegionType, ScalarIMR>();
        oldMap.put(TectonicRegionType.ACTIVE_SHALLOW, newAttenRel);
        ScalarIMRChangeEvent event = new ScalarIMRChangeEvent(this, oldMap, newMap);
        for (ScalarIMRChangeListener listener : this.listeners) {
            listener.imrChange(event);
        }
    }
}

