/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.gui.beans;

import org.opensha.commons.exceptions.ParameterException;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.editor.impl.ParameterListEditor;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.sha.imr.ScalarIMR;

public class IMR_ParamEditor
extends ParameterListEditor
implements ParameterChangeListener {
    private static final long serialVersionUID = 1L;
    public static final String DEFAULT_NAME = "IMR Params";
    private ScalarIMR imr;

    public IMR_ParamEditor() {
        this((ScalarIMR)null);
    }

    public IMR_ParamEditor(ScalarIMR imr) {
        this.setTitle(DEFAULT_NAME);
        this.setIMR(imr);
    }

    public void setIMR(ScalarIMR imr) {
        if (imr == this.imr) {
            this.validate();
            return;
        }
        this.imr = imr;
        if (imr == null) {
            this.setParameterList(null);
            this.validate();
            return;
        }
        ParameterList paramList = imr.getOtherParams();
        this.setParameterList(paramList);
        for (Parameter<?> param : paramList) {
            if (!param.getName().equals("Gaussian Truncation")) continue;
            String val = (String)param.getValue();
            this.toggleSigmaLevelBasedOnTypeValue(val);
            param.addParameterChangeListener(this);
        }
        this.validate();
        this.repaint();
    }

    public void setTRTParamVisible(boolean visible) {
        if (this.imr == null) {
            return;
        }
        try {
            this.imr.getParameter("Tectonic Region");
            this.setParameterVisible("Tectonic Region", visible);
        }
        catch (ParameterException e) {
            return;
        }
    }

    private void toggleSigmaLevelBasedOnTypeValue(String value) {
        if (!this.parameterList.containsParameter("Truncation Level")) {
            return;
        }
        if (value.equalsIgnoreCase("None")) {
            this.setParameterVisible("Truncation Level", false);
        } else {
            this.setParameterVisible("Truncation Level", true);
            this.getParameterEditor("Truncation Level").getComponent().validate();
        }
        this.validate();
    }

    @Override
    public void parameterChange(ParameterChangeEvent event) {
        if (event.getParameterName().equals("Gaussian Truncation")) {
            String val = (String)event.getParameter().getValue();
            this.toggleSigmaLevelBasedOnTypeValue(val);
        }
    }
}

