/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.gui.beans;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.opensha.commons.param.AbstractParameter;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.constraint.impl.DoubleDiscreteConstraint;
import org.opensha.commons.param.editor.impl.ParameterListEditor;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.impl.DoubleDiscreteParameter;
import org.opensha.commons.param.impl.DoubleParameter;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.sha.imr.ScalarIMR;
import org.opensha.sha.imr.param.IntensityMeasureParams.PeriodParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.SA_Param;

@Deprecated
public class IMT_GuiBean
extends ParameterListEditor
implements ParameterChangeListener {
    public static final String IMT_PARAM_NAME = "IMT";
    public static final String IMT_EDITOR_TITLE = "Set IMT";
    private ArrayList<Parameter> imtParam;
    private ScalarIMR imr;
    private ArrayList<ScalarIMR> multipleIMRs;

    public IMT_GuiBean(ScalarIMR imr, Iterator<Parameter<?>> supportedIntensityMeasureIt) {
        this.setIM(imr, supportedIntensityMeasureIt);
    }

    public IMT_GuiBean(ArrayList<ScalarIMR> multipleIMRs) {
        this.setIM(multipleIMRs);
    }

    public void setIM(ScalarIMR imr, Iterator<Parameter<?>> supportedIntensityMeasureIt) {
        this.imr = imr;
        this.init_imtParamListAndEditor(imr.getSupportedIntensityMeasures());
    }

    public void setIM(ArrayList<ScalarIMR> multipleIMRs) {
        if (multipleIMRs == null || multipleIMRs.size() == 0) {
            return;
        }
        this.imr = null;
        ArrayList<Double> saPeriods = new ArrayList<Double>();
        double defaultPeriod = -1.0;
        ParameterList paramList = new ParameterList();
        for (ScalarIMR imr : multipleIMRs) {
            for (Parameter<?> param : imr.getSupportedIntensityMeasures()) {
                if (!paramList.containsParameter(param.getName())) {
                    paramList.addParameter(param);
                }
                if (!param.getName().equals("SA")) continue;
                SA_Param saParam = (SA_Param)param;
                PeriodParam periodParam = saParam.getPeriodParam();
                if (defaultPeriod < 0.0) {
                    defaultPeriod = (Double)periodParam.getValue();
                }
                List<Double> list = periodParam.getSupportedPeriods();
                for (double period : list) {
                    if (saPeriods.contains(period)) continue;
                    saPeriods.add(period);
                }
            }
        }
        ParameterList toBeRemoved = new ParameterList();
        AbstractParameter replaceSA = null;
        for (Parameter<?> param : paramList) {
            boolean remove = false;
            for (ScalarIMR scalarIMR : multipleIMRs) {
                if (scalarIMR.getSupportedIntensityMeasures().containsParameter(param.getName())) continue;
                remove = true;
                break;
            }
            if (remove) {
                if (toBeRemoved.containsParameter(param.getName())) continue;
                toBeRemoved.addParameter(param);
                continue;
            }
            ArrayList<Double> badPeriods = new ArrayList<Double>();
            if (!param.getName().equals("SA")) continue;
            for (ScalarIMR imr3 : multipleIMRs) {
                SA_Param saParam = (SA_Param)imr3.getSupportedIntensityMeasures().getParameter("SA");
                PeriodParam periodParam = saParam.getPeriodParam();
                List<Double> periods = periodParam.getSupportedPeriods();
                for (double period : saPeriods) {
                    if (periods.contains(period) || badPeriods.contains(period)) continue;
                    badPeriods.add(period);
                }
            }
            Iterator iterator = badPeriods.iterator();
            while (iterator.hasNext()) {
                double badPeriod = (Double)iterator.next();
                saPeriods.remove(badPeriod);
            }
            SA_Param sA_Param = (SA_Param)param;
            DoubleDiscreteConstraint pConst = new DoubleDiscreteConstraint(saPeriods);
            PeriodParam periodParam = new PeriodParam(pConst, defaultPeriod, true);
            replaceSA = new SA_Param(periodParam, sA_Param.getDampingParam());
            ((DoubleParameter)replaceSA).setValue(defaultPeriod);
        }
        if (replaceSA != null) {
            paramList.replaceParameter(replaceSA.getName(), replaceSA);
        }
        for (Parameter<?> badParam : toBeRemoved) {
            paramList.removeParameter(badParam.getName());
        }
        this.init_imtParamListAndEditor(paramList);
    }

    private void init_imtParamListAndEditor(ParameterList newIMTParams) {
        Parameter depParam;
        this.parameterList = new ParameterList();
        ArrayList<String> imt = new ArrayList<String>();
        this.imtParam = new ArrayList();
        for (Parameter param : newIMTParams) {
            DoubleDiscreteParameter param1 = new DoubleDiscreteParameter(param.getName());
            if (param instanceof Parameter) {
                depParam = param;
                for (Parameter<?> param2 : depParam.getIndependentParameterList()) {
                    DoubleDiscreteConstraint values = (DoubleDiscreteConstraint)param2.getConstraint();
                    DoubleDiscreteParameter independentParam = new DoubleDiscreteParameter(param2.getName(), values, values.getAllowedValues().get(0));
                    if (independentParam.getName().equals("SA Period") && independentParam.isAllowed(1.0)) {
                        independentParam.setValue(1.0);
                    }
                    param1.addIndependentParameter(independentParam);
                }
            }
            this.imtParam.add(param1);
            imt.add(param.getName());
        }
        StringParameter imtParameter = new StringParameter(IMT_PARAM_NAME, imt, (String)imt.get(0));
        imtParameter.addParameterChangeListener(this);
        this.parameterList.addParameter(imtParameter);
        for (Parameter param : this.imtParam) {
            if (!(param instanceof Parameter)) continue;
            depParam = param;
            for (Parameter<?> indepParam : depParam.getIndependentParameterList()) {
                this.parameterList.addParameter(indepParam);
            }
        }
        this.editorPanel.removeAll();
        this.addParameters();
        this.setTitle(IMT_EDITOR_TITLE);
        this.updateIMT((String)imt.get(0));
    }

    private void updateIMT(String imtName) {
        Iterator<Parameter<Object>> it = this.parameterList.getParametersIterator();
        while (it.hasNext()) {
            this.setParameterVisible(((Parameter)it.next()).getName(), false);
        }
        this.setParameterVisible(IMT_PARAM_NAME, true);
        for (Parameter<Object> parameter : this.imtParam) {
            if (!parameter.getName().equalsIgnoreCase(imtName)) continue;
            for (Parameter<?> indepParam : parameter.getIndependentParameterList()) {
                this.setParameterVisible(indepParam.getName(), true);
            }
        }
    }

    @Override
    public void parameterChange(ParameterChangeEvent event) {
        String S = "ParameterListEditor: parameterChange(): ";
        String name1 = event.getParameterName();
        if (name1.equalsIgnoreCase(IMT_PARAM_NAME)) {
            this.updateIMT((String)event.getNewValue());
        }
    }

    public String getSelectedIMT() {
        return this.parameterList.getValue(IMT_PARAM_NAME).toString();
    }

    public void setIMT() {
        Parameter param = this.getIntensityMeasure();
        if (this.imr != null) {
            this.imr.setIntensityMeasure(param);
        } else {
            for (ScalarIMR imr : this.multipleIMRs) {
                imr.setIntensityMeasure(param.getName());
                if (!(param instanceof SA_Param)) continue;
                SA_Param saParam = (SA_Param)param;
                double period = (Double)saParam.getPeriodParam().getValue();
                SA_Param imt = (SA_Param)imr.getIntensityMeasure();
                imt.getPeriodParam().setValue(period);
            }
        }
    }

    public Parameter getIntensityMeasure() {
        String selectedImt = this.parameterList.getValue(IMT_PARAM_NAME).toString();
        for (Parameter param : this.imtParam) {
            if (!param.getName().equalsIgnoreCase(selectedImt)) continue;
            return param;
        }
        return null;
    }

    public String getParameterListMetadataString() {
        Object metadata = null;
        ListIterator<Parameter<?>> it = this.getVisibleParameters().getParametersIterator();
        int paramSize = this.getVisibleParameters().size();
        while (it.hasNext()) {
            Parameter<?> tempParam = it.next();
            if (tempParam.getName().equals(IMT_PARAM_NAME)) {
                metadata = tempParam.getName() + " = " + (String)tempParam.getValue();
                if (paramSize <= 1) continue;
                metadata = (String)metadata + "[ ";
                continue;
            }
            metadata = (String)metadata + tempParam.getName() + " = " + (Double)tempParam.getValue() + " ; ";
        }
        if (paramSize > 1) {
            metadata = ((String)metadata).substring(0, ((String)metadata).length() - 3);
        }
        if (paramSize > 1) {
            metadata = (String)metadata + " ] ";
        }
        return metadata;
    }
}

