/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.gui.beans;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import org.opensha.commons.data.TimeSpan;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.editor.impl.ParameterListEditor;

public class TimeSpanGuiBean
extends JPanel {
    public static final String TIMESPAN_EDITOR_TITLE = "Set Time Span";
    private TimeSpan timeSpan;
    private ParameterListEditor editor;
    private ParameterList parameterList;
    private JEditorPane timespanEditor = new JEditorPane();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();

    public TimeSpanGuiBean() {
        this.parameterList = new ParameterList();
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public TimeSpanGuiBean(TimeSpan timeSpan) {
        this();
        this.setTimeSpan(timeSpan);
    }

    public void setTimeSpan(TimeSpan timeSpan) {
        this.parameterList.clear();
        this.timeSpan = timeSpan;
        if (this.editor != null) {
            this.remove(this.editor);
        }
        if (timeSpan != null) {
            for (Parameter<?> param : timeSpan.getAdjustableParams()) {
                this.parameterList.addParameter(param);
            }
            this.remove(this.timespanEditor);
            this.editor = new ParameterListEditor(this.parameterList);
            this.editor.setTitle(TIMESPAN_EDITOR_TITLE);
            this.add((Component)this.editor, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.validate();
            this.repaint();
        } else {
            this.add((Component)this.timespanEditor, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
    }

    public TimeSpan getTimeSpan() {
        return this.timeSpan;
    }

    private void jbInit() throws Exception {
        String text = "This ERF does not have any Timespan\n";
        this.setLayout(this.gridBagLayout1);
        this.timespanEditor.setEditable(false);
        this.timespanEditor.setText(text);
        this.add((Component)this.timespanEditor, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(4, 4, 4, 4), 0, 0));
    }

    public ParameterList getParameterList() {
        return this.parameterList;
    }

    public ParameterListEditor getParameterListEditor() {
        return this.editor;
    }

    public String getParameterListMetadataString() {
        if (this.timeSpan != null) {
            return this.editor.getVisibleParametersCloned().getParameterListMetadataString();
        }
        return "No Timespan";
    }
}

