/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.gui.controls;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.ListIterator;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTextPane;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.param.Parameter;
import org.opensha.sha.gui.beans.IMR_GuiBean;
import org.opensha.sha.gui.beans.Site_GuiBean;
import org.opensha.sha.gui.infoTools.ConnectToCVM;
import org.opensha.sha.imr.ScalarIMR;
import org.opensha.sha.util.SiteTranslator;

public class SetSiteParamsFromWebServicesControlPanel
extends JFrame {
    JButton setAllIMRButton = new JButton();
    public static String SET_ALL_IMRS = "Set Site Params for all IMRs";
    public static String SET_SELECTED_IMR = "Set Site Params for Selected IMR";
    private static final double MIN_CVM_LAT = 32.0;
    private static final double MAX_CVM_LAT = 36.0;
    private static final double MIN_CVM_LON = -121.0;
    private static final double MAX_CVM_LON = -114.0;
    SiteTranslator siteTranslator = new SiteTranslator();
    private IMR_GuiBean imrGuiBean;
    private Site_GuiBean siteGuiBean;
    private JTextPane siteInfoPane = new JTextPane();
    private JButton setSelectedIMRButton = new JButton();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();

    public SetSiteParamsFromWebServicesControlPanel(Component parent, IMR_GuiBean imrGuiBean, Site_GuiBean siteGuiBean) {
        try {
            this.setLocation(parent.getX() + parent.getWidth() / 2, parent.getY() + parent.getHeight() / 2);
            this.imrGuiBean = imrGuiBean;
            this.siteGuiBean = siteGuiBean;
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.getContentPane().setLayout(this.gridBagLayout1);
        this.setAllIMRButton.setText("Set Params For All IMRs");
        this.setAllIMRButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SetSiteParamsFromWebServicesControlPanel.this.setAllIMRButton_actionPerformed(e);
            }
        });
        String info = new String("This uses both the CGS Preliminary Site Conditions Map of CA (Wills et al., 2000) and basin depth from the SCEC CVM.");
        this.siteInfoPane.setBackground(SystemColor.menu);
        this.siteInfoPane.setEnabled(false);
        this.siteInfoPane.setPreferredSize(new Dimension(300, 64));
        this.siteInfoPane.setEditable(false);
        this.siteInfoPane.setText(info);
        this.setSelectedIMRButton.setText("Set Params For Chosen IMR");
        this.setSelectedIMRButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SetSiteParamsFromWebServicesControlPanel.this.setSelectedIMRButton_actionPerformed(e);
            }
        });
        this.getContentPane().add((Component)this.siteInfoPane, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(12, 31, 18, 4), 0, 0));
        this.getContentPane().add((Component)this.setAllIMRButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(27, 72, 0, 94), 23, 4));
        this.getContentPane().add((Component)this.setSelectedIMRButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(7, 72, 0, 94), 1, 4));
        this.setTitle("Set Site Related Params");
    }

    void setAllIMRButton_actionPerformed(ActionEvent e) {
        Double lon = (Double)this.siteGuiBean.getParameterListEditor().getParameterList().getParameter("Longitude").getValue();
        Double lat = (Double)this.siteGuiBean.getParameterListEditor().getParameterList().getParameter("Latitude").getValue();
        LocationList locList = new LocationList();
        locList.add(new Location(lat, lon));
        String willsClass = "NA";
        double basinDepth = Double.NaN;
        try {
            willsClass = (String)ConnectToCVM.getWillsSiteTypeFromCVM(locList).get(0);
            basinDepth = (Double)ConnectToCVM.getBasinDepthFromCVM(locList).get(0);
        }
        catch (Exception ee) {
            ee.printStackTrace();
            JOptionPane.showMessageDialog(this, "Server is down for maintenance, please try again later. If the problem persists, make sure you are using the latest version of our applications.", "Server Problem", 1);
            return;
        }
        List<? extends ScalarIMR> imrObjects = this.imrGuiBean.getSupportedIMRs();
        int num = imrObjects.size();
        for (int i = 0; i < num; ++i) {
            this.setSiteParamsInIMR(imrObjects.get(i), willsClass, basinDepth);
        }
        this.siteGuiBean.getParameterListEditor().refreshParamEditor();
        this.dispose();
    }

    private void setSiteParamsInIMR(ScalarIMR imr, String willsClass, double basinDepth) {
        ListIterator<Parameter<?>> it = imr.getSiteParamsIterator();
        while (it.hasNext()) {
            Parameter tempParam = (Parameter)it.next();
            System.out.println("Param:" + tempParam.getName());
            boolean flag = this.siteTranslator.setParameterValue(tempParam, willsClass, basinDepth);
            if (flag) continue;
            String message = "cannot set the site parameter \"" + tempParam.getName() + "\" from Wills class \"" + willsClass + "\"\n (no known, sanctioned translation - please set by hand)";
            JOptionPane.showMessageDialog(this, message, "Warning", 0);
        }
    }

    public void setSelectedIMRButton_actionPerformed(ActionEvent e) {
        Double lon = (Double)this.siteGuiBean.getParameterListEditor().getParameterList().getParameter("Longitude").getValue();
        Double lat = (Double)this.siteGuiBean.getParameterListEditor().getParameterList().getParameter("Latitude").getValue();
        LocationList locList = new LocationList();
        locList.add(new Location(lat, lon));
        String willsClass = "NA";
        double basinDepth = Double.NaN;
        try {
            willsClass = (String)ConnectToCVM.getWillsSiteTypeFromCVM(locList).get(0);
            basinDepth = (Double)ConnectToCVM.getBasinDepthFromCVM(locList).get(0);
        }
        catch (Exception ee) {
            ee.printStackTrace();
            JOptionPane.showMessageDialog(this, "Server is down for maintenance, please try again later", "Server Problem", 1);
            return;
        }
        ScalarIMR imr = this.imrGuiBean.getSelectedIMR_Instance();
        this.setSiteParamsInIMR(imr, willsClass, basinDepth);
        this.siteGuiBean.getParameterListEditor().refreshParamEditor();
        this.dispose();
    }
}

