/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.gui.controls;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.gui.ControlPanel;
import org.opensha.sha.gui.controls.CurveDisplayAppAPI;
import org.opensha.sha.gui.controls.XY_ValuesControlPanel_cancelButton_actionAdapter;
import org.opensha.sha.gui.controls.XY_ValuesControlPanel_okButton_actionAdapter;

public class XY_ValuesControlPanel
extends ControlPanel {
    public static final String NAME = "Set external XY dataset";
    JPanel jPanel1 = new JPanel();
    BorderLayout borderLayout1 = new BorderLayout();
    JScrollPane xyDatasetScrollPane = new JScrollPane();
    JLabel jLabel1 = new JLabel();
    JTextArea xyDatasetText = new JTextArea();
    JTextArea metadataText = new JTextArea();
    JLabel jLabel2 = new JLabel();
    JScrollPane metadataScrollPane = new JScrollPane();
    JButton okButton = new JButton();
    JButton cancelButton = new JButton();
    CurveDisplayAppAPI application;
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JFrame frame;
    private Component parent;

    public XY_ValuesControlPanel(Component parent, CurveDisplayAppAPI api) {
        super(NAME);
        this.application = api;
        this.parent = parent;
    }

    @Override
    public void doinit() {
        this.frame = new JFrame();
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.frame.pack();
        this.frame.setLocation(this.parent.getX() + this.parent.getWidth() / 2, this.parent.getY());
    }

    private void jbInit() throws Exception {
        this.frame.getContentPane().setLayout(this.borderLayout1);
        this.cancelButton.addActionListener(new XY_ValuesControlPanel_cancelButton_actionAdapter(this));
        this.okButton.addActionListener(new XY_ValuesControlPanel_okButton_actionAdapter(this));
        this.frame.setDefaultCloseOperation(2);
        this.frame.getContentPane().add((Component)this.jPanel1, "Center");
        this.jLabel1.setFont(new Font("Arial", 1, 16));
        this.jLabel1.setText("Enter XY Dataset:");
        this.jLabel2.setFont(new Font("Arial", 1, 16));
        this.jLabel2.setText("Enter Metadata:");
        this.okButton.setText("OK");
        this.cancelButton.setText("Cancel");
        this.xyDatasetScrollPane.getViewport().add(this.xyDatasetText);
        this.metadataScrollPane.getViewport().add(this.metadataText);
        this.jPanel1.setLayout(this.gridBagLayout1);
        this.jPanel1.add((Component)this.xyDatasetScrollPane, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 38, 0, 105), 185, 331));
        this.jPanel1.add((Component)this.jLabel1, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(28, 38, 0, 107), 66, 16));
        this.jPanel1.add((Component)this.jLabel2, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 0, new Insets(20, 38, 0, 120), 68, 19));
        this.jPanel1.add((Component)this.metadataScrollPane, new GridBagConstraints(0, 3, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 38, 0, 20), 270, 136));
        this.jPanel1.add((Component)this.cancelButton, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(12, 34, 18, 34), 19, 1));
        this.jPanel1.add((Component)this.okButton, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(12, 64, 18, 0), 19, 1));
        this.frame.setSize(new Dimension(250, 500));
        this.frame.setTitle("New Dataset Control Panel");
    }

    public void cancelButton_actionPerformed(ActionEvent actionEvent) {
        this.frame.dispose();
    }

    public void okButton_actionPerformed(ActionEvent actionEvent) {
        try {
            this.application.addCurve(this.getX_Values());
            this.frame.dispose();
        }
        catch (NumberFormatException ex) {
            JOptionPane.showMessageDialog(this.frame, ex.getMessage(), "Error", 0);
            return;
        }
        catch (RuntimeException ex) {
            JOptionPane.showMessageDialog(this.frame, ex.getMessage(), "Error", 0);
            return;
        }
    }

    private ArbitrarilyDiscretizedFunc getX_Values() throws NumberFormatException, RuntimeException {
        ArbitrarilyDiscretizedFunc function = new ArbitrarilyDiscretizedFunc();
        String str = this.xyDatasetText.getText();
        StringTokenizer st = new StringTokenizer(str, "\n");
        while (st.hasMoreTokens()) {
            StringTokenizer st1 = new StringTokenizer(st.nextToken());
            int numVals = st1.countTokens();
            if (numVals != 2) {
                throw new RuntimeException("Each line should have just one X and one Y value, which are space seperated");
            }
            double tempX_Val = 0.0;
            double tempY_Val = 0.0;
            try {
                tempX_Val = Double.parseDouble(st1.nextToken());
                tempY_Val = Double.parseDouble(st1.nextToken());
            }
            catch (NumberFormatException e) {
                throw new NumberFormatException("X and Y Values entered must be valid numbers");
            }
            function.set(tempX_Val, tempY_Val);
        }
        function.setName("(manually entered XY data)");
        String metadata = this.metadataText.getText();
        if (metadata == null || metadata.equals("")) {
            function.setInfo(" ");
        } else {
            function.setInfo(metadata);
        }
        return function;
    }

    @Override
    public Window getComponent() {
        return this.frame;
    }
}

