/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.gui.infoTools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.border.Border;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.opensha.commons.mapping.gmt.gui.ImageViewerWindow;
import org.opensha.sha.gui.infoTools.DisplayDataWindow;
import org.opensha.sha.gui.infoTools.HazardCurveDisaggregationWindowAPI;

public class HazardCurveDisaggregationWindow
extends JFrame {
    private JPanel jMessagePanel = new JPanel();
    private JButton jMessageButton = new JButton();
    private String infoMessage;
    private JTextPane jMessagePane = new JTextPane();
    private SimpleAttributeSet setMessage;
    Border border1;
    JButton sourceListButton = new JButton();
    JButton plotButton = new JButton();
    private DisplayDataWindow dataWindow;
    private HazardCurveDisaggregationWindowAPI application;
    BorderLayout borderLayout1 = new BorderLayout();
    GridBagLayout gridBagLayout1 = new GridBagLayout();

    public HazardCurveDisaggregationWindow(HazardCurveDisaggregationWindowAPI app, Component parent, String s) {
        this.infoMessage = s;
        this.application = app;
        try {
            this.jbInit();
            this.setLocation(parent.getX() + parent.getWidth() / 2, parent.getY() + parent.getHeight() / 2);
            this.jMessagePane.setEditable(false);
            StyledDocument doc = this.jMessagePane.getStyledDocument();
            doc.remove(0, doc.getLength());
            this.setMessage = new SimpleAttributeSet();
            StyleConstants.setFontSize(this.setMessage, 13);
            StyleConstants.setForeground(this.setMessage, Color.black);
            doc.insertString(doc.getLength(), this.infoMessage, this.setMessage);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.border1 = BorderFactory.createLineBorder(SystemColor.controlText, 1);
        this.jMessagePanel.setLayout(this.gridBagLayout1);
        this.setTitle("Disaggregation Result Window");
        this.getContentPane().setLayout(this.borderLayout1);
        this.jMessageButton.setBackground(new Color(200, 200, 230));
        this.jMessageButton.setForeground(new Color(80, 80, 133));
        this.jMessageButton.setText("OK");
        this.jMessageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HazardCurveDisaggregationWindow.this.jMessageButton_actionPerformed(e);
            }
        });
        this.jMessagePanel.setBackground(new Color(200, 200, 230));
        this.jMessagePanel.setForeground(new Color(80, 18, 133));
        this.jMessagePanel.setBorder(this.border1);
        this.setResizable(true);
        this.getContentPane().setBackground(new Color(200, 200, 230));
        this.setDefaultCloseOperation(2);
        this.jMessagePane.setBorder(null);
        this.jMessagePane.setToolTipText("");
        this.jMessagePane.setEditable(false);
        this.sourceListButton.setBackground(new Color(200, 200, 230));
        this.sourceListButton.setForeground(new Color(80, 80, 133));
        this.sourceListButton.setText("Source List");
        this.sourceListButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HazardCurveDisaggregationWindow.this.sourceListButton_actionPerformed(actionEvent);
            }
        });
        this.plotButton.setBackground(new Color(200, 200, 230));
        this.plotButton.setForeground(new Color(80, 80, 133));
        this.plotButton.setText("Disagg. Plot");
        this.plotButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HazardCurveDisaggregationWindow.this.plotButton_actionPerformed(actionEvent);
            }
        });
        this.getContentPane().add((Component)this.jMessagePanel, "Center");
        this.jMessagePanel.add((Component)this.jMessageButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(4, 4, 4, 4), 35, 0));
        this.jMessagePanel.add((Component)this.sourceListButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(4, 4, 4, 4), 13, 0));
        this.jMessagePanel.add((Component)this.plotButton, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(4, 4, 4, 4), 6, 0));
        this.jMessagePanel.add((Component)this.jMessagePane, new GridBagConstraints(0, 0, 3, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    void jMessageButton_actionPerformed(ActionEvent e) {
        this.dispose();
    }

    public void sourceListButton_actionPerformed(ActionEvent actionEvent) {
        String sourceDisaggregationList = this.application.getSourceDisaggregationInfo();
        String title = "Source Disaggregation Result";
        if (this.dataWindow == null) {
            this.dataWindow = new DisplayDataWindow(this, sourceDisaggregationList, title);
        } else {
            this.dataWindow.setDataInWindow(sourceDisaggregationList);
        }
        this.dataWindow.setVisible(true);
    }

    public void plotButton_actionPerformed(ActionEvent actionEvent) {
        String disaggregationPlotWebAddr = null;
        Object metadata = null;
        try {
            disaggregationPlotWebAddr = this.application.getDisaggregationPlot();
            metadata = this.application.getMapParametersInfoAsHTML();
            metadata = (String)metadata + "<br><p>Click:  <a href=\"" + disaggregationPlotWebAddr + "\">here</a> to download files. They will be deleted at midnight</p>";
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, e.getMessage(), "Server Problem", 1);
            return;
        }
        String imgName = disaggregationPlotWebAddr + "DisaggregationPlot.jpg";
        ImageViewerWindow imgView = new ImageViewerWindow(imgName, (String)metadata, true);
    }
}

