/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.gui.servlets;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.xyz.ArbDiscrGeoDataSet;
import org.opensha.commons.data.xyz.GeoDataSet;
import org.opensha.commons.geo.Location;
import org.opensha.commons.mapping.gmt.GMT_MapGenerator;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.util.FileUtils;

public class HazardMapViewerServlet
extends HttpServlet {
    public static final String PARENT_DIR = "/opt/install/apache-tomcat-5.5.20/webapps/OpenSHA/HazardMapDatasets/";
    public static final String METADATA_FILE_NAME = "metadata.txt";
    public static final String SITES_FILE_NAME = "sites.txt";
    public static final String GET_DATA = "Get Data";
    public static final String MAKE_MAP = "Make Map";

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            System.out.println("HazardMapViewerServlet: Handling GET");
            ObjectInputStream inputFromApplet = new ObjectInputStream((InputStream)request.getInputStream());
            String functionDesired = (String)inputFromApplet.readObject();
            if (functionDesired.equalsIgnoreCase(GET_DATA)) {
                this.loadDataSets(new ObjectOutputStream((OutputStream)response.getOutputStream()));
            } else if (functionDesired.equalsIgnoreCase(MAKE_MAP)) {
                String selectedSet = (String)inputFromApplet.readObject();
                GMT_MapGenerator map = (GMT_MapGenerator)inputFromApplet.readObject();
                String optionSelected = (String)inputFromApplet.readObject();
                double val = (Double)inputFromApplet.readObject();
                String metadata = (String)inputFromApplet.readObject();
                boolean isProbAt_IML = true;
                if (optionSelected.equalsIgnoreCase("IML@Prob")) {
                    isProbAt_IML = false;
                }
                GeoDataSet xyzData = this.getXYZ_DataSet(selectedSet, isProbAt_IML, val, map);
                String metadataFileName = PARENT_DIR + selectedSet + "/map_info.txt";
                FileWriter fw = new FileWriter(metadataFileName);
                fw.write(metadata);
                fw.close();
                map.setMetatdataFileName(metadataFileName);
                String mapLabel = this.getMapLabel(isProbAt_IML);
                String jpgFileName = map.makeMapUsingServlet(xyzData, mapLabel, metadata, null);
                ObjectOutputStream outputToApplet = new ObjectOutputStream((OutputStream)response.getOutputStream());
                outputToApplet.writeObject(jpgFileName);
                outputToApplet.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    private String getMapLabel(boolean isProbAtIML) {
        String label = isProbAtIML ? "Prob" : "IML";
        return label;
    }

    private void loadDataSets(ObjectOutputStream outputToApplet) {
        Hashtable<String, Object> metaDataHash = new Hashtable<String, Object>();
        Hashtable<String, String> lonHash = new Hashtable<String, String>();
        Hashtable<String, String> latHash = new Hashtable<String, String>();
        try {
            File dirs = new File(PARENT_DIR);
            File[] dirList = dirs.listFiles();
            for (int i = 0; i < dirList.length; ++i) {
                if (!dirList[i].isDirectory()) continue;
                Object dataSetDescription = new String();
                try {
                    File f = new File(PARENT_DIR + dirList[i].getName() + "/metadata.txt");
                    if (!f.exists()) continue;
                    FileReader dataReader = new FileReader(f);
                    BufferedReader in = new BufferedReader(dataReader);
                    dataSetDescription = "";
                    String str = in.readLine();
                    while (str != null) {
                        dataSetDescription = (String)dataSetDescription + str + "\n";
                        str = in.readLine();
                    }
                    metaDataHash.put(dirList[i].getName(), dataSetDescription);
                    in.close();
                    FileReader sitesReader = new FileReader(PARENT_DIR + dirList[i].getName() + "/sites.txt");
                    BufferedReader sitesin = new BufferedReader(sitesReader);
                    String latitude = sitesin.readLine();
                    latHash.put(dirList[i].getName(), latitude);
                    String longitude = sitesin.readLine();
                    lonHash.put(dirList[i].getName(), longitude);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            outputToApplet.writeObject(metaDataHash);
            outputToApplet.writeObject(lonHash);
            outputToApplet.writeObject(latHash);
            outputToApplet.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private GeoDataSet getXYZ_DataSet(String selectedSet, boolean isProbAt_IML, double val, GMT_MapGenerator map) {
        int i;
        ParameterList paramList = map.getAdjustableParamsList();
        String minLat = paramList.getValue("Min Latitude").toString();
        String maxLat = paramList.getValue("Max Latitude").toString();
        String minLon = paramList.getValue("Min Longitude").toString();
        String maxLon = paramList.getValue("Max Longitude").toString();
        double gridSpacing = (Double)paramList.getValue("Grid Spacing");
        ArbDiscrGeoDataSet xyzData = new ArbDiscrGeoDataSet(true);
        File dir = new File(PARENT_DIR + selectedSet + "/");
        File[] fileList = dir.listFiles();
        int numFiles = fileList.length;
        ArrayList<Double> latList = new ArrayList<Double>();
        ArrayList<Double> lonList = new ArrayList<Double>();
        for (int i2 = 0; i2 < numFiles; ++i2) {
            int lastIndex;
            String fileName;
            if (!fileList[i2].isFile() || !(fileName = fileList[i2].getName()).endsWith(".txt")) continue;
            int index = fileName.indexOf("_");
            int firstIndex = fileName.indexOf(".");
            if (firstIndex == (lastIndex = fileName.lastIndexOf("."))) continue;
            Double latVal = Double.valueOf(fileName.substring(0, index).trim());
            Double lonVal = Double.valueOf(fileName.substring(index + 1, lastIndex).trim());
            if (!latList.contains(latVal)) {
                latList.add(latVal);
            }
            if (lonList.contains(lonVal)) continue;
            lonList.add(lonVal);
        }
        Collections.sort(latList);
        Collections.sort(lonList);
        int latListSize = latList.size();
        int lonListSize = lonList.size();
        int minLatIndex = 0;
        int maxLatIndex = 0;
        double minLatVal = Double.parseDouble(minLat);
        double maxLatVal = Double.parseDouble(maxLat);
        for (i = 0; i < latListSize; ++i) {
            if (!(Math.abs(minLatVal - (Double)latList.get(i)) < gridSpacing)) continue;
            minLatIndex = i;
            break;
        }
        while (i < latListSize) {
            if (Math.abs(maxLatVal - (Double)latList.get(i)) < gridSpacing) {
                maxLatIndex = i;
                break;
            }
            ++i;
        }
        int minLonIndex = 0;
        int maxLonIndex = 0;
        double minLonVal = Double.parseDouble(minLon);
        double maxLonVal = Double.parseDouble(maxLon);
        for (i = 0; i < lonListSize; ++i) {
            if (!(Math.abs(minLonVal - (Double)lonList.get(i)) < gridSpacing)) continue;
            minLonIndex = i;
            break;
        }
        while (i < lonListSize) {
            if (Math.abs(maxLonVal - (Double)lonList.get(i)) < gridSpacing) {
                maxLonIndex = i;
                break;
            }
            ++i;
        }
        DecimalFormat d = new DecimalFormat("0.00##");
        for (int k = minLatIndex; k <= maxLatIndex; ++k) {
            double interpolatedVal = 0.0;
            for (int j = minLonIndex; j <= maxLonIndex; ++j) {
                String lat = d.format((Double)latList.get(k));
                String lon = d.format((Double)lonList.get(j));
                try {
                    String fileToRead = lat + "_" + lon + ".txt";
                    ArrayList<String> fileLines = FileUtils.loadFile(PARENT_DIR + selectedSet + "/" + fileToRead);
                    ArbitrarilyDiscretizedFunc func = new ArbitrarilyDiscretizedFunc();
                    if (fileLines.size() == 0) {
                        System.out.println("File to read but could not found:" + fileToRead);
                    }
                    for (i = 0; i < fileLines.size(); ++i) {
                        String dataLine = fileLines.get(i);
                        StringTokenizer st = new StringTokenizer(dataLine);
                        double currentIML = Double.parseDouble(st.nextToken());
                        double currentProb = Double.parseDouble(st.nextToken());
                        func.set(currentIML, currentProb);
                    }
                    interpolatedVal = isProbAt_IML ? func.getInterpolatedY_inLogXLogYDomain(val) : func.getFirstInterpolatedX_inLogXLogYDomain(val);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                xyzData.set(new Location((Double)latList.get(k), (Double)lonList.get(j)), interpolatedVal);
            }
        }
        return xyzData;
    }
}

