/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.gui.servlets;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.ListIterator;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opensha.commons.data.region.SitesInGriddedRegion;
import org.opensha.commons.data.xyz.ArbDiscrGeoDataSet;
import org.opensha.commons.data.xyz.GeoDataSet;
import org.opensha.commons.exceptions.ParameterException;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.event.ParameterChangeWarningEvent;
import org.opensha.commons.param.event.ParameterChangeWarningListener;
import org.opensha.commons.util.FileUtils;
import org.opensha.commons.util.ServerPrefUtils;
import org.opensha.sha.calc.ScenarioShakeMapCalculator;
import org.opensha.sha.earthquake.EqkRupture;
import org.opensha.sha.gui.infoTools.IMT_Info;
import org.opensha.sha.imr.AttenuationRelationship;
import org.opensha.sha.imr.ScalarIMR;

public class ScenarioShakeMapCalcServlet
extends HttpServlet
implements ParameterChangeWarningListener {
    public static final String SERVLET_URL = ServerPrefUtils.SERVER_PREFS.getServletBaseURL() + "ScenarioShakeMapCalcServlet";
    protected static final String FILE_PATH = "/scratch/opensha/MapCalculationSavedObjects/";
    private static final String XYZ_DATA_DIR = "xyzDataObject/";

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        System.out.println("ScenarioShakeMapCalcServlet: Handling GET");
        ObjectInputStream inputFromApplication = new ObjectInputStream((InputStream)request.getInputStream());
        ObjectOutputStream output = new ObjectOutputStream((OutputStream)response.getOutputStream());
        try {
            Object xyzDataFileName = "";
            xyzDataFileName = (String)xyzDataFileName + System.currentTimeMillis() + ".obj";
            File mainDir = new File("/scratch/opensha/MapCalculationSavedObjects/xyzDataObject/");
            if (!mainDir.isDirectory()) {
                boolean bl = new File("/scratch/opensha/MapCalculationSavedObjects/xyzDataObject/").mkdir();
            }
            ArrayList selectedAttenRels = (ArrayList)inputFromApplication.readObject();
            ArrayList selectedAttenRelWts = (ArrayList)inputFromApplication.readObject();
            String griddedRegionFile = (String)inputFromApplication.readObject();
            SitesInGriddedRegion griddedRegion = (SitesInGriddedRegion)FileUtils.loadObject(griddedRegionFile);
            EqkRupture rupture = (EqkRupture)inputFromApplication.readObject();
            boolean isProbAtIML = (Boolean)inputFromApplication.readObject();
            double value = (Double)inputFromApplication.readObject();
            String selectedIMT = (String)inputFromApplication.readObject();
            inputFromApplication.close();
            this.getIMR_ParametersAndAddListeners(selectedAttenRels);
            ScenarioShakeMapCalculator calc = new ScenarioShakeMapCalculator();
            GeoDataSet xyzData = null;
            if (!selectedIMT.equals("PGV")) {
                xyzData = calc.getScenarioShakeMapData(selectedAttenRels, selectedAttenRelWts, griddedRegion, rupture, isProbAtIML, value);
                this.convertIML_ValuesToExpo(xyzData, selectedIMT, isProbAtIML);
            } else {
                xyzData = this.getXYZDataForPGV(selectedAttenRels, selectedAttenRelWts, griddedRegion, rupture, isProbAtIML, value, calc);
            }
            String xyzDataFileWithAbsolutePath = "/scratch/opensha/MapCalculationSavedObjects/xyzDataObject/" + (String)xyzDataFileName;
            this.createXYZDataObjectFile(xyzData, xyzDataFileWithAbsolutePath);
            output.writeObject(xyzDataFileWithAbsolutePath);
            output.close();
        }
        catch (RuntimeException e) {
            output.writeObject("Error " + e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void convertIML_ValuesToExpo(GeoDataSet xyzData, String selectedIMT, boolean isProbAtIML) {
        if (IMT_Info.isIMT_LogNormalDist(selectedIMT) && !isProbAtIML) {
            xyzData.exp();
        }
    }

    private GeoDataSet getXYZDataForPGV(ArrayList<AttenuationRelationship> selectedIMRs, ArrayList<Double> selectedWts, SitesInGriddedRegion region, EqkRupture rupture, boolean isProbAtIML, double value, ScenarioShakeMapCalculator calc) throws ParameterException {
        ArrayList<AttenuationRelationship> attenRelsSupportingPGV = new ArrayList<AttenuationRelationship>();
        ArrayList<AttenuationRelationship> attenRelsNotSupportingPGV = new ArrayList<AttenuationRelationship>();
        ArrayList<Double> attenRelsWtsSupportingPGV = new ArrayList<Double>();
        ArrayList<Double> attenRelsWtsNotSupportingPGV = new ArrayList<Double>();
        GeoDataSet pgvDataSet = null;
        int size = selectedIMRs.size();
        for (int i = 0; i < size; ++i) {
            AttenuationRelationship attenRel = selectedIMRs.get(i);
            String imt = attenRel.getIntensityMeasure().getName();
            if (imt.equals("SA")) {
                attenRelsNotSupportingPGV.add(attenRel);
                attenRelsWtsNotSupportingPGV.add(selectedWts.get(i));
                continue;
            }
            attenRelsSupportingPGV.add(attenRel);
            attenRelsWtsSupportingPGV.add(selectedWts.get(i));
        }
        int attenRelsNotSupportingPGV_size = attenRelsNotSupportingPGV.size();
        int attenRelsSupportingPGV_size = attenRelsSupportingPGV.size();
        GeoDataSet xyzDataSetForPGV = null;
        GeoDataSet xyzDataSetForNotPGV = null;
        if (attenRelsNotSupportingPGV_size > 0) {
            xyzDataSetForNotPGV = calc.getScenarioShakeMapData(attenRelsNotSupportingPGV, attenRelsWtsNotSupportingPGV, region, rupture, isProbAtIML, value);
            this.convertIML_ValuesToExpo(xyzDataSetForNotPGV, "SA", isProbAtIML);
            xyzDataSetForNotPGV.scale(94.5896);
        }
        if (attenRelsSupportingPGV_size > 0) {
            xyzDataSetForPGV = calc.getScenarioShakeMapData(attenRelsSupportingPGV, attenRelsWtsSupportingPGV, region, rupture, isProbAtIML, value);
            this.convertIML_ValuesToExpo(xyzDataSetForPGV, "PGV", isProbAtIML);
        }
        if (attenRelsNotSupportingPGV_size > 0 && attenRelsSupportingPGV_size > 0) {
            pgvDataSet = new ArbDiscrGeoDataSet(true);
            for (int i = 0; i < xyzDataSetForPGV.size(); ++i) {
                pgvDataSet.set(xyzDataSetForNotPGV.getLocation(i), xyzDataSetForNotPGV.get(i));
            }
        } else if (attenRelsSupportingPGV_size == 0) {
            pgvDataSet = xyzDataSetForNotPGV;
        } else if (attenRelsNotSupportingPGV_size == 0) {
            pgvDataSet = xyzDataSetForPGV;
        }
        return pgvDataSet;
    }

    private void createXYZDataObjectFile(GeoDataSet xyzData, String xyzDataFileWithAbsolutePath) {
        try {
            FileUtils.saveObjectInFile(xyzDataFileWithAbsolutePath, xyzData);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void getIMR_ParametersAndAddListeners(ArrayList selectedAttenRels) {
        ListIterator it = selectedAttenRels.listIterator();
        while (it.hasNext()) {
            ScalarIMR imr = (ScalarIMR)it.next();
            ScalarIMR imr_temp = (ScalarIMR)this.createIMRClassInstance(imr.getClass().getName(), this);
            ListIterator<Parameter<?>> lt = imr.getOtherParamsIterator();
            while (lt.hasNext()) {
                Parameter<?> tempParam = lt.next();
                imr_temp.getParameter(tempParam.getName()).setValue(tempParam.getValue());
            }
            imr_temp.setIntensityMeasure(imr.getIntensityMeasure());
            ScalarIMR scalarIMR = imr_temp;
        }
    }

    private Object createIMRClassInstance(String className, ParameterChangeWarningListener listener) {
        try {
            Class<?> listenerClass = Class.forName("org.opensha.commons.param.event.ParameterChangeWarningListener");
            Object[] paramObjects = new Object[]{listener};
            Class[] params = new Class[]{listenerClass};
            Class<?> imrClass = Class.forName(className);
            Constructor<?> con = imrClass.getConstructor(params);
            Object obj = con.newInstance(paramObjects);
            return obj;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void parameterChangeWarning(ParameterChangeWarningEvent e) {
        e.getWarningParameter().setValueIgnoreWarning(e.getNewValue());
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.doGet(request, response);
    }
}

