/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.gui.servlets;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opensha.commons.data.xyz.GeoDataSet;
import org.opensha.commons.util.FileUtils;
import org.opensha.commons.util.ServerPrefUtils;
import org.opensha.sha.earthquake.EqkRupture;
import org.opensha.sha.mapping.GMT_MapGeneratorForShakeMaps;

public class ScenarioShakeMapGeneratorServlet
extends HttpServlet {
    public static final String SERVLET_URL = ServerPrefUtils.SERVER_PREFS.getServletBaseURL() + "ScenarioShakeMapGeneratorServlet";

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        System.out.println("ScenarioShakeMapGeneratorServlet: Handling GET");
        ObjectOutputStream outputToApplet = new ObjectOutputStream((OutputStream)response.getOutputStream());
        try {
            ObjectInputStream inputFromApplet = new ObjectInputStream((InputStream)request.getInputStream());
            GMT_MapGeneratorForShakeMaps gmtMap = (GMT_MapGeneratorForShakeMaps)inputFromApplet.readObject();
            String xyzDataFileName = (String)inputFromApplet.readObject();
            EqkRupture rupture = (EqkRupture)inputFromApplet.readObject();
            String imt = (String)inputFromApplet.readObject();
            String metadata = (String)inputFromApplet.readObject();
            String dirName = (String)inputFromApplet.readObject();
            GeoDataSet xyzData = (GeoDataSet)FileUtils.loadObject(xyzDataFileName);
            String webaddr = gmtMap.makeMapUsingServlet(xyzData, rupture, imt, metadata, dirName);
            outputToApplet.writeObject(webaddr);
            outputToApplet.close();
        }
        catch (Exception e) {
            outputToApplet.writeObject(new RuntimeException(e.getMessage()));
            outputToApplet.close();
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }
}

