/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.imr.attenRelImpl;

import java.util.HashMap;
import org.opensha.commons.data.Site;
import org.opensha.commons.exceptions.InvalidRangeException;
import org.opensha.commons.exceptions.ParameterException;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.param.constraint.impl.DoubleConstraint;
import org.opensha.commons.param.constraint.impl.DoubleDiscreteConstraint;
import org.opensha.commons.param.constraint.impl.StringConstraint;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.event.ParameterChangeWarningListener;
import org.opensha.commons.param.impl.DoubleParameter;
import org.opensha.sha.earthquake.EqkRupture;
import org.opensha.sha.faultSurface.FaultTrace;
import org.opensha.sha.faultSurface.RuptureSurface;
import org.opensha.sha.imr.AttenuationRelationship;
import org.opensha.sha.imr.param.EqkRuptureParams.DipParam;
import org.opensha.sha.imr.param.EqkRuptureParams.MagParam;
import org.opensha.sha.imr.param.EqkRuptureParams.RakeParam;
import org.opensha.sha.imr.param.EqkRuptureParams.RupTopDepthParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.DampingParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.PGA_Param;
import org.opensha.sha.imr.param.IntensityMeasureParams.PeriodParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.SA_Param;
import org.opensha.sha.imr.param.OtherParams.Component;
import org.opensha.sha.imr.param.OtherParams.ComponentParam;
import org.opensha.sha.imr.param.OtherParams.StdDevTypeParam;
import org.opensha.sha.imr.param.PropagationEffectParams.DistRupMinusJB_OverRupParameter;
import org.opensha.sha.imr.param.PropagationEffectParams.DistanceRupParameter;
import org.opensha.sha.imr.param.SiteParams.Vs30_Param;

@Deprecated
public class AS_2005_AttenRel
extends AttenuationRelationship
implements ParameterChangeListener {
    private static final String C = "AS_2005_prelim_AttenRel";
    private static final boolean D = false;
    public static final String SHORT_NAME = "AS2005";
    private static final long serialVersionUID = 1234567890987654352L;
    public static final String NAME = "Abrahamson & Silva (2005 prelim)";
    private static double[] period = new double[]{0.0, 0.01, 0.02, 0.03, 0.04, 0.05, 0.075, 0.1, 0.15, 0.2, 0.25, 0.3, 0.4, 0.5, 0.75, 1.0, 1.5, 2.0, 3.0, 4.0, 5.0};
    private static double[] vref = new double[]{865.1, 865.1, 865.1, 907.8, 994.5, 1053.5, 1085.7, 1032.5, 877.6, 748.2, 654.3, 587.1, 503.0, 456.6, 410.5, 400.0, 400.0, 400.0, 400.0, 400.0, 400.0};
    private static double[] b_soil = new double[]{-1.186, -1.186, -1.219, -1.273, -1.308, -1.346, -1.471, -1.624, -1.931, -2.188, -2.381, -2.518, -2.657, -2.669, -2.401, -1.955, -1.025, -0.299, 0.0, 0.0, 0.0};
    private static double[] c0 = new double[]{6.4, 6.7, 6.6, 6.4, 6.7, 7.1, 8.3, 9.6, 10.3, 9.5, 8.7, 7.3, 6.8, 6.1, 3.8, 3.6, 2.7, 2.4, 3.9, 5.1, 6.1};
    private static double[] c1 = new double[]{1.283, 1.2474, 1.2808, 1.3632, 1.4936, 1.6645, 2.1555, 2.5918, 2.87, 2.7123, 2.5164, 2.2411, 2.0442, 1.9085, 1.3589, 1.0968, 0.5499, 0.0308, -0.0884, -0.2875, -0.3686};
    private static double[] c2 = new double[]{-0.9841, -0.9704, -0.9771, -0.9969, -1.0286, -1.0637, -1.1423, -1.2036, -1.1957, -1.1051, -1.0301, -0.9411, -0.883, -0.8539, -0.7629, -0.7397, -0.6657, -0.6195, -0.7102, -0.7218, -0.7683};
    private static double[] c3 = new double[]{-0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2};
    private static double[] c5 = new double[]{0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05};
    private static double[] c6 = new double[]{0.01, 0.0112, 0.0118, 0.0131, 0.0163, 0.0194, 0.0281, 0.0282, 0.0218, 0.0068, -0.0056, -0.0158, -0.0293, -0.0469, -0.0687, -0.0874, -0.1146, -0.1282, -0.1574, -0.1916, -0.1994};
    private static double[] c7 = new double[]{0.2601, 0.2491, 0.2511, 0.2512, 0.236, 0.2297, 0.1891, 0.1719, 0.1894, 0.2071, 0.2327, 0.2282, 0.22, 0.2364, 0.2589, 0.268, 0.2012, 0.2527, 0.2511, 0.1449, 0.0998};
    private static double[] c8 = new double[]{-0.09, -0.09, -0.09, -0.09, -0.09, -0.09, -0.09, -0.09, -0.09, -0.09, -0.09, -0.09, -0.09, -0.09, -0.09, -0.09, -0.09, -0.09, -0.09, -0.09, -0.09};
    private static double[] c9 = new double[]{0.213, 0.1986, 0.2084, 0.2389, 0.2495, 0.2748, 0.2351, 0.2122, 0.1978, 0.1531, 0.0514, -0.0102, -0.0246, -0.0299, -0.0193, 0.0178, -0.0019, 0.0336, 0.1418, 0.321, 0.2559};
    private static double[] c10 = new double[]{0.9475, 0.949, 0.9898, 1.054, 1.0943, 1.1456, 1.3126, 1.4806, 1.8391, 2.1163, 2.319, 2.4505, 2.5833, 2.558, 2.1441, 1.533, 0.3399, -0.5625, -0.8821, -0.8508, -0.7994};
    private static double[] c11 = new double[]{0.0647, 0.0546, 0.0557, 0.0583, 0.064, 0.0694, 0.0628, 0.0566, 0.0458, 0.0286, 0.0511, 0.05, 0.0491, 0.0385, 0.0227, 0.0294, 0.0222, 0.0667, 0.0262, 0.0272, 0.0073};
    private static double[] c12 = new double[]{0.0245, 0.0245, 0.0248, 0.0254, 0.0259, 0.0274, 0.0291, 0.0291, 0.0314, 0.029, 0.0288, 0.0277, 0.0181, 0.019, 0.0077, -0.003, -0.0189, -0.0264, -0.0275, -0.0385, -0.0377};
    private static double[] sigma0 = new double[]{0.5065, 0.509, 0.5106, 0.5176, 0.5249, 0.5313, 0.5476, 0.558, 0.556, 0.5465, 0.5458, 0.5521, 0.5499, 0.5604, 0.5809, 0.598, 0.6156, 0.6159, 0.5719, 0.58, 0.5889};
    private static double[] tau0 = new double[]{0.3281, 0.326, 0.3304, 0.3443, 0.3573, 0.3796, 0.4044, 0.4008, 0.3929, 0.3657, 0.3507, 0.336, 0.3504, 0.377, 0.3535, 0.3614, 0.3795, 0.4161, 0.4935, 0.4882, 0.5652};
    private static double[] tauCorr = new double[]{1.0, 0.99, 0.99, 0.98, 0.97, 0.95, 0.93, 0.92, 0.92, 0.92, 0.91, 0.89, 0.85, 0.82, 0.68, 0.57, 0.45, 0.28, 0.28, 0.17, 0.17};
    private static double n = 1.18;
    private static double c = 1.88;
    private HashMap indexFromPerHashMap;
    private int iper;
    private double vs30;
    private double rjb;
    private double rRup;
    private double distRupJB_Fraction;
    private double aspectratio;
    private double rake;
    private double dip;
    private double mag;
    private double srcSiteA;
    private double depthTop;
    private String stdDevType;
    private boolean parameterChange;
    private double mean;
    private double stdDev;
    protected static final Double MAG_WARN_MIN = 4.5;
    protected static final Double MAG_WARN_MAX = 8.5;
    protected static final Double DISTANCE_RUP_WARN_MIN = 0.0;
    protected static final Double DISTANCE_RUP_WARN_MAX = 200.0;
    protected static final Double VS30_WARN_MIN = 180.0;
    protected static final Double VS30_WARN_MAX = 3500.0;
    protected DoubleParameter srcSiteAngleParam = null;
    public static final String SRC_SITE_ANGLE_NAME = "Source_Site Angle";
    public static final String SRC_SITE_ANGLE_UNITS = "degrees";
    public static final String SRC_SITE_ANGLE_INFO = "Difference between directions defined by closest point on trace to site and the average strike of fault";
    public static final Double SRC_SITE_ANGLE_DEFAULT = 90.0;
    protected static final Double SRC_SITE_ANGLE_MIN = -360.0;
    protected static final Double SRC_SITE_ANGLE_MAX = 360.0;
    protected DoubleParameter aspectRatioParam = null;
    public static final String ASPECT_RATIO_NAME = "Rupture Apsect Ratio";
    public static final String ASPECT_RATIO_INFO = "Rupture length over down-dip width";
    public static final Double ASPECT_RATIO_DEFAULT = 1.0;
    protected static final Double ASPECT_RATIO_MIN = Double.MIN_VALUE;
    protected static final Double ASPECT_RATIO_MAX = 200.0;

    public AS_2005_AttenRel(ParameterChangeWarningListener listener) {
        this.listener = listener;
        this.initSupportedIntensityMeasureParams();
        this.indexFromPerHashMap = new HashMap();
        for (int i = 0; i < period.length; ++i) {
            this.indexFromPerHashMap.put(period[i], i);
        }
        this.initEqkRuptureParams();
        this.initPropagationEffectParams();
        this.initSiteParams();
        this.initOtherParams();
        this.initIndependentParamLists();
        this.initParameterEventListeners();
    }

    @Override
    public void setEqkRupture(EqkRupture eqkRupture) throws InvalidRangeException {
        this.magParam.setValueIgnoreWarning(eqkRupture.getMag());
        this.rakeParam.setValue(eqkRupture.getAveRake());
        RuptureSurface surface = eqkRupture.getRuptureSurface();
        this.dipParam.setValue(surface.getAveDip());
        this.rupTopDepthParam.setValue(surface.getAveRupTopDepth());
        if (surface.isPointSurface()) {
            this.aspectRatioParam.setValue(1.0);
        } else {
            this.aspectRatioParam.setValue(surface.getAveLength() / surface.getAveWidth());
        }
        this.eqkRupture = eqkRupture;
        this.setPropagationEffectParams();
    }

    @Override
    public void setSite(Site site) throws ParameterException {
        this.vs30Param.setValue((Double)site.getParameter("Vs30").getValue());
        this.site = site;
        this.setPropagationEffectParams();
    }

    @Override
    protected void setPropagationEffectParams() {
        if (this.site != null && this.eqkRupture != null) {
            this.distanceRupParam.setValue(this.eqkRupture, this.site);
            this.distRupMinusJB_OverRupParam.setValue(this.eqkRupture, this.site);
            RuptureSurface surface = this.eqkRupture.getRuptureSurface();
            FaultTrace surfTrace = this.eqkRupture.getRuptureSurface().getEvenlyDiscritizedUpperEdge();
            Location fltLoc1 = (Location)surfTrace.get(0);
            Location fltLoc2 = (Location)surfTrace.get(surfTrace.size() - 1);
            double angle1 = LocationUtils.azimuth(fltLoc1, fltLoc2);
            double minDist = Double.MAX_VALUE;
            int minDistLocIndex = -1;
            for (int i = 0; i < surfTrace.size(); ++i) {
                double dist = LocationUtils.horzDistanceFast(this.site.getLocation(), (Location)surfTrace.get(i));
                if (!(dist < minDist)) continue;
                minDist = dist;
                minDistLocIndex = i;
            }
            double angle2 = LocationUtils.azimuth((Location)surfTrace.get(minDistLocIndex), this.site.getLocation());
            this.srcSiteAngleParam.setValue(angle2 - angle1);
        }
    }

    protected void setCoeffIndex() throws ParameterException {
        if (this.im == null) {
            throw new ParameterException("AS_2005_prelim_AttenRel: updateCoefficients(): The Intensity Measusre Parameter has not been set yet, unable to process.");
        }
        this.iper = this.im.getName().equalsIgnoreCase("SA") ? (Integer)this.indexFromPerHashMap.get(this.saPeriodParam.getValue()) : 0;
        this.parameterChange = true;
        this.intensityMeasureChanged = false;
    }

    @Override
    public double getMean() {
        if (this.intensityMeasureChanged) {
            this.setCoeffIndex();
        }
        if (this.rRup > this.USER_MAX_DISTANCE) {
            return -35.0;
        }
        if (this.parameterChange) {
            this.calcMeanStdDev();
        }
        return this.mean;
    }

    @Override
    public double getStdDev() {
        if (this.intensityMeasureChanged) {
            this.setCoeffIndex();
        }
        if (this.parameterChange) {
            this.calcMeanStdDev();
        }
        return this.stdDev;
    }

    @Override
    public void setParamDefaults() {
        this.vs30Param.setValueAsDefault();
        this.magParam.setValueAsDefault();
        this.rakeParam.setValueAsDefault();
        this.dipParam.setValueAsDefault();
        this.aspectRatioParam.setValue(ASPECT_RATIO_DEFAULT);
        this.rupTopDepthParam.setValueAsDefault();
        this.distanceRupParam.setValueAsDefault();
        this.distRupMinusJB_OverRupParam.setValueAsDefault();
        this.saParam.setValueAsDefault();
        this.saPeriodParam.setValueAsDefault();
        this.saDampingParam.setValueAsDefault();
        this.pgaParam.setValueAsDefault();
        this.componentParam.setValueAsDefault();
        this.stdDevTypeParam.setValueAsDefault();
        this.srcSiteAngleParam.setValue(SRC_SITE_ANGLE_DEFAULT);
        this.vs30 = (Double)this.vs30Param.getValue();
        this.rjb = (Double)this.distRupMinusJB_OverRupParam.getValue();
        this.rRup = (Double)this.distanceRupParam.getValue();
        this.aspectratio = (Double)this.aspectRatioParam.getValue();
        this.rake = (Double)this.rakeParam.getValue();
        this.dip = (Double)this.dipParam.getValue();
        this.mag = (Double)this.magParam.getValue();
        this.srcSiteA = (Double)this.srcSiteAngleParam.getValue();
        this.depthTop = (Double)this.rupTopDepthParam.getValue();
        this.stdDevType = (String)this.stdDevTypeParam.getValue();
    }

    protected void initIndependentParamLists() {
        this.meanIndependentParams.clear();
        this.meanIndependentParams.addParameter(this.distanceRupParam);
        this.meanIndependentParams.addParameter(this.distRupMinusJB_OverRupParam);
        this.meanIndependentParams.addParameter(this.vs30Param);
        this.meanIndependentParams.addParameter(this.magParam);
        this.meanIndependentParams.addParameter(this.rakeParam);
        this.meanIndependentParams.addParameter(this.dipParam);
        this.meanIndependentParams.addParameter(this.componentParam);
        this.meanIndependentParams.addParameter(this.aspectRatioParam);
        this.meanIndependentParams.addParameter(this.rupTopDepthParam);
        this.meanIndependentParams.addParameter(this.srcSiteAngleParam);
        this.stdDevIndependentParams.clear();
        this.stdDevIndependentParams.addParameter(this.stdDevTypeParam);
        this.stdDevIndependentParams.addParameterList(this.meanIndependentParams);
        this.exceedProbIndependentParams.clear();
        this.exceedProbIndependentParams.addParameterList(this.stdDevIndependentParams);
        this.exceedProbIndependentParams.addParameter(this.sigmaTruncTypeParam);
        this.exceedProbIndependentParams.addParameter(this.sigmaTruncLevelParam);
        this.imlAtExceedProbIndependentParams.addParameterList(this.exceedProbIndependentParams);
        this.imlAtExceedProbIndependentParams.addParameter(this.exceedProbParam);
    }

    @Override
    protected void initSiteParams() {
        this.vs30Param = new Vs30_Param(VS30_WARN_MIN, (double)VS30_WARN_MAX);
        this.siteParams.clear();
        this.siteParams.addParameter(this.vs30Param);
    }

    @Override
    protected void initEqkRuptureParams() {
        this.magParam = new MagParam(MAG_WARN_MIN, (double)MAG_WARN_MAX);
        this.rakeParam = new RakeParam();
        this.dipParam = new DipParam();
        this.rupTopDepthParam = new RupTopDepthParam();
        DoubleConstraint c2 = new DoubleConstraint(ASPECT_RATIO_MIN, ASPECT_RATIO_MAX);
        this.aspectRatioParam = new DoubleParameter(ASPECT_RATIO_NAME, c2);
        this.aspectRatioParam.setInfo(ASPECT_RATIO_INFO);
        this.aspectRatioParam.setNonEditable();
        this.eqkRuptureParams.clear();
        this.eqkRuptureParams.addParameter(this.magParam);
        this.eqkRuptureParams.addParameter(this.rakeParam);
        this.eqkRuptureParams.addParameter(this.dipParam);
        this.eqkRuptureParams.addParameter(this.rupTopDepthParam);
        this.eqkRuptureParams.addParameter(this.aspectRatioParam);
    }

    @Override
    protected void initPropagationEffectParams() {
        this.distanceRupParam = new DistanceRupParameter(0.0);
        this.distanceRupParam.addParameterChangeWarningListener(this.listener);
        DoubleConstraint warn = new DoubleConstraint(DISTANCE_RUP_WARN_MIN, DISTANCE_RUP_WARN_MAX);
        warn.setNonEditable();
        this.distanceRupParam.setWarningConstraint(warn);
        this.distanceRupParam.setNonEditable();
        this.distRupMinusJB_OverRupParam = new DistRupMinusJB_OverRupParameter(0.0);
        this.distRupMinusJB_OverRupParam.setNonEditable();
        DoubleConstraint c3 = new DoubleConstraint(SRC_SITE_ANGLE_MIN, SRC_SITE_ANGLE_MAX);
        this.srcSiteAngleParam = new DoubleParameter(SRC_SITE_ANGLE_NAME, c3, SRC_SITE_ANGLE_UNITS);
        this.srcSiteAngleParam.setInfo(SRC_SITE_ANGLE_INFO);
        this.srcSiteAngleParam.setNonEditable();
        this.propagationEffectParams.addParameter(this.distanceRupParam);
        this.propagationEffectParams.addParameter(this.distRupMinusJB_OverRupParam);
        this.propagationEffectParams.addParameter(this.srcSiteAngleParam);
    }

    @Override
    protected void initSupportedIntensityMeasureParams() {
        DoubleDiscreteConstraint periodConstraint = new DoubleDiscreteConstraint();
        for (int i = 0; i < period.length; ++i) {
            periodConstraint.addDouble((Double)period[i]);
        }
        periodConstraint.setNonEditable();
        this.saPeriodParam = new PeriodParam(periodConstraint);
        this.saDampingParam = new DampingParam();
        this.saParam = new SA_Param(this.saPeriodParam, this.saDampingParam);
        this.saParam.setNonEditable();
        this.pgaParam = new PGA_Param();
        this.pgaParam.setNonEditable();
        this.saParam.addParameterChangeWarningListener(this.listener);
        this.pgaParam.addParameterChangeWarningListener(this.listener);
        this.supportedIMParams.clear();
        this.supportedIMParams.addParameter(this.saParam);
        this.supportedIMParams.addParameter(this.pgaParam);
    }

    @Override
    protected void initOtherParams() {
        super.initOtherParams();
        this.componentParam = new ComponentParam(Component.AVE_HORZ, Component.AVE_HORZ);
        StringConstraint stdDevTypeConstraint = new StringConstraint();
        stdDevTypeConstraint.addString("Total");
        stdDevTypeConstraint.addString("None (zero)");
        stdDevTypeConstraint.addString("Inter-Event");
        stdDevTypeConstraint.addString("Intra-Event");
        stdDevTypeConstraint.setNonEditable();
        this.stdDevTypeParam = new StdDevTypeParam(stdDevTypeConstraint);
        this.otherParams.addParameter(this.componentParam);
        this.otherParams.addParameter(this.stdDevTypeParam);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getShortName() {
        return SHORT_NAME;
    }

    private void calcMeanStdDev() {
        double pgaRock = Math.exp(this.calcMean(0, 0.0, 1100.0));
        this.mean = this.calcMean(this.iper, pgaRock, this.vs30);
        this.stdDev = this.calcStdDev(this.iper, pgaRock, this.vs30);
        this.parameterChange = false;
    }

    private double calcMean(int iper, double pgaRock, double vs30) {
        this.rjb = this.rRup - this.distRupJB_Fraction * this.rRup;
        double Frv = this.rake > 22.5 && this.rake < 157.5 ? 1.0 : 0.0;
        double Fn = this.rake < -22.5 && this.rake > -157.5 ? 1.0 : 0.0;
        double r = Math.sqrt(this.rRup * this.rRup + c0[iper] * c0[iper]);
        double sum = c1[iper] + (c2[iper] + c3[iper] * (7.5 - this.mag)) * Math.log(r) + c5[iper] * (this.mag - 6.0) + c6[iper] * (8.5 - this.mag) * (8.5 - this.mag);
        sum += c7[iper] * Frv + c9[iper] * Fn;
        double taperM1 = this.mag > 7.0 ? 1.0 : (this.mag > 6.5 ? (this.mag - 6.5) * 2.0 : 0.0);
        double taperM2 = this.mag > 6.5 ? 1.0 : (this.mag > 6.0 ? (this.mag - 6.0) * 2.0 : 0.0);
        double ar1 = this.aspectratio;
        if (ar1 > 20.0) {
            ar1 = 20.0;
        } else if (ar1 < 1.5) {
            ar1 = 1.5;
        }
        sum += c8[iper] * (Math.log(ar1) - Math.log(1.5)) * taperM1;
        double soilamp = vs30 < vref[iper] ? c10[iper] * Math.log(vs30 / vref[iper]) - b_soil[iper] * Math.log(c + pgaRock) + b_soil[iper] * Math.log(pgaRock + c * Math.pow(vs30 / vref[iper], n)) : (c10[iper] + b_soil[iper] * n) * Math.log(vs30 / vref[iper]);
        sum += soilamp;
        double hw1 = 0.0;
        double angle1 = Math.abs(this.srcSiteA);
        if (angle1 > 90.0) {
            angle1 = 180.0 - this.srcSiteA;
        }
        double taperTheta = angle1 < 20.0 ? angle1 / 20.0 : 1.0;
        double t_hw = (30.0 - this.rjb) / 30.0 * (90.0 - this.dip) / 45.0 * taperM2;
        double t_fw = this.depthTop == 0.0 ? 0.0 : 1.0 - this.rjb / (2.0 * this.depthTop + 1.0);
        hw1 = this.srcSiteA > 0.0 && this.rjb < 30.0 ? c11[iper] * (t_hw * taperTheta + t_fw * (1.0 - taperTheta)) : (this.srcSiteA < 0.0 && this.rjb < 2.0 * this.depthTop ? c11[iper] * t_fw : 0.0);
        sum += hw1;
        if (this.mag < 6.5) {
            sum += c12[iper] * (this.depthTop - 5.0) * (1.0 - taperM2);
        }
        return sum;
    }

    private double calcStdDev(int iper, double pgaRock, double vs30) {
        double sigma = sigma0[iper];
        double tau = tau0[iper];
        if (this.stdDevType.equals("None (zero)")) {
            return 0.0;
        }
        if (this.stdDevType.equals("Intra-Event")) {
            return sigma;
        }
        double dAmp_dPGA = vs30 >= vref[iper] ? 0.0 : b_soil[iper] * pgaRock * (-1.0 / (pgaRock + 1.0) + 1.0 / (pgaRock + vs30 / vref[iper]));
        tau = Math.sqrt(tau0[iper] * tau0[iper] + Math.pow(dAmp_dPGA * tau0[0], 2.0) + 2.0 * dAmp_dPGA * tau0[0] * tau0[iper] * tauCorr[iper]);
        if (this.stdDevType.equals("Inter-Event")) {
            return tau;
        }
        return Math.sqrt(sigma * sigma + tau * tau);
    }

    @Override
    public void parameterChange(ParameterChangeEvent e) {
        String pName = e.getParameterName();
        Object val = e.getNewValue();
        this.parameterChange = true;
        if (pName.equals("DistanceRup")) {
            this.rRup = (Double)val;
        } else if (pName.equals("(distRup-distJB)/distRup")) {
            this.distRupJB_Fraction = (Double)val;
        } else if (pName.equals("Vs30")) {
            this.vs30 = (Double)val;
        } else if (pName.equals("Magnitude")) {
            this.mag = (Double)val;
        } else if (pName.equals("Dip")) {
            this.dip = (Double)val;
        } else if (pName.equals("Rake")) {
            this.rake = (Double)val;
        } else if (pName.equals(ASPECT_RATIO_NAME)) {
            this.aspectratio = (Double)val;
        } else if (pName.equals(SRC_SITE_ANGLE_NAME)) {
            this.srcSiteA = (Double)val;
        } else if (pName.equals("Rupture Top Depth")) {
            this.depthTop = (Double)val;
        } else if (pName.equals("Std Dev Type")) {
            this.stdDevType = (String)val;
        } else if (pName.equals("SA Period") && this.intensityMeasureChanged) {
            this.setCoeffIndex();
        }
    }

    @Override
    public void resetParameterEventListeners() {
        this.distanceRupParam.removeParameterChangeListener(this);
        this.distRupMinusJB_OverRupParam.removeParameterChangeListener(this);
        this.vs30Param.removeParameterChangeListener(this);
        this.magParam.removeParameterChangeListener(this);
        this.rakeParam.removeParameterChangeListener(this);
        this.dipParam.removeParameterChangeListener(this);
        this.aspectRatioParam.removeParameterChangeListener(this);
        this.rupTopDepthParam.removeParameterChangeListener(this);
        this.srcSiteAngleParam.removeParameterChangeListener(this);
        this.stdDevTypeParam.removeParameterChangeListener(this);
        this.saPeriodParam.removeParameterChangeListener(this);
        this.initParameterEventListeners();
    }

    @Override
    protected void initParameterEventListeners() {
        this.distanceRupParam.addParameterChangeListener(this);
        this.distRupMinusJB_OverRupParam.addParameterChangeListener(this);
        this.vs30Param.addParameterChangeListener(this);
        this.magParam.addParameterChangeListener(this);
        this.rakeParam.addParameterChangeListener(this);
        this.dipParam.addParameterChangeListener(this);
        this.aspectRatioParam.addParameterChangeListener(this);
        this.rupTopDepthParam.addParameterChangeListener(this);
        this.srcSiteAngleParam.addParameterChangeListener(this);
        this.stdDevTypeParam.addParameterChangeListener(this);
        this.saPeriodParam.addParameterChangeListener(this);
    }
}

