/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.imr.attenRelImpl;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.opensha.commons.data.Site;
import org.opensha.commons.exceptions.ParameterException;
import org.opensha.commons.param.constraint.impl.DoubleConstraint;
import org.opensha.commons.param.constraint.impl.StringConstraint;
import org.opensha.commons.param.event.ParameterChangeWarningListener;
import org.opensha.commons.param.impl.EnumParameter;
import org.opensha.commons.util.FaultUtils;
import org.opensha.sha.earthquake.EqkRupture;
import org.opensha.sha.imr.AttenuationRelationship;
import org.opensha.sha.imr.attenRelImpl.ngaw2.FaultStyle;
import org.opensha.sha.imr.param.EqkRuptureParams.MagParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.DurationTimeInterval;
import org.opensha.sha.imr.param.IntensityMeasureParams.SignificantDurationParam;
import org.opensha.sha.imr.param.OtherParams.Component;
import org.opensha.sha.imr.param.OtherParams.ComponentParam;
import org.opensha.sha.imr.param.OtherParams.StdDevTypeParam;
import org.opensha.sha.imr.param.PropagationEffectParams.DistanceRupParameter;
import org.opensha.sha.imr.param.SiteParams.DepthTo1pt0kmPerSecParam;
import org.opensha.sha.imr.param.SiteParams.Vs30_Param;

public class AfshariStewart_2016_AttenRel
extends AttenuationRelationship {
    public static final String NAME = "Afshari & Stewart (2016)";
    public static final String SHORT_NAME = "AfshariStewart2016";
    private SignificantDurationParam durParam;
    protected static final double VS30_WARN_MIN = 150.0;
    protected static final double VS30_WARN_MAX = 1500.0;
    protected static final double DEPTH_1pt0_WARN_MIN = 0.0;
    protected static final double DEPTH_1pt0_WARN_MAX = 3000.0;
    protected static final double MAG_WARN_MIN = 3.0;
    protected static final double MAG_WARN_MAX = 8.0;
    protected static final double DISTANCE_RUP_WARN_MIN = 0.0;
    protected static final double DISTANCE_RUP_WARN_MAX = 300.0;
    private EnumParameter<FaultStyle> faultStyleParam;
    public static final String FAULT_STYLE_PARAM_NAME = "Fault Style";
    public static final String BASIN_DEPTH_MODEL_NAME = "Basin Depth Model Region";
    private EnumParameter<BasinDepthModel> basinDepthModelParam;
    static final Map<DurationTimeInterval, Coefficients> coeffs = new HashMap<DurationTimeInterval, Coefficients>();

    public AfshariStewart_2016_AttenRel() {
        this(null);
    }

    public AfshariStewart_2016_AttenRel(ParameterChangeWarningListener l) {
        this.listener = l;
        this.initEqkRuptureParams();
        this.initSiteParams();
        this.initPropagationEffectParams();
        this.initOtherParams();
        this.initSupportedIntensityMeasureParams();
        this.initIndependentParamLists();
        this.initParameterEventListeners();
    }

    @Override
    public void setParamDefaults() {
        this.vs30Param.setValue(760.0);
        this.depthTo1pt0kmPerSecParam.setValue(null);
        this.magParam.setValue(6.0);
        this.distanceRupParam.setValue(0.0);
        this.faultStyleParam.setValue(FaultStyle.UNKNOWN);
        this.basinDepthModelParam.setValue(BasinDepthModel.CALIFORNIA);
        this.componentParam.setValue(Component.AVE_HORZ);
        this.stdDevTypeParam.setValue("Total");
        this.durParam.setTimeInterval(DurationTimeInterval.INTERVAL_5_75);
        this.setIntensityMeasure(this.durParam);
    }

    protected void initIndependentParamLists() {
        this.meanIndependentParams.clear();
        this.meanIndependentParams.addParameter(this.magParam);
        this.meanIndependentParams.addParameter(this.faultStyleParam);
        this.meanIndependentParams.addParameter(this.vs30Param);
        this.meanIndependentParams.addParameter(this.depthTo1pt0kmPerSecParam);
        this.meanIndependentParams.addParameter(this.basinDepthModelParam);
        this.meanIndependentParams.addParameter(this.distanceRupParam);
        this.meanIndependentParams.addParameter(this.componentParam);
        this.stdDevIndependentParams.clear();
        this.stdDevIndependentParams.addParameter(this.magParam);
        this.stdDevIndependentParams.addParameter(this.stdDevTypeParam);
        this.stdDevIndependentParams.addParameter(this.componentParam);
        this.exceedProbIndependentParams.clear();
        this.exceedProbIndependentParams.addParameterList(this.meanIndependentParams);
        this.exceedProbIndependentParams.addParameterList(this.stdDevIndependentParams);
        this.exceedProbIndependentParams.addParameter(this.sigmaTruncTypeParam);
        this.exceedProbIndependentParams.addParameter(this.sigmaTruncLevelParam);
        this.imlAtExceedProbIndependentParams.addParameterList(this.exceedProbIndependentParams);
        this.imlAtExceedProbIndependentParams.addParameter(this.exceedProbParam);
    }

    @Override
    protected void initSiteParams() {
        this.vs30Param = new Vs30_Param(150.0, 1500.0);
        this.depthTo1pt0kmPerSecParam = new DepthTo1pt0kmPerSecParam(0.0, 3000.0);
        this.depthTo1pt0kmPerSecParam.setValue(null);
        this.siteParams.clear();
        this.siteParams.addParameter(this.vs30Param);
        this.siteParams.addParameter(this.depthTo1pt0kmPerSecParam);
    }

    @Override
    protected void initEqkRuptureParams() {
        this.magParam = new MagParam(3.0, 8.0);
        this.faultStyleParam = new EnumParameter<FaultStyle>(FAULT_STYLE_PARAM_NAME, EnumSet.allOf(FaultStyle.class), FaultStyle.UNKNOWN, null);
        this.eqkRuptureParams.clear();
        this.eqkRuptureParams.addParameter(this.magParam);
        this.eqkRuptureParams.addParameter(this.faultStyleParam);
    }

    @Override
    protected void initPropagationEffectParams() {
        this.distanceRupParam = new DistanceRupParameter(0.0);
        this.distanceRupParam.addParameterChangeWarningListener(this.listener);
        DoubleConstraint warn = new DoubleConstraint(0.0, 300.0);
        warn.setNonEditable();
        this.distanceRupParam.setWarningConstraint(warn);
        this.distanceRupParam.setNonEditable();
        this.propagationEffectParams.addParameter(this.distanceRupParam);
    }

    @Override
    protected void initSupportedIntensityMeasureParams() {
        this.durParam = new SignificantDurationParam(DurationTimeInterval.INTERVAL_5_75, DurationTimeInterval.INTERVAL_5_95, DurationTimeInterval.INTERVAL_20_80);
        this.supportedIMParams.clear();
        this.supportedIMParams.addParameter(this.durParam);
    }

    @Override
    protected void initOtherParams() {
        super.initOtherParams();
        this.componentParam = new ComponentParam(Component.AVE_HORZ, Component.AVE_HORZ);
        this.basinDepthModelParam = new EnumParameter<BasinDepthModel>(BASIN_DEPTH_MODEL_NAME, EnumSet.allOf(BasinDepthModel.class), BasinDepthModel.CALIFORNIA, "Disabled");
        this.basinDepthModelParam.setInfo("Model used for Z1.0 scaling, or disable to use the default Z1.0 model (in which case user supplied Z1.0 will also be ignored)");
        StringConstraint stdDevTypeConstraint = new StringConstraint();
        stdDevTypeConstraint.addString("Total");
        stdDevTypeConstraint.addString("None (zero)");
        stdDevTypeConstraint.addString("Inter-Event");
        stdDevTypeConstraint.addString("Intra-Event");
        stdDevTypeConstraint.setNonEditable();
        this.stdDevTypeParam = new StdDevTypeParam(stdDevTypeConstraint);
        this.otherParams.addParameter(this.basinDepthModelParam);
        this.otherParams.addParameter(this.componentParam);
        this.otherParams.addParameter(this.stdDevTypeParam);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getShortName() {
        return SHORT_NAME;
    }

    @Override
    public void setEqkRupture(EqkRupture eqkRupture) {
        this.eqkRupture = eqkRupture;
        this.magParam.setValueIgnoreWarning(eqkRupture.getMag());
        this.faultStyleParam.setValue(AfshariStewart_2016_AttenRel.getFaultStyle(eqkRupture.getAveRake()));
        this.setPropagationEffectParams();
    }

    private void propEffectUpdate() {
        this.distanceRupParam.setValueIgnoreWarning(this.eqkRupture.getRuptureSurface().getDistanceRup(this.site.getLocation()));
    }

    static FaultStyle getFaultStyle(Double rake) {
        if (rake == null || Double.isNaN(rake)) {
            return FaultStyle.UNKNOWN;
        }
        FaultUtils.assertValidRake(rake);
        if (rake >= 135.0 || rake <= -135.0) {
            return FaultStyle.STRIKE_SLIP;
        }
        if (rake >= -45.0 && rake <= 45.0) {
            return FaultStyle.STRIKE_SLIP;
        }
        if (rake >= 45.0 && rake <= 135.0) {
            return FaultStyle.REVERSE;
        }
        return FaultStyle.NORMAL;
    }

    @Override
    public void setSite(Site site) throws ParameterException {
        this.site = site;
        this.vs30Param.setValueIgnoreWarning((Double)site.getParameter("Vs30").getValue());
        this.depthTo1pt0kmPerSecParam.setValueIgnoreWarning((Double)site.getParameter("Depth 1.0 km/sec").getValue());
        this.setPropagationEffectParams();
    }

    @Override
    protected void setPropagationEffectParams() {
        if (this.site != null && this.eqkRupture != null) {
            this.propEffectUpdate();
        }
    }

    @Override
    public double getMean() {
        double delZ1;
        double eventTerm;
        Coefficients c = coeffs.get((Object)this.durParam.getTimeInterval());
        FaultStyle flt = (FaultStyle)((Object)this.faultStyleParam.getValue());
        double b0 = c.b0.get((Object)flt);
        double b1 = c.b1.get((Object)flt);
        double mag = (Double)this.magParam.getValue();
        double rRup = (Double)this.distanceRupParam.getValue();
        double vs30 = (Double)this.vs30Param.getValue();
        Double z1 = (Double)this.depthTo1pt0kmPerSecParam.getValue();
        if (z1 != null && Double.isNaN(z1)) {
            z1 = null;
        }
        BasinDepthModel depthModel = (BasinDepthModel)((Object)this.basinDepthModelParam.getValue());
        if (mag > c.m1) {
            double m0 = Math.pow(10.0, 1.5 * mag + 16.05);
            double deltaSigma = mag <= c.m2 ? Math.exp(b1 + c.b2 * (mag - c.mStar)) : Math.exp(b1 + c.b2 * (c.m2 - c.mStar) + c.b3 * (mag - c.m2));
            double f0 = 1.568E7 * Math.pow(deltaSigma / m0, 0.3333333333333333);
            eventTerm = 1.0 / f0;
        } else {
            eventTerm = b0;
        }
        double pathTerm = rRup <= c.R1 ? c.c1 * rRup : (rRup <= c.R2 ? c.c1 * c.R1 + c.c2 * (rRup - c.R1) : c.c1 * c.R1 + c.c2 * (c.R2 - c.R1) + c.c3 * (rRup - c.R2));
        if (z1 == null || depthModel == null) {
            delZ1 = 0.0;
        } else {
            double vsTerm;
            double scalar;
            switch (depthModel.ordinal()) {
                case 0: {
                    scalar = -1.7875;
                    vsTerm = (Math.pow(vs30, 4.0) + Math.pow(570.94, 4.0)) / (Math.pow(1360.0, 4.0) + Math.pow(570.94, 4.0));
                    break;
                }
                case 1: {
                    scalar = -2.615;
                    vsTerm = (Math.pow(vs30, 2.0) + Math.pow(412.39, 2.0)) / (Math.pow(1360.0, 2.0) + Math.pow(412.39, 2.0));
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported basin model: " + String.valueOf((Object)depthModel));
                }
            }
            double muZ1 = Math.exp(scalar * Math.log(vsTerm) - Math.log(1000.0));
            delZ1 = z1 - muZ1;
        }
        double fDelZ1 = delZ1 <= c.delZ1ref ? c.c5 * delZ1 : c.c5 * c.delZ1ref;
        double siteTerm = vs30 <= c.V1 ? c.c4 * Math.log(vs30 / c.Vref) + fDelZ1 : c.c4 * Math.log(c.V1 / c.Vref) + fDelZ1;
        return Math.log(eventTerm + pathTerm) + siteTerm;
    }

    @Override
    public double getStdDev() {
        String stdDevType;
        Coefficients c = coeffs.get((Object)this.durParam.getTimeInterval());
        double mag = (Double)this.magParam.getValue();
        double tau = mag < 6.5 ? c.tau1 : (mag < 7.0 ? c.tau1 + (c.tau2 - c.tau1) * (2.0 * (mag - 6.5)) : c.tau2);
        double phi = mag < 5.5 ? c.phi1 : (mag < 5.75 ? c.phi1 + (c.phi2 - c.phi1) * (4.0 * (mag - 5.5)) : c.phi2);
        switch (stdDevType = (String)this.stdDevTypeParam.getValue()) {
            case "None (zero)": {
                return 0.0;
            }
            case "Total": {
                return Math.sqrt(tau * tau + phi * phi);
            }
            case "Inter-Event": {
                return tau;
            }
            case "Intra-Event": {
                return phi;
            }
        }
        throw new IllegalStateException("Unsupported std dev type: " + stdDevType);
    }

    static {
        HashMap<FaultStyle, Double> b0 = new HashMap<FaultStyle, Double>();
        b0.put(FaultStyle.NORMAL, 1.555);
        b0.put(FaultStyle.REVERSE, 0.7806);
        b0.put(FaultStyle.STRIKE_SLIP, 1.279);
        b0.put(FaultStyle.UNKNOWN, 1.28);
        HashMap<FaultStyle, Double> b1 = new HashMap<FaultStyle, Double>();
        b1.put(FaultStyle.NORMAL, 4.992);
        b1.put(FaultStyle.REVERSE, 7.061);
        b1.put(FaultStyle.STRIKE_SLIP, 5.578);
        b1.put(FaultStyle.UNKNOWN, 5.576);
        coeffs.put(DurationTimeInterval.INTERVAL_5_75, new Coefficients(5.35, 7.15, 6.0, b0, b1, 0.9011, -1.684, 0.1159, 0.1065, 0.0682, -0.2246, 6.0E-4, 10.0, 50.0, 600.0, 368.2, 200.0, 0.28, 0.25, 0.54, 0.41));
        b0 = new HashMap();
        b0.put(FaultStyle.NORMAL, 2.541);
        b0.put(FaultStyle.REVERSE, 1.612);
        b0.put(FaultStyle.STRIKE_SLIP, 2.302);
        b0.put(FaultStyle.UNKNOWN, 2.182);
        b1 = new HashMap();
        b1.put(FaultStyle.NORMAL, 3.17);
        b1.put(FaultStyle.REVERSE, 4.536);
        b1.put(FaultStyle.STRIKE_SLIP, 3.467);
        b1.put(FaultStyle.UNKNOWN, 3.628);
        coeffs.put(DurationTimeInterval.INTERVAL_5_95, new Coefficients(5.2, 7.4, 6.0, b0, b1, 0.9443, -3.911, 0.3165, 0.2539, 0.0932, -0.3183, 6.0E-4, 10.0, 50.0, 600.0, 369.9, 200.0, 0.25, 0.19, 0.43, 0.35));
        b0 = new HashMap();
        b0.put(FaultStyle.NORMAL, 1.409);
        b0.put(FaultStyle.REVERSE, 0.7729);
        b0.put(FaultStyle.STRIKE_SLIP, 0.8804);
        b0.put(FaultStyle.UNKNOWN, 0.8822);
        b1 = new HashMap();
        b1.put(FaultStyle.NORMAL, 4.778);
        b1.put(FaultStyle.REVERSE, 6.579);
        b1.put(FaultStyle.STRIKE_SLIP, 6.188);
        b1.put(FaultStyle.UNKNOWN, 6.182);
        coeffs.put(DurationTimeInterval.INTERVAL_20_80, new Coefficients(5.2, 7.4, 6.0, b0, b1, 0.7414, -3.164, 0.0646, 0.0865, 0.0373, -0.4237, 5.0E-4, 10.0, 50.0, 600.0, 369.6, 200.0, 0.3, 0.19, 0.56, 0.45));
    }

    public static enum BasinDepthModel {
        CALIFORNIA("California"),
        JAPAN("Japan");

        private String name;

        private BasinDepthModel(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    private static class Coefficients {
        final double m1;
        final double m2;
        final double mStar;
        final Map<FaultStyle, Double> b0;
        final Map<FaultStyle, Double> b1;
        final double b2;
        final double b3;
        final double c1;
        final double c2;
        final double c3;
        final double c4;
        final double c5;
        final double R1;
        final double R2;
        final double V1;
        final double Vref;
        final double delZ1ref;
        final double tau1;
        final double tau2;
        final double phi1;
        final double phi2;

        public Coefficients(double m1, double m2, double mStar, Map<FaultStyle, Double> b0, Map<FaultStyle, Double> b1, double b2, double b3, double c1, double c2, double c3, double c4, double c5, double r1, double r2, double v1, double vref, double dZ1ref, double tau1, double tau2, double phi1, double phi2) {
            this.m1 = m1;
            this.m2 = m2;
            this.mStar = mStar;
            this.b0 = b0;
            this.b1 = b1;
            this.b2 = b2;
            this.b3 = b3;
            this.c1 = c1;
            this.c2 = c2;
            this.c3 = c3;
            this.c4 = c4;
            this.c5 = c5;
            this.R1 = r1;
            this.R2 = r2;
            this.V1 = v1;
            this.Vref = vref;
            this.delZ1ref = dZ1ref;
            this.tau1 = tau1;
            this.tau2 = tau2;
            this.phi1 = phi1;
            this.phi2 = phi2;
        }
    }
}

