/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.imr.attenRelImpl;

import java.text.DecimalFormat;
import java.util.Hashtable;
import java.util.ListIterator;
import org.opensha.commons.data.Named;
import org.opensha.commons.data.Site;
import org.opensha.commons.exceptions.IMRException;
import org.opensha.commons.exceptions.InvalidRangeException;
import org.opensha.commons.exceptions.ParameterException;
import org.opensha.commons.param.AbstractParameter;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.constraint.ParameterConstraint;
import org.opensha.commons.param.constraint.impl.DoubleConstraint;
import org.opensha.commons.param.constraint.impl.IntegerConstraint;
import org.opensha.commons.param.event.ParameterChangeWarningListener;
import org.opensha.commons.param.impl.BooleanParameter;
import org.opensha.commons.param.impl.DoubleParameter;
import org.opensha.commons.param.impl.IntegerParameter;
import org.opensha.sha.earthquake.EqkRupture;
import org.opensha.sha.imr.AttenuationRelationship;
import org.opensha.sha.imr.attenRelImpl.AS_1997_AttenRel;
import org.opensha.sha.imr.param.IntensityMeasureParams.PeriodParam;
import org.opensha.sha.imr.param.OtherParams.Component;
import org.opensha.sha.imr.param.OtherParams.ComponentParam;
import org.opensha.sha.imr.param.OtherParams.SigmaTruncLevelParam;
import org.opensha.sha.imr.param.OtherParams.SigmaTruncTypeParam;
import org.opensha.sha.imr.param.OtherParams.StdDevTypeParam;
import org.opensha.sha.imr.param.SiteParams.Vs30_Param;

public class BS_2003_AttenRel
extends AttenuationRelationship {
    private static final String C = "BS_2006_AttenRel";
    private static final boolean D = false;
    public static final String NAME = "Baturay and Stewart (2003)";
    public static final String SHORT_NAME = "BS2006";
    private static final long serialVersionUID = 1234567890987654356L;
    protected static final Double VS30_WARN_MIN = 50.0;
    protected static final Double VS30_WARN_MAX = 760.0;
    private BooleanParameter softSoilParam = null;
    public static final String SOFT_SOIL_NAME = "Soft Soil Case";
    public static final String SOFT_SOIL_INFO = "Indicates that site is considered NEHRP E regardless of Vs30.\n\nConditions required are undrained shear strength < 24 kPa, PI > 20, water content > 40%, and thickness of clay exceeds 3 m.";
    public static final Boolean SOFT_SOIL_DEFAULT = false;
    private AS_1997_AttenRel as_1997_attenRel;
    private BS_2003_AttenRelCoefficients coeffs = null;
    private DoubleParameter AF_InterceptParam;
    public static final String AF_INTERCEPT_PARAM_NAME = "AF Intercept";
    public static final String AF_INTERCEPT_PARAM_INFO = "Intercept of the median regression model for the ground response analyses";
    private DoubleConstraint AF_InterceptparamConstraint = new DoubleConstraint(-2.0, 2.0);
    public static final double AF_INTERCEPT_PARAM_DEFAULT = 0.0;
    private DoubleParameter AF_SlopeParam;
    public static final String AF_SLOPE_PARAM_NAME = "AF Slope";
    public static final String AF_SLOPE_PARAM_INFO = "Slope of the median regression model for the ground response analyses";
    private DoubleConstraint AF_slopeParamConstraint = new DoubleConstraint(-1.0, 1.0);
    public static final double AF_SLOPE_PARAM_DEFAULT = 0.0;
    private DoubleParameter AF_AddRefAccParam;
    public static final String AF_ADDITIVE_REF_ACCELERATION_PARAM_NAME = "AF Add. Ref. Acceleration";
    public static final String AF_ADDITIVE_REF_ACCELERATION_PARAM_INFO = "Additive reference acceleration of the median regression model for the ground response analyses. This parameter improves the linear model fit for low Sa(rock) / PGA(rock)values and leads to more relaistic predictons than quadratic models";
    private DoubleConstraint AFaddRefAccParamConstraint = new DoubleConstraint(0.0, 0.5);
    public static final double AF_ADDITIVE_REF_ACCERLATION_DEFAULT = 0.03;
    private DoubleParameter AF_StdDevParam;
    public static final String AF_STD_DEV_PARAM_NAME = "Std. Dev. AF";
    public static final String AF_STD_DEV_PARAM_INFO = "Standard Deviation of the amplification factor from the ground response analyses regression model";
    private DoubleConstraint AF_StdDevParamConstraint = new DoubleConstraint(0.0, 1.0);
    public static final double AF_STD_DEV_DEFAULT = 0.3;
    private IntegerParameter numRunsParam;
    public static final String NUM_RUNS_PARAM_NAME = "Number of Runs";
    public static final String NUM_RUNS_PARAM_INFO = "Number of runs of the wave propagation simulation for the site";
    private IntegerConstraint numRunsConstraint = new IntegerConstraint(1, Integer.MAX_VALUE);
    public static final int NUM_RUNS_PARAM_DEFAULT = 1;
    protected Hashtable horzCoeffs = new Hashtable();

    public BS_2003_AttenRel(ParameterChangeWarningListener listener) {
        this.listener = listener;
        this.as_1997_attenRel = new AS_1997_AttenRel(listener);
        this.as_1997_attenRel.getParameter("AS Site Type").setValue("Rock/Shallow-Soil");
        this.as_1997_attenRel.getParameter("Component").setValue(Component.AVE_HORZ);
        this.sigmaTruncTypeParam = (SigmaTruncTypeParam)this.as_1997_attenRel.getParameter("Gaussian Truncation");
        this.sigmaTruncLevelParam = (SigmaTruncLevelParam)this.as_1997_attenRel.getParameter("Truncation Level");
        this.exceedProbParam = (DoubleParameter)this.as_1997_attenRel.getParameter("Exceed. Prob.");
        this.stdDevTypeParam = (StdDevTypeParam)this.as_1997_attenRel.getParameter("Std Dev Type");
        this.saPeriodParam = (PeriodParam)this.as_1997_attenRel.getParameter("SA Period");
        this.initCoefficients();
        this.initSupportedIntensityMeasureParams();
        this.initEqkRuptureParams();
        this.initPropagationEffectParams();
        this.initSiteParams();
        this.initOtherParams();
        this.initIndependentParamLists();
    }

    protected void setRockAttenAndParamLists() {
    }

    @Override
    protected void setPropagationEffectParams() {
    }

    @Override
    public void setEqkRupture(EqkRupture eqkRupture) throws InvalidRangeException {
        this.as_1997_attenRel.setEqkRupture(eqkRupture);
        this.eqkRupture = eqkRupture;
    }

    @Override
    public void setSite(Site site) throws ParameterException {
        this.AF_InterceptParam.setValue((Double)site.getParameter(AF_INTERCEPT_PARAM_NAME).getValue());
        this.AF_AddRefAccParam.setValue((Double)site.getParameter(AF_ADDITIVE_REF_ACCELERATION_PARAM_NAME).getValue());
        this.AF_SlopeParam.setValue((Double)site.getParameter(AF_SLOPE_PARAM_NAME).getValue());
        this.AF_StdDevParam.setValue((Double)site.getParameter(AF_STD_DEV_PARAM_NAME).getValue());
        this.vs30Param.setValueIgnoreWarning((Double)site.getParameter("Vs30").getValue());
        this.softSoilParam.setValue((Boolean)site.getParameter(SOFT_SOIL_NAME).getValue());
        this.numRunsParam.setValue((Integer)site.getParameter(NUM_RUNS_PARAM_NAME).getValue());
        this.site = site;
        this.as_1997_attenRel.setSiteLocation(site.getLocation());
    }

    protected void updateCoefficients() throws ParameterException {
        if (this.im == null) {
            throw new ParameterException("BS_2006_AttenRel: updateCoefficients(): The Intensity Measusre Parameter has not been set yet, unable to process.");
        }
        StringBuffer key = new StringBuffer(this.im.getName());
        if (this.im.getName().equalsIgnoreCase("SA")) {
            key.append("/" + String.valueOf(this.saPeriodParam.getValue()));
        }
        if (!this.horzCoeffs.containsKey(key.toString())) {
            throw new ParameterException("BS_2006_AttenRel: setIntensityMeasureType(): Unable to locate coefficients with key = " + String.valueOf(key));
        }
        this.coeffs = (BS_2003_AttenRelCoefficients)this.horzCoeffs.get(key.toString());
    }

    @Override
    public double getMean() throws IMRException {
        this.as_1997_attenRel.setIntensityMeasure(this.im);
        double asRockSA = this.as_1997_attenRel.getMean();
        double aVal = (Double)this.AF_InterceptParam.getValue();
        double bVal = (Double)this.AF_SlopeParam.getValue();
        double cVal = (Double)this.AF_AddRefAccParam.getValue();
        double lnAF = aVal + bVal * Math.log(Math.exp(asRockSA) + cVal);
        return lnAF + asRockSA;
    }

    @Override
    public double getStdDev() {
        String stdDevType = ((String)this.stdDevTypeParam.getValue()).toString();
        if (stdDevType.equals("None (zero)")) {
            return 0.0;
        }
        float periodParamVal = this.im.getName().equals("SA") ? (float)((Double)this.saPeriodParam.getValue()).doubleValue() : 0.0f;
        this.updateCoefficients();
        if ((double)periodParamVal < 0.75) {
            return this.getStdDevForBS();
        }
        if ((double)periodParamVal > 1.5) {
            return this.getStdDevForCS();
        }
        this.saPeriodParam.setValue(0.75);
        double stdDev_BS = this.getStdDevForBS();
        this.saPeriodParam.setValue(1.5);
        double stdDev_CS = this.getStdDevForCS();
        DecimalFormat format = new DecimalFormat("##.###");
        this.saPeriodParam.setValue(Double.valueOf(format.format(periodParamVal)));
        double stdDev = ((double)periodParamVal - 0.75) / 0.75 * (stdDev_CS - stdDev_BS) + stdDev_BS;
        return stdDev;
    }

    private double getStdDevForBS() {
        double stdDevAF = (Double)this.AF_StdDevParam.getValue();
        int numRuns = (Integer)this.numRunsParam.getValue();
        boolean softSoilCase = (Boolean)this.softSoilParam.getValue();
        double stdError = stdDevAF / Math.sqrt(numRuns);
        double vs30 = (Double)this.vs30Param.getValue();
        double stdDev_gNet = vs30 <= 180.0 || softSoilCase ? 0.38 : 0.56;
        double stdDev = Math.pow(stdDev_gNet, 2.0) + Math.pow(stdError, 2.0) + this.coeffs.tau * this.coeffs.tau;
        return Math.sqrt(stdDev);
    }

    private double getStdDevForCS() throws IMRException {
        double vs30;
        if (((Boolean)this.softSoilParam.getValue()).booleanValue()) {
            vs30 = 174.0;
        } else {
            try {
                vs30 = (Double)this.vs30Param.getValue();
            }
            catch (NullPointerException e) {
                throw new IMRException("BS_2006_AttenRel: getMean(): Not all parameters have been set");
            }
        }
        double sigmaV = vs30 < 260.0 ? this.coeffs.e1 : (vs30 < 360.0 ? this.coeffs.e1 + (this.coeffs.e3 - this.coeffs.e1) / Math.log(1.3846153846153846) * Math.log(vs30 / 260.0) : this.coeffs.e3);
        return Math.sqrt(sigmaV * sigmaV + this.coeffs.tau * this.coeffs.tau);
    }

    @Override
    public void setParamDefaults() {
        this.vs30Param.setValueAsDefault();
        this.softSoilParam.setValue(false);
        this.AF_AddRefAccParam.setValue(0.03);
        this.AF_InterceptParam.setValue(0.0);
        this.AF_SlopeParam.setValue(0.0);
        this.AF_StdDevParam.setValue(0.3);
        this.numRunsParam.setValue(1);
        this.as_1997_attenRel.setParamDefaults();
        this.as_1997_attenRel.getParameter("AS Site Type").setValue("Rock/Shallow-Soil");
        this.as_1997_attenRel.getParameter("Component").setValue(Component.AVE_HORZ);
        this.componentParam.setValueAsDefault();
    }

    protected void initIndependentParamLists() {
        AbstractParameter param;
        this.meanIndependentParams.clear();
        ListIterator<Parameter<?>> it = this.as_1997_attenRel.getMeanIndependentParamsIterator();
        String ignoreStr1 = "AS Site Type";
        String ignoreStr2 = "Component";
        while (it.hasNext()) {
            param = (AbstractParameter)it.next();
            if (ignoreStr1.equals(param.getName()) || ignoreStr2.equals(param.getName())) continue;
            this.meanIndependentParams.addParameter(param);
        }
        this.meanIndependentParams.addParameter(this.AF_AddRefAccParam);
        this.meanIndependentParams.addParameter(this.AF_InterceptParam);
        this.meanIndependentParams.addParameter(this.AF_SlopeParam);
        this.meanIndependentParams.addParameter(this.AF_StdDevParam);
        this.meanIndependentParams.addParameter(this.vs30Param);
        this.meanIndependentParams.addParameter(this.softSoilParam);
        this.meanIndependentParams.addParameter(this.numRunsParam);
        this.meanIndependentParams.addParameter(this.componentParam);
        this.stdDevIndependentParams.clear();
        it = this.as_1997_attenRel.getStdDevIndependentParamsIterator();
        while (it.hasNext()) {
            param = (AbstractParameter)it.next();
            if (ignoreStr1.equals(param.getName()) || ignoreStr2.equals(param.getName())) continue;
            this.stdDevIndependentParams.addParameter(param);
        }
        this.stdDevIndependentParams.addParameter(this.AF_AddRefAccParam);
        this.stdDevIndependentParams.addParameter(this.AF_InterceptParam);
        this.stdDevIndependentParams.addParameter(this.AF_SlopeParam);
        this.stdDevIndependentParams.addParameter(this.AF_StdDevParam);
        this.stdDevIndependentParams.addParameter(this.vs30Param);
        this.stdDevIndependentParams.addParameter(this.softSoilParam);
        this.stdDevIndependentParams.addParameter(this.numRunsParam);
        this.stdDevIndependentParams.addParameter(this.componentParam);
        this.exceedProbIndependentParams.clear();
        it = this.as_1997_attenRel.getExceedProbIndependentParamsIterator();
        while (it.hasNext()) {
            param = (AbstractParameter)it.next();
            if (ignoreStr1.equals(param.getName()) || ignoreStr2.equals(param.getName())) continue;
            this.exceedProbIndependentParams.addParameter(param);
        }
        this.exceedProbIndependentParams.addParameter(this.AF_AddRefAccParam);
        this.exceedProbIndependentParams.addParameter(this.AF_InterceptParam);
        this.exceedProbIndependentParams.addParameter(this.AF_SlopeParam);
        this.exceedProbIndependentParams.addParameter(this.AF_StdDevParam);
        this.exceedProbIndependentParams.addParameter(this.vs30Param);
        this.exceedProbIndependentParams.addParameter(this.softSoilParam);
        this.exceedProbIndependentParams.addParameter(this.numRunsParam);
        this.exceedProbIndependentParams.addParameter(this.componentParam);
        this.imlAtExceedProbIndependentParams.addParameterList(this.exceedProbIndependentParams);
        this.imlAtExceedProbIndependentParams.addParameter(this.exceedProbParam);
    }

    @Override
    protected void initSiteParams() {
        this.vs30Param = new Vs30_Param(VS30_WARN_MIN, (double)VS30_WARN_MAX);
        this.softSoilParam = new BooleanParameter(SOFT_SOIL_NAME, SOFT_SOIL_DEFAULT);
        this.softSoilParam.setInfo(SOFT_SOIL_INFO);
        this.AF_InterceptParam = new DoubleParameter(AF_INTERCEPT_PARAM_NAME, this.AF_InterceptparamConstraint, (Double)0.0);
        this.AF_InterceptParam.setInfo(AF_INTERCEPT_PARAM_INFO);
        this.AF_SlopeParam = new DoubleParameter(AF_SLOPE_PARAM_NAME, this.AF_slopeParamConstraint, (Double)0.0);
        this.AF_SlopeParam.setInfo(AF_SLOPE_PARAM_INFO);
        this.AF_AddRefAccParam = new DoubleParameter(AF_ADDITIVE_REF_ACCELERATION_PARAM_NAME, this.AFaddRefAccParamConstraint, (Double)0.03);
        this.AF_AddRefAccParam.setInfo(AF_ADDITIVE_REF_ACCELERATION_PARAM_INFO);
        this.AF_StdDevParam = new DoubleParameter(AF_STD_DEV_PARAM_NAME, this.AF_StdDevParamConstraint, (Double)0.3);
        this.AF_StdDevParam.setInfo(AF_STD_DEV_PARAM_INFO);
        this.numRunsParam = new IntegerParameter(NUM_RUNS_PARAM_NAME, (ParameterConstraint<Integer>)this.numRunsConstraint, (Integer)1);
        this.numRunsParam.setInfo(NUM_RUNS_PARAM_INFO);
        this.siteParams.clear();
        this.siteParams.addParameter(this.AF_AddRefAccParam);
        this.siteParams.addParameter(this.AF_InterceptParam);
        this.siteParams.addParameter(this.AF_SlopeParam);
        this.siteParams.addParameter(this.AF_StdDevParam);
        this.siteParams.addParameter(this.vs30Param);
        this.siteParams.addParameter(this.softSoilParam);
        this.siteParams.addParameter(this.numRunsParam);
    }

    @Override
    protected void initEqkRuptureParams() {
        this.eqkRuptureParams.clear();
        ListIterator<Parameter<?>> it = this.as_1997_attenRel.getEqkRuptureParamsIterator();
        while (it.hasNext()) {
            this.eqkRuptureParams.addParameter((AbstractParameter)it.next());
        }
    }

    @Override
    protected void initPropagationEffectParams() {
        this.propagationEffectParams.clear();
        ListIterator<Parameter<?>> it = this.as_1997_attenRel.getPropagationEffectParamsIterator();
        while (it.hasNext()) {
            this.propagationEffectParams.addParameter((AbstractParameter)it.next());
        }
    }

    @Override
    protected void initSupportedIntensityMeasureParams() {
        this.supportedIMParams.clear();
        ListIterator<Parameter<?>> it = this.as_1997_attenRel.getSupportedIntensityMeasuresIterator();
        while (it.hasNext()) {
            this.supportedIMParams.addParameter((AbstractParameter)it.next());
        }
    }

    @Override
    protected void initOtherParams() {
        this.componentParam = new ComponentParam(Component.AVE_HORZ, Component.AVE_HORZ);
        this.otherParams.clear();
        this.otherParams.addParameter(this.componentParam);
        ListIterator<Parameter<?>> it = this.as_1997_attenRel.getOtherParamsIterator();
        while (it.hasNext()) {
            AbstractParameter param = (AbstractParameter)it.next();
            if ("Component".equals(param.getName())) continue;
            this.otherParams.addParameter(param);
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getShortName() {
        return SHORT_NAME;
    }

    protected void initCoefficients() {
        String S = "BS_2006_AttenRel: initCoefficients():";
        this.horzCoeffs.clear();
        BS_2003_AttenRelCoefficients coeff = new BS_2003_AttenRelCoefficients("PGA", 0.0, -0.64, 418.0, -0.36, -0.14, 0.27, 0.44, 0.5);
        BS_2003_AttenRelCoefficients coeff0 = new BS_2003_AttenRelCoefficients("SA/" + Double.valueOf("0.01"), 0.01, -0.64, 418.0, -0.36, -0.14, 0.27, 0.44, 0.5);
        BS_2003_AttenRelCoefficients coeff1 = new BS_2003_AttenRelCoefficients("SA/" + Double.valueOf("0.02"), 0.02, -0.63, 490.0, -0.34, -0.12, 0.26, 0.45, 0.51);
        BS_2003_AttenRelCoefficients coeff2 = new BS_2003_AttenRelCoefficients("SA/" + Double.valueOf("0.03"), 0.03, -0.62, 324.0, -0.33, -0.11, 0.26, 0.46, 0.51);
        BS_2003_AttenRelCoefficients coeff3 = new BS_2003_AttenRelCoefficients("SA/" + Double.valueOf("0.04"), 0.04, -0.61, 233.0, -0.31, -0.11, 0.26, 0.47, 0.51);
        BS_2003_AttenRelCoefficients coeff4 = new BS_2003_AttenRelCoefficients("SA/" + Double.valueOf("0.05"), 0.05, -0.64, 192.0, -0.29, -0.11, 0.25, 0.47, 0.52);
        BS_2003_AttenRelCoefficients coeff5 = new BS_2003_AttenRelCoefficients("SA/" + Double.valueOf("0.06"), 0.06, -0.64, 181.0, -0.25, -0.11, 0.25, 0.48, 0.52);
        BS_2003_AttenRelCoefficients coeff6 = new BS_2003_AttenRelCoefficients("SA/" + Double.valueOf("0.075"), 0.075, -0.64, 196.0, -0.23, -0.11, 0.24, 0.48, 0.52);
        BS_2003_AttenRelCoefficients coeff7 = new BS_2003_AttenRelCoefficients("SA/" + Double.valueOf("0.09"), 0.09, -0.64, 239.0, -0.23, -0.12, 0.23, 0.49, 0.52);
        BS_2003_AttenRelCoefficients coeff8 = new BS_2003_AttenRelCoefficients("SA/" + Double.valueOf("0.10"), 0.1, -0.6, 257.0, -0.25, -0.13, 0.23, 0.49, 0.53);
        BS_2003_AttenRelCoefficients coeff9 = new BS_2003_AttenRelCoefficients("SA/" + Double.valueOf("0.12"), 0.12, -0.56, 299.0, -0.26, -0.14, 0.24, 0.49, 0.53);
        BS_2003_AttenRelCoefficients coeff10 = new BS_2003_AttenRelCoefficients("SA/" + Double.valueOf("0.15"), 0.15, -0.53, 357.0, -0.28, -0.18, 0.25, 0.49, 0.54);
        BS_2003_AttenRelCoefficients coeff11 = new BS_2003_AttenRelCoefficients("SA/" + Double.valueOf("0.17"), 0.17, -0.53, 406.0, -0.29, -0.19, 0.26, 0.48, 0.55);
        BS_2003_AttenRelCoefficients coeff12 = new BS_2003_AttenRelCoefficients("SA/" + Double.valueOf("0.20"), 0.2, -0.52, 453.0, -0.31, -0.19, 0.27, 0.47, 0.56);
        BS_2003_AttenRelCoefficients coeff13 = new BS_2003_AttenRelCoefficients("SA/" + Double.valueOf("0.24"), 0.24, -0.52, 493.0, -0.38, -0.16, 0.29, 0.47, 0.56);
        BS_2003_AttenRelCoefficients coeff14 = new BS_2003_AttenRelCoefficients("SA/" + Double.valueOf("0.30"), 0.3, -0.52, 532.0, -0.44, -0.14, 0.35, 0.46, 0.57);
        BS_2003_AttenRelCoefficients coeff15 = new BS_2003_AttenRelCoefficients("SA/" + Double.valueOf("0.36"), 0.36, -0.51, 535.0, -0.48, -0.11, 0.38, 0.46, 0.57);
        BS_2003_AttenRelCoefficients coeff16 = new BS_2003_AttenRelCoefficients("SA/" + Double.valueOf("0.40"), 0.4, -0.51, 535.0, -0.5, -0.1, 0.4, 0.46, 0.57);
        BS_2003_AttenRelCoefficients coeff17 = new BS_2003_AttenRelCoefficients("SA/" + Double.valueOf("0.46"), 0.46, -0.5, 535.0, -0.55, -0.08, 0.42, 0.45, 0.58);
        BS_2003_AttenRelCoefficients coeff18 = new BS_2003_AttenRelCoefficients("SA/" + Double.valueOf("0.50"), 0.5, -0.5, 535.0, -0.6, -0.06, 0.42, 0.45, 0.59);
        BS_2003_AttenRelCoefficients coeff19 = new BS_2003_AttenRelCoefficients("SA/" + Double.valueOf("0.60"), 0.6, -0.49, 535.0, -0.66, -0.03, 0.42, 0.44, 0.6);
        BS_2003_AttenRelCoefficients coeff20 = new BS_2003_AttenRelCoefficients("SA/" + Double.valueOf("0.75"), 0.75, -0.47, 535.0, -0.69, 0.0, 0.42, 0.44, 0.63);
        BS_2003_AttenRelCoefficients coeff21 = new BS_2003_AttenRelCoefficients("SA/" + Double.valueOf("0.85"), 0.85, -0.46, 535.0, -0.69, 0.0, 0.42, 0.44, 0.63);
        BS_2003_AttenRelCoefficients coeff22 = new BS_2003_AttenRelCoefficients("SA/" + Double.valueOf("1.00"), 1.0, -0.44, 535.0, -0.7, 0.0, 0.42, 0.44, 0.64);
        BS_2003_AttenRelCoefficients coeff23 = new BS_2003_AttenRelCoefficients("SA/" + Double.valueOf("1.50"), 1.5, -0.4, 535.0, -0.72, 0.0, 0.42, 0.44, 0.67);
        BS_2003_AttenRelCoefficients coeff24 = new BS_2003_AttenRelCoefficients("SA/" + Double.valueOf("2.00"), 2.0, -0.38, 535.0, -0.73, 0.0, 0.43, 0.44, 0.69);
        BS_2003_AttenRelCoefficients coeff25 = new BS_2003_AttenRelCoefficients("SA/" + Double.valueOf("3.00"), 3.0, -0.34, 535.0, -0.74, 0.0, 0.45, 0.44, 0.71);
        BS_2003_AttenRelCoefficients coeff26 = new BS_2003_AttenRelCoefficients("SA/" + Double.valueOf("4.00"), 4.0, -0.31, 535.0, -0.75, 0.0, 0.47, 0.44, 0.73);
        BS_2003_AttenRelCoefficients coeff27 = new BS_2003_AttenRelCoefficients("SA/" + Double.valueOf("5.00"), 5.0, -0.3, 535.0, -0.75, 0.0, 0.49, 0.44, 0.75);
        BS_2003_AttenRelCoefficients coeff28 = new BS_2003_AttenRelCoefficients("SA/" + Double.valueOf("0.0"), 0.0, -0.64, 418.0, -0.36, -0.14, 0.27, 0.44, 0.5);
        this.horzCoeffs.put(coeff.getName(), coeff);
        this.horzCoeffs.put(coeff0.getName(), coeff0);
        this.horzCoeffs.put(coeff1.getName(), coeff1);
        this.horzCoeffs.put(coeff2.getName(), coeff2);
        this.horzCoeffs.put(coeff3.getName(), coeff3);
        this.horzCoeffs.put(coeff4.getName(), coeff4);
        this.horzCoeffs.put(coeff5.getName(), coeff5);
        this.horzCoeffs.put(coeff6.getName(), coeff6);
        this.horzCoeffs.put(coeff7.getName(), coeff7);
        this.horzCoeffs.put(coeff8.getName(), coeff8);
        this.horzCoeffs.put(coeff9.getName(), coeff9);
        this.horzCoeffs.put(coeff10.getName(), coeff10);
        this.horzCoeffs.put(coeff11.getName(), coeff11);
        this.horzCoeffs.put(coeff12.getName(), coeff12);
        this.horzCoeffs.put(coeff13.getName(), coeff13);
        this.horzCoeffs.put(coeff14.getName(), coeff14);
        this.horzCoeffs.put(coeff15.getName(), coeff15);
        this.horzCoeffs.put(coeff16.getName(), coeff16);
        this.horzCoeffs.put(coeff17.getName(), coeff17);
        this.horzCoeffs.put(coeff18.getName(), coeff18);
        this.horzCoeffs.put(coeff19.getName(), coeff19);
        this.horzCoeffs.put(coeff20.getName(), coeff20);
        this.horzCoeffs.put(coeff21.getName(), coeff21);
        this.horzCoeffs.put(coeff22.getName(), coeff22);
        this.horzCoeffs.put(coeff23.getName(), coeff23);
        this.horzCoeffs.put(coeff24.getName(), coeff24);
        this.horzCoeffs.put(coeff25.getName(), coeff25);
        this.horzCoeffs.put(coeff26.getName(), coeff26);
        this.horzCoeffs.put(coeff27.getName(), coeff27);
        this.horzCoeffs.put(coeff28.getName(), coeff28);
    }

    class BS_2003_AttenRelCoefficients
    implements Named {
        protected static final String C = "BS_2003_AttenRelCoefficients";
        protected static final boolean D = false;
        private static final long serialVersionUID = 1234567890987654399L;
        protected String name;
        protected double period = -1.0;
        protected double b1;
        protected double vRef;
        protected double c;
        protected double b2;
        protected double tau;
        protected double e1;
        protected double e3;

        public BS_2003_AttenRelCoefficients(String name, double period, double b1, double vRef, double c, double b2, double tau, double e1, double e3) {
            this.name = name;
            this.period = period;
            this.b1 = b1;
            this.vRef = vRef;
            this.c = c;
            this.b2 = b2;
            this.tau = tau;
            this.e1 = e1;
            this.e3 = e3;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public String toString() {
            StringBuffer b = new StringBuffer();
            b.append(C);
            b.append("\n  Period = " + this.period);
            b.append("\n  b1 = " + this.b1);
            b.append("\n  vRef = " + this.vRef);
            b.append("\n  c = " + this.c);
            b.append("\n  b2 = " + this.b2);
            b.append("\n  tau = " + this.tau);
            b.append("\n  e1 = " + this.e1);
            b.append("\n e3 = " + this.e3);
            return b.toString();
        }
    }
}

