/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.imr.attenRelImpl;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeSet;
import org.opensha.commons.data.Named;
import org.opensha.commons.data.Site;
import org.opensha.commons.exceptions.IMRException;
import org.opensha.commons.exceptions.InvalidRangeException;
import org.opensha.commons.exceptions.ParameterException;
import org.opensha.commons.param.constraint.impl.DoubleConstraint;
import org.opensha.commons.param.constraint.impl.DoubleDiscreteConstraint;
import org.opensha.commons.param.constraint.impl.StringConstraint;
import org.opensha.commons.param.event.ParameterChangeWarningListener;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.commons.param.impl.WarningDoubleParameter;
import org.opensha.commons.util.FaultUtils;
import org.opensha.sha.earthquake.EqkRupture;
import org.opensha.sha.imr.AttenuationRelationship;
import org.opensha.sha.imr.param.EqkRuptureParams.FaultTypeParam;
import org.opensha.sha.imr.param.EqkRuptureParams.MagParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.DampingParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.PGA_Param;
import org.opensha.sha.imr.param.IntensityMeasureParams.PGV_Param;
import org.opensha.sha.imr.param.IntensityMeasureParams.PeriodParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.SA_Param;
import org.opensha.sha.imr.param.OtherParams.Component;
import org.opensha.sha.imr.param.OtherParams.ComponentParam;
import org.opensha.sha.imr.param.OtherParams.StdDevTypeParam;
import org.opensha.sha.imr.param.PropagationEffectParams.DistanceSeisParameter;

public class Campbell_1997_AttenRel
extends AttenuationRelationship {
    public static final String C = "Campbell_1997_AttenRel";
    private static final boolean D = false;
    public static final String NAME = "Campbell (1997) w/ erratum (2000) changes";
    public static final String SHORT_NAME = "Campbell_1997";
    private static final long serialVersionUID = 1234567890987654356L;
    public static final String FLT_TYPE_REVERSE = "Reverse";
    public static final String FLT_TYPE_OTHER = "Other";
    public static final String FLT_TYPE_UNKNOWN = "Unknown";
    private StringParameter siteTypeParam = null;
    public static final String SITE_TYPE_NAME = "Campbell Site Type";
    public static final String SITE_TYPE_INFO = "Geological conditions as the site";
    public static final String SITE_TYPE_FIRM_SOIL = "Firm-Soil";
    public static final String SITE_TYPE_SOFT_ROCK = "Soft-Rock";
    public static final String SITE_TYPE_HARD_ROCK = "Hard-Rock";
    public static final String SITE_TYPE_GEN_ROCK = "Generic-Rock";
    public static final String SITE_TYPE_GEN_SOIL = "Generic-Soil";
    public static final String SITE_TYPE_DEFAULT = "Firm-Soil";
    protected static final Double MAG_WARN_MIN = 5.0;
    protected static final Double MAG_WARN_MAX = 8.0;
    protected static final Double DISTANCE_SEIS_WARN_MIN = 3.0;
    protected static final Double DISTANCE_SEIS_WARN_MAX = 60.0;
    protected static final Double PERIOD_DEFAULT = 0.5;
    protected WarningDoubleParameter basinDepthParam = null;
    public static final String BASIN_DEPTH_NAME = "Campbell-Basin-Depth";
    public static final String BASIN_DEPTH_UNITS = "km";
    public static final String BASIN_DEPTH_INFO = "Depth to Cretaceous, crystalline basement, or 3 km/sec S-wave velocity";
    protected static final Double BASIN_DEPTH_DEFAULT = 5.0;
    protected static final Double BASIN_DEPTH_MIN = 0.0;
    protected static final Double BASIN_DEPTH_MAX = 30.0;
    protected static final Double BASIN_DEPTH_WARN_MIN = 0.0;
    protected static final Double BASIN_DEPTH_WARN_MAX = 10.0;
    private Campbell_1997_AttenRelCoefficients coeff = null;
    protected Hashtable coefficients = new Hashtable();

    protected void setFaultTypeFromRake(double rake) throws InvalidRangeException {
        FaultUtils.assertValidRake(rake);
        if (rake >= 22.5 && rake <= 157.5) {
            this.fltTypeParam.setValue(FLT_TYPE_REVERSE);
        } else {
            this.fltTypeParam.setValue(FLT_TYPE_OTHER);
        }
    }

    @Override
    public void setEqkRupture(EqkRupture eqkRupture) throws InvalidRangeException {
        this.magParam.setValueIgnoreWarning(eqkRupture.getMag());
        this.setFaultTypeFromRake(eqkRupture.getAveRake());
        this.eqkRupture = eqkRupture;
        this.setPropagationEffectParams();
    }

    @Override
    public void setSite(Site site) throws ParameterException {
        this.siteTypeParam.setValue((String)site.getParameter(SITE_TYPE_NAME).getValue());
        this.basinDepthParam.setValueIgnoreWarning((Double)site.getParameter(BASIN_DEPTH_NAME).getValue());
        this.site = site;
        this.setPropagationEffectParams();
    }

    @Override
    protected void setPropagationEffectParams() {
        if (this.site != null && this.eqkRupture != null) {
            this.distanceSeisParam.setValue(this.eqkRupture, this.site);
        }
    }

    protected void updateCoefficients() throws ParameterException {
        if (this.im == null) {
            throw new ParameterException("Campbell_1997_AttenRel: updateCoefficients(): The Intensity Measusre Parameter has not been set yet, unable to process.");
        }
        StringBuffer key = new StringBuffer(this.im.getName() + "/" + String.valueOf(this.saPeriodParam.getValue()));
        if (!this.coefficients.containsKey(key.toString())) {
            throw new ParameterException("Campbell_1997_AttenRel: setIntensityMeasureType(): Unable to locate coefficients with key = " + String.valueOf(key));
        }
        this.coeff = (Campbell_1997_AttenRelCoefficients)this.coefficients.get(key.toString());
    }

    public Campbell_1997_AttenRel(ParameterChangeWarningListener listener) {
        this.listener = listener;
        this.initCoefficients();
        this.initSupportedIntensityMeasureParams();
        this.initEqkRuptureParams();
        this.initPropagationEffectParams();
        this.initSiteParams();
        this.initOtherParams();
        this.initIndependentParamLists();
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getShortName() {
        return SHORT_NAME;
    }

    @Override
    public double getMean() throws IMRException {
        double mean;
        String im_name;
        Component component;
        String siteType;
        String fltType;
        Double tempDepth;
        double dist;
        double mag;
        double S_sr = 0.0;
        double S_hr = 0.0;
        try {
            mag = (Double)this.magParam.getValue();
            dist = (Double)this.distanceSeisParam.getValue();
            tempDepth = (Double)this.basinDepthParam.getValue();
            fltType = ((String)this.fltTypeParam.getValue()).toString();
            siteType = ((String)this.siteTypeParam.getValue()).toString();
            component = (Component)this.componentParam.getValue();
            im_name = this.im.getName();
        }
        catch (NullPointerException e) {
            throw new IMRException("Campbell_1997_AttenRel: getMean(): Not all parameters have been set");
        }
        if (dist > this.USER_MAX_DISTANCE) {
            return -35.0;
        }
        double F = fltType.equals(FLT_TYPE_REVERSE) ? 1.0 : (fltType.equals(FLT_TYPE_OTHER) ? 0.0 : 0.5);
        if (siteType.equals(SITE_TYPE_SOFT_ROCK)) {
            S_sr = 1.0;
        } else if (siteType.equals(SITE_TYPE_HARD_ROCK)) {
            S_hr = 1.0;
        } else if (siteType.equals(SITE_TYPE_GEN_ROCK)) {
            S_sr = 1.0;
        }
        double depth = tempDepth != null ? tempDepth : (S_hr == 1.0 ? 0.0 : (S_sr == 1.0 ? 1.0 : 5.0));
        if (siteType.equals(SITE_TYPE_GEN_ROCK)) {
            depth = 1.0;
        }
        if (siteType.equals(SITE_TYPE_GEN_SOIL)) {
            depth = 5.0;
        }
        double lnPGA = -3.512 + 0.904 * mag - 0.664 * Math.log(dist * dist + 0.0222 * Math.exp(1.294 * mag)) + (1.125 - 0.112 * Math.log(dist) - 0.0957 * mag) * F + (0.44 - 0.171 * Math.log(dist)) * S_sr + (0.405 - 0.222 * Math.log(dist)) * S_hr;
        if (depth <= 1.0) {
            lnPGA += (0.405 - 0.222 * Math.log(dist) - (0.44 - 0.171 * Math.log(dist)) * S_sr) * (1.0 - depth) * (1.0 - S_hr);
        }
        if (im_name.equals("PGA")) {
            mean = component == Component.AVE_HORZ ? lnPGA : lnPGA - 1.58 - 0.1 * mag - 1.5 * Math.log(dist + 0.079 * Math.exp(0.661 * mag)) + 1.89 * Math.log(dist + 0.361 * Math.exp(0.576 * mag)) - 0.11 * F;
        } else if (im_name.equals("SA")) {
            double period = (Double)this.saPeriodParam.getValue();
            if (period == 0.0) {
                mean = component == Component.AVE_HORZ ? lnPGA : lnPGA - 1.58 - 0.1 * mag - 1.5 * Math.log(dist + 0.079 * Math.exp(0.661 * mag)) + 1.89 * Math.log(dist + 0.361 * Math.exp(0.576 * mag)) - 0.11 * F;
            } else {
                this.updateCoefficients();
                mean = lnPGA + this.coeff.c1_h + this.coeff.c2_h * this.tanh(this.coeff.c3_h * (mag - 4.7)) + (this.coeff.c4_h + this.coeff.c5_h * mag) * dist + 0.5 * this.coeff.c6 * S_sr + this.coeff.c6 * S_hr + this.coeff.c7 * this.tanh(this.coeff.c8 * depth) * (1.0 - S_hr);
                if (depth < 1.0) {
                    mean += this.coeff.c6 * (1.0 - depth) * (1.0 - 0.5 * S_sr) * (1.0 - S_hr);
                }
                if (component == Component.VERT) {
                    mean += this.coeff.c1_v - 0.1 * mag + this.coeff.c2_v * this.tanh(0.71 * (mag - 4.7)) + this.coeff.c3_v * this.tanh(0.66 * (mag - 4.7)) - 1.5 * Math.log(dist + 0.079 * Math.exp(0.661 * mag)) + 1.89 * Math.log(dist + 0.361 * Math.exp(0.576 * mag)) - 0.11 * F + (this.coeff.c4_v * this.tanh(0.51 * depth) + this.coeff.c5_v * this.tanh(0.57 * depth)) * (1.0 - S_hr);
                }
            }
        } else {
            mean = lnPGA + 0.26 + 0.29 * mag - 1.44 * Math.log(dist + 0.0203 * Math.exp(0.958 * mag)) + 1.89 * Math.log(dist + 0.361 * Math.exp(0.576 * mag)) + (1.0E-4 - 5.65E-4 * mag) * dist - 0.12 * F - 0.15 * S_sr - 0.3 * S_hr + 0.75 * this.tanh(0.51 * depth) * (1.0 - S_hr);
            if (depth < 1.0) {
                mean -= 0.3 * (1.0 - depth) * (1.0 - 0.5 * S_sr) * (1.0 - S_hr);
            }
            if (component == Component.VERT) {
                mean += -2.15 + 0.07 * mag - 1.24 * Math.log(dist + 0.00394 * Math.exp(1.17 * mag)) + 1.44 * Math.log(dist + 0.0203 * Math.exp(0.958 * mag)) + 0.1 * F + (0.46 * this.tanh(2.68 * depth) - 0.53 * this.tanh(0.47 * depth)) * (1.0 - S_hr);
            }
        }
        return mean;
    }

    @Override
    public double getStdDev() throws IMRException {
        double sigma;
        String stdevType;
        String im_name;
        Component component;
        double mag;
        if (((String)this.stdDevTypeParam.getValue()).equals("None (zero)")) {
            return 0.0;
        }
        double S_hr = 0.0;
        double S_sr = 0.0;
        try {
            mag = (Double)this.magParam.getValue();
            component = (Component)this.componentParam.getValue();
            im_name = this.im.getName();
            stdevType = ((String)this.stdDevTypeParam.getValue()).toString();
        }
        catch (NullPointerException e) {
            throw new IMRException("Campbell_1997_AttenRel: getMean(): Not all parameters have been set");
        }
        if (stdevType.equals("Total (Mag Dependent)")) {
            sigma = mag < 7.4 ? 0.889 - 0.0691 * mag : 0.38;
        } else {
            String siteType;
            String fltType;
            double depth;
            double dist;
            try {
                dist = (Double)this.distanceSeisParam.getValue();
                depth = (Double)this.basinDepthParam.getValue();
                fltType = ((String)this.fltTypeParam.getValue()).toString();
                siteType = ((String)this.siteTypeParam.getValue()).toString();
            }
            catch (NullPointerException e) {
                throw new IMRException("Campbell_1997_AttenRel: getMean(): Not all parameters have been set");
            }
            double F = fltType.equals(FLT_TYPE_REVERSE) ? 1.0 : (fltType.equals(FLT_TYPE_OTHER) ? 0.0 : 0.0);
            if (siteType.equals(SITE_TYPE_SOFT_ROCK)) {
                S_sr = 1.0;
            } else if (siteType.equals(SITE_TYPE_HARD_ROCK)) {
                S_hr = 1.0;
            }
            double pga = -3.512 + 0.904 * mag - 0.664 * Math.log(dist * dist + 0.0222 * Math.exp(1.294 * mag)) + (1.125 - 0.112 * Math.log(dist) - 0.0957 * mag) * F + (0.44 - 0.171 * Math.log(dist)) * S_sr + (0.405 - 0.222 * Math.log(dist)) * S_hr;
            if (depth <= 1.0) {
                pga += (0.405 - 0.222 * Math.log(dist) - (0.44 - 0.171 * Math.log(dist)) * S_sr) * (1.0 - depth) * (1.0 - S_hr);
            }
            sigma = (pga = Math.exp(pga)) < 0.068 ? 0.55 : (pga >= 0.068 && pga < 0.21 ? 0.173 - 0.14 * Math.log(pga) : 0.39);
        }
        if (im_name.equals("PGA")) {
            if (component == Component.AVE_HORZ) {
                return sigma;
            }
            return Math.pow(sigma * sigma + 0.1296, 0.5);
        }
        if (im_name.equals("SA")) {
            double period = (Double)this.saPeriodParam.getValue();
            if (period == 0.0) {
                if (component == Component.AVE_HORZ) {
                    return sigma;
                }
                return Math.pow(sigma * sigma + 0.1296, 0.5);
            }
            sigma = Math.pow(sigma * sigma + 0.0729, 0.5);
            if (component == Component.AVE_HORZ) {
                return sigma;
            }
            return Math.pow(sigma * sigma + 0.1521, 0.5);
        }
        sigma = Math.pow(sigma * sigma + 0.0036, 0.5);
        if (component == Component.AVE_HORZ) {
            return sigma;
        }
        return Math.pow(sigma * sigma + 0.09, 0.5);
    }

    private double tanh(double x) {
        return (Math.exp(x) - Math.exp(-x)) / (Math.exp(x) + Math.exp(-x));
    }

    @Override
    public void setParamDefaults() {
        this.siteTypeParam.setValue("Firm-Soil");
        this.magParam.setValueAsDefault();
        this.fltTypeParam.setValueAsDefault();
        this.distanceSeisParam.setValueAsDefault();
        this.basinDepthParam.setValue(BASIN_DEPTH_DEFAULT);
        this.saParam.setValueAsDefault();
        this.saPeriodParam.setValueAsDefault();
        this.saDampingParam.setValueAsDefault();
        this.pgaParam.setValueAsDefault();
        this.pgvParam.setValueAsDefault();
        this.componentParam.setValueAsDefault();
        this.stdDevTypeParam.setValueAsDefault();
    }

    protected void initIndependentParamLists() {
        this.meanIndependentParams.clear();
        this.meanIndependentParams.addParameter(this.distanceSeisParam);
        this.meanIndependentParams.addParameter(this.siteTypeParam);
        this.meanIndependentParams.addParameter(this.basinDepthParam);
        this.meanIndependentParams.addParameter(this.magParam);
        this.meanIndependentParams.addParameter(this.fltTypeParam);
        this.meanIndependentParams.addParameter(this.componentParam);
        this.stdDevIndependentParams.clear();
        this.stdDevIndependentParams.addParameter(this.stdDevTypeParam);
        this.stdDevIndependentParams.addParameter(this.distanceSeisParam);
        this.stdDevIndependentParams.addParameter(this.siteTypeParam);
        this.stdDevIndependentParams.addParameter(this.basinDepthParam);
        this.stdDevIndependentParams.addParameter(this.magParam);
        this.stdDevIndependentParams.addParameter(this.fltTypeParam);
        this.stdDevIndependentParams.addParameter(this.componentParam);
        this.exceedProbIndependentParams.clear();
        this.exceedProbIndependentParams.addParameter(this.distanceSeisParam);
        this.exceedProbIndependentParams.addParameter(this.siteTypeParam);
        this.exceedProbIndependentParams.addParameter(this.basinDepthParam);
        this.exceedProbIndependentParams.addParameter(this.magParam);
        this.exceedProbIndependentParams.addParameter(this.fltTypeParam);
        this.exceedProbIndependentParams.addParameter(this.componentParam);
        this.exceedProbIndependentParams.addParameter(this.stdDevTypeParam);
        this.exceedProbIndependentParams.addParameter(this.sigmaTruncTypeParam);
        this.exceedProbIndependentParams.addParameter(this.sigmaTruncLevelParam);
        this.imlAtExceedProbIndependentParams.addParameterList(this.exceedProbIndependentParams);
        this.imlAtExceedProbIndependentParams.addParameter(this.exceedProbParam);
    }

    @Override
    protected void initSiteParams() {
        StringConstraint siteConstraint = new StringConstraint();
        siteConstraint.addString("Firm-Soil");
        siteConstraint.addString(SITE_TYPE_SOFT_ROCK);
        siteConstraint.addString(SITE_TYPE_HARD_ROCK);
        siteConstraint.addString(SITE_TYPE_GEN_ROCK);
        siteConstraint.addString(SITE_TYPE_GEN_SOIL);
        siteConstraint.setNonEditable();
        this.siteTypeParam = new StringParameter(SITE_TYPE_NAME, siteConstraint, null);
        this.siteTypeParam.setInfo(SITE_TYPE_INFO);
        this.siteTypeParam.setNonEditable();
        DoubleConstraint basinDepthConstraint = new DoubleConstraint(BASIN_DEPTH_MIN, BASIN_DEPTH_MAX);
        basinDepthConstraint.setNullAllowed(true);
        basinDepthConstraint.setNonEditable();
        this.basinDepthParam = new WarningDoubleParameter(BASIN_DEPTH_NAME, basinDepthConstraint, BASIN_DEPTH_UNITS);
        this.basinDepthParam.setInfo(BASIN_DEPTH_INFO);
        this.basinDepthParam.setNonEditable();
        this.siteParams.clear();
        this.siteParams.addParameter(this.siteTypeParam);
        this.siteParams.addParameter(this.basinDepthParam);
    }

    @Override
    protected void initEqkRuptureParams() {
        this.magParam = new MagParam(MAG_WARN_MIN, (double)MAG_WARN_MAX);
        StringConstraint constraint = new StringConstraint();
        constraint.addString(FLT_TYPE_REVERSE);
        constraint.addString(FLT_TYPE_OTHER);
        constraint.addString(FLT_TYPE_UNKNOWN);
        constraint.setNonEditable();
        this.fltTypeParam = new FaultTypeParam(constraint, FLT_TYPE_OTHER);
        this.eqkRuptureParams.clear();
        this.eqkRuptureParams.addParameter(this.magParam);
        this.eqkRuptureParams.addParameter(this.fltTypeParam);
    }

    @Override
    protected void initPropagationEffectParams() {
        this.distanceSeisParam = new DistanceSeisParameter(3.0);
        this.distanceSeisParam.addParameterChangeWarningListener(this.listener);
        DoubleConstraint warn = new DoubleConstraint(DISTANCE_SEIS_WARN_MIN, DISTANCE_SEIS_WARN_MAX);
        warn.setNonEditable();
        this.distanceSeisParam.setWarningConstraint(warn);
        this.distanceSeisParam.setNonEditable();
        this.propagationEffectParams.addParameter(this.distanceSeisParam);
    }

    @Override
    protected void initSupportedIntensityMeasureParams() {
        DoubleDiscreteConstraint periodConstraint = new DoubleDiscreteConstraint();
        TreeSet<Double> set = new TreeSet<Double>();
        Enumeration keys = this.coefficients.keys();
        while (keys.hasMoreElements()) {
            Campbell_1997_AttenRelCoefficients coeff = (Campbell_1997_AttenRelCoefficients)this.coefficients.get(keys.nextElement());
            if (!(coeff.period >= 0.0)) continue;
            set.add(coeff.period);
        }
        periodConstraint.addDouble((Double)0.0);
        Iterator it = set.iterator();
        while (it.hasNext()) {
            periodConstraint.addDouble((Double)it.next());
        }
        this.saPeriodParam = new PeriodParam(periodConstraint);
        this.saDampingParam = new DampingParam();
        this.saParam = new SA_Param(this.saPeriodParam, this.saDampingParam);
        this.saParam.setNonEditable();
        this.pgaParam = new PGA_Param();
        this.pgaParam.setNonEditable();
        this.pgvParam = new PGV_Param();
        this.pgvParam.setNonEditable();
        this.saParam.addParameterChangeWarningListener(this.listener);
        this.pgaParam.addParameterChangeWarningListener(this.listener);
        this.pgvParam.addParameterChangeWarningListener(this.listener);
        this.supportedIMParams.clear();
        this.supportedIMParams.addParameter(this.saParam);
        this.supportedIMParams.addParameter(this.pgaParam);
        this.supportedIMParams.addParameter(this.pgvParam);
    }

    @Override
    protected void initOtherParams() {
        super.initOtherParams();
        this.componentParam = new ComponentParam(Component.AVE_HORZ, Component.AVE_HORZ, Component.VERT);
        StringConstraint stdDevTypeConstraint = new StringConstraint();
        stdDevTypeConstraint.addString("Total (Mag Dependent)");
        stdDevTypeConstraint.addString("Total (PGA Dependent)");
        stdDevTypeConstraint.addString("None (zero)");
        stdDevTypeConstraint.setNonEditable();
        this.stdDevTypeParam = new StdDevTypeParam(stdDevTypeConstraint, "Total (Mag Dependent)");
        this.otherParams.addParameter(this.componentParam);
        this.otherParams.addParameter(this.stdDevTypeParam);
    }

    protected void initCoefficients() {
        String S = "Campbell_1997_AttenRel: initCoefficients():";
        this.coefficients.clear();
        Campbell_1997_AttenRelCoefficients coeff0 = new Campbell_1997_AttenRelCoefficients("SA/" + Double.valueOf("0.05"), 0.05, 0.05, 0.0, 0.0, -0.0011, 5.5E-5, 0.2, 0.0, 0.0, -1.32, 0.0, 0.0, 0.0, 0.0);
        Campbell_1997_AttenRelCoefficients coeff1 = new Campbell_1997_AttenRelCoefficients("SA/" + Double.valueOf("0.075"), 0.075, 0.27, 0.0, 0.0, -0.0024, 9.5E-5, 0.22, 0.0, 0.0, -1.21, 0.0, 0.0, 0.0, 0.0);
        Campbell_1997_AttenRelCoefficients coeff2 = new Campbell_1997_AttenRelCoefficients("SA/" + Double.valueOf("0.1"), 0.1, 0.48, 0.0, 0.0, -0.0024, 7.0E-6, 0.14, 0.0, 0.0, -1.29, 0.0, 0.0, 0.0, 0.0);
        Campbell_1997_AttenRelCoefficients coeff3 = new Campbell_1997_AttenRelCoefficients("SA/" + Double.valueOf("0.15"), 0.15, 0.72, 0.0, 0.0, -0.001, -2.7E-4, -0.02, 0.0, 0.0, -1.57, 0.0, 0.0, 0.0, 0.0);
        Campbell_1997_AttenRelCoefficients coeff4 = new Campbell_1997_AttenRelCoefficients("SA/" + Double.valueOf("0.2"), 0.2, 0.79, 0.0, 0.0, 0.0011, -5.3E-4, -0.18, 0.0, 0.0, -1.73, 0.0, 0.0, 0.0, 0.0);
        Campbell_1997_AttenRelCoefficients coeff5 = new Campbell_1997_AttenRelCoefficients("SA/" + Double.valueOf("0.3"), 0.3, 0.77, 0.0, 0.0, 0.0035, -7.2E-4, -0.4, 0.0, 0.0, -1.98, 0.0, 0.0, 0.0, 0.0);
        Campbell_1997_AttenRelCoefficients coeff6 = new Campbell_1997_AttenRelCoefficients("SA/" + Double.valueOf("0.5"), 0.5, -0.28, 0.74, 0.66, 0.0068, -0.001, -0.42, 0.25, 0.62, -2.03, 0.46, -0.74, 0.0, 0.0);
        Campbell_1997_AttenRelCoefficients coeff7 = new Campbell_1997_AttenRelCoefficients("SA/" + Double.valueOf("0.75"), 0.75, -1.08, 1.23, 0.66, 0.0077, -0.001, -0.44, 0.37, 0.62, -1.79, 0.67, -1.23, 0.0, 0.0);
        Campbell_1997_AttenRelCoefficients coeff8 = new Campbell_1997_AttenRelCoefficients("SA/" + Double.valueOf("1.0"), 1.0, -1.79, 1.59, 0.66, 0.0085, -0.001, -0.38, 0.57, 0.62, -1.82, 1.13, -1.59, 0.18, -0.18);
        Campbell_1997_AttenRelCoefficients coeff9 = new Campbell_1997_AttenRelCoefficients("SA/" + Double.valueOf("1.5"), 1.5, -2.65, 1.98, 0.66, 0.0094, -0.001, -0.32, 0.72, 0.62, -1.81, 1.52, -1.98, 0.57, -0.49);
        Campbell_1997_AttenRelCoefficients coeff10 = new Campbell_1997_AttenRelCoefficients("SA/" + Double.valueOf("2.0"), 2.0, -3.28, 2.23, 0.66, 0.01, -0.001, -0.36, 0.83, 0.62, -1.65, 1.65, -2.23, 0.61, -0.63);
        Campbell_1997_AttenRelCoefficients coeff11 = new Campbell_1997_AttenRelCoefficients("SA/" + Double.valueOf("3.0"), 3.0, -4.07, 2.39, 0.66, 0.0108, -0.001, -0.22, 0.86, 0.62, -1.31, 1.28, -2.39, 1.07, -0.84);
        Campbell_1997_AttenRelCoefficients coeff12 = new Campbell_1997_AttenRelCoefficients("SA/" + Double.valueOf("4.0"), 4.0, -4.26, 2.03, 0.66, 0.0112, -0.001, -0.3, 1.05, 0.62, -1.35, 1.15, -2.03, 1.26, -1.17);
        this.coefficients.put(coeff0.getName(), coeff0);
        this.coefficients.put(coeff1.getName(), coeff1);
        this.coefficients.put(coeff2.getName(), coeff2);
        this.coefficients.put(coeff3.getName(), coeff3);
        this.coefficients.put(coeff4.getName(), coeff4);
        this.coefficients.put(coeff5.getName(), coeff5);
        this.coefficients.put(coeff6.getName(), coeff6);
        this.coefficients.put(coeff7.getName(), coeff7);
        this.coefficients.put(coeff8.getName(), coeff8);
        this.coefficients.put(coeff9.getName(), coeff9);
        this.coefficients.put(coeff10.getName(), coeff10);
        this.coefficients.put(coeff11.getName(), coeff11);
        this.coefficients.put(coeff12.getName(), coeff12);
    }

    @Override
    public URL getInfoURL() throws MalformedURLException {
        return new URL("http://www.opensha.org/glossary-attenuationRelation-CAMPBELL_1997");
    }

    class Campbell_1997_AttenRelCoefficients
    implements Named {
        protected static final String C = "Campbell_1997_AttenRelCoefficients";
        protected static final boolean D = true;
        private static final long serialVersionUID = 1234567890987654324L;
        protected String name;
        protected double period = -1.0;
        protected double c1_h;
        protected double c2_h;
        protected double c3_h;
        protected double c4_h;
        protected double c5_h;
        protected double c6;
        protected double c7;
        protected double c8;
        protected double c1_v;
        protected double c2_v;
        protected double c3_v;
        protected double c4_v;
        protected double c5_v;

        public Campbell_1997_AttenRelCoefficients(String name) {
            this.name = name;
        }

        public Campbell_1997_AttenRelCoefficients(String name, double period, double c1_h, double c2_h, double c3_h, double c4_h, double c5_h, double c6, double c7, double c8, double c1_v, double c2_v, double c3_v, double c4_v, double c5_v) {
            this.period = period;
            this.name = name;
            this.c1_h = c1_h;
            this.c2_h = c2_h;
            this.c3_h = c3_h;
            this.c4_h = c4_h;
            this.c5_h = c5_h;
            this.c6 = c6;
            this.c7 = c7;
            this.c8 = c8;
            this.c1_v = c1_v;
            this.c2_v = c2_v;
            this.c3_v = c3_v;
            this.c4_v = c4_v;
            this.c5_v = c5_v;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public String toString() {
            StringBuffer b = new StringBuffer();
            b.append(C);
            b.append("\n  Period = " + this.period);
            b.append("\n  c1_h = " + this.c1_h);
            b.append("\n  c2_h = " + this.c2_h);
            b.append("\n  c3_h = " + this.c3_h);
            b.append("\n  c4_h = " + this.c4_h);
            b.append("\n  c5_h = " + this.c5_h);
            b.append("\n  c6 = " + this.c6);
            b.append("\n  c7 = " + this.c7);
            b.append("\n  c8 = " + this.c8);
            b.append("\n  c1_v = " + this.c1_v);
            b.append("\n  c2_v = " + this.c2_v);
            b.append("\n  c3_v = " + this.c3_v);
            b.append("\n  c4_v = " + this.c4_v);
            b.append("\n  c5_v = " + this.c5_v);
            return b.toString();
        }
    }
}

