/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.imr.attenRelImpl.gui;

import com.google.common.collect.Lists;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.gui.DisclaimerDialog;
import org.opensha.commons.gui.HelpMenuBuilder;
import org.opensha.commons.gui.plot.AxisLimitsControlPanel;
import org.opensha.commons.gui.plot.GraphWidget;
import org.opensha.commons.gui.plot.GraphWindow;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotElement;
import org.opensha.commons.gui.plot.PlotSpec;
import org.opensha.commons.gui.plot.PlotSymbol;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.WarningParameter;
import org.opensha.commons.param.constraint.ParameterConstraint;
import org.opensha.commons.param.editor.impl.ParameterListEditor;
import org.opensha.commons.param.event.ParameterChangeFailEvent;
import org.opensha.commons.param.event.ParameterChangeFailListener;
import org.opensha.commons.param.event.ParameterChangeWarningEvent;
import org.opensha.commons.param.event.ParameterChangeWarningListener;
import org.opensha.commons.util.ApplicationVersion;
import org.opensha.commons.util.BrowserUtils;
import org.opensha.commons.util.FileUtils;
import org.opensha.sha.gcim.imr.attenRelImpl.ASI_WrapperAttenRel.BA_2008_ASI_AttenRel;
import org.opensha.sha.gcim.imr.attenRelImpl.BommerEtAl_2009_AttenRel;
import org.opensha.sha.gcim.imr.attenRelImpl.CB_2010_CAV_AttenRel;
import org.opensha.sha.gcim.imr.attenRelImpl.DSI_WrapperAttenRel.BA_2008_DSI_AttenRel;
import org.opensha.sha.gcim.imr.attenRelImpl.KS_2006_AttenRel;
import org.opensha.sha.gcim.imr.attenRelImpl.SI_WrapperAttenRel.BA_2008_SI_AttenRel;
import org.opensha.sha.gui.controls.CurveDisplayAppAPI;
import org.opensha.sha.gui.controls.XY_ValuesControlPanel;
import org.opensha.sha.gui.util.IconFetcher;
import org.opensha.sha.imr.attenRelImpl.AS_1997_AttenRel;
import org.opensha.sha.imr.attenRelImpl.AS_2008_AttenRel;
import org.opensha.sha.imr.attenRelImpl.Abrahamson_2000_AttenRel;
import org.opensha.sha.imr.attenRelImpl.AfshariStewart_2016_AttenRel;
import org.opensha.sha.imr.attenRelImpl.BA_2006_AttenRel;
import org.opensha.sha.imr.attenRelImpl.BA_2008_AttenRel;
import org.opensha.sha.imr.attenRelImpl.BC_2004_AttenRel;
import org.opensha.sha.imr.attenRelImpl.BJF_1997_AttenRel;
import org.opensha.sha.imr.attenRelImpl.BS_2003_AttenRel;
import org.opensha.sha.imr.attenRelImpl.CB_2003_AttenRel;
import org.opensha.sha.imr.attenRelImpl.CB_2006_AttenRel;
import org.opensha.sha.imr.attenRelImpl.CB_2008_AttenRel;
import org.opensha.sha.imr.attenRelImpl.CS_2005_AttenRel;
import org.opensha.sha.imr.attenRelImpl.CY_2006_AttenRel;
import org.opensha.sha.imr.attenRelImpl.CY_2008_AttenRel;
import org.opensha.sha.imr.attenRelImpl.Campbell_1997_AttenRel;
import org.opensha.sha.imr.attenRelImpl.Field_2000_AttenRel;
import org.opensha.sha.imr.attenRelImpl.GouletEtAl_2006_AttenRel;
import org.opensha.sha.imr.attenRelImpl.McVerryetal_2000_AttenRel;
import org.opensha.sha.imr.attenRelImpl.SA_InterpolatedWrapperAttenRel.InterpolatedBA_2008_AttenRel;
import org.opensha.sha.imr.attenRelImpl.SEA_1999_AttenRel;
import org.opensha.sha.imr.attenRelImpl.SadighEtAl_1997_AttenRel;
import org.opensha.sha.imr.attenRelImpl.ShakeMap_2003_AttenRel;
import org.opensha.sha.imr.attenRelImpl.gui.AttenuationRelationshipGuiBean;
import org.opensha.sha.imr.attenRelImpl.gui.AttenuationRelationshipGuiList;
import org.opensha.sha.imr.attenRelImpl.ngaw2.NGAW2_Wrappers;
import org.opensha.sha.imr.mod.impl.stewartSiteSpecific.StewartAfshariGoulet2017NonergodicGMPE;

public class AttenuationRelationshipApplet
extends JFrame
implements ParameterChangeFailListener,
ParameterChangeWarningListener,
ItemListener,
CurveDisplayAppAPI {
    public static final String APP_NAME = "Attenuation Relationship Application";
    public static final String APP_SHORT_NAME = "AttenuationRelationship";
    private static final String GUIDE_URL = "http://www.opensha.org/guide-AttenuationRelationship";
    private static ApplicationVersion version;
    protected static final String C = "AttenuationRelationshipApplet";
    protected static final boolean D = false;
    private static final String AXIS_RANGE_NOT_ALLOWED;
    protected GraphWidget graphWidget;
    private static final String FRAME_ICON_NAME = "openSHA_Aqua_sm.gif";
    protected static final String POWERED_BY_IMAGE = "logos/PoweredByOpenSHA_Agua.jpg";
    private static final String OPENSHA_WEBSITE = "http://www.OpenSHA.org";
    private JButton attenRelInfobutton = new JButton("  Get Info  ");
    AttenuationRelationshipGuiBean attenRel = null;
    protected AttenuationRelationshipGuiList attenRels = new AttenuationRelationshipGuiList();
    private ArrayList<PlotElement> functionList = new ArrayList();
    protected boolean inParameterChangeWarning = false;
    boolean isStandalone = false;
    Insets plotInsets = new Insets(4, 10, 4, 4);
    Insets defaultInsets = new Insets(4, 4, 4, 4);
    Insets emptyInsets = new Insets(0, 0, 0, 0);
    protected static final int W = 900;
    protected static final int H = 730;
    protected static final Font BUTTON_FONT;
    protected static final Font TITLE_FONT;
    protected static final int MIN_NUMBER_POINTS = 15;
    JMenuBar menuBar = new JMenuBar();
    JMenu helpMenu;
    JMenu fileMenu = new JMenu();
    JMenuItem fileExitMenu = new JMenuItem();
    JMenuItem fileSaveMenu = new JMenuItem();
    JMenuItem filePrintMenu = new JCheckBoxMenuItem();
    JToolBar jToolBar = new JToolBar();
    JButton closeButton = new JButton();
    ImageIcon closeFileImage = new ImageIcon(FileUtils.loadImage("icons/closeFile.png"));
    JButton printButton = new JButton();
    ImageIcon printFileImage = new ImageIcon(FileUtils.loadImage("icons/printFile.jpg"));
    JButton saveButton = new JButton();
    ImageIcon saveFileImage = new ImageIcon(FileUtils.loadImage("icons/saveFile.jpg"));
    private boolean drawCurvesUsingPlotPrefs;
    protected static ArrayList<String> attenRelClasses;
    protected static ArrayList<String> imNames;
    public String currentAttenuationRelationshipName = "";
    protected String legend = null;
    boolean newGraph = false;
    private static final String AUTO_SCALE = "Auto Scale";
    private static final String CUSTOM_SCALE = "Custom Scale";
    static final Dimension COMBO_DIM;
    static final Dimension BUTTON_DIM;
    static final String NO_PLOT_MSG = "No Plot Data Available";
    Color darkBlue = new Color(80, 80, 133);
    Color lightBlue = new Color(200, 200, 230);
    static final GridBagLayout GBL;
    Color background = Color.white;
    JPanel outerPanel = new JPanel();
    JPanel outerControlPanel = new JPanel();
    JPanel mainPanel = new JPanel();
    JPanel titlePanel = new JPanel();
    JPanel plotPanel = new JPanel();
    JPanel innerPlotPanel = new JPanel();
    JPanel controlPanel = new JPanel();
    JButton clearButton = new JButton();
    JButton addButton = new JButton();
    JPanel parametersPanel = new JPanel();
    JPanel buttonPanel = new JPanel();
    JPanel inputPanel = new JPanel();
    JPanel sheetPanel = new JPanel();
    JSplitPane parametersSplitPane = new JSplitPane();
    JSplitPane mainSplitPane = new JSplitPane();
    JSplitPane plotSplitPane = new JSplitPane();
    protected String lastXYAxisName = "";
    JComboBox attenRelComboBox = new JComboBox();
    JLabel attenRelLabel = new JLabel();
    protected JFrame frame;
    JCheckBox plotColorCheckBox = new JCheckBox();
    boolean isWhite = true;
    protected AxisLimitsControlPanel axisLimits;
    private double Y_MIN_VAL = 1.0E-8;
    protected JLabel imgLabel = new JLabel();
    protected Border border1;
    protected FlowLayout flowLayout1 = new FlowLayout();
    protected JButton xyDatasetButton = new JButton();
    protected XY_ValuesControlPanel xyNewDatasetControl;
    protected JButton peelOffButton = new JButton();

    public static ApplicationVersion getAppVersion() {
        if (version == null) {
            try {
                version = ApplicationVersion.loadBuildVersion();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return version;
    }

    public String getCurrentAttenuationRelationshipName() {
        return this.currentAttenuationRelationshipName;
    }

    public String getAppInfo() {
        return "Attenuation Relationship Plotter";
    }

    private File getFileFromUser() {
        JFileChooser fc = new JFileChooser();
        File[] roots = File.listRoots();
        String path = roots[0].getAbsolutePath();
        for (int i = 0; i < roots.length; ++i) {
            String path1 = roots[i].getAbsolutePath();
            if (!path1.startsWith("C:")) continue;
            path = path1;
        }
        fc.setCurrentDirectory(new File(path));
        fc.setSelectedFile(new File("data.txt"));
        int result = fc.showSaveDialog(this);
        if (result != 0) {
            return null;
        }
        return fc.getSelectedFile();
    }

    public void init() {
        this.initAttenuationRelationshipGui();
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initAttenuationRelationshipGui() {
        String S = "AttenuationRelationshipApplet: initAttenuationRelationshipGui(): ";
        if (imNames.size() < 1) {
            throw new RuntimeException(S + "No AttenuationRelationships specified, unable to continue");
        }
        boolean first = true;
        String firstImr = "";
        Iterator<String> it = imNames.iterator();
        while (it.hasNext()) {
            if (first) {
                first = false;
                String val = it.next().toString();
                this.attenRelComboBox.addItem(val);
                this.attenRelComboBox.setSelectedItem(val);
                firstImr = val;
                continue;
            }
            this.attenRelComboBox.addItem(it.next().toString());
        }
    }

    protected void jbInit() throws Exception {
        String S = "AttenuationRelationshipApplet: jbInit(): ";
        this.border1 = BorderFactory.createLineBorder(new Color(80, 80, 133), 2);
        this.setFont(new Font("Dialog", 0, 10));
        this.setSize(new Dimension(900, 690));
        this.getContentPane().setLayout(new BorderLayout());
        this.outerPanel.setLayout(GBL);
        this.mainPanel.setBorder(this.border1);
        this.mainPanel.setLayout(GBL);
        this.titlePanel.setMinimumSize(new Dimension(40, 40));
        this.titlePanel.setPreferredSize(new Dimension(40, 40));
        this.titlePanel.setLayout(GBL);
        this.graphWidget = new GraphWidget();
        this.plotPanel.setLayout(GBL);
        this.innerPlotPanel.setLayout(GBL);
        this.innerPlotPanel.setBorder(null);
        this.controlPanel.setLayout(GBL);
        this.controlPanel.setBorder(BorderFactory.createEtchedBorder(1));
        this.outerControlPanel.setLayout(GBL);
        this.attenRelInfobutton.setToolTipText("Gets the information for the selected AttenuationRelationship model");
        this.clearButton.setText("Clear Plot");
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AttenuationRelationshipApplet.this.clearButton_actionPerformed(e);
            }
        });
        this.addButton.setText("Add Curve");
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AttenuationRelationshipApplet.this.addButton_actionPerformed(e);
            }
        });
        this.buttonPanel.setLayout(this.flowLayout1);
        this.parametersSplitPane.setOrientation(0);
        this.parametersSplitPane.setBorder(null);
        this.parametersSplitPane.setDividerSize(5);
        this.mainSplitPane.setOrientation(1);
        this.mainSplitPane.setBorder(null);
        this.mainSplitPane.setDividerSize(2);
        this.plotSplitPane.setOrientation(0);
        this.plotSplitPane.setBorder(null);
        this.plotSplitPane.setDividerSize(2);
        this.plotSplitPane.setBottomComponent(this.buttonPanel);
        this.plotSplitPane.setTopComponent(this.mainPanel);
        this.plotSplitPane.setDividerLocation(500);
        this.attenRelLabel.setForeground(this.darkBlue);
        this.attenRelLabel.setFont(new Font("Dialog", 1, 13));
        this.attenRelLabel.setText("Choose Model:    ");
        this.attenRelComboBox.setFont(new Font("Dialog", 1, 16));
        this.attenRelComboBox.addItemListener(this);
        this.plotColorCheckBox.setText("Black Background");
        this.plotColorCheckBox.addItemListener(this);
        this.parametersPanel.setLayout(GBL);
        this.controlPanel.setLayout(GBL);
        this.sheetPanel.setLayout(GBL);
        this.inputPanel.setLayout(GBL);
        this.imgLabel.setText("");
        this.imgLabel.setIcon(new ImageIcon(FileUtils.loadImage(POWERED_BY_IMAGE)));
        this.xyDatasetButton.setText("Add Data Points");
        this.xyDatasetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AttenuationRelationshipApplet.this.xyDatasetButton_actionPerformed(e);
            }
        });
        this.peelOffButton.setText("Peel Off");
        this.peelOffButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AttenuationRelationshipApplet.this.peelOffButton_actionPerformed(e);
            }
        });
        this.getContentPane().add((Component)this.outerPanel, "Center");
        this.outerPanel.add((Component)this.plotSplitPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        this.titlePanel.add((Component)this.attenRelLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, this.emptyInsets, 0, 0));
        this.titlePanel.add((Component)this.attenRelComboBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, this.emptyInsets, 0, 0));
        this.titlePanel.add((Component)this.attenRelInfobutton, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 13, 0, this.emptyInsets, 4, 0));
        this.mainPanel.add((Component)this.mainSplitPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 4, 4, 4), 0, 0));
        this.controlPanel.add((Component)this.parametersPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, this.emptyInsets, 0, 0));
        this.outerControlPanel.add((Component)this.controlPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
        this.parametersPanel.add((Component)this.parametersSplitPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, this.emptyInsets, 0, 0));
        this.plotPanel.add((Component)this.titlePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(4, 4, 2, 4), 0, 0));
        this.plotPanel.add((Component)this.innerPlotPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, this.defaultInsets, 0, 0));
        this.attenRelInfobutton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AttenuationRelationshipApplet.this.attenRelInfobutton_actionPerformed(e);
            }
        });
        this.buttonPanel.add((Component)this.addButton, 0);
        this.buttonPanel.add((Component)this.clearButton, 1);
        this.buttonPanel.add((Component)this.peelOffButton, 2);
        this.buttonPanel.add((Component)this.xyDatasetButton, 3);
        this.buttonPanel.add((Component)this.plotColorCheckBox, 4);
        this.buttonPanel.add((Component)this.imgLabel, 5);
        this.parametersSplitPane.setBottomComponent(this.sheetPanel);
        this.parametersSplitPane.setTopComponent(this.inputPanel);
        this.parametersSplitPane.setDividerLocation(220);
        this.parametersSplitPane.setOneTouchExpandable(false);
        this.mainSplitPane.setBottomComponent(this.outerControlPanel);
        this.mainSplitPane.setTopComponent(this.plotPanel);
        this.mainSplitPane.setDividerLocation(630);
        this.setTitle(this.getAppInfo() + " (Version:" + String.valueOf(AttenuationRelationshipApplet.getAppVersion()) + ")");
        this.setSize(900, 730);
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((d.width - this.getSize().width) / 2, (d.height - this.getSize().height) / 2);
        this.fileMenu.setText("File");
        this.fileExitMenu.setText("Exit");
        this.fileSaveMenu.setText("Save");
        this.filePrintMenu.setText("Print");
        this.helpMenu = this.createHelpMenu();
        this.fileExitMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AttenuationRelationshipApplet.this.fileExitMenu_actionPerformed(e);
            }
        });
        this.fileSaveMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AttenuationRelationshipApplet.this.fileSaveMenu_actionPerformed(e);
            }
        });
        this.filePrintMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AttenuationRelationshipApplet.this.filePrintMenu_actionPerformed(e);
            }
        });
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AttenuationRelationshipApplet.this.closeButton_actionPerformed(actionEvent);
            }
        });
        this.printButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AttenuationRelationshipApplet.this.printButton_actionPerformed(actionEvent);
            }
        });
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AttenuationRelationshipApplet.this.saveButton_actionPerformed(actionEvent);
            }
        });
        this.menuBar.add((Component)this.fileMenu, 0);
        this.menuBar.add((Component)this.helpMenu, 1);
        this.fileMenu.add(this.fileSaveMenu);
        this.fileMenu.add(this.filePrintMenu);
        this.fileMenu.add(this.fileExitMenu);
        this.setJMenuBar(this.menuBar);
        this.closeButton.setIcon(this.closeFileImage);
        this.closeButton.setToolTipText("Exit Application");
        Dimension d1 = this.closeButton.getSize();
        this.jToolBar.add(this.closeButton);
        this.printButton.setIcon(this.printFileImage);
        this.printButton.setToolTipText("Print Graph");
        this.printButton.setSize(d1);
        this.jToolBar.add(this.printButton);
        this.saveButton.setIcon(this.saveFileImage);
        this.saveButton.setToolTipText("Save Graph as image");
        this.saveButton.setSize(d1);
        this.jToolBar.add(this.saveButton);
        this.jToolBar.setFloatable(false);
        this.getContentPane().add((Component)this.jToolBar, "North");
        this.setDefaultCloseOperation(3);
        this.updateChoosenAttenuationRelationship();
        this.createHelpMenu();
        this.enableMenuButtons();
        this.innerPlotPanel.removeAll();
        this.innerPlotPanel.add((Component)this.graphWidget, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.innerPlotPanel.validate();
        this.innerPlotPanel.repaint();
        this.setVisible(true);
    }

    private JMenu createHelpMenu() {
        HelpMenuBuilder builder = new HelpMenuBuilder(APP_NAME, APP_SHORT_NAME, AttenuationRelationshipApplet.getAppVersion(), this);
        builder.setGuideURL(GUIDE_URL);
        return builder.buildMenu();
    }

    private void fileExitMenu_actionPerformed(ActionEvent actionEvent) {
        this.close();
    }

    private void close() {
        int option = JOptionPane.showConfirmDialog(this, "Do you really want to exit the application?\nYou will loose all unsaved data.", "Exit App", 2);
        if (option == 0) {
            System.exit(0);
        }
    }

    private void fileSaveMenu_actionPerformed(ActionEvent actionEvent) {
        try {
            this.save();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Save File Error", 0);
            return;
        }
    }

    private void filePrintMenu_actionPerformed(ActionEvent actionEvent) {
        this.print();
    }

    public void save() throws IOException {
        this.graphWidget.save();
    }

    public void print() {
        this.graphWidget.print();
    }

    public void closeButton_actionPerformed(ActionEvent actionEvent) {
        this.close();
    }

    public void printButton_actionPerformed(ActionEvent actionEvent) {
        this.print();
    }

    public void saveButton_actionPerformed(ActionEvent actionEvent) {
        try {
            this.save();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Save File Error", 0);
            return;
        }
    }

    public static void main(String[] args) throws MalformedURLException, IOException {
        new DisclaimerDialog(APP_NAME, APP_SHORT_NAME, AttenuationRelationshipApplet.getAppVersion());
        AttenuationRelationshipApplet.launch();
    }

    public static AttenuationRelationshipApplet launch() {
        AttenuationRelationshipApplet applet = new AttenuationRelationshipApplet();
        applet.init();
        applet.setIconImages(IconFetcher.fetchIcons(APP_SHORT_NAME));
        applet.setVisible(true);
        return applet;
    }

    protected void updateChoosenAttenuationRelationship() {
        String S = "AttenuationRelationshipApplet: updateChoosenAttenuationRelationship(): ";
        String choice = this.attenRelComboBox.getSelectedItem().toString();
        if (choice.equals(this.currentAttenuationRelationshipName)) {
            return;
        }
        if (this.newGraph) {
            this.clearPlot(true);
        }
        int currentSelectedAttenRelIndex = imNames.indexOf(choice);
        try {
            this.attenRel = this.attenRels.setImr(currentSelectedAttenRelIndex, this);
        }
        catch (Exception e) {
            this.attenRelComboBox.setSelectedIndex(imNames.indexOf(this.currentAttenuationRelationshipName));
            throw new RuntimeException("Failed to load Attenuation Relationship: " + choice, e);
        }
        this.currentAttenuationRelationshipName = choice;
        this.sheetPanel.removeAll();
        this.sheetPanel.add((Component)this.attenRel.getIndependentsEditor(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, this.defaultInsets, 0, 0));
        this.inputPanel.removeAll();
        ParameterListEditor controlsEditor = this.attenRel.getControlsEditor();
        this.inputPanel.add((Component)controlsEditor, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, this.defaultInsets, 0, 0));
        this.validate();
        this.repaint();
    }

    private void enableMenuButtons() {
        boolean enableSavePrint = this.functionList != null && this.functionList.size() > 0;
        this.saveButton.setEnabled(enableSavePrint);
        this.fileSaveMenu.setEnabled(enableSavePrint);
        this.printButton.setEnabled(enableSavePrint);
        this.filePrintMenu.setEnabled(enableSavePrint);
    }

    private void addGraphPanel() {
        PlotSpec spec = this.graphWidget.getPlotSpec();
        spec.setPlotElems(this.functionList);
        this.graphWidget.drawGraph();
        if (this.isWhite) {
            this.graphWidget.getGraphPanel().setPlotBackgroundColor(Color.white);
        } else {
            this.graphWidget.getGraphPanel().setPlotBackgroundColor(Color.black);
        }
        this.enableMenuButtons();
    }

    public void plotGraphUsingPlotPreferences() {
        this.addGraphPanel();
    }

    private void clearButton() {
        this.clearPlot(true);
        this.attenRel.refreshParamEditor();
    }

    private void clearPlot(boolean clearFunctions) {
        int loc;
        int newLoc = loc = this.mainSplitPane.getDividerLocation();
        if (clearFunctions) {
            this.functionList.clear();
            this.graphWidget.getPlottingFeatures().clear();
        }
        this.graphWidget.removeChartAndMetadata();
        this.graphWidget.setAutoRange();
        this.mainSplitPane.setDividerLocation(newLoc);
        this.enableMenuButtons();
    }

    @Override
    public void parameterChangeFailed(ParameterChangeFailEvent e) {
        String S = "AttenuationRelationshipApplet : parameterChangeWarning(): ";
        if (this.inParameterChangeWarning) {
            return;
        }
        this.inParameterChangeWarning = true;
        StringBuffer b = new StringBuffer();
        Parameter param = (Parameter)e.getSource();
        ParameterConstraint constraint = param.getConstraint();
        String oldValueStr = e.getOldValue().toString();
        String badValueStr = e.getBadValue().toString();
        String name = param.getName();
        b.append("The value ");
        b.append(badValueStr);
        b.append(" is not permitted for '");
        b.append(name);
        b.append("'.\n");
        b.append("Resetting to ");
        b.append(oldValueStr);
        b.append(". The constraints are: \n");
        b.append(constraint.toString());
        JOptionPane.showMessageDialog(this, b.toString(), "Cannot Change Value", 1);
        this.inParameterChangeWarning = false;
    }

    @Override
    public void parameterChangeWarning(ParameterChangeWarningEvent e) {
        String S = "AttenuationRelationshipApplet : parameterChangeWarning(): ";
        if (this.inParameterChangeWarning) {
            return;
        }
        this.inParameterChangeWarning = true;
        StringBuffer b = new StringBuffer();
        WarningParameter param = e.getWarningParameter();
        try {
            Double min = (Double)param.getWarningMin();
            Double max = (Double)param.getWarningMax();
            String name = param.getName();
            b.append("You have exceeded the recommended range\n");
            b.append(name);
            b.append(": (");
            b.append(min.toString());
            b.append(" to ");
            b.append(max.toString());
            b.append(")\n");
            b.append("Click Yes to accept the new value: ");
            b.append(e.getNewValue().toString());
        }
        catch (Exception ee) {
            String name = param.getName();
            b.append("You have exceeded the recommended range for: \n");
            b.append(name + "\n");
            b.append("Click Yes to accept the new value: ");
            b.append(e.getNewValue().toString());
            b.append(name);
        }
        int result = 0;
        result = JOptionPane.showConfirmDialog(this, b.toString(), "Exceeded Recommended Values", 0, 3);
        switch (result) {
            case 0: {
                param.setValueIgnoreWarning(e.getNewValue());
                break;
            }
            case 1: {
                param.setValueIgnoreWarning(e.getOldValue());
                break;
            }
            default: {
                param.setValueIgnoreWarning(e.getOldValue());
            }
        }
        this.inParameterChangeWarning = false;
    }

    protected void addButton_actionPerformed(ActionEvent e) {
        String S = "AttenuationRelationshipApplet : addButton_actionPerformed";
        this.addButton();
    }

    private void addButton() {
        String yOld;
        String S = "AttenuationRelationshipApplet: addButton(): ";
        String XLabel = (String)this.attenRel.getControlsEditor().getParameterList().getParameter("X-Axis").getValue();
        String YLabel = (String)this.attenRel.getControlsEditor().getParameterList().getParameter("Y-Axis").getValue();
        if (XLabel.equals("Individual Value")) {
            this.functionList.clear();
            this.graphWidget.getPlottingFeatures().clear();
            this.clearButton.setEnabled(false);
            this.graphWidget.getButtonControlPanel().setEnabled(false);
            this.plotColorCheckBox.setEnabled(false);
            double yVal = this.attenRel.getChosenValue();
            Object info = "";
            info = "AttenuationRelationship Name: " + this.attenRel.getAttenRel().getName() + "\n\n";
            info = (String)info + "Intensity Measure Type: " + (String)this.attenRel.getSelectedIMParam().getValue() + "\n\n";
            info = (String)info + "Info: " + this.attenRel.getIndependentsEditor().getVisibleParametersCloned().toString() + "\n\n";
            info = (String)info + YLabel + " = " + yVal;
            this.graphWidget.removeChartAndMetadata();
            this.graphWidget.getGraphPanel().setMetadata((String)info);
            return;
        }
        this.clearButton.setEnabled(true);
        this.graphWidget.getButtonControlPanel().setEnabled(true);
        this.plotColorCheckBox.setEnabled(true);
        DiscretizedFunc function = null;
        try {
            function = this.attenRel.getChoosenFunction();
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, e.getMessage(), "Incorrect Parameter Input", 0);
            return;
        }
        String xOld = this.graphWidget.getXAxisLabel();
        if (xOld == null) {
            xOld = "";
        }
        String xUnitsOld = "";
        if (xOld.indexOf(40) != -1) {
            xUnitsOld = xOld.substring(xOld.indexOf(40) + 1, xOld.indexOf(41));
        }
        if ((yOld = this.graphWidget.getYAxisLabel()) == null) {
            yOld = "";
        }
        Object xNew = this.attenRel.getGraphXAxisLabel();
        String xUnitsNew = "";
        if (((String)xNew).indexOf(40) != -1) {
            xUnitsNew = ((String)xNew).substring(((String)xNew).indexOf(40) + 1, ((String)xNew).indexOf(41));
        }
        String yNew = this.attenRel.getGraphIMYAxisLabel();
        this.newGraph = false;
        if (xUnitsNew.equals(xUnitsOld) && !xUnitsNew.equals("") && !xUnitsOld.equals("")) {
            String tempX = ((String)xNew).substring(0, ((String)xNew).indexOf(40));
            if (xOld.indexOf(tempX) == -1) {
                xNew = xOld.substring(0, xOld.indexOf(40)) + " " + ((String)xNew).substring(0, ((String)xNew).indexOf(40)) + " (" + xUnitsNew + ")";
                this.graphWidget.setXAxisLabel((String)xNew);
            }
        } else {
            this.newGraph = !xUnitsNew.equals(xUnitsOld);
        }
        if (!yOld.equals(yNew)) {
            this.newGraph = true;
        }
        if (this.newGraph) {
            this.functionList.clear();
            this.graphWidget.getPlottingFeatures().clear();
            this.graphWidget.setXAxisLabel(this.attenRel.getGraphXAxisLabel());
            this.graphWidget.setYAxisLabel(this.attenRel.getGraphIMYAxisLabel());
        }
        this.newGraph = false;
        if (this.functionList.contains(function)) {
            if (!this.inParameterChangeWarning) {
                JOptionPane.showMessageDialog(null, "This graph already exists, will not add again.", "Cannot Add", 1);
            }
            return;
        }
        this.functionList.add(function);
        this.attenRel.refreshParamEditor();
        this.addGraphPanel();
    }

    @Override
    public void addCurve(ArbitrarilyDiscretizedFunc function) {
        if (!this.functionList.contains(function)) {
            this.functionList.add(function);
            List<PlotCurveCharacterstics> plotFeaturesList = this.graphWidget.getPlottingFeatures();
            plotFeaturesList.add(new PlotCurveCharacterstics(null, 1.0f, PlotSymbol.CROSS, 4.0f, Color.BLACK));
            this.addGraphPanel();
        } else {
            JOptionPane.showMessageDialog(null, "This graph already exists, will not add again.", "Cannot Add", 1);
        }
    }

    protected void clearButton_actionPerformed(ActionEvent e) {
        String S = "AttenuationRelationshipApplet : clearButtonFocusGained(): ";
        this.clearButton();
    }

    private void peelOffCurves() {
        this.graphWidget.getPlotSpec().setPlotElems(Lists.newArrayList(this.graphWidget.getPlotSpec().getPlotElems()));
        GraphWindow graphWindow = new GraphWindow(this.graphWidget);
        this.graphWidget = new GraphWidget();
        this.clearPlot(true);
        this.innerPlotPanel.removeAll();
        this.graphWidget.togglePlot();
        this.innerPlotPanel.add((Component)this.graphWidget, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.innerPlotPanel.validate();
        this.innerPlotPanel.repaint();
        graphWindow.setVisible(true);
    }

    public ArrayList getCurveFunctionList() {
        return this.functionList;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        String S = "AttenuationRelationshipApplet: itemStateChanged(): ";
        if (e.getSource().equals(this.attenRelComboBox)) {
            try {
                this.updateChoosenAttenuationRelationship();
            }
            catch (Exception e1) {
                e1.printStackTrace();
                JOptionPane.showMessageDialog(this, e1.getMessage());
            }
        } else if (e.getSource().equals(this.plotColorCheckBox)) {
            if (this.isWhite) {
                this.isWhite = false;
                this.graphWidget.getGraphPanel().setPlotBackgroundColor(Color.black);
            } else {
                this.isWhite = true;
                this.graphWidget.getGraphPanel().setPlotBackgroundColor(Color.white);
            }
        }
    }

    void xyDatasetButton_actionPerformed(ActionEvent e) {
        if (this.xyNewDatasetControl == null) {
            this.xyNewDatasetControl = new XY_ValuesControlPanel(this, this);
        }
        this.xyNewDatasetControl.showControlPanel();
    }

    void peelOffButton_actionPerformed(ActionEvent e) {
        this.peelOffCurves();
    }

    void attenRelInfobutton_actionPerformed(ActionEvent e) {
        try {
            URL url = this.attenRel.getInfoURL();
            if (url == null) {
                JOptionPane.showMessageDialog(this, "No information exists for the selected Attenuation Relationship");
                return;
            }
            BrowserUtils.launch(url);
        }
        catch (Exception e1) {
            JOptionPane.showMessageDialog(this, "No information exists for the selected Attenuation Relationship");
            return;
        }
    }

    @Override
    public String getSelectedIMT() {
        return this.attenRel.getSelectedIMParam().getName();
    }

    @Override
    public void setCurveXValues(ArbitrarilyDiscretizedFunc func) {
        throw new RuntimeException("Not applicable for application");
    }

    @Override
    public void setCurveXValues() {
        throw new RuntimeException("Not applicable for application");
    }

    static {
        AXIS_RANGE_NOT_ALLOWED = new String("First Choose Add Graph. Then choose Axis Scale option");
        BUTTON_FONT = new Font("Dialog", 1, 11);
        TITLE_FONT = new Font("Dialog", 1, 12);
        attenRelClasses = new ArrayList();
        imNames = new ArrayList();
        imNames.add("Abrahamson, Silva & Kamai (2014)");
        attenRelClasses.add(NGAW2_Wrappers.ASK_2014_Wrapper.class.getName());
        imNames.add("Boore, Stewart, Seyhan & Atkinson (2014)");
        attenRelClasses.add(NGAW2_Wrappers.BSSA_2014_Wrapper.class.getName());
        imNames.add("Campbell & Bozorgnia (2014)");
        attenRelClasses.add(NGAW2_Wrappers.CB_2014_Wrapper.class.getName());
        imNames.add("Chiou & Youngs (2014)");
        attenRelClasses.add(NGAW2_Wrappers.CY_2014_Wrapper.class.getName());
        imNames.add("Idriss (2014)");
        attenRelClasses.add(NGAW2_Wrappers.Idriss_2014_Wrapper.class.getName());
        imNames.add("Interpolated Boore & Atkinson (2008)");
        attenRelClasses.add(InterpolatedBA_2008_AttenRel.class.getName());
        imNames.add("Chiou & Youngs (2008)");
        attenRelClasses.add(CY_2008_AttenRel.class.getName());
        imNames.add("Abrahamson & Silva (2008)");
        attenRelClasses.add(AS_2008_AttenRel.class.getName());
        imNames.add("Campbell & Bozorgnia (2008)");
        attenRelClasses.add(CB_2008_AttenRel.class.getName());
        imNames.add("Boore & Atkinson (2008)");
        attenRelClasses.add(BA_2008_AttenRel.class.getName());
        imNames.add("Chiou & Youngs (2006)");
        attenRelClasses.add(CY_2006_AttenRel.class.getName());
        imNames.add("Campbell & Bozorgnia (2006)");
        attenRelClasses.add(CB_2006_AttenRel.class.getName());
        imNames.add("Boore & Atkinson (2006)");
        attenRelClasses.add(BA_2006_AttenRel.class.getName());
        imNames.add("Choi & Stewart (2005)");
        attenRelClasses.add(CS_2005_AttenRel.class.getName());
        imNames.add("Boore, Joyner & Fumal (1997)");
        attenRelClasses.add(BJF_1997_AttenRel.class.getName());
        imNames.add("Abrahamson & Silva (1997)");
        attenRelClasses.add(AS_1997_AttenRel.class.getName());
        imNames.add("Campbell (1997) w/ erratum (2000) changes");
        attenRelClasses.add(Campbell_1997_AttenRel.class.getName());
        imNames.add("Sadigh et al (1997)");
        attenRelClasses.add(SadighEtAl_1997_AttenRel.class.getName());
        imNames.add("Field (2000)");
        attenRelClasses.add(Field_2000_AttenRel.class.getName());
        imNames.add("Abrahamson (2000)");
        attenRelClasses.add(Abrahamson_2000_AttenRel.class.getName());
        imNames.add("Campbell and Bozorgnia (2003)");
        attenRelClasses.add(CB_2003_AttenRel.class.getName());
        imNames.add("Baturay and Stewart (2003)");
        attenRelClasses.add(BS_2003_AttenRel.class.getName());
        imNames.add("Bazzuro and Cornell (2004)");
        attenRelClasses.add(BC_2004_AttenRel.class.getName());
        imNames.add("Goulet Et. Al. (2006)");
        attenRelClasses.add(GouletEtAl_2006_AttenRel.class.getName());
        imNames.add("ShakeMap (2003)");
        attenRelClasses.add(ShakeMap_2003_AttenRel.class.getName());
        imNames.add("SEA (Spudich et al., 1999)");
        attenRelClasses.add(SEA_1999_AttenRel.class.getName());
        imNames.add("McVerry et al (2000)");
        attenRelClasses.add(McVerryetal_2000_AttenRel.class.getName());
        imNames.add("Bradley(2008)-SI-BooreAtkinson08");
        attenRelClasses.add(BA_2008_SI_AttenRel.class.getName());
        imNames.add("Bradley(2009)-ASI-BooreAtkinson08");
        attenRelClasses.add(BA_2008_ASI_AttenRel.class.getName());
        imNames.add("Bradley(2008)-DSI-BooreAtkinson08");
        attenRelClasses.add(BA_2008_DSI_AttenRel.class.getName());
        imNames.add("Campbell & Bozorgnia (2010)");
        attenRelClasses.add(CB_2010_CAV_AttenRel.class.getName());
        imNames.add("Kempton & Stewart (2006)");
        attenRelClasses.add(KS_2006_AttenRel.class.getName());
        imNames.add("Bommer et al. (2009)");
        attenRelClasses.add(BommerEtAl_2009_AttenRel.class.getName());
        imNames.add("Stewart, Afshari, Goulet (2017) Non-Ergodic Site Response GMPE");
        attenRelClasses.add(StewartAfshariGoulet2017NonergodicGMPE.class.getName());
        imNames.add("Afshari & Stewart (2016)");
        attenRelClasses.add(AfshariStewart_2016_AttenRel.class.getName());
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        COMBO_DIM = new Dimension(170, 30);
        BUTTON_DIM = new Dimension(80, 20);
        GBL = new GridBagLayout();
    }
}

