/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.imr.attenRelImpl.ngaw2;

import java.util.Collection;
import org.opensha.commons.geo.GeoTools;
import org.opensha.sha.imr.attenRelImpl.ngaw2.Coefficients;
import org.opensha.sha.imr.attenRelImpl.ngaw2.DefaultGroundMotion;
import org.opensha.sha.imr.attenRelImpl.ngaw2.FaultStyle;
import org.opensha.sha.imr.attenRelImpl.ngaw2.IMT;
import org.opensha.sha.imr.attenRelImpl.ngaw2.NGAW2_GMM;
import org.opensha.sha.imr.attenRelImpl.ngaw2.ScalarGroundMotion;
import org.opensha.sha.util.TectonicRegionType;

public class CY_2014
implements NGAW2_GMM {
    public static final String NAME = "Chiou & Youngs (2014)";
    public static final String SHORT_NAME = "CY2014";
    private static final double C2 = 1.06;
    private static final double C4 = -2.1;
    private static final double C4A = -0.5;
    private static final double dC4 = 1.6;
    private static final double CRB = 50.0;
    private static final double CRBsq = 2500.0;
    private static final double C11 = 0.0;
    private static final double PHI6 = 300.0;
    private static final double A = Math.pow(571.0, 4.0);
    private static final double B = Math.pow(1360.0, 4.0) + A;
    private final Coeffs coeffs;
    private IMT imt = null;
    private double Mw = Double.NaN;
    private double rJB = Double.NaN;
    private double rRup = Double.NaN;
    private double rX = Double.NaN;
    private double dip = Double.NaN;
    private double zTop = Double.NaN;
    private double vs30 = Double.NaN;
    private boolean vsInf = true;
    private double z1p0 = Double.NaN;
    private FaultStyle style = FaultStyle.UNKNOWN;

    public CY_2014() {
        this.coeffs = new Coeffs();
    }

    @Override
    public ScalarGroundMotion calc() {
        return this.calc(this.imt, this.Mw, this.rJB, this.rRup, this.rX, this.dip, this.zTop, this.vs30, this.vsInf, this.z1p0, this.style);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void set_IMT(IMT imt) {
        this.imt = imt;
    }

    @Override
    public void set_Mw(double Mw) {
        this.Mw = Mw;
    }

    @Override
    public void set_rJB(double rJB) {
        this.rJB = rJB;
    }

    @Override
    public void set_rRup(double rRup) {
        this.rRup = rRup;
    }

    @Override
    public void set_rX(double rX) {
        this.rX = rX;
    }

    @Override
    public void set_dip(double dip) {
        this.dip = dip;
    }

    @Override
    public void set_width(double width) {
    }

    @Override
    public void set_zTop(double zTop) {
        this.zTop = zTop;
    }

    @Override
    public void set_zHyp(double zHyp) {
    }

    @Override
    public void set_vs30(double vs30) {
        this.vs30 = vs30;
    }

    @Override
    public void set_vsInf(boolean vsInf) {
        this.vsInf = vsInf;
    }

    @Override
    public void set_z2p5(double z2p5) {
    }

    @Override
    public void set_z1p0(double z1p0) {
        this.z1p0 = z1p0;
    }

    @Override
    public void set_fault(FaultStyle style) {
        this.style = style;
    }

    @Override
    public TectonicRegionType get_TRT() {
        return TectonicRegionType.ACTIVE_SHALLOW;
    }

    @Override
    public Collection<IMT> getSupportedIMTs() {
        return this.coeffs.getSupportedIMTs();
    }

    public final ScalarGroundMotion calc(IMT imt, double Mw, double rJB, double rRup, double rX, double dip, double zTop, double vs30, boolean vsInferred, double z1p0, FaultStyle style) {
        this.coeffs.set(imt);
        double saRef = CY_2014.calcSAref(this.coeffs, Mw, rJB, rRup, rX, dip, zTop, style);
        double soilNonLin = CY_2014.calcSoilNonLin(this.coeffs, vs30);
        double mean = CY_2014.calcMean(this.coeffs, vs30, z1p0, soilNonLin, saRef);
        double NL0sq = CY_2014.calcNLOsq(this.coeffs, soilNonLin, saRef);
        double mTest = Math.min(Math.max(Mw, 5.0), 6.5) - 5.0;
        double tauSq = CY_2014.calcTauSq(this.coeffs, NL0sq, mTest);
        double phiSq = CY_2014.calcPhiSq(this.coeffs, this.vsInf, NL0sq, mTest);
        double stdDev = Math.sqrt(tauSq + phiSq);
        return new DefaultGroundMotion(mean, stdDev, Math.sqrt(phiSq), Math.sqrt(tauSq));
    }

    private static final double calcSAref(Coeffs c, double Mw, double rJB, double rRup, double rX, double dip, double zTop, FaultStyle style) {
        double r1 = c.c1 + 1.06 * (Mw - 6.0) + (1.06 - c.c3) / c.cn * Math.log(1.0 + Math.exp(c.cn * (c.cM - Mw)));
        double r2 = -2.1 * Math.log(rRup + c.c5 * Math.cosh(c.c6 * Math.max(Mw - c.cHM, 0.0)));
        double gamma = c.cgamma1 + c.cgamma2 / Math.cosh(Math.max(Mw - c.cgamma3, 0.0));
        double r3 = 1.6 * Math.log(Math.sqrt(rRup * rRup + 2500.0)) + rRup * gamma;
        double coshM = Math.cosh(2.0 * Math.max(Mw - 4.5, 0.0));
        double cosDelta = Math.cos(dip * GeoTools.TO_RAD);
        double deltaZtop = zTop - CY_2014.calcMwZtop(style, Mw);
        double r4 = (c.c7 + c.c7b / coshM) * deltaZtop + (0.0 + c.c11b / coshM) * cosDelta * cosDelta;
        r4 += style == FaultStyle.REVERSE ? c.c1a + c.c1c / coshM : (style == FaultStyle.NORMAL ? c.c1b + c.c1d / coshM : 0.0);
        double r5 = 0.0;
        if (rX >= 0.0) {
            r5 = c.c9 * Math.cos(dip * GeoTools.TO_RAD) * (c.c9a + (1.0 - c.c9a) * Math.tanh(rX / c.c9b)) * (1.0 - Math.sqrt(rJB * rJB + zTop * zTop) / (rRup + 1.0));
        }
        return Math.exp(r1 + r2 + r3 + r4 + r5);
    }

    private static final double calcSoilNonLin(Coeffs c, double vs30) {
        double exp1 = Math.exp(c.phi3 * (Math.min(vs30, 1130.0) - 360.0));
        double exp2 = Math.exp(c.phi3 * 770.0);
        return c.phi2 * (exp1 - exp2);
    }

    private static final double calcMean(Coeffs c, double vs30, double z1p0, double snl, double saRef) {
        double sl = c.phi1 * Math.min(Math.log(vs30 / 1130.0), 0.0);
        double dZ1 = CY_2014.calcDeltaZ1(z1p0, vs30);
        double rkdepth = c.phi5 * (1.0 - Math.exp(-dZ1 / 300.0));
        return Math.log(saRef) + sl + (snl *= Math.log((saRef + c.phi4) / c.phi4)) + rkdepth;
    }

    private static final double calcMwZtop(FaultStyle style, double Mw) {
        double mzTop = 0.0;
        mzTop = style == FaultStyle.REVERSE ? (Mw <= 5.849 ? 2.704 : Math.max(2.704 - 1.226 * (Mw - 5.849), 0.0)) : (Mw <= 4.97 ? 2.673 : Math.max(2.673 - 1.136 * (Mw - 4.97), 0.0));
        return mzTop * mzTop;
    }

    private static final double calcDeltaZ1(double z1p0, double vs30) {
        if (Double.isNaN(z1p0)) {
            return 0.0;
        }
        return 1000.0 * (z1p0 - CY_2014.calcZ1ref(vs30));
    }

    public static final double calcZ1ref(double vs30) {
        double vsPow4 = vs30 * vs30 * vs30 * vs30;
        return Math.exp(-1.7875 * Math.log((vsPow4 + A) / B)) / 1000.0;
    }

    private static double calcNLOsq(Coeffs c, double snl, double saRef) {
        double NL0 = snl * saRef / (saRef + c.phi4);
        double NL0sq = (1.0 + NL0) * (1.0 + NL0);
        return NL0sq;
    }

    private static double calcTauSq(Coeffs c, double NL0sq, double mTest) {
        double tau = c.tau1 + (c.tau2 - c.tau1) / 1.5 * mTest;
        double tauSq = tau * tau * NL0sq;
        return tauSq;
    }

    private static double calcPhiSq(Coeffs c, boolean vsInf, double NL0sq, double mTest) {
        double sigmaNL0 = c.sigma1 + (c.sigma2 - c.sigma1) / 1.5 * mTest;
        double vsTerm = vsInf ? c.sigma3 : 0.7;
        double phiSq = (sigmaNL0 *= Math.sqrt(vsTerm + NL0sq)) * sigmaNL0;
        return phiSq;
    }

    public static void main(String[] args) {
        CY_2014 cy = new CY_2014();
        System.out.println("PGA");
        ScalarGroundMotion sgm = cy.calc(IMT.PGA, 6.8, 0.0, 4.629, 5.963, 27.0, 2.1, 760.0, true, Double.NaN, FaultStyle.REVERSE);
        System.out.println(sgm.mean());
        System.out.println(sgm.stdDev());
        System.out.println("5Hz");
        sgm = cy.calc(IMT.SA0P2, 6.8, 0.0, 4.629, 5.963, 27.0, 2.1, 760.0, true, Double.NaN, FaultStyle.REVERSE);
        System.out.println(sgm.mean());
        System.out.println(sgm.stdDev());
        System.out.println("1Hz");
        sgm = cy.calc(IMT.SA1P0, 6.8, 0.0, 4.629, 5.963, 27.0, 2.1, 760.0, true, Double.NaN, FaultStyle.REVERSE);
        System.out.println(sgm.mean());
        System.out.println(sgm.stdDev());
    }

    private class Coeffs
    extends Coefficients {
        double c1;
        double c1a;
        double c1b;
        double c1c;
        double c1d;
        double c3;
        double c5;
        double c6;
        double c7;
        double c7b;
        double c8b;
        double c9;
        double c9a;
        double c9b;
        double c11b;
        double cn;
        double cM;
        double cHM;
        double cgamma1;
        double cgamma2;
        double cgamma3;
        double phi1;
        double phi2;
        double phi3;
        double phi4;
        double phi5;
        double tau1;
        double tau2;
        double sigma1;
        double sigma2;
        double sigma3;
        double c2;
        double c4;
        double c4a;
        double c11;
        double cRB;
        double phi6;
        double c8;
        double c8a;
        double sigma2_JP;
        double gamma_JP_IT;
        double gamma_WN;
        double phi1_JP;
        double phi5_JP;
        double phi6_JP;

        Coeffs() {
            super("CY14.csv");
            this.set(IMT.PGA);
        }
    }
}

