/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.imr.attenRelImpl.ngaw2;

import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import org.opensha.sha.imr.attenRelImpl.ngaw2.DefaultGroundMotion;
import org.opensha.sha.imr.attenRelImpl.ngaw2.FaultStyle;
import org.opensha.sha.imr.attenRelImpl.ngaw2.IMT;
import org.opensha.sha.imr.attenRelImpl.ngaw2.NGAW2_GMM;
import org.opensha.sha.imr.attenRelImpl.ngaw2.ScalarGroundMotion;
import org.opensha.sha.util.TectonicRegionType;

@Deprecated
public class GK_2014
implements NGAW2_GMM {
    public static final String NAME = "Graizer & Kalkan (2013)";
    public static final String SHORT_NAME = "GK2013";
    static final Set<IMT> IMTS = EnumSet.complementOf(EnumSet.of(IMT.PGV, IMT.PGD));
    private IMT imt = null;
    private double Mw = Double.NaN;
    private double rRup = Double.NaN;
    private double vs30 = Double.NaN;
    private FaultStyle style = FaultStyle.UNKNOWN;
    private static final double m1 = -0.0012;
    private static final double m2 = -0.38;
    private static final double m3 = 6.0E-4;
    private static final double m4 = 3.9;
    private static final double a1 = 0.01686;
    private static final double a2 = 1.2695;
    private static final double a3 = 1.0E-4;
    private static final double s1 = 0.0;
    private static final double s2 = 0.077;
    private static final double s3 = 0.3251;
    private static final double t1 = 0.001;
    private static final double t2 = 0.59;
    private static final double t3 = -5.0E-4;
    private static final double t4 = -2.3;
    private static final double c1 = 0.14;
    private static final double c2 = -6.25;
    private static final double c3 = 0.37;
    private static final double c4 = 2.237;
    private static final double c5 = -7.542;
    private static final double c6 = -0.125;
    private static final double c7 = 1.19;
    private static final double c8 = -6.15;
    private static final double c9 = 0.6;
    private static final double bv = -0.24;
    private static final double VA = 484.5;
    private static final double c11 = 0.345;
    private static final double Q = 150.0;

    @Override
    public ScalarGroundMotion calc() {
        return this.calc(this.imt, this.Mw, this.rRup, this.vs30, this.style);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void set_IMT(IMT imt) {
        this.imt = imt;
    }

    @Override
    public void set_Mw(double Mw) {
        this.Mw = Mw;
    }

    @Override
    public void set_rJB(double rJB) {
    }

    @Override
    public void set_rRup(double rRup) {
        this.rRup = rRup;
    }

    @Override
    public void set_rX(double rX) {
    }

    @Override
    public void set_dip(double dip) {
    }

    @Override
    public void set_width(double width) {
    }

    @Override
    public void set_zTop(double zTop) {
    }

    @Override
    public void set_zHyp(double zHyp) {
    }

    @Override
    public void set_vs30(double vs30) {
        this.vs30 = vs30;
    }

    @Override
    public void set_vsInf(boolean vsInf) {
    }

    @Override
    public void set_z2p5(double z2p5) {
    }

    @Override
    public void set_z1p0(double z1p0) {
    }

    @Override
    public void set_fault(FaultStyle style) {
        this.style = style;
    }

    @Override
    public TectonicRegionType get_TRT() {
        return TectonicRegionType.ACTIVE_SHALLOW;
    }

    @Override
    public Collection<IMT> getSupportedIMTs() {
        return IMTS;
    }

    public final ScalarGroundMotion calc(IMT imt, double Mw, double rRup, double vs30, FaultStyle style) {
        double per = imt.equals((Object)IMT.PGA) ? 0.01 : imt.getPeriod();
        double F = style == FaultStyle.REVERSE ? 1.28 : 1.0;
        double dBasin = 0.15;
        double pgaRef = GK_2014.calcLnPGA(Mw, rRup, vs30, dBasin, F);
        double sa = GK_2014.calcSpectralShape(per, Mw, rRup, vs30, dBasin);
        double mean = Math.log(sa) + pgaRef;
        double std = GK_2014.calcStdDev(per);
        return new DefaultGroundMotion(mean, std);
    }

    private static final double calcSpectralShape(double per, double Mw, double rRup, double vs30, double dBasin) {
        double mu = -0.0012 * rRup + -0.38 * Mw + 6.0E-4 * vs30 + 3.9;
        double A = (0.01686 * Mw + 1.2695) * Math.exp(1.0E-4 * rRup);
        double si = 0.0 * rRup - (0.077 * Mw + 0.3251);
        double T1 = Math.abs(0.001 * rRup + 0.59 * Mw + -5.0E-4 * vs30 + -2.3);
        double To = Math.max(0.3, T1);
        double slope = 1.763 - 0.25 * Math.atan(1.4 * (dBasin - 1.0));
        double F1A = (Math.log(per) + mu) / si;
        double F1 = A * Math.exp(-0.5 * F1A * F1A);
        double F2A = Math.pow(per / To, slope);
        double F2 = 1.0 / Math.sqrt((1.0 - F2A) * (1.0 - F2A) + 2.25 * F2A);
        return F1 + F2;
    }

    private static final double calcStdDev(double per) {
        double Sigma1 = 0.5522 + 0.0047 * Math.log(per);
        double Sigma2 = 0.646 + 0.0497 * Math.log(per);
        return Math.max(Sigma1, Sigma2);
    }

    private static final double calcLnPGA(double Mw, double rRup, double vs30, double dBasin, double F) {
        double F1 = Math.log((0.14 * Math.atan(Mw + -6.25) + 0.37) * F / 1.12);
        double Ro = 2.237 * Mw + -7.542;
        double Do = -0.125 * Math.cos(1.19 * (Mw + -6.15)) + 0.6;
        double rRo1 = rRup / Ro;
        double rRo2 = 1.0 - rRo1;
        double F2 = -0.5 * Math.log(rRo2 * rRo2 + 4.0 * (Do * Do) * rRo1);
        double F3 = -0.345 * rRup / 150.0;
        double F4 = -0.24 * Math.log(vs30 / 484.5);
        double bd1 = 1.5 / (dBasin + 0.1) * (1.5 / (dBasin + 0.1));
        double Bas_Depth = 1.4 / Math.sqrt((1.0 - bd1) * (1.0 - bd1) + 1.96 * bd1);
        double bd2 = 40.0 / (rRup + 0.1) * (40.0 / (rRup + 0.1));
        double Bas_Dist = 1.0 / Math.sqrt((1.0 - bd2) * (1.0 - bd2) + 1.96 * bd2);
        double Bas_Cor = Bas_Depth * Bas_Dist;
        double F5 = Math.log(1.0 + Bas_Cor / 1.3);
        return F1 + F2 + F3 + F4 + F5;
    }
}

