/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.imr.attenRelImpl.ngaw2;

import java.util.HashSet;
import org.opensha.commons.data.Site;
import org.opensha.commons.exceptions.ConstraintException;
import org.opensha.commons.exceptions.IMRException;
import org.opensha.commons.exceptions.ParameterException;
import org.opensha.commons.geo.GeoTools;
import org.opensha.commons.geo.Location;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.constraint.impl.DoubleDiscreteConstraint;
import org.opensha.commons.param.constraint.impl.StringConstraint;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.util.FaultUtils;
import org.opensha.sha.earthquake.EqkRupture;
import org.opensha.sha.faultSurface.RuptureSurface;
import org.opensha.sha.imr.AttenuationRelationship;
import org.opensha.sha.imr.attenRelImpl.ngaw2.FaultStyle;
import org.opensha.sha.imr.attenRelImpl.ngaw2.IMT;
import org.opensha.sha.imr.attenRelImpl.ngaw2.NGAW2_GMM;
import org.opensha.sha.imr.attenRelImpl.ngaw2.ScalarGroundMotion;
import org.opensha.sha.imr.param.IntensityMeasureParams.DampingParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.PGA_Param;
import org.opensha.sha.imr.param.IntensityMeasureParams.PGD_Param;
import org.opensha.sha.imr.param.IntensityMeasureParams.PGV_Param;
import org.opensha.sha.imr.param.IntensityMeasureParams.PeriodParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.SA_Param;
import org.opensha.sha.imr.param.OtherParams.Component;
import org.opensha.sha.imr.param.OtherParams.ComponentParam;
import org.opensha.sha.imr.param.SiteParams.DepthTo1pt0kmPerSecParam;
import org.opensha.sha.imr.param.SiteParams.DepthTo2pt5kmPerSecParam;
import org.opensha.sha.imr.param.SiteParams.Vs30_Param;
import org.opensha.sha.imr.param.SiteParams.Vs30_TypeParam;

public class NGAW2_Wrapper
extends AttenuationRelationship
implements ParameterChangeListener {
    private String shortName;
    private NGAW2_GMM gmpe;
    private ScalarGroundMotion gm;

    public NGAW2_Wrapper(String shortName, NGAW2_GMM gmpe) {
        this.shortName = shortName;
        this.gmpe = gmpe;
        this.initSupportedIntensityMeasureParams();
        this.initSiteParams();
        this.initOtherParams();
    }

    NGAW2_GMM getGMPE() {
        return this.gmpe;
    }

    @Override
    public double getMean() {
        if (this.gm == null) {
            this.gm = this.gmpe.calc();
        }
        return this.gm.mean();
    }

    @Override
    public double getStdDev() {
        if (this.gm == null) {
            this.gm = this.gmpe.calc();
        }
        return this.gm.stdDev();
    }

    @Override
    public void setParamDefaults() {
        for (Parameter<?> param : this.siteParams) {
            param.setValueAsDefault();
        }
    }

    @Override
    public String getName() {
        return this.gmpe.getName();
    }

    @Override
    public String getShortName() {
        return this.shortName;
    }

    @Override
    public void setSite(Site site) {
        super.setSite(site);
        this.update();
    }

    @Override
    public void setEqkRupture(EqkRupture eqkRupture) {
        super.setEqkRupture(eqkRupture);
        this.update();
    }

    @Override
    public void setIntensityMeasure(Parameter intensityMeasure) throws ParameterException, ConstraintException {
        super.setIntensityMeasure(intensityMeasure);
        this.update();
    }

    @Override
    public void setIntensityMeasure(String intensityMeasureName) throws ParameterException {
        super.setIntensityMeasure(intensityMeasureName);
        this.update();
    }

    @Override
    public void setAll(EqkRupture eqkRupture, Site site, Parameter intensityMeasure) throws ParameterException, IMRException, ConstraintException {
        super.setSite(site);
        super.setEqkRupture(eqkRupture);
        super.setIntensityMeasure(intensityMeasure);
        this.update();
    }

    @Override
    protected void setPropagationEffectParams() {
        this.update();
    }

    private void update() {
        this.gm = null;
        if (this.site != null && this.eqkRupture != null) {
            IMT imt = this.im.getName().equals("SA") ? IMT.getSA(SA_Param.getPeriodInSA_Param(this.im)) : IMT.parseIMT(this.im.getName());
            RuptureSurface surf = this.eqkRupture.getRuptureSurface();
            Location siteLoc = this.site.getLocation();
            this.vs30Param.setValue(this.site.getParameter(Double.class, "Vs30").getValue());
            this.vs30_TypeParam.setValue(this.site.getParameter(String.class, "Vs30 Type").getValue());
            this.depthTo1pt0kmPerSecParam.setValue(this.site.getParameter(Double.class, "Depth 1.0 km/sec").getValue());
            this.depthTo2pt5kmPerSecParam.setValue(this.site.getParameter(Double.class, "Depth 2.5 km/sec").getValue());
            double rake = this.eqkRupture.getAveRake();
            FaultUtils.assertValidRake(rake);
            FaultStyle style = NGAW2_Wrapper.getFaultStyle(rake);
            this.gmpe.set_IMT(imt);
            this.gmpe.set_Mw(this.eqkRupture.getMag());
            this.gmpe.set_rJB(surf.getDistanceJB(siteLoc));
            this.gmpe.set_rRup(surf.getDistanceRup(siteLoc));
            this.gmpe.set_rX(surf.getDistanceX(siteLoc));
            this.gmpe.set_dip(surf.getAveDip());
            this.gmpe.set_width(surf.getAveWidth());
            this.gmpe.set_zTop(surf.getAveRupTopDepth());
            if (this.eqkRupture.getHypocenterLocation() != null) {
                this.gmpe.set_zHyp(this.eqkRupture.getHypocenterLocation().getDepth());
            } else {
                double zHyp = surf.getAveRupTopDepth() + Math.sin(surf.getAveDip() * GeoTools.TO_RAD) * surf.getAveWidth() / 2.0;
                this.gmpe.set_zHyp(zHyp);
            }
            this.gmpe.set_vs30((Double)this.vs30Param.getValue());
            this.gmpe.set_vsInf(((String)this.vs30_TypeParam.getValue()).equals("Inferred"));
            if (this.depthTo2pt5kmPerSecParam.getValue() == null) {
                this.gmpe.set_z2p5(Double.NaN);
            } else {
                this.gmpe.set_z2p5((Double)this.depthTo2pt5kmPerSecParam.getValue());
            }
            if (this.depthTo1pt0kmPerSecParam.getValue() == null) {
                this.gmpe.set_z1p0(Double.NaN);
            } else {
                this.gmpe.set_z1p0((Double)this.depthTo1pt0kmPerSecParam.getValue() / 1000.0);
            }
            this.gmpe.set_fault(style);
        } else {
            this.gmpe.set_IMT(null);
            this.gmpe.set_Mw(Double.NaN);
            this.gmpe.set_rJB(Double.NaN);
            this.gmpe.set_rRup(Double.NaN);
            this.gmpe.set_rX(Double.NaN);
            this.gmpe.set_dip(Double.NaN);
            this.gmpe.set_width(Double.NaN);
            this.gmpe.set_zTop(Double.NaN);
            this.gmpe.set_zHyp(Double.NaN);
            this.gmpe.set_vs30(Double.NaN);
            this.gmpe.set_vsInf(true);
            this.gmpe.set_z2p5(Double.NaN);
            this.gmpe.set_z1p0(Double.NaN);
            this.gmpe.set_fault(null);
        }
    }

    static FaultStyle getFaultStyle(double rake) {
        if (rake >= 135.0 || rake <= -135.0) {
            return FaultStyle.STRIKE_SLIP;
        }
        if (rake >= -45.0 && rake <= 45.0) {
            return FaultStyle.STRIKE_SLIP;
        }
        if (rake >= 45.0 && rake <= 135.0) {
            return FaultStyle.REVERSE;
        }
        return FaultStyle.NORMAL;
    }

    @Override
    protected void initSupportedIntensityMeasureParams() {
        this.supportedIMParams.clear();
        DoubleDiscreteConstraint periodConstraint = new DoubleDiscreteConstraint();
        HashSet<IMT> imtsSet = new HashSet<IMT>(this.gmpe.getSupportedIMTs());
        for (IMT imt : imtsSet) {
            Double p = imt.getPeriod();
            if (p == null) continue;
            periodConstraint.addDouble(p);
        }
        periodConstraint.setNonEditable();
        this.saPeriodParam = new PeriodParam(periodConstraint);
        this.saPeriodParam.setValueAsDefault();
        this.saPeriodParam.addParameterChangeListener(this);
        this.saDampingParam = new DampingParam();
        this.saDampingParam.setValueAsDefault();
        this.saDampingParam.addParameterChangeListener(this);
        this.saParam = new SA_Param(this.saPeriodParam, this.saDampingParam);
        this.saParam.setNonEditable();
        this.saParam.addParameterChangeWarningListener(this.listener);
        this.supportedIMParams.addParameter(this.saParam);
        if (imtsSet.contains((Object)IMT.PGA)) {
            this.pgaParam = new PGA_Param();
            this.pgaParam.setNonEditable();
            this.pgaParam.addParameterChangeWarningListener(this.listener);
            this.supportedIMParams.addParameter(this.pgaParam);
        }
        if (imtsSet.contains((Object)IMT.PGV)) {
            this.pgvParam = new PGV_Param();
            this.pgvParam.setNonEditable();
            this.pgvParam.addParameterChangeWarningListener(this.listener);
            this.supportedIMParams.addParameter(this.pgvParam);
        }
        if (imtsSet.contains((Object)IMT.PGD)) {
            this.pgdParam = new PGD_Param();
            this.pgdParam.setNonEditable();
            this.pgdParam.addParameterChangeWarningListener(this.listener);
            this.supportedIMParams.addParameter(this.pgdParam);
        }
    }

    @Override
    protected void initSiteParams() {
        this.vs30Param = new Vs30_Param();
        this.vs30_TypeParam = new Vs30_TypeParam();
        this.depthTo1pt0kmPerSecParam = new DepthTo1pt0kmPerSecParam(null, (double)DepthTo1pt0kmPerSecParam.MIN, (double)DepthTo1pt0kmPerSecParam.MAX, true);
        this.depthTo2pt5kmPerSecParam = new DepthTo2pt5kmPerSecParam(null, (double)DepthTo2pt5kmPerSecParam.MIN, (double)DepthTo2pt5kmPerSecParam.MAX, true);
        this.siteParams.clear();
        this.siteParams.addParameter(this.vs30Param);
        this.siteParams.addParameter(this.vs30_TypeParam);
        this.siteParams.addParameter(this.depthTo1pt0kmPerSecParam);
        this.siteParams.addParameter(this.depthTo2pt5kmPerSecParam);
    }

    @Override
    protected void initEqkRuptureParams() {
    }

    @Override
    protected void initPropagationEffectParams() {
    }

    @Override
    protected void initOtherParams() {
        super.initOtherParams();
        this.componentParam = new ComponentParam(Component.RotD50, Component.RotD50);
        this.componentParam.setValueAsDefault();
        this.otherParams.addParameter(this.componentParam);
        StringConstraint options = new StringConstraint();
        options.addString(this.gmpe.get_TRT().toString());
        this.tectonicRegionTypeParam.setConstraint(options);
        this.tectonicRegionTypeParam.setDefaultValue(this.gmpe.get_TRT().toString());
        this.tectonicRegionTypeParam.setValueAsDefault();
    }

    @Override
    public void parameterChange(ParameterChangeEvent event) {
        this.update();
    }

    protected void initIndependentParamLists() {
        this.meanIndependentParams.clear();
        this.meanIndependentParams.addParameter(this.distanceRupParam);
        this.meanIndependentParams.addParameter(this.distRupMinusJB_OverRupParam);
        this.meanIndependentParams.addParameter(this.vs30Param);
        this.meanIndependentParams.addParameter(this.depthTo2pt5kmPerSecParam);
        this.meanIndependentParams.addParameter(this.magParam);
        this.meanIndependentParams.addParameter(this.fltTypeParam);
        this.meanIndependentParams.addParameter(this.rupTopDepthParam);
        this.meanIndependentParams.addParameter(this.dipParam);
        this.meanIndependentParams.addParameter(this.componentParam);
        this.stdDevIndependentParams.clear();
        this.stdDevIndependentParams.addParameterList(this.meanIndependentParams);
        this.stdDevIndependentParams.addParameter(this.stdDevTypeParam);
        this.exceedProbIndependentParams.clear();
        this.exceedProbIndependentParams.addParameterList(this.stdDevIndependentParams);
        this.exceedProbIndependentParams.addParameter(this.sigmaTruncTypeParam);
        this.exceedProbIndependentParams.addParameter(this.sigmaTruncLevelParam);
        this.imlAtExceedProbIndependentParams.addParameterList(this.exceedProbIndependentParams);
        this.imlAtExceedProbIndependentParams.addParameter(this.exceedProbParam);
    }
}

