/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.imr.attenRelImpl.ngaw2;

import java.util.EnumSet;
import java.util.HashSet;
import org.opensha.commons.data.Site;
import org.opensha.commons.exceptions.ParameterException;
import org.opensha.commons.geo.GeoTools;
import org.opensha.commons.geo.Location;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.constraint.impl.DoubleConstraint;
import org.opensha.commons.param.constraint.impl.DoubleDiscreteConstraint;
import org.opensha.commons.param.constraint.impl.StringConstraint;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.impl.EnumParameter;
import org.opensha.commons.util.FaultUtils;
import org.opensha.sha.earthquake.EqkRupture;
import org.opensha.sha.faultSurface.RuptureSurface;
import org.opensha.sha.gcim.imr.param.EqkRuptureParams.FocalDepthParam;
import org.opensha.sha.imr.AttenuationRelationship;
import org.opensha.sha.imr.attenRelImpl.ngaw2.DefaultGroundMotion;
import org.opensha.sha.imr.attenRelImpl.ngaw2.FaultStyle;
import org.opensha.sha.imr.attenRelImpl.ngaw2.IMT;
import org.opensha.sha.imr.attenRelImpl.ngaw2.NGAW2_GMM;
import org.opensha.sha.imr.attenRelImpl.ngaw2.ScalarGroundMotion;
import org.opensha.sha.imr.param.EqkRuptureParams.DipParam;
import org.opensha.sha.imr.param.EqkRuptureParams.MagParam;
import org.opensha.sha.imr.param.EqkRuptureParams.RakeParam;
import org.opensha.sha.imr.param.EqkRuptureParams.RupTopDepthParam;
import org.opensha.sha.imr.param.EqkRuptureParams.RupWidthParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.DampingParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.PGA_Param;
import org.opensha.sha.imr.param.IntensityMeasureParams.PGD_Param;
import org.opensha.sha.imr.param.IntensityMeasureParams.PGV_Param;
import org.opensha.sha.imr.param.IntensityMeasureParams.PeriodParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.SA_Param;
import org.opensha.sha.imr.param.OtherParams.Component;
import org.opensha.sha.imr.param.OtherParams.ComponentParam;
import org.opensha.sha.imr.param.OtherParams.StdDevTypeParam;
import org.opensha.sha.imr.param.PropagationEffectParams.DistanceJBParameter;
import org.opensha.sha.imr.param.PropagationEffectParams.DistanceRupParameter;
import org.opensha.sha.imr.param.PropagationEffectParams.DistanceX_Parameter;
import org.opensha.sha.imr.param.SiteParams.DepthTo1pt0kmPerSecParam;
import org.opensha.sha.imr.param.SiteParams.DepthTo2pt5kmPerSecParam;
import org.opensha.sha.imr.param.SiteParams.Vs30_Param;
import org.opensha.sha.imr.param.SiteParams.Vs30_TypeParam;

public class NGAW2_WrapperFullParam
extends AttenuationRelationship
implements ParameterChangeListener {
    private String shortName;
    private NGAW2_GMM gmpe;
    private ScalarGroundMotion gm;
    private boolean supportsPhiTau;
    private DistanceX_Parameter distanceXParam;
    public static final String EPISTEMIC_PARAM_NAME = "Additional Epistemic Uncertainty";
    private EnumParameter<EpistemicOption> epiParam;
    private static final double[][] EPI_VAL = new double[][]{{0.375, 0.25, 0.4}, {0.22, 0.23, 0.36}, {0.22, 0.23, 0.33}};

    public NGAW2_WrapperFullParam(String shortName, NGAW2_GMM gmpe, boolean supportsPhiTau) {
        this.shortName = shortName;
        this.gmpe = gmpe;
        this.supportsPhiTau = supportsPhiTau;
        this.initSupportedIntensityMeasureParams();
        this.initSiteParams();
        this.initEqkRuptureParams();
        this.initPropagationEffectParams();
        this.initOtherParams();
        this.initIndependentParamLists();
    }

    NGAW2_GMM getGMPE() {
        return this.gmpe;
    }

    @Override
    public double getMean() {
        ScalarGroundMotion gm = this.getGroundMotion();
        return gm.mean();
    }

    @Override
    public double getStdDev() {
        ScalarGroundMotion gm = this.getGroundMotion();
        String stdType = (String)this.stdDevTypeParam.getValue();
        if (stdType.equals("Total")) {
            return gm.stdDev();
        }
        if (stdType.equals("Inter-Event")) {
            return gm.tau();
        }
        if (stdType.equals("Intra-Event")) {
            return gm.phi();
        }
        throw new IllegalStateException("Unsupported Std Dev Type: " + stdType);
    }

    @Override
    public void setParamDefaults() {
        for (Parameter<?> param : this.siteParams) {
            param.setValueAsDefault();
        }
        for (Parameter<?> param : this.propagationEffectParams) {
            param.setValueAsDefault();
        }
        for (Parameter<?> param : this.eqkRuptureParams) {
            param.setValueAsDefault();
        }
        for (Parameter<?> param : this.otherParams) {
            param.setValueAsDefault();
        }
        this.setIntensityMeasure("SA");
    }

    @Override
    public String getName() {
        return this.gmpe.getName();
    }

    @Override
    public String getShortName() {
        return this.shortName;
    }

    @Override
    public void setSite(Site site) {
        super.setSite(site);
        this.vs30Param.setValueIgnoreWarning(site.getParameter(Double.class, "Vs30").getValue());
        this.vs30_TypeParam.setValue(site.getParameter(String.class, "Vs30 Type").getValue());
        this.depthTo1pt0kmPerSecParam.setValue(site.getParameter(Double.class, "Depth 1.0 km/sec").getValue());
        this.depthTo2pt5kmPerSecParam.setValue(site.getParameter(Double.class, "Depth 2.5 km/sec").getValue());
        this.setPropagationEffectParams();
    }

    @Override
    public void setEqkRupture(EqkRupture eqkRupture) {
        super.setEqkRupture(eqkRupture);
        RuptureSurface surf = eqkRupture.getRuptureSurface();
        this.magParam.setValueIgnoreWarning(eqkRupture.getMag());
        this.rakeParam.setValue(eqkRupture.getAveRake());
        this.dipParam.setValueIgnoreWarning(surf.getAveDip());
        double width = surf.getAveWidth();
        if (width == 0.0) {
            width = 0.1;
        }
        this.rupWidthParam.setValueIgnoreWarning(width);
        this.rupTopDepthParam.setValueIgnoreWarning(surf.getAveRupTopDepth());
        double zHyp = eqkRupture.getHypocenterLocation() != null ? eqkRupture.getHypocenterLocation().getDepth() : surf.getAveRupTopDepth() + Math.sin(surf.getAveDip() * GeoTools.TO_RAD) * width / 2.0;
        this.focalDepthParam.setValueIgnoreWarning(zHyp);
        this.setPropagationEffectParams();
    }

    @Override
    protected void setPropagationEffectParams() {
        if (this.site != null && this.eqkRupture != null) {
            Location siteLoc = this.site.getLocation();
            RuptureSurface surf = this.eqkRupture.getRuptureSurface();
            this.distanceJBParam.setValueIgnoreWarning(surf.getDistanceJB(siteLoc));
            this.distanceRupParam.setValueIgnoreWarning(surf.getDistanceRup(siteLoc));
            this.distanceXParam.setValueIgnoreWarning(surf.getDistanceX(siteLoc));
        }
    }

    private void clear() {
        this.gm = null;
    }

    public synchronized ScalarGroundMotion getGroundMotion() {
        if (this.gm != null) {
            return this.gm;
        }
        IMT imt = this.im.getName().equals("SA") ? IMT.getSA(SA_Param.getPeriodInSA_Param(this.im)) : IMT.parseIMT(this.im.getName());
        Double rake = (Double)this.rakeParam.getValue();
        if (rake != null) {
            FaultUtils.assertValidRake(rake);
        }
        FaultStyle style = NGAW2_WrapperFullParam.getFaultStyle(rake);
        this.gmpe.set_IMT(imt);
        double mag = (Double)this.magParam.getValue();
        this.gmpe.set_Mw(mag);
        double rJB = (Double)this.distanceJBParam.getValue();
        this.gmpe.set_rJB(rJB);
        this.gmpe.set_rRup((Double)this.distanceRupParam.getValue());
        this.gmpe.set_rX((Double)this.distanceXParam.getValue());
        this.gmpe.set_dip((Double)this.dipParam.getValue());
        this.gmpe.set_width((Double)this.rupWidthParam.getValue());
        this.gmpe.set_zTop((Double)this.rupTopDepthParam.getValue());
        this.gmpe.set_zHyp((Double)this.focalDepthParam.getValue());
        this.gmpe.set_vs30((Double)this.vs30Param.getValue());
        this.gmpe.set_vsInf(((String)this.vs30_TypeParam.getValue()).equals("Inferred"));
        if (this.depthTo2pt5kmPerSecParam.getValue() == null) {
            this.gmpe.set_z2p5(Double.NaN);
        } else {
            this.gmpe.set_z2p5((Double)this.depthTo2pt5kmPerSecParam.getValue());
        }
        if (this.depthTo1pt0kmPerSecParam.getValue() == null) {
            this.gmpe.set_z1p0(Double.NaN);
        } else {
            this.gmpe.set_z1p0((Double)this.depthTo1pt0kmPerSecParam.getValue() / 1000.0);
        }
        this.gmpe.set_fault(style);
        this.gm = this.gmpe.calc();
        if (this.epiParam.getValue() != null) {
            double sign = ((EpistemicOption)((Object)this.epiParam.getValue())).sign;
            double val = NGAW2_WrapperFullParam.getUncertainty(mag, rJB);
            this.gm = this.supportsPhiTau ? new DefaultGroundMotion(this.gm.mean() + val * sign, this.gm.stdDev(), this.gm.phi(), this.gm.tau()) : new DefaultGroundMotion(this.gm.mean() + val * sign, this.gm.stdDev());
        }
        return this.gm;
    }

    static FaultStyle getFaultStyle(Double rake) {
        if (rake == null || Double.isNaN(rake)) {
            return FaultStyle.UNKNOWN;
        }
        if (rake >= 135.0 || rake <= -135.0) {
            return FaultStyle.STRIKE_SLIP;
        }
        if (rake >= -45.0 && rake <= 45.0) {
            return FaultStyle.STRIKE_SLIP;
        }
        if (rake >= 45.0 && rake <= 135.0) {
            return FaultStyle.REVERSE;
        }
        return FaultStyle.NORMAL;
    }

    @Override
    protected void initSupportedIntensityMeasureParams() {
        this.supportedIMParams.clear();
        DoubleDiscreteConstraint periodConstraint = new DoubleDiscreteConstraint();
        HashSet<IMT> imtsSet = new HashSet<IMT>(this.gmpe.getSupportedIMTs());
        for (IMT imt : imtsSet) {
            Double p = imt.getPeriod();
            if (p == null) continue;
            periodConstraint.addDouble(p);
        }
        periodConstraint.setNonEditable();
        this.saPeriodParam = new PeriodParam(periodConstraint);
        this.saPeriodParam.setValueAsDefault();
        this.saPeriodParam.addParameterChangeListener(this);
        this.saDampingParam = new DampingParam();
        this.saDampingParam.setValueAsDefault();
        this.saDampingParam.addParameterChangeListener(this);
        this.saParam = new SA_Param(this.saPeriodParam, this.saDampingParam);
        this.saParam.setNonEditable();
        this.saParam.addParameterChangeWarningListener(this.listener);
        this.supportedIMParams.addParameter(this.saParam);
        if (imtsSet.contains((Object)IMT.PGA)) {
            this.pgaParam = new PGA_Param();
            this.pgaParam.setNonEditable();
            this.pgaParam.addParameterChangeWarningListener(this.listener);
            this.supportedIMParams.addParameter(this.pgaParam);
        }
        if (imtsSet.contains((Object)IMT.PGV)) {
            this.pgvParam = new PGV_Param();
            this.pgvParam.setNonEditable();
            this.pgvParam.addParameterChangeWarningListener(this.listener);
            this.supportedIMParams.addParameter(this.pgvParam);
        }
        if (imtsSet.contains((Object)IMT.PGD)) {
            this.pgdParam = new PGD_Param();
            this.pgdParam.setNonEditable();
            this.pgdParam.addParameterChangeWarningListener(this.listener);
            this.supportedIMParams.addParameter(this.pgdParam);
        }
    }

    @Override
    protected void initSiteParams() {
        this.vs30Param = new Vs30_Param(760.0, 150.0, 1500.0);
        this.vs30_TypeParam = new Vs30_TypeParam();
        this.depthTo1pt0kmPerSecParam = new DepthTo1pt0kmPerSecParam(null, (double)DepthTo1pt0kmPerSecParam.MIN, (double)DepthTo1pt0kmPerSecParam.MAX, true);
        this.depthTo2pt5kmPerSecParam = new DepthTo2pt5kmPerSecParam(null, (double)DepthTo2pt5kmPerSecParam.MIN, (double)DepthTo2pt5kmPerSecParam.MAX, true);
        this.siteParams.clear();
        this.siteParams.addParameter(this.vs30Param);
        this.siteParams.addParameter(this.vs30_TypeParam);
        this.siteParams.addParameter(this.depthTo1pt0kmPerSecParam);
        this.siteParams.addParameter(this.depthTo2pt5kmPerSecParam);
        for (Parameter<?> param : this.siteParams) {
            param.addParameterChangeListener(this);
        }
    }

    @Override
    protected void initEqkRuptureParams() {
        this.eqkRuptureParams.clear();
        this.magParam = new MagParam(4.0, 9.0, 5.0);
        this.eqkRuptureParams.addParameter(this.magParam);
        this.dipParam = new DipParam(15.0, 90.0, 90.0);
        this.eqkRuptureParams.addParameter(this.dipParam);
        this.rupWidthParam = new RupWidthParam(0.0, 500.0, 10.0);
        this.eqkRuptureParams.addParameter(this.rupWidthParam);
        this.rakeParam = new RakeParam(null, true);
        this.eqkRuptureParams.addParameter(this.rakeParam);
        this.rupTopDepthParam = new RupTopDepthParam(0.0, 500.0, 0.0, 15.0, 0.0);
        this.eqkRuptureParams.addParameter(this.rupTopDepthParam);
        this.focalDepthParam = new FocalDepthParam(0.0, 15.0, 0.0);
        this.eqkRuptureParams.addParameter(this.focalDepthParam);
        for (Parameter<?> param : this.eqkRuptureParams) {
            param.addParameterChangeListener(this);
        }
    }

    @Override
    protected void initPropagationEffectParams() {
        this.propagationEffectParams.clear();
        this.distanceJBParam = new DistanceJBParameter(new DoubleConstraint(0.0, 400.0), 0.0);
        this.propagationEffectParams.addParameter(this.distanceJBParam);
        this.distanceRupParam = new DistanceRupParameter(new DoubleConstraint(0.0, 400.0), 0.0);
        this.propagationEffectParams.addParameter(this.distanceRupParam);
        this.distanceXParam = new DistanceX_Parameter(new DoubleConstraint(-400.0, 400.0), 0.0);
        this.propagationEffectParams.addParameter(this.distanceXParam);
        for (Parameter<?> param : this.propagationEffectParams) {
            param.addParameterChangeListener(this);
        }
    }

    @Override
    protected void initOtherParams() {
        super.initOtherParams();
        this.componentParam = new ComponentParam(Component.RotD50, Component.RotD50);
        this.componentParam.setValueAsDefault();
        this.componentParam.addParameterChangeListener(this);
        this.otherParams.addParameter(this.componentParam);
        StringConstraint stdDevTypeConstraint = new StringConstraint();
        stdDevTypeConstraint.addString("Total");
        if (this.supportsPhiTau) {
            stdDevTypeConstraint.addString("Inter-Event");
            stdDevTypeConstraint.addString("Intra-Event");
        }
        stdDevTypeConstraint.setNonEditable();
        this.stdDevTypeParam = new StdDevTypeParam(stdDevTypeConstraint);
        this.otherParams.addParameter(this.stdDevTypeParam);
        StringConstraint options = new StringConstraint();
        options.addString(this.gmpe.get_TRT().toString());
        this.tectonicRegionTypeParam.setConstraint(options);
        this.tectonicRegionTypeParam.setDefaultValue(this.gmpe.get_TRT().toString());
        this.tectonicRegionTypeParam.setValueAsDefault();
        this.epiParam = new EnumParameter<Object>(EPISTEMIC_PARAM_NAME, EnumSet.allOf(EpistemicOption.class), null, "(Disabled)");
        this.epiParam.setValue(null);
        this.epiParam.addParameterChangeListener(this);
        this.epiParam.setInfo("Additional epistemic uncertainty branch as implemented in the 2014 USGS NSHM and described in Rezaeian et al., 2014");
        this.otherParams.addParameter(this.epiParam);
    }

    @Override
    public void parameterChange(ParameterChangeEvent event) {
        this.clear();
    }

    @Override
    public void setIntensityMeasure(String intensityMeasureName) throws ParameterException {
        super.setIntensityMeasure(intensityMeasureName);
        if (this.epiParam != null) {
            boolean supports = this.supportsEpi(intensityMeasureName);
            if (!supports && this.epiParam.getValue() != null) {
                this.epiParam.setValue(null);
                if (this.epiParam.isEditorBuilt()) {
                    this.epiParam.refreshEditor();
                }
            }
            if (this.epiParam.isEditorBuilt()) {
                this.epiParam.getEditor().setEnabled(supports);
            }
        }
        this.clear();
    }

    private boolean supportsEpi(String imt) {
        return imt.equals("PGA") || imt.equals("SA");
    }

    public NGAW2_GMM getGMM() {
        return this.gmpe;
    }

    protected void initIndependentParamLists() {
        this.meanIndependentParams.clear();
        this.meanIndependentParams.addParameter(this.distanceRupParam);
        this.meanIndependentParams.addParameter(this.distanceJBParam);
        this.meanIndependentParams.addParameter(this.distanceXParam);
        this.meanIndependentParams.addParameter(this.vs30Param);
        this.meanIndependentParams.addParameter(this.depthTo2pt5kmPerSecParam);
        this.meanIndependentParams.addParameter(this.depthTo1pt0kmPerSecParam);
        this.meanIndependentParams.addParameter(this.magParam);
        this.meanIndependentParams.addParameter(this.rakeParam);
        this.meanIndependentParams.addParameter(this.dipParam);
        this.meanIndependentParams.addParameter(this.rupTopDepthParam);
        this.meanIndependentParams.addParameter(this.rupWidthParam);
        this.meanIndependentParams.addParameter(this.focalDepthParam);
        this.meanIndependentParams.addParameter(this.componentParam);
        this.stdDevIndependentParams.clear();
        this.stdDevIndependentParams.addParameterList(this.meanIndependentParams);
        this.stdDevIndependentParams.addParameter(this.vs30_TypeParam);
        this.stdDevIndependentParams.addParameter(this.stdDevTypeParam);
        this.exceedProbIndependentParams.clear();
        this.exceedProbIndependentParams.addParameterList(this.stdDevIndependentParams);
        this.exceedProbIndependentParams.addParameter(this.sigmaTruncTypeParam);
        this.exceedProbIndependentParams.addParameter(this.sigmaTruncLevelParam);
        this.imlAtExceedProbIndependentParams.addParameterList(this.exceedProbIndependentParams);
        this.imlAtExceedProbIndependentParams.addParameter(this.exceedProbParam);
    }

    private static double getUncertainty(double M, double D) {
        int mi;
        int n = M < 6.0 ? 0 : (mi = M < 7.0 ? 1 : 2);
        int di = D < 10.0 ? 0 : (D < 30.0 ? 1 : 2);
        return EPI_VAL[di][mi];
    }

    public static enum EpistemicOption {
        UPPER("Upper", 1.0),
        LOWER("Lower", -1.0);

        private String name;
        private double sign;

        private EpistemicOption(String name, double sign) {
            this.name = name;
            this.sign = sign;
        }

        public String toString() {
            return this.name;
        }
    }
}

