/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.imr.mod.impl;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Doubles;
import org.opensha.commons.data.Site;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.geo.LocationVector;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.impl.BooleanParameter;
import org.opensha.sha.earthquake.EqkRupture;
import org.opensha.sha.faultSurface.CompoundSurface;
import org.opensha.sha.faultSurface.EvenlyGriddedSurface;
import org.opensha.sha.faultSurface.GriddedSubsetSurface;
import org.opensha.sha.faultSurface.RuptureSurface;
import org.opensha.sha.faultSurface.cache.CacheEnabledSurface;
import org.opensha.sha.imr.ScalarIMR;
import org.opensha.sha.imr.mod.AbstractAttenRelMod;
import org.opensha.sha.imr.param.IntensityMeasureParams.SA_Param;

public class BaylessSomerville2013DirectivityModifier
extends AbstractAttenRelMod {
    private static final boolean D = false;
    public static final String NAME = "Bayless & Somerville 2013 Directivity";
    public static final String SHORT_NAME = "BS13_Directivity";
    private BooleanParameter forceFakeHypoParam = new BooleanParameter("Force Fake Southernmost Hypos", false);
    private ParameterList params = new ParameterList();
    private static final double HALF_PI = 1.5707963267948966;
    private static double[] periods = new double[]{0.5, 0.75, 1.0, 1.5, 2.0, 3.0, 4.0, 5.0, 7.5, 10.0};
    private static final ArbitrarilyDiscretizedFunc c0_ss_func = BaylessSomerville2013DirectivityModifier.buildCoeffsFunc(0.0, 0.0, -0.12, -0.175, -0.21, -0.235, -0.255, -0.275, -0.29, -0.3);
    private static final ArbitrarilyDiscretizedFunc c1_ss_func = BaylessSomerville2013DirectivityModifier.buildCoeffsFunc(0.0, 0.0, 0.075, 0.09, 0.095, 0.099, 0.103, 0.108, 0.112, 0.115);
    private static final ArbitrarilyDiscretizedFunc c0_dip_func = BaylessSomerville2013DirectivityModifier.buildCoeffsFunc(0.0, 0.0, 0.0, 0.0, 0.0, -0.033, -0.089, -0.133, -0.16, -0.176);
    private static final ArbitrarilyDiscretizedFunc c1_dip_func = BaylessSomerville2013DirectivityModifier.buildCoeffsFunc(0.0, 0.0, 0.0, 0.0, 0.034, 0.093, 0.128, 0.15, 0.165, 0.179);

    public BaylessSomerville2013DirectivityModifier() {
        this.params.addParameter(this.forceFakeHypoParam);
    }

    @Override
    public String getShortName() {
        return SHORT_NAME;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void setIMRParams(ScalarIMR imr) {
    }

    @Override
    public double getModMean(ScalarIMR imr) {
        EqkRupture rup = imr.getEqkRupture();
        Site site = imr.getSite();
        RuptureSurface surf = rup.getRuptureSurface();
        if (((Boolean)this.forceFakeHypoParam.getValue()).booleanValue() && rup.getHypocenterLocation() == null && surf != null) {
            Location first = surf.getFirstLocOnUpperEdge();
            Location last = surf.getFirstLocOnUpperEdge();
            if (first.getLatitude() < last.getLatitude()) {
                rup.setHypocenterLocation(first);
            } else {
                rup.setHypocenterLocation(last);
            }
        }
        if (rup == null || rup.getHypocenterLocation() == null || site == null || site.getLocation() == null || surf == null || surf.isPointSurface()) {
            return imr.getMean();
        }
        Preconditions.checkState((boolean)imr.getIntensityMeasure().getName().equals("SA"), (Object)"Must be S(a)");
        double period = SA_Param.getPeriodInSA_Param(imr.getIntensityMeasure());
        Location siteLoc = site.getLocation();
        double fD = this.getFd(rup, siteLoc, period);
        return imr.getMean() + fD;
    }

    public double getFd(EqkRupture rup, Location siteLoc, double period) {
        double fD;
        Location hypo = rup.getHypocenterLocation();
        RuptureSurface surf = rup.getRuptureSurface();
        double rake = Math.abs(rup.getAveRake());
        Preconditions.checkState((rake <= 180.0 ? 1 : 0) != 0);
        boolean strikeSlip = rake >= 0.0 && rake <= 30.0 || rake >= 150.0 && rake <= 180.0;
        boolean dipSlip = rake >= 60.0 && rake <= 120.0;
        Location closestTraceLoc = BaylessSomerville2013DirectivityModifier.calcClosestLoc(rup, siteLoc, false, true);
        Location closestSurfLoc = strikeSlip ? closestTraceLoc : BaylessSomerville2013DirectivityModifier.calcClosestLoc(rup, siteLoc, true, true);
        Location hypoMappedToTraceLoc = BaylessSomerville2013DirectivityModifier.calcClosestLoc(rup, hypo, false, false);
        double s = LocationUtils.horzDistance(closestTraceLoc, hypo);
        s = Math.max(s, Math.exp(1.0));
        double depthDiff = Math.abs(hypo.getDepth() - closestSurfLoc.getDepth());
        double d = depthDiff / Math.sin(Math.toRadians(surf.getAveDip()));
        d = Math.max(d, Math.exp(0.0));
        double azimuth = BaylessSomerville2013DirectivityModifier.calcAzimuth(surf, siteLoc, closestTraceLoc);
        double azimuthRad = Math.toRadians(azimuth);
        double theta = BaylessSomerville2013DirectivityModifier.calcTheta(siteLoc, hypoMappedToTraceLoc, closestTraceLoc);
        if (theta > 90.0) {
            theta = theta < 180.0 ? 180.0 - theta : (theta < 270.0 ? (theta -= 180.0) : 360.0 - theta);
        }
        Preconditions.checkState((theta >= 0.0 && theta <= 90.0 ? 1 : 0) != 0, (String)"bad theta: %s", (Object)theta);
        double thetaRad = Math.toRadians(theta);
        double L = LocationUtils.horzDistance(surf.getFirstLocOnUpperEdge(), surf.getLastLocOnUpperEdge());
        double rRup = surf.getDistanceRup(siteLoc);
        double mag = rup.getMag();
        if (strikeSlip) {
            Coeffs c = new Coeffs(period, true);
            fD = this.calcStrikeSlip(s, thetaRad, L, rRup, mag).calcFd(c.c0, c.c1);
        } else if (dipSlip) {
            Coeffs c = new Coeffs(period, false);
            fD = this.calcDipSlip(surf, siteLoc, d, azimuthRad, rRup, mag).calcFd(c.c0, c.c1);
        } else {
            double q1Rake = rake;
            if (q1Rake > 90.0) {
                q1Rake = 180.0 - q1Rake;
            }
            double dipWeight = q1Rake / 90.0;
            double strikeWeight = 1.0 - dipWeight;
            Coeffs cDip = new Coeffs(period, false);
            Coeffs cStrike = new Coeffs(period, true);
            double fD_dip = this.calcDipSlip(surf, siteLoc, d, azimuthRad, rRup, mag).calcFd(cDip.c0, cDip.c1);
            double fD_strike = this.calcStrikeSlip(s, thetaRad, L, rRup, mag).calcFd(cStrike.c0, cStrike.c1);
            fD = strikeWeight * fD_strike + dipWeight * fD_dip;
        }
        Preconditions.checkState((boolean)Doubles.isFinite((double)fD));
        return fD;
    }

    private DirectivityParams calcStrikeSlip(double s, double thetaRad, double L, double rRup, double mag) {
        double fGeom = Math.log(s) * (0.5 * Math.cos(2.0 * thetaRad) + 0.5);
        double rRupOverL = rRup / L;
        double tCD = rRupOverL < 0.5 ? 1.0 : (rRupOverL < 1.0 ? 1.0 - (rRupOverL - 0.5) / 0.5 : 0.0);
        double tMw = mag < 5.0 ? 0.0 : (mag < 6.5 ? 1.0 - (6.5 - mag) / 1.5 : 1.0);
        double tAz = 1.0;
        return new DirectivityParams(fGeom, tCD, tMw, tAz);
    }

    private DirectivityParams calcDipSlip(RuptureSurface surf, Location siteLoc, double d, double azimuth, double rRup, double mag) {
        double rx = surf.getDistanceX(siteLoc);
        double width = surf.getAveWidth();
        double fGeom = Math.log(d) * Math.cos(rx / width);
        double rRupOverW = rRup / width;
        double tCD = rRupOverW < 1.5 ? 1.0 : (rRupOverW < 2.0 ? 1.0 - (rRupOverW - 1.5) / 0.5 : 0.0);
        double tMw = mag < 5.0 ? 0.0 : (mag < 6.5 ? 1.0 - (6.5 - mag) / 1.5 : 1.0);
        double tAz = Math.pow(Math.sin(Math.abs(azimuth)), 2.0);
        return new DirectivityParams(fGeom, tCD, tMw, tAz);
    }

    private static ArbitrarilyDiscretizedFunc buildCoeffsFunc(double ... vals) {
        Preconditions.checkState((periods.length == vals.length ? 1 : 0) != 0);
        ArbitrarilyDiscretizedFunc func = new ArbitrarilyDiscretizedFunc();
        func.set(0.0, 0.0);
        for (int i = 0; i < periods.length; ++i) {
            func.set(periods[i], vals[i]);
        }
        return func;
    }

    /*
     * WARNING - void declaration
     */
    private static Location calcClosestLoc(EqkRupture rup, Location siteLoc, boolean fullSurf, boolean cacheDists) {
        RuptureSurface surf = rup.getRuptureSurface();
        if (surf instanceof CompoundSurface) {
            double minDist = Double.POSITIVE_INFINITY;
            RuptureSurface closest = null;
            for (RuptureSurface ruptureSurface : ((CompoundSurface)surf).getSurfaceList()) {
                double dist = ruptureSurface instanceof CacheEnabledSurface && !cacheDists ? ((CacheEnabledSurface)ruptureSurface).calcQuickDistance(siteLoc) : ruptureSurface.getQuickDistance(siteLoc);
                if (!(dist < minDist)) continue;
                minDist = dist;
                closest = ruptureSurface;
            }
            surf = closest;
        }
        if (fullSurf && surf instanceof EvenlyGriddedSurface) {
            int n;
            void var9_14;
            EvenlyGriddedSurface gridSurf = (EvenlyGriddedSurface)surf;
            int closestCol = -1;
            double minDist = Double.POSITIVE_INFINITY;
            boolean bl = false;
            while (var9_14 < gridSurf.getNumCols()) {
                Location loc = (Location)gridSurf.get(0, (int)var9_14);
                double dist = LocationUtils.horzDistanceFast(siteLoc, loc);
                if (dist < minDist) {
                    minDist = dist;
                    closestCol = var9_14;
                }
                ++var9_14;
            }
            int n2 = closestCol - 10;
            int colEnd = closestCol + 10;
            if (n2 < 0) {
                n = 0;
            }
            if (colEnd >= gridSurf.getNumCols()) {
                colEnd = gridSurf.getNumCols() - 1;
            }
            int numCols = colEnd - n + 1;
            surf = new GriddedSubsetSurface(gridSurf.getNumRows(), numCols, 0, n, gridSurf);
        }
        LocationList locs = fullSurf ? surf.getEvenlyDiscritizedListOfLocsOnSurface() : surf.getEvenlyDiscritizedUpperEdge();
        Preconditions.checkState((locs.size() > 1 ? 1 : 0) != 0, (Object)"shouldn't be a point source...we already checked?");
        double closestDist = Double.MAX_VALUE;
        Location closestLoc = null;
        for (Location loc : locs) {
            double dist = LocationUtils.horzDistance(siteLoc, loc);
            if (!(dist < closestDist)) continue;
            closestDist = dist;
            closestLoc = loc;
        }
        return closestLoc;
    }

    private static double calcAzimuth(RuptureSurface surf, Location siteLoc, Location closestLoc) {
        LocationVector traceVector = LocationUtils.vector(surf.getFirstLocOnUpperEdge(), surf.getLastLocOnUpperEdge());
        LocationVector siteVector = LocationUtils.vector(closestLoc, siteLoc);
        double traceAz = traceVector.getAzimuth();
        double siteAz = siteVector.getAzimuth();
        return siteAz - traceAz;
    }

    private static double calcTheta(Location siteLoc, Location hypo, Location closestLoc) {
        double angleDiff;
        double angle2;
        LocationVector dir = LocationUtils.vector(hypo, siteLoc);
        double angle1 = dir.getAzimuth();
        if (angle1 < 0.0) {
            angle1 += 360.0;
        }
        if ((angle2 = (dir = LocationUtils.vector(hypo, closestLoc)).getHorzDistance() < 0.01 ? 180.0 : dir.getAzimuth()) < 0.0) {
            angle2 += 360.0;
        }
        if ((angleDiff = angle2 - angle1) < -90.0) {
            angleDiff += 360.0;
        } else if (angleDiff > 90.0) {
            angleDiff -= 360.0;
        }
        while (angleDiff < 0.0) {
            angleDiff += 360.0;
        }
        return angleDiff;
    }

    @Override
    public double getModStdDev(ScalarIMR imr) {
        return imr.getStdDev();
    }

    @Override
    public ParameterList getModParams() {
        return this.params;
    }

    public static void main(String[] args) {
    }

    public static class Coeffs {
        private double c0;
        private double c1;

        public Coeffs(double period, boolean strikeSlip) {
            if (strikeSlip) {
                this.c0 = c0_ss_func.getInterpolatedY(period);
                this.c1 = c1_ss_func.getInterpolatedY(period);
            } else {
                this.c0 = c0_dip_func.getInterpolatedY(period);
                this.c1 = c1_dip_func.getInterpolatedY(period);
            }
        }
    }

    public static class DirectivityParams {
        private double fGeom;
        private double tCD;
        private double tMw;
        private double tAz;

        public DirectivityParams(double fGeom, double tCD, double tMw, double tAz) {
            this.fGeom = fGeom;
            this.tCD = tCD;
            this.tMw = tMw;
            this.tAz = tAz;
        }

        public double calcFd(double c0, double c1) {
            return (c0 + c1 * this.fGeom) * this.tCD * this.tMw * this.tAz;
        }
    }
}

