/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.imr.mod.impl;

import org.opensha.commons.data.Site;
import org.opensha.commons.exceptions.ParameterException;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.sha.imr.ScalarIMR;
import org.opensha.sha.imr.mod.AbstractAttenRelMod;

public class DemoSiteSpecificMod
extends AbstractAttenRelMod {
    private static final boolean D = true;
    public static final String NAME = "Demo Site Specific";
    public static final String SHORT_NAME = "SimpleScalar";
    private ParameterList modParams = null;
    private double vs30;
    private String vs30Type;
    private Double z2500;
    private Double z1000;

    @Override
    public void setIMRParams(ScalarIMR imr) {
        Parameter param;
        try {
            param = imr.getParameter("Vs30");
            param.setValue(760.0);
        }
        catch (ParameterException e) {
            System.out.println("IMR doesn't support Vs30");
        }
        try {
            param = imr.getParameter("Vs30 Type");
            param.setValue("Inferred");
        }
        catch (ParameterException e) {
            System.out.println("IMR doesn't support Vs30 Type");
        }
        try {
            param = imr.getParameter("Depth 2.5 km/sec");
            param.setValue(null);
        }
        catch (ParameterException e) {
            System.out.println("IMR doesn't support Z2.5");
        }
        try {
            param = imr.getParameter("Depth 1.0 km/sec");
            param.setValue(null);
        }
        catch (ParameterException e) {
            System.out.println("IMR doesn't support Z1.0");
        }
        System.out.println("Set site params to default");
    }

    @Override
    public void setIMRSiteParams(ScalarIMR imr, Site site) {
        imr.setSiteLocation(site.getLocation());
        this.vs30 = site.getParameter(Double.class, "Vs30").getValue();
        this.vs30Type = site.getParameter(String.class, "Vs30 Type").getValue();
        this.z2500 = site.getParameter(Double.class, "Depth 2.5 km/sec").getValue();
        this.z1000 = site.getParameter(Double.class, "Depth 1.0 km/sec").getValue();
        if (this.z1000 != null) {
            this.z1000 = this.z1000 / 1000.0;
        }
        System.out.println("Site params intercepted: vs30=" + this.vs30 + ", vs30_Type=" + this.vs30Type + ", z2.5=" + this.z2500 + " z1.0=" + this.z1000);
    }

    @Override
    public double getModMean(ScalarIMR imr) {
        double origMean;
        double scaleValue = origMean = imr.getMean();
        if (this.vs30 < 500.0) {
            scaleValue = Math.log(Math.exp(origMean) * 2.0);
        }
        return scaleValue;
    }

    @Override
    public double getModStdDev(ScalarIMR imr) {
        double origStdDev = imr.getStdDev();
        double scaleValue = origStdDev * 1.0;
        return scaleValue;
    }

    @Override
    public ParameterList getModParams() {
        return this.modParams;
    }

    @Override
    public String getShortName() {
        return SHORT_NAME;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

