/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.imr.mod.impl.stewartSiteSpecific;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.opensha.commons.data.Named;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.editor.AbstractParameterEditor;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.sha.imr.mod.impl.stewartSiteSpecific.PeriodDependentParamSet;
import org.opensha.sha.imr.mod.impl.stewartSiteSpecific.PeriodDependentParamSetParam;

public class PeriodDependentParamSetEditor<E extends Enum<E>>
extends AbstractParameterEditor<PeriodDependentParamSet<E>>
implements ActionListener,
TableModelListener {
    private static final boolean D = true;
    private PeriodDepTableModel tableModel;
    private JTable table;
    private JButton addButton;
    private JButton removeButton;
    private JButton importButton;
    private JButton exportButton;
    private JButton clearButton;
    private JFileChooser chooser;
    private JTextField periodField;
    private boolean isFocusListenerForX = false;
    private JPanel widgetPanel;
    private static final Color disabledColor = new Color(210, 210, 210);
    private static DecimalFormat format = new DecimalFormat();

    public PeriodDependentParamSetEditor(Parameter<PeriodDependentParamSet<E>> param) {
        super(param);
    }

    @Override
    public boolean isParameterSupported(Parameter<PeriodDependentParamSet<E>> param) {
        if (param == null) {
            return false;
        }
        return param.getValue() == null || param.getValue() instanceof PeriodDependentParamSet;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.table.setEnabled(enabled);
        this.tableModel.setEnabled(enabled);
        this.addButton.setEnabled(enabled);
        this.removeButton.setEnabled(enabled);
    }

    @Override
    public boolean isEnabled() {
        return this.table != null && this.table.isEnabled();
    }

    @Override
    protected JComponent buildWidget() {
        PeriodDependentParamSet data = (PeriodDependentParamSet)this.getValue();
        Preconditions.checkNotNull((Object)data);
        JPanel buttonPanel = new JPanel(new BorderLayout());
        JPanel topButtonPanel = new JPanel(new BorderLayout());
        JPanel topLeftButtonPanel = new JPanel();
        topLeftButtonPanel.setLayout(new BoxLayout(topLeftButtonPanel, 0));
        JPanel topRightButtonPanel = new JPanel();
        topRightButtonPanel.setLayout(new BoxLayout(topRightButtonPanel, 0));
        JPanel bottomButtonPanel = new JPanel();
        bottomButtonPanel.setLayout(new BoxLayout(bottomButtonPanel, 0));
        if (this.addButton == null) {
            this.addButton = new JButton("+");
            this.addButton.addActionListener(this);
        }
        if (this.removeButton == null) {
            this.removeButton = new JButton("-");
            this.removeButton.addActionListener(this);
        }
        if (this.periodField == null) {
            this.periodField = new JTextField();
            this.periodField.setColumns(4);
        }
        topLeftButtonPanel.add(new JLabel("period: "));
        topLeftButtonPanel.add(this.periodField);
        topLeftButtonPanel.add(this.addButton);
        topRightButtonPanel.add(this.removeButton);
        topButtonPanel.add((Component)topLeftButtonPanel, "West");
        topButtonPanel.add((Component)topRightButtonPanel, "East");
        buttonPanel.add((Component)topButtonPanel, "North");
        if (this.importButton == null) {
            this.importButton = new JButton("Import");
            this.importButton.addActionListener(this);
        }
        if (this.exportButton == null) {
            this.exportButton = new JButton("Export");
            this.exportButton.addActionListener(this);
        }
        if (this.clearButton == null) {
            this.clearButton = new JButton("Clear");
            this.clearButton.addActionListener(this);
        }
        bottomButtonPanel.add(this.importButton);
        bottomButtonPanel.add(this.exportButton);
        bottomButtonPanel.add(this.clearButton);
        JPanel bottomWrapper = new JPanel();
        bottomWrapper.add(bottomButtonPanel);
        buttonPanel.add((Component)bottomWrapper, "South");
        this.tableModel = new PeriodDepTableModel(data);
        this.table = new JTable(this.tableModel){

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                Component c = super.prepareRenderer(renderer, row, column);
                PeriodDependentParamSetEditor.this.addToolTip(c, row, column);
                return c;
            }
        };
        this.tableModel.addTableModelListener(this);
        CustomTableCellRenderer renderer = this.tableModel.getRenderer();
        this.table.setDefaultRenderer(Double.class, renderer);
        JScrollPane scroll = new JScrollPane(this.table);
        scroll.setPreferredSize(new Dimension(100, 200));
        this.widgetPanel = new JPanel(new BorderLayout());
        this.widgetPanel.add((Component)scroll, "Center");
        this.widgetPanel.add((Component)buttonPanel, "South");
        this.widgetPanel.setBackground(null);
        this.widgetPanel.validate();
        this.widgetPanel.repaint();
        return this.widgetPanel;
    }

    private void addToolTip(Component c, int row, int col) {
        String toolTip = null;
        if (col == 0) {
            toolTip = "SA Period (s), PGA, or PGV";
        } else if (this.tableModel != null) {
            Object param = this.tableModel.params[col - 1];
            toolTip = param instanceof Named ? ((Named)param).getName() : ((Enum)param).toString();
        }
        if (toolTip != null && c instanceof JComponent) {
            ((JComponent)c).setToolTipText(toolTip);
        }
    }

    @Override
    protected JComponent updateWidget() {
        PeriodDependentParamSet data = (PeriodDependentParamSet)this.getValue();
        System.out.println("Update called!");
        this.tableModel.updateData(data);
        this.widgetPanel.validate();
        this.widgetPanel.repaint();
        return this.widgetPanel;
    }

    static Object getPeriodForRender(double period) {
        if (period == 0.0) {
            return "PGA";
        }
        if (period == -1.0) {
            return "PGV";
        }
        return period;
    }

    static double getPeriodFromRender(Object val) {
        String str = val.toString();
        if (str.equalsIgnoreCase("PGA")) {
            return 0.0;
        }
        if (str.equalsIgnoreCase("PGV")) {
            return -1.0;
        }
        if (val instanceof String) {
            return Double.parseDouble(str);
        }
        return (Double)val;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        block16: {
            int ret;
            block19: {
                int ret2;
                block18: {
                    block17: {
                        block15: {
                            if (e.getSource() != this.addButton) break block15;
                            String periodStr = this.periodField.getText().trim();
                            try {
                                double period = PeriodDependentParamSetEditor.getPeriodFromRender(periodStr);
                                this.tableModel.addPeriod(period);
                            }
                            catch (NumberFormatException ex) {
                                JOptionPane.showMessageDialog(this.widgetPanel, "Must supply valid period", "Must supply period", 0);
                            }
                            break block16;
                        }
                        if (e.getSource() != this.removeButton) break block17;
                        int[] selected = this.table.getSelectedRows();
                        if (selected == null || selected.length == 0) {
                            return;
                        }
                        ArrayList rowsSorted = Lists.newArrayList();
                        for (int index : selected) {
                            rowsSorted.add(index);
                        }
                        if (selected.length > 1) {
                            Collections.sort(rowsSorted);
                            Collections.reverse(rowsSorted);
                        }
                        Object object = rowsSorted.iterator();
                        while (object.hasNext()) {
                            int index = (Integer)object.next();
                            this.tableModel.removePeriod(index);
                        }
                        break block16;
                    }
                    if (e.getSource() != this.clearButton) break block18;
                    ((PeriodDependentParamSet)this.getValue()).clear();
                    this.updateWidget();
                    break block16;
                }
                if (e.getSource() != this.importButton) break block19;
                if (this.chooser == null) {
                    this.chooser = new JFileChooser();
                    this.chooser.setFileFilter(new FileNameExtensionFilter("CSV File", "csv", "CSV"));
                }
                if ((ret2 = this.chooser.showOpenDialog(this.widgetPanel)) == 0) {
                    File csvFile = this.chooser.getSelectedFile();
                    try {
                        ((PeriodDependentParamSet)this.getValue()).loadCSV(csvFile);
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                        JOptionPane.showMessageDialog(this.widgetPanel, "Error reading CSV", "Exception: " + e1.getMessage(), 0);
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                        JOptionPane.showMessageDialog(this.widgetPanel, "Error loading CSV", "Exception parsing CSV:\n" + e1.getMessage(), 0);
                    }
                }
                this.refreshParamEditor();
                break block16;
            }
            if (e.getSource() != this.exportButton) break block16;
            if (this.chooser == null) {
                this.chooser = new JFileChooser();
                this.chooser.setFileFilter(new FileNameExtensionFilter("CSV File", "csv", "CSV"));
            }
            if ((ret = this.chooser.showSaveDialog(this.widgetPanel)) == 0) {
                File csvFile = this.chooser.getSelectedFile();
                try {
                    ((PeriodDependentParamSet)this.getValue()).writeCSV(csvFile);
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                    JOptionPane.showMessageDialog(this.widgetPanel, "Error writing CSV", "Exception: " + e1.getMessage(), 0);
                }
            }
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        System.out.println("Table event...");
        System.out.println(((PeriodDependentParamSet)this.getValue()).toString());
        Parameter param = this.getParameter();
        PeriodDependentParamSet val = (PeriodDependentParamSet)this.getValue();
        param.firePropertyChange(new ParameterChangeEvent(param, param.getName(), val, val));
        System.out.println("Table event DONE");
    }

    public static void main(String[] args) {
        PeriodDependentParamSet data = new PeriodDependentParamSet((Enum[])TestEnum.values());
        PeriodDependentParamSetParam param = new PeriodDependentParamSetParam("Test", data);
        PeriodDependentParamSetEditor editor = new PeriodDependentParamSetEditor(param);
        JFrame frame = new JFrame();
        frame.setSize(500, 500);
        frame.setContentPane(editor);
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
        editor.validate();
        editor.refreshParamEditor();
    }

    static {
        format.setMaximumFractionDigits(10);
    }

    private class PeriodDepTableModel
    extends AbstractTableModel {
        private PeriodDependentParamSet<E> data;
        private E[] params;
        private CustomTableCellRenderer renderer;

        public PeriodDepTableModel(PeriodDependentParamSet<E> data) {
            this.updateData(data);
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public int getColumnCount() {
            return this.params.length + 1;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return PeriodDependentParamSetEditor.getPeriodForRender(this.data.getPeriod(rowIndex));
            }
            int paramIndex = columnIndex - 1;
            return this.data.get(this.params[paramIndex], rowIndex);
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            System.out.println("Setting value at (" + rowIndex + "," + columnIndex + ") to: " + String.valueOf(aValue));
            if (columnIndex > 0) {
                double val = (Double)aValue;
                this.data.set(rowIndex, this.params[columnIndex - 1], val);
            } else {
                double[] vals = this.data.getValues(rowIndex);
                this.removePeriod(rowIndex);
                this.data.set(PeriodDependentParamSetEditor.getPeriodFromRender(aValue), vals);
            }
            this.fireTableDataChanged();
        }

        @Override
        public Class<?> getColumnClass(int c) {
            return Double.class;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return true;
        }

        public void setEnabled(boolean isEnabled) {
            CustomTableCellRenderer renderer = this.getRenderer();
            if (isEnabled) {
                renderer.setBackground(Color.WHITE);
            } else {
                renderer.setBackground(disabledColor);
            }
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return "Period/IMT";
            }
            return ((Enum)this.params[column - 1]).toString();
        }

        public CustomTableCellRenderer getRenderer() {
            if (this.renderer == null) {
                this.renderer = new CustomTableCellRenderer();
            }
            return this.renderer;
        }

        public void updateData(PeriodDependentParamSet<E> data) {
            this.data = data;
            this.params = data.getParams();
            this.fireTableDataChanged();
        }

        public void addPeriod(double period) {
            this.addPeriod(period, new double[this.params.length]);
        }

        public void addPeriod(double period, double[] vals) {
            this.data.set(period, vals);
            this.fireTableDataChanged();
        }

        public void removePeriod(int index) {
            this.data.remove(index);
            this.fireTableDataChanged();
        }
    }

    private class CustomTableCellRenderer
    extends DefaultTableCellRenderer.UIResource {
        public CustomTableCellRenderer() {
            this.setHorizontalAlignment(4);
            this.setPreferredSize(new Dimension(20, 8));
        }

        @Override
        public void setValue(Object value) {
            if (value instanceof String) {
                this.setText(value.toString());
            } else {
                this.setText(value == null ? "" : format.format(value));
            }
        }
    }

    private static enum TestEnum {
        P1,
        P2,
        P3;

    }
}

