/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.imr.param.IntensityMeasureParams;

import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.constraint.impl.DoubleConstraint;
import org.opensha.commons.param.impl.WarningDoubleParameter;
import org.opensha.sha.imr.param.IntensityMeasureParams.DampingParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.PeriodParam;

public class SA_Param
extends WarningDoubleParameter {
    public static final String NAME = "SA";
    public static final String UNITS = "g";
    public static final String INFO = "Response Spectral Acceleration";
    protected static final Double MIN = Math.log(Double.MIN_VALUE);
    protected static final Double MAX = Double.MAX_VALUE;
    protected static final Double DEFAULT_WARN_MIN = Math.log(Double.MIN_VALUE);
    protected static final Double DEFAULT_WARN_MAX = Math.log(3.0);

    public SA_Param(PeriodParam periodParam, DampingParam dampingParam) {
        super(NAME, new DoubleConstraint(MIN, MAX), UNITS);
        this.getConstraint().setNonEditable();
        this.setInfo(INFO);
        DoubleConstraint warn2 = new DoubleConstraint(DEFAULT_WARN_MIN, DEFAULT_WARN_MAX);
        warn2.setNonEditable();
        this.setWarningConstraint(warn2);
        this.addIndependentParameter(periodParam);
        this.addIndependentParameter(dampingParam);
        this.setDefaultValue(0.5);
        this.setNonEditable();
    }

    public SA_Param(PeriodParam periodPeram, DampingParam dampingParam, DoubleConstraint warningConstraint, double defaultPGA) {
        super(NAME, new DoubleConstraint(MIN, MAX), UNITS);
        this.getConstraint().setNonEditable();
        this.setInfo(INFO);
        this.setWarningConstraint(warningConstraint);
        this.addIndependentParameter(periodPeram);
        this.addIndependentParameter(dampingParam);
        this.setDefaultValue(defaultPGA);
        this.setNonEditable();
    }

    public PeriodParam getPeriodParam() {
        return (PeriodParam)this.getIndependentParameter("SA Period");
    }

    public DampingParam getDampingParam() {
        return (DampingParam)this.getIndependentParameter("SA Damping");
    }

    public static void setPeriodInSA_Param(Parameter<?> param, double period) {
        SA_Param saParam = (SA_Param)param;
        saParam.getPeriodParam().setValue(period);
    }

    public static double getPeriodInSA_Param(Parameter<?> param) {
        SA_Param saParam = (SA_Param)param;
        return (Double)saParam.getPeriodParam().getValue();
    }
}

