/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.imr.param.IntensityMeasureParams;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.EnumSet;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.impl.DoubleParameter;
import org.opensha.sha.imr.param.IntensityMeasureParams.DurationTimeInterval;
import org.opensha.sha.imr.param.IntensityMeasureParams.DurationTimeIntervalParam;

public class SignificantDurationParam
extends DoubleParameter {
    public static final String NAME = "Significant Duration";
    public static final String UNITS = "s";
    public static final String INFO = "Significant Duration";
    public static final Double MIN = Math.log(Double.MIN_VALUE);
    public static final Double MAX = Double.MAX_VALUE;
    private DurationTimeIntervalParam intervalParam;

    public SignificantDurationParam() {
        this(DurationTimeInterval.values());
    }

    public SignificantDurationParam(DurationTimeInterval ... intervals) {
        super("Significant Duration", MIN, MAX);
        Preconditions.checkArgument((intervals.length > 0 ? 1 : 0) != 0);
        EnumSet<Object> set = intervals.length == 1 ? EnumSet.of(intervals[0]) : EnumSet.of(intervals[0], Arrays.copyOfRange(intervals, 1, intervals.length));
        this.intervalParam = new DurationTimeIntervalParam(set, intervals[0]);
        this.addIndependentParameter(this.intervalParam);
        this.setNonEditable();
    }

    public DurationTimeInterval getTimeInterval() {
        return (DurationTimeInterval)((Object)this.intervalParam.getValue());
    }

    public void setTimeInterval(DurationTimeInterval interval) {
        this.intervalParam.setValue(interval);
    }

    public static DurationTimeInterval getTimeInterval(Parameter<?> param) {
        Preconditions.checkState((boolean)(param instanceof SignificantDurationParam));
        return ((SignificantDurationParam)param).getTimeInterval();
    }

    public static void setTimeInterval(Parameter<?> param, DurationTimeInterval interval) {
        Preconditions.checkState((boolean)(param instanceof SignificantDurationParam));
        ((SignificantDurationParam)param).setTimeInterval(interval);
    }
}

