/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.imr.param.PropagationEffectParams;

import org.dom4j.Element;
import org.opensha.commons.param.constraint.ParameterConstraint;
import org.opensha.commons.param.constraint.impl.DoubleConstraint;
import org.opensha.sha.imr.param.PropagationEffectParams.AbstractDoublePropEffectParam;

public class DistanceJBParameter
extends AbstractDoublePropEffectParam {
    protected static final String C = "DistanceJBParameter";
    protected static final boolean D = false;
    public static final String NAME = "DistanceJB";
    private static final String UNITS = "km";
    private static final String INFO = "Joyner-Boore Distance (closest distance to surface projection of fault)";
    private static final Double MIN = 0.0;
    private static final Double MAX = Double.MAX_VALUE;

    public DistanceJBParameter() {
        super(NAME);
        this.init();
    }

    public DistanceJBParameter(double defaultValue) {
        super(NAME);
        this.init();
        this.setDefaultValue(defaultValue);
    }

    public DistanceJBParameter(DoubleConstraint warningConstraint, double defaultValue) {
        super(NAME);
        this.init(warningConstraint);
        this.setDefaultValue(defaultValue);
    }

    protected void init(DoubleConstraint warningConstraint) {
        this.warningConstraint = warningConstraint;
        this.constraint = new DoubleConstraint(MIN, MAX);
        this.constraint.setNullAllowed(false);
        this.name = NAME;
        this.constraint.setName(this.name);
        this.units = UNITS;
        this.info = INFO;
    }

    protected void init() {
        this.init(null);
    }

    @Override
    protected void calcValueFromSiteAndEqkRup() {
        if (this.site != null && this.eqkRupture != null) {
            this.setValueIgnoreWarning(this.eqkRupture.getRuptureSurface().getDistanceJB(this.site.getLocation()));
        } else {
            this.value = null;
        }
    }

    @Override
    public String getType() {
        Object type = "DoubleParameter";
        ParameterConstraint constraint = this.constraint;
        if (constraint != null) {
            type = "Constrained" + (String)type;
        }
        return type;
    }

    @Override
    public Object clone() {
        DoubleConstraint c1 = null;
        DoubleConstraint c2 = null;
        if (this.constraint != null) {
            c1 = (DoubleConstraint)this.constraint.clone();
        }
        if (this.warningConstraint != null) {
            c2 = (DoubleConstraint)this.warningConstraint.clone();
        }
        Double val = null;
        Double val2 = null;
        if (this.value != null) {
            val = (Double)this.value;
            val2 = (double)val;
        }
        DistanceJBParameter param = new DistanceJBParameter();
        param.info = this.info;
        param.value = val2;
        param.constraint = c1;
        param.warningConstraint = c2;
        param.name = this.name;
        param.info = this.info;
        param.site = this.site;
        param.eqkRupture = this.eqkRupture;
        if (!this.editable) {
            param.setNonEditable();
        }
        return param;
    }

    @Override
    public boolean setIndividualParamValueFromXML(Element el) {
        return false;
    }
}

