/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.imr.param.SiteParams;

import org.opensha.commons.param.constraint.impl.DoubleConstraint;
import org.opensha.commons.param.impl.WarningDoubleParameter;

public class SedimentThicknessParam
extends WarningDoubleParameter {
    public static final String NAME = "Sediment Thickness (zSed)";
    public static final String UNITS = "km";
    public static final String INFO = "Thickness of coastal margin sediments";
    public static final Double MIN = 0.0;
    public static final Double MAX = 30000.0;

    public SedimentThicknessParam(Double defaultThickness) {
        this(defaultThickness, true);
    }

    public SedimentThicknessParam(Double defaultThickness, boolean allowsNull) {
        super(NAME, new DoubleConstraint(MIN, MAX), UNITS);
        this.getConstraint().setNullAllowed(allowsNull);
        this.getConstraint().setNonEditable();
        this.setInfo(INFO);
        this.setDefaultValue(defaultThickness);
    }

    public SedimentThicknessParam() {
        this((Double)null);
    }

    public SedimentThicknessParam(Double defaultThickness, double warnMin, double warnMax, boolean nullAllowed) {
        super(NAME, new DoubleConstraint(MIN, MAX), UNITS);
        this.getConstraint().setNullAllowed(nullAllowed);
        this.getConstraint().setNonEditable();
        this.setInfo(INFO);
        this.setDefaultValue(defaultThickness);
        DoubleConstraint warn = new DoubleConstraint(warnMin, warnMax);
        this.setWarningConstraint(warn);
        warn.setNonEditable();
        this.setNonEditable();
    }

    public SedimentThicknessParam(double warnMin, double warnMax, boolean nullAllowed) {
        this(null, warnMin, warnMax, nullAllowed);
    }
}

