/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.magdist;

import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.eq.MagUtils;
import org.opensha.commons.exceptions.InvalidRangeException;
import org.opensha.sha.magdist.IncrementalMagFreqDist;

public class ArbIncrementalMagFreqDist
extends IncrementalMagFreqDist {
    public static String NAME = "Arb Mag Freq Dist";

    public ArbIncrementalMagFreqDist(double min, double max, int num) throws InvalidRangeException {
        super(min, max, num);
    }

    public ArbIncrementalMagFreqDist(double min, int num, double delta) throws InvalidRangeException {
        super(min, num, delta);
    }

    public void setResampledMagFreqDist(DiscretizedFunc func, boolean preserveRates) {
        for (int i = 0; i < func.size(); ++i) {
            this.addResampledMagRate(func.getX(i), func.getY(i), preserveRates);
        }
    }

    public void setCumRateDist(DiscretizedFunc cumFunc) {
        double halfDelta = this.delta / 2.0;
        double minX = cumFunc.getMinX();
        double maxX = cumFunc.getMaxX();
        for (int i = 0; i < this.num; ++i) {
            double mag = this.getX(i);
            double mag1 = mag - halfDelta;
            double mag2 = mag + halfDelta;
            double rate1 = cumFunc.getInterpolatedY_inLogYDomain(mag1);
            double rate2 = cumFunc.getInterpolatedY_inLogYDomain(mag2);
            double rate = rate1 - rate2;
            this.set(i, rate);
        }
    }

    public void addResampledMagRate(double mag, double rate, boolean preserveRates) {
        int index = (int)Math.round((mag - this.minX) / this.delta);
        if (!this.isIndexWithinRange(index)) {
            return;
        }
        if (preserveRates) {
            this.set(index, this.getY(index) + rate);
        } else {
            double newRate = rate * MagUtils.magToMoment(mag) / MagUtils.magToMoment(this.getX(index));
            this.set(index, this.getY(index) + newRate);
        }
    }

    @Override
    public String getDefaultName() {
        return NAME;
    }

    @Override
    public String getDefaultInfo() {
        return "Arbitrary Incremental Magnitude Frequency Dististribution";
    }
}

