/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.magdist;

import org.opensha.commons.exceptions.InvalidRangeException;
import org.opensha.sha.magdist.IncrementalMagFreqDist;

public class GutenbergRichterMagFreqDist
extends IncrementalMagFreqDist {
    public static String NAME = new String("Gutenberg Richter Dist");
    private boolean D = false;
    private double magLower;
    private double magUpper;
    private double bValue;

    public GutenbergRichterMagFreqDist(double min, int num, double delta) throws InvalidRangeException {
        super(min, num, delta);
        this.magLower = min;
    }

    public GutenbergRichterMagFreqDist(double min, double max, int num) throws InvalidRangeException {
        super(min, max, num);
    }

    public GutenbergRichterMagFreqDist(double bValue, double totCumRate, double min, double max, int num) throws InvalidRangeException {
        super(min, max, num);
        this.setAllButTotMoRate(min, max, totCumRate, bValue);
    }

    public GutenbergRichterMagFreqDist(double min, int num, double delta, double totMoRate, double bValue) {
        super(min, num, delta);
        this.setAllButTotCumRate(this.minX, this.maxX, totMoRate, bValue);
    }

    public GutenbergRichterMagFreqDist(double min, int num, double delta, double magLower, double magUpper, double totMoRate, double bValue) throws InvalidRangeException {
        super(min, num, delta);
        this.setAllButTotCumRate(magLower, magUpper, totMoRate, bValue);
    }

    public void setAllButTotCumRate(double magLower, double magUpper, double totMoRate, double bValue) {
        this.magLower = magLower;
        this.magUpper = magUpper;
        this.bValue = bValue;
        this.calculateRelativeRates();
        this.scaleToTotalMomentRate(totMoRate);
    }

    public void setAllButTotMoRate(double magLower, double magUpper, double totCumRate, double bValue) {
        this.magLower = magLower;
        this.magUpper = magUpper;
        this.bValue = bValue;
        this.calculateRelativeRates();
        this.scaleToCumRate(magLower, totCumRate);
    }

    public void setAllButMagUpper(double magLower, double totMoRate, double totCumRate, double bValue, boolean relaxTotMoRate) {
        int index;
        if (this.D) {
            System.out.println("magLower = " + magLower);
        }
        if (this.D) {
            System.out.println("totMoRate = " + totMoRate);
        }
        if (this.D) {
            System.out.println("totCumRate = " + totCumRate);
        }
        if (this.D) {
            System.out.println("bValue = " + bValue);
        }
        if (this.D) {
            System.out.println("relaxCumRate = " + relaxTotMoRate);
        }
        double b = bValue;
        double N = totCumRate;
        double z = 1.5 - b;
        double X = N * b * Math.pow(10.0, 9.05) / z;
        double M1 = magLower;
        double tempTotMoRate = 0.0;
        double lastMoRate = 0.0;
        for (index = this.getXIndex(M1) + 1; tempTotMoRate < totMoRate && index < this.num; ++index) {
            lastMoRate = tempTotMoRate;
            double M2 = this.getX(index);
            tempTotMoRate = X * (Math.pow(10.0, z * M2) - Math.pow(10.0, z * M1)) / (Math.pow(10.0, -b * M1) - Math.pow(10.0, -b * M2));
        }
        --index;
        if (this.D) {
            System.out.println("just above target: index=" + index + "; mag=" + this.getX(index));
        }
        if (this.D) {
            System.out.println("lastMoRate = " + lastMoRate);
        }
        if (this.D) {
            System.out.println("tempTotMoRate = " + tempTotMoRate);
        }
        if (this.D) {
            System.out.println("targetMoRate = " + totMoRate);
        }
        if (lastMoRate <= totMoRate && tempTotMoRate >= totMoRate) {
            double diff2 = totMoRate - lastMoRate;
            double diff1 = tempTotMoRate - totMoRate;
            if (diff2 < diff1) {
                --index;
            }
        } else {
            throw new RuntimeException("Moment rate not attainable; totMoRate=" + totMoRate + "  totCumRate=" + totCumRate);
        }
        this.magUpper = this.getX(index);
        if (this.D) {
            System.out.println("chosen magUpper=" + this.magUpper);
        }
        if (relaxTotMoRate) {
            this.setAllButTotMoRate(magLower, this.magUpper, totCumRate, bValue);
        } else {
            this.setAllButTotCumRate(magLower, this.magUpper, totMoRate, bValue);
        }
    }

    public void setAllButBvalue(double magLower, double magUpper, double totMoRate, double totCumRate) {
        GutenbergRichterMagFreqDist gr = new GutenbergRichterMagFreqDist(this.getMinX(), this.size(), this.getDelta(), magLower, magUpper, totMoRate, 1.0);
        double bMax = 3.0;
        double bIncrement = 0.01;
        double lastB = 1.0;
        double currRate = gr.getTotalIncrRate();
        double lastDiff = Math.abs(totCumRate - currRate);
        double finalB = Double.NaN;
        if (currRate > totCumRate) {
            for (double b = 1.0 - bIncrement; b > -bMax; b -= bIncrement) {
                gr = new GutenbergRichterMagFreqDist(this.getMinX(), this.size(), this.getDelta(), magLower, magUpper, totMoRate, b);
                currRate = gr.getTotalIncrRate();
                double currDiff = Math.abs(totCumRate - currRate);
                if (currRate <= totCumRate) {
                    if (currDiff < lastDiff) {
                        finalB = b;
                        break;
                    }
                    finalB = lastB;
                    break;
                }
                lastDiff = currDiff;
                lastB = b;
            }
            if (Double.isNaN(finalB)) {
                finalB = -bMax;
            }
        } else {
            for (double b = 1.0 + bIncrement; b < bMax; b += bIncrement) {
                gr = new GutenbergRichterMagFreqDist(this.getMinX(), this.size(), this.getDelta(), magLower, magUpper, totMoRate, b);
                currRate = gr.getTotalIncrRate();
                double currDiff = Math.abs(totCumRate - currRate);
                if (currRate >= totCumRate) {
                    if (currDiff < lastDiff) {
                        finalB = b;
                        break;
                    }
                    finalB = lastB;
                    break;
                }
                lastDiff = currDiff;
                lastB = b;
            }
            if (Double.isNaN(finalB)) {
                finalB = bMax;
            }
        }
        if (Math.abs(finalB) < bIncrement / 2.0) {
            finalB = 0.0;
        }
        this.magLower = magLower;
        this.magUpper = magUpper;
        this.bValue = finalB;
        this.calculateRelativeRates();
        this.scaleToTotalMomentRate(totMoRate);
    }

    private void calculateRelativeRates() {
        int i;
        if (this.magLower < this.minX || this.magLower > this.maxX) {
            throw new IllegalArgumentException("magLower should lie between minX and maxX; magLower=" + this.magLower);
        }
        if (this.magLower > this.magUpper) {
            throw new InvalidRangeException("magLower must be < magUpper; magLower=" + this.magLower);
        }
        int indexLow = this.getXIndex(this.magLower);
        if (indexLow == -1) {
            throw new RuntimeException("magLower is not within tolerance of an x-axis value");
        }
        int indexUp = this.getXIndex(this.magUpper);
        if (indexUp == -1) {
            throw new RuntimeException("magUpper is not within tolerance of an x-axis value");
        }
        for (i = 0; i < indexLow; ++i) {
            super.set(i, 0.0);
        }
        for (i = indexLow; i <= indexUp; ++i) {
            super.set(i, Math.pow(10.0, -this.bValue * this.getX(i)));
        }
        for (i = indexUp + 1; i < this.num; ++i) {
            super.set(i, 0.0);
        }
    }

    public double getTotCumRate() {
        return this.getCumRate(this.magLower);
    }

    public double get_bValue() {
        return this.bValue;
    }

    public double getMagLower() {
        return this.magLower;
    }

    public double getMagUpper() {
        return this.magUpper;
    }

    @Override
    public String getDefaultName() {
        return NAME;
    }

    @Override
    public String getDefaultInfo() {
        return "minMag=" + this.minX + "; maxMag=" + this.maxX + "; numMag=" + this.num + "; bValue=" + this.bValue + "; magLower=" + this.magLower + "; magUpper=" + (float)this.magUpper + "; totMoRate=" + (float)this.getTotalMomentRate() + "; totCumRate=" + (float)this.getCumRate(this.magLower);
    }

    public static void main(String[] args) {
        GutenbergRichterMagFreqDist grTest = new GutenbergRichterMagFreqDist(1.0, 1.0, 0.0, 10.0, 100);
        System.out.println(grTest);
        System.out.println("bVal=" + grTest.compute_bValue(Double.NaN, Double.NaN));
    }
}

