/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.magdist.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.LogarithmicAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.TickUnitSource;
import org.jfree.chart.axis.TickUnits;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.Range;
import org.jfree.data.xy.XYDataset;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.data.function.XY_DataSet;
import org.opensha.commons.data.function.XY_DataSetList;
import org.opensha.commons.gui.plot.jfreechart.DiscretizedFunctionXYDataSet;
import org.opensha.commons.gui.plot.jfreechart.MyTickUnits;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.editor.impl.ParameterListEditor;
import org.opensha.sha.magdist.GaussianMagFreqDist;
import org.opensha.sha.magdist.GutenbergRichterMagFreqDist;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import org.opensha.sha.magdist.SingleMagFreqDist;
import org.opensha.sha.magdist.SummedMagFreqDist;
import org.opensha.sha.magdist.TaperedGR_MagFreqDist;
import org.opensha.sha.magdist.YC_1985_CharMagFreqDist;
import org.opensha.sha.magdist.gui.MagFreqDistAxisScale;
import org.opensha.sha.param.MagFreqDistParameter;
import org.opensha.sha.param.editor.MagFreqDistParameterEditor;

public class MagFreqDistTesterApplet
extends JPanel
implements ItemListener {
    protected static final String C = "MagFreqDistTesterApplet";
    private static final String version = "0.0.3";
    protected static final boolean D = false;
    protected float minXValue;
    protected float maxXValue;
    protected float minYValue;
    protected float maxYValue;
    protected boolean incrCustomAxis = false;
    protected boolean cumCustomAxis = false;
    protected boolean moCustomAxis = false;
    protected String legend = null;
    protected static final int W = 870;
    protected static final int H = 730;
    protected static final int A1 = 360;
    protected static final int A2 = 430;
    protected static final Font BUTTON_FONT = new Font("Dialog", 1, 11);
    static final Dimension BUTTON_DIM = new Dimension(80, 20);
    static final Dimension COMBO_DIM = new Dimension(180, 20);
    private static final String MAG_DIST_PARAM_NAME = "Mag Dist Param";
    static final String NO_PLOT_MSG = "No Plot Data Available";
    private static final String MAG = new String("Magnitude");
    private static final String INCR_RATE = new String("Incremental Rate");
    private static final String CUM_RATE = new String("Cumulative Rate");
    private static final String MO_RATE = new String("Moment Rate");
    private SummedMagFreqDist summedMagFreqDist;
    private static final String AUTO_SCALE_ALL = new String("Auto Scale All");
    private static final String INCR_AUTO_SCALE = new String("Incr Auto Scale");
    private static final String CUM_AUTO_SCALE = new String("Cum Auto Scale");
    private static final String MO_AUTO_SCALE = new String("Mo Auto Scale");
    private static final String CUSTOM_SCALE = new String("Custom Scale");
    NumberAxis incrXAxis = null;
    NumberAxis cumXAxis = null;
    NumberAxis moXAxis = null;
    private double AUTO_RANGE_MINIMUM_SIZE = 1.0E-100;
    NumberAxis incrYAxis = null;
    NumberAxis cumYAxis = null;
    NumberAxis moYAxis = null;
    private double xIncrMin;
    private double xIncrMax;
    private double yIncrMin;
    private double yIncrMax;
    private double xCumMin;
    private double xCumMax;
    private double yCumMin;
    private double yCumMax;
    private double xMoMin;
    private double xMoMax;
    private double yMoMin;
    private double yMoMax;
    public String currentMagDistName = "";
    boolean isStandalone = false;
    protected boolean inParameterChangeWarning = false;
    Insets plotInsets = new Insets(4, 10, 4, 4);
    Insets defaultInsets = new Insets(4, 4, 4, 4);
    Insets emptyInsets = new Insets(0, 0, 0, 0);
    private JPanel mainPanel = new JPanel();
    private GridBagLayout GBL = new GridBagLayout();
    private JComboBox rangeComboBox = new JComboBox();
    private JCheckBox plotColorCheckBox = new JCheckBox();
    private JButton clearButton = new JButton();
    private JLabel jIncrAxisScale = new JLabel();
    private JCheckBox jCheckylog = new JCheckBox();
    private JButton toggleButton = new JButton();
    private JPanel buttonPanel = new JPanel();
    private JButton addButton = new JButton();
    private JPanel outerPanel = new JPanel();
    private JSplitPane mainSplitPane = new JSplitPane();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    protected JFrame frame;
    private ChartPanel incrPanel;
    private ChartPanel cumPanel;
    private ChartPanel moPanel;
    private JTextPane legendPane = new JTextPane();
    private JScrollPane legendScrollPane = new JScrollPane();
    private JPanel legendPanel = new JPanel();
    private SimpleAttributeSet setLegend;
    private JScrollPane dataScrollPane = new JScrollPane();
    private JTextArea pointsTextArea = new JTextArea();
    private JLabel titleLabel = new JLabel();
    private JPanel plotPanel = new JPanel();
    private JPanel titlePanel = new JPanel();
    private JPanel innerPlotPanel = new JPanel();
    Color[] legendColor = new Color[11];
    Paint[] legendPaint = new Paint[11];
    Color darkBlue = new Color(80, 80, 133);
    Color lightBlue = new Color(200, 200, 230);
    protected boolean graphOn = false;
    boolean isWhite = true;
    Color background = Color.white;
    int titleSize = 0;
    private Paint[] paint;
    MagFreqDistParameter magDist = null;
    MagFreqDistParameterEditor magDistEditor;
    XY_DataSetList incrFunctions = new XY_DataSetList();
    XY_DataSetList toCumFunctions = new XY_DataSetList();
    XY_DataSetList toMoFunctions = new XY_DataSetList();
    DiscretizedFunctionXYDataSet incrData = new DiscretizedFunctionXYDataSet();
    DiscretizedFunctionXYDataSet toCumData = new DiscretizedFunctionXYDataSet();
    DiscretizedFunctionXYDataSet toMoData = new DiscretizedFunctionXYDataSet();
    private boolean yLog = false;
    JCheckBox jCheckSumDist = new JCheckBox();
    private static final String FRAME_ICON_NAME = "openSHA_Aqua_sm.gif";
    private static final String POWERED_BY_IMAGE = "PoweredBy.gif";
    private static final String OPENSHA_WEBSITE = "http://www.OpenSHA.org";
    private JLabel jLabel1 = new JLabel();
    private Border border1;

    public MagFreqDistTesterApplet() {
        this.incrData.setFunctions(this.incrFunctions);
        this.toCumData.setFunctions(this.toCumFunctions);
        this.toMoData.setFunctions(this.toMoFunctions);
        this.incrFunctions.setXAxisName(MAG);
        this.toCumFunctions.setXAxisName(MAG);
        this.toMoFunctions.setXAxisName(MAG);
        this.incrFunctions.setYAxisName(INCR_RATE);
        this.toCumFunctions.setYAxisName(CUM_RATE);
        this.toMoFunctions.setYAxisName(MO_RATE);
        this.incrData.setConvertZeroToMin(true, 1.0E-7);
        this.toCumData.setConvertZeroToMin(true, 1.0E-7);
        this.toMoData.setConvertZeroToMin(true, 1.0);
        int k = 0;
        this.legendColor[k] = Color.blue;
        this.legendPaint[k++] = Color.blue;
        this.legendColor[k] = Color.green;
        this.legendPaint[k++] = Color.green;
        this.legendColor[k] = Color.orange;
        this.legendPaint[k++] = Color.orange;
        this.legendColor[k] = Color.magenta;
        this.legendPaint[k++] = Color.magenta;
        this.legendColor[k] = Color.cyan;
        this.legendPaint[k++] = Color.cyan;
        this.legendColor[k] = Color.pink;
        this.legendPaint[k++] = Color.pink;
        this.legendColor[k] = Color.yellow;
        this.legendPaint[k++] = Color.yellow;
        this.legendColor[k] = Color.darkGray;
        this.legendPaint[k++] = Color.darkGray;
    }

    public void init() {
        try {
            this.jbInit();
            this.initMagDistGui();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.border1 = BorderFactory.createLineBorder(new Color(80, 80, 133), 3);
        this.mainPanel.setLayout(this.GBL);
        this.mainPanel.setBorder(this.border1);
        this.setLayout(this.GBL);
        this.rangeComboBox.setBackground(new Color(200, 200, 230));
        this.rangeComboBox.setFont(new Font("Lucida Grande", 0, 11));
        this.rangeComboBox.setForeground(new Color(80, 80, 133));
        this.rangeComboBox.setMaximumSize(new Dimension(125, 22));
        this.rangeComboBox.setMinimumSize(new Dimension(125, 22));
        this.rangeComboBox.setPreferredSize(new Dimension(125, 22));
        this.rangeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MagFreqDistTesterApplet.this.rangeComboBox_actionPerformed(e);
            }
        });
        this.plotColorCheckBox.setBackground(Color.white);
        this.plotColorCheckBox.setFont(new Font("Dialog", 1, 11));
        this.plotColorCheckBox.setForeground(new Color(80, 80, 133));
        this.plotColorCheckBox.setText("Black Background");
        this.plotColorCheckBox.addItemListener(this);
        this.clearButton.setBackground(new Color(200, 200, 230));
        this.clearButton.setFont(BUTTON_FONT);
        this.clearButton.setForeground(new Color(80, 80, 133));
        this.clearButton.setFocusPainted(false);
        this.clearButton.setText("Clear Plot");
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MagFreqDistTesterApplet.this.clearButton_actionPerformed(e);
            }
        });
        this.clearButton.setPreferredSize(BUTTON_DIM);
        this.clearButton.setMinimumSize(BUTTON_DIM);
        this.jIncrAxisScale.setFont(new Font("Dialog", 1, 12));
        this.jIncrAxisScale.setForeground(new Color(80, 80, 133));
        this.jIncrAxisScale.setToolTipText("");
        this.jIncrAxisScale.setText("Axis Scales: ");
        this.jCheckylog.setBackground(Color.white);
        this.jCheckylog.setFont(new Font("Dialog", 1, 11));
        this.jCheckylog.setForeground(new Color(80, 80, 133));
        this.jCheckylog.setText("Y-Log");
        this.jCheckylog.addItemListener(this);
        this.toggleButton.setBackground(new Color(200, 200, 230));
        this.toggleButton.setFont(BUTTON_FONT);
        this.toggleButton.setForeground(new Color(80, 80, 133));
        this.toggleButton.setFocusPainted(false);
        this.toggleButton.setText("Show Data");
        this.toggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MagFreqDistTesterApplet.this.toggleButton_actionPerformed(e);
            }
        });
        this.toggleButton.setPreferredSize(BUTTON_DIM);
        this.toggleButton.setMinimumSize(BUTTON_DIM);
        this.buttonPanel.setLayout(this.GBL);
        this.addButton.setBackground(new Color(200, 200, 230));
        this.addButton.setFont(BUTTON_FONT);
        this.addButton.setForeground(new Color(80, 80, 133));
        this.addButton.setFocusPainted(false);
        this.addButton.setText("Add Dist");
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MagFreqDistTesterApplet.this.addButton_actionPerformed(e);
            }
        });
        this.addButton.setPreferredSize(BUTTON_DIM);
        this.addButton.setActionCommand("Add Dist");
        this.addButton.setMinimumSize(BUTTON_DIM);
        this.outerPanel.setLayout(this.GBL);
        this.mainSplitPane.setOrientation(1);
        this.mainSplitPane.setBorder(null);
        this.mainSplitPane.setDividerSize(5);
        this.mainSplitPane.setOneTouchExpandable(false);
        this.dataScrollPane.setHorizontalScrollBarPolicy(31);
        this.dataScrollPane.setBorder(BorderFactory.createEtchedBorder());
        this.legendScrollPane.setBorder(BorderFactory.createEtchedBorder());
        this.legendPane.setBorder(BorderFactory.createEtchedBorder());
        this.pointsTextArea.setBorder(BorderFactory.createEtchedBorder());
        this.pointsTextArea.setText(NO_PLOT_MSG);
        this.pointsTextArea.setLineWrap(true);
        this.titleLabel.setHorizontalAlignment(0);
        this.titleLabel.setFont(new Font("Dialog", 1, 16));
        this.plotPanel.setLayout(this.GBL);
        this.titlePanel.setLayout(this.GBL);
        this.innerPlotPanel.setLayout(this.GBL);
        this.innerPlotPanel.setBorder(null);
        this.setBackground(Color.white);
        this.outerPanel.setBackground(Color.white);
        this.mainPanel.setBackground(Color.white);
        this.buttonPanel.setBackground(Color.white);
        this.jCheckSumDist.setBackground(Color.white);
        this.jCheckSumDist.setForeground(Color.red);
        this.jCheckSumDist.setText("Summed Dist");
        this.jCheckSumDist.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MagFreqDistTesterApplet.this.jCheckSumDist_actionPerformed(e);
            }
        });
        this.jLabel1.setFont(new Font("Dialog", 0, 18));
        this.jLabel1.setForeground(new Color(80, 80, 133));
        this.jLabel1.setText("Magnitude-Frequency Distribution GUI");
        this.mainPanel.add((Component)this.mainSplitPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 4, 4, 4), 0, 0));
        this.mainPanel.add((Component)this.buttonPanel, new GridBagConstraints(0, 1, 0, 0, 1.0, 0.0, 10, 2, new Insets(1, 1, 1, 1), 0, 0));
        this.add((Component)this.outerPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(9, 9, 0, 9), 109, 399));
        this.outerPanel.add((Component)this.mainPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.buttonPanel.add((Component)this.toggleButton, new GridBagConstraints(5, 0, 1, 2, 0.0, 0.0, 10, 0, new Insets(2, 5, 0, 1), 11, 7));
        this.buttonPanel.add((Component)this.clearButton, new GridBagConstraints(4, 0, 1, 3, 0.0, 0.0, 10, 0, new Insets(2, 0, 0, 0), 8, 7));
        this.buttonPanel.add((Component)this.plotColorCheckBox, new GridBagConstraints(7, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(4, 3, 0, 0), 0, 0));
        this.buttonPanel.add((Component)this.addButton, new GridBagConstraints(3, 0, 1, 4, 0.0, 0.0, 10, 0, new Insets(2, 0, 0, 5), 12, 7));
        this.buttonPanel.add((Component)this.jCheckylog, new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 0, 2), 0, 0));
        this.buttonPanel.add((Component)this.jCheckSumDist, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 0, 0, 0), 0, 0));
        this.buttonPanel.add((Component)this.jIncrAxisScale, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(4, 4, 0, 0), 0, 0));
        this.buttonPanel.add((Component)this.rangeComboBox, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 0, 0, 4), 0, 0));
        this.outerPanel.add((Component)this.jLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        ArrayList<String> distNames = new ArrayList<String>();
        distNames.add(SingleMagFreqDist.NAME);
        distNames.add(GutenbergRichterMagFreqDist.NAME);
        distNames.add(GaussianMagFreqDist.NAME);
        distNames.add(YC_1985_CharMagFreqDist.NAME);
        distNames.add(TaperedGR_MagFreqDist.NAME);
        this.magDist = new MagFreqDistParameter(MAG_DIST_PARAM_NAME, distNames);
        this.magDistEditor = new MagFreqDistParameterEditor();
        this.magDistEditor.setParameter((Parameter)this.magDist);
        this.magDistEditor.setMagFreqDistParamButtonVisible(false);
        ParameterListEditor magDistPanel = this.magDistEditor.getMagFreqDistParameterEditor();
        this.mainSplitPane.setBottomComponent(magDistPanel);
        this.mainSplitPane.setTopComponent(this.plotPanel);
        this.mainSplitPane.setDividerLocation(600);
        this.dataScrollPane.getViewport().add((Component)this.pointsTextArea, null);
        this.legendScrollPane.getViewport().add((Component)this.legendPane, null);
        this.plotPanel.add((Component)this.titlePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(4, 4, 2, 4), 0, 0));
        this.plotPanel.add((Component)this.innerPlotPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, this.defaultInsets, 0, 0));
        this.titlePanel.add((Component)this.titleLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, this.emptyInsets, 0, 0));
        this.titlePanel.setBackground(this.background);
        this.plotPanel.setBackground(this.background);
        this.innerPlotPanel.setBackground(this.background);
    }

    public void setFrame(JFrame newFrame) {
        this.frame = newFrame;
    }

    public static void main(String[] args) {
        MagFreqDistTesterApplet applet = new MagFreqDistTesterApplet();
        Color c = new Color(0.9f, 0.9f, 1.0f, 1.0f);
        Font f = new Font("Dialog", 0, 11);
        UIManager.put("ScrollBar.width", 12);
        UIManager.put("ScrollPane.width", 12);
        UIManager.put("PopupMenu.font", f);
        UIManager.put("Menu.font", f);
        UIManager.put("MenuItem.font", f);
        UIManager.put("ScrollBar.border", BorderFactory.createEtchedBorder(1));
        UIManager.put("PopupMenu.background", c);
        UIManager.put("Menu.background", c);
        UIManager.put("MenuItem.background", c);
        UIManager.put("MenuItem.disabledBackground", c);
        UIManager.put("MenuItem.margin", new Insets(0, 0, 0, 0));
        UIManager.put("ComboBox.background", c);
        applet.isStandalone = true;
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().add((Component)applet, "Center");
        applet.init();
        applet.setFrame(frame);
        frame.setTitle(applet.getAppletInfo() + " (Version:" + version + ")");
        frame.setSize(870, 730);
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        frame.setLocation((d.width - frame.getSize().width) / 2, (d.height - frame.getSize().height) / 2);
        frame.setVisible(true);
    }

    protected void initMagDistGui() {
        String S = "MagFreqDistTesterApplet: initMagDistGui(): ";
        this.rangeComboBox.addItem(AUTO_SCALE_ALL);
        this.rangeComboBox.addItem(INCR_AUTO_SCALE);
        this.rangeComboBox.addItem(CUM_AUTO_SCALE);
        this.rangeComboBox.addItem(MO_AUTO_SCALE);
        this.rangeComboBox.addItem(CUSTOM_SCALE);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        String S = "MagFreqDistTesterApplet: itemStateChanged(): ";
        if (e.getSource().equals(this.jCheckylog)) {
            this.clearPlot(false);
            this.inParameterChangeWarning = false;
            this.yLog = this.jCheckylog.isSelected();
            if (this.incrFunctions != null && this.incrData != null && this.toCumFunctions != null && this.toCumData != null && this.toMoFunctions != null && this.toMoData != null) {
                this.incrData.setYLog(this.yLog);
                this.toCumData.setYLog(this.yLog);
                this.toMoData.setYLog(this.yLog);
                this.pointsTextArea.setText("                   " + ((IncrementalMagFreqDist)this.magDist.getValue()).getName() + "             ");
                this.pointsTextArea.setText("\n");
                this.pointsTextArea.append(MAG + " vs. " + INCR_RATE + "\n" + this.incrFunctions.toString());
                this.pointsTextArea.append("\n\n");
                this.pointsTextArea.append(MAG + " vs. " + CUM_RATE + "\n" + this.toCumFunctions.toString());
                this.pointsTextArea.append("\n\n");
                this.pointsTextArea.append(MAG + " vs. " + MO_RATE + "\n" + this.toMoFunctions.toString());
                this.addGraphPanel();
            }
        } else if (e.getSource().equals(this.plotColorCheckBox)) {
            if (this.isWhite) {
                this.isWhite = false;
                if (this.incrPanel != null) {
                    this.incrPanel.getChart().getPlot().setBackgroundPaint((Paint)Color.black);
                }
                if (this.cumPanel != null) {
                    this.cumPanel.getChart().getPlot().setBackgroundPaint((Paint)Color.black);
                }
                if (this.moPanel != null) {
                    this.moPanel.getChart().getPlot().setBackgroundPaint((Paint)Color.black);
                }
                if (this.legendPane != null) {
                    this.legendPane.setBackground(Color.black);
                }
            } else {
                this.isWhite = true;
                if (this.incrPanel != null) {
                    this.incrPanel.getChart().getPlot().setBackgroundPaint((Paint)Color.white);
                }
                if (this.cumPanel != null) {
                    this.cumPanel.getChart().getPlot().setBackgroundPaint((Paint)Color.white);
                }
                if (this.moPanel != null) {
                    this.moPanel.getChart().getPlot().setBackgroundPaint((Paint)Color.white);
                }
                if (this.legendPane != null) {
                    this.legendPane.setBackground(Color.white);
                }
            }
        }
    }

    public String getCurrentMagDistName() {
        return this.currentMagDistName;
    }

    void clearPlot(boolean clearFunctions) {
        int loc;
        int newLoc = loc = this.mainSplitPane.getDividerLocation();
        this.titleSize = this.titlePanel.getHeight() + 6;
        this.innerPlotPanel.removeAll();
        this.pointsTextArea.setText(NO_PLOT_MSG);
        if (clearFunctions) {
            this.incrFunctions.clear();
            this.toCumFunctions.clear();
            this.toMoFunctions.clear();
            this.jCheckSumDist.setSelected(false);
        }
        if (!this.titlePanel.isVisible()) {
            this.titlePanel.setVisible(true);
        }
        if (this.titleLabel != null) {
            this.titleLabel.setText(this.currentMagDistName);
            this.titleLabel.validate();
            this.titleLabel.repaint();
        }
        this.validate();
        this.repaint();
        this.mainSplitPane.setDividerLocation(newLoc);
    }

    public String getAppletInfo() {
        return "MagFreqDist Tester Applet";
    }

    void addButton_actionPerformed(ActionEvent e) {
        this.addButton();
    }

    protected void addButton() {
        String S = "MagFreqDistTesterApplet: addButton(): ";
        try {
            this.magDistEditor.setMagDistFromParams();
            IncrementalMagFreqDist function = (IncrementalMagFreqDist)this.magDist.getValue();
            EvenlyDiscretizedFunc cumRate = function.getCumRateDist();
            EvenlyDiscretizedFunc moRate = function.getMomentRateDist();
            this.incrData.setYLog(this.yLog);
            this.toMoData.setYLog(this.yLog);
            this.toCumData.setYLog(this.yLog);
            if (!this.jCheckSumDist.isSelected()) {
                this.incrFunctions.add(function);
                this.toCumFunctions.add(cumRate);
                this.toMoFunctions.add(moRate);
            } else {
                try {
                    this.summedMagFreqDist.addIncrementalMagFreqDist(function);
                    this.incrFunctions.remove(0);
                    this.toCumFunctions.remove(0);
                    this.toMoFunctions.remove(0);
                    this.incrFunctions.add(function);
                    this.toCumFunctions.add(cumRate);
                    this.toMoFunctions.add(moRate);
                    this.insertSummedDistribution();
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(this, "min, max, and num must be the same to sum the distributions.\n To add this distribution first deselect the Summed Dist option");
                    return;
                }
            }
            this.pointsTextArea.setText(INCR_RATE + " vs. " + MAG + "\n--------------------------\n" + this.incrFunctions.toString());
            this.pointsTextArea.append("\n" + CUM_RATE + " vs. " + MAG + "\n-------------------------\n" + this.toCumFunctions.toString());
            this.pointsTextArea.append("\n" + MO_RATE + " vs. " + MAG + "\n-----------------------\n" + this.toMoFunctions.toString());
            this.addGraphPanel();
            if (this.titleLabel != null) {
                this.titleLabel.setText(this.currentMagDistName);
                this.titleLabel.validate();
                this.titleLabel.repaint();
            }
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this, new String("Enter a Valid Numerical Value"), "Invalid Data Entered", 0);
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, new String(e.getMessage()), "Invalid Data Entered", 0);
        }
    }

    protected void addGraphPanel() {
        String S = "MagFreqDistTesterApplet: addGraphPanel(): ";
        this.yLog = this.jCheckylog.isSelected();
        String incrXAxisLabel = this.incrFunctions.getXAxisName();
        String incrYAxisLabel = this.incrFunctions.getYAxisName();
        String cumXAxisLabel = this.toCumFunctions.getXAxisName();
        String cumYAxisLabel = this.toCumFunctions.getYAxisName();
        String moXAxisLabel = this.toMoFunctions.getXAxisName();
        String moYAxisLabel = this.toMoFunctions.getYAxisName();
        String title = this.getCurrentMagDistName();
        TickUnits units = MyTickUnits.createStandardTickUnits();
        this.incrXAxis = new NumberAxis(incrXAxisLabel);
        this.incrXAxis.setAutoRangeIncludesZero(false);
        this.incrXAxis.setStandardTickUnits((TickUnitSource)units);
        this.incrXAxis.setTickMarksVisible(false);
        this.cumXAxis = new NumberAxis(cumXAxisLabel);
        this.cumXAxis.setAutoRangeIncludesZero(false);
        this.cumXAxis.setStandardTickUnits((TickUnitSource)units);
        this.cumXAxis.setTickMarksVisible(false);
        this.moXAxis = new NumberAxis(moXAxisLabel);
        this.moXAxis.setAutoRangeIncludesZero(false);
        this.moXAxis.setStandardTickUnits((TickUnitSource)units);
        this.moXAxis.setTickMarksVisible(false);
        if (this.yLog) {
            this.incrYAxis = new LogarithmicAxis(incrYAxisLabel);
            this.cumYAxis = new LogarithmicAxis(cumYAxisLabel);
            this.moYAxis = new LogarithmicAxis(moYAxisLabel);
        } else {
            this.incrYAxis = new NumberAxis(incrYAxisLabel);
            this.cumYAxis = new NumberAxis(cumYAxisLabel);
            this.moYAxis = new NumberAxis(moYAxisLabel);
        }
        try {
            this.incrYAxis.setAutoRangeIncludesZero(true);
            this.incrYAxis.setStandardTickUnits((TickUnitSource)units);
            this.incrYAxis.setAutoRangeIncludesZero(false);
            this.incrYAxis.setAutoRangeStickyZero(true);
            this.incrYAxis.setAutoRangeMinimumSize(this.AUTO_RANGE_MINIMUM_SIZE);
            this.incrYAxis.setTickMarksVisible(false);
            this.cumYAxis.setAutoRangeIncludesZero(true);
            this.cumYAxis.setStandardTickUnits((TickUnitSource)units);
            this.cumYAxis.setAutoRangeIncludesZero(false);
            this.cumYAxis.setAutoRangeStickyZero(true);
            this.cumYAxis.setAutoRangeMinimumSize(this.AUTO_RANGE_MINIMUM_SIZE);
            this.cumYAxis.setTickMarksVisible(false);
            this.moYAxis.setAutoRangeIncludesZero(true);
            this.moYAxis.setStandardTickUnits((TickUnitSource)units);
            this.moYAxis.setAutoRangeIncludesZero(false);
            this.moYAxis.setAutoRangeStickyZero(true);
            this.moYAxis.setAutoRangeMinimumSize(this.AUTO_RANGE_MINIMUM_SIZE);
            this.moYAxis.setTickMarksVisible(false);
            int type = 2;
            StandardXYItemRenderer renderer = new StandardXYItemRenderer(type, (XYToolTipGenerator)new StandardXYToolTipGenerator());
            if (this.incrCustomAxis) {
                this.incrXAxis.setRange(this.xIncrMin, this.xIncrMax);
                this.incrYAxis.setRange(this.yIncrMin, this.yIncrMax);
            }
            if (this.cumCustomAxis) {
                this.cumXAxis.setRange(this.xCumMin, this.xCumMax);
                this.cumYAxis.setRange(this.yCumMin, this.yCumMax);
            }
            if (this.moCustomAxis) {
                this.moXAxis.setRange(this.xMoMin, this.xMoMax);
                this.moYAxis.setRange(this.yMoMin, this.yMoMax);
            }
            XYPlot incrPlot = new XYPlot((XYDataset)this.incrData, (ValueAxis)this.incrXAxis, (ValueAxis)this.incrYAxis, (XYItemRenderer)renderer);
            XYPlot cumPlot = new XYPlot((XYDataset)this.toCumData, (ValueAxis)this.cumXAxis, (ValueAxis)this.cumYAxis, (XYItemRenderer)renderer);
            XYPlot moPlot = new XYPlot((XYDataset)this.toMoData, (ValueAxis)this.moXAxis, (ValueAxis)this.moYAxis, (XYItemRenderer)renderer);
            incrPlot.setBackgroundAlpha(0.8f);
            incrPlot.setDomainCrosshairLockedOnData(false);
            incrPlot.setDomainCrosshairVisible(false);
            incrPlot.setRangeCrosshairLockedOnData(false);
            incrPlot.setRangeCrosshairVisible(false);
            cumPlot.setBackgroundAlpha(0.8f);
            cumPlot.setDomainCrosshairLockedOnData(false);
            cumPlot.setDomainCrosshairVisible(false);
            cumPlot.setRangeCrosshairLockedOnData(false);
            cumPlot.setRangeCrosshairVisible(false);
            moPlot.setBackgroundAlpha(0.8f);
            moPlot.setDomainCrosshairLockedOnData(false);
            moPlot.setDomainCrosshairVisible(false);
            moPlot.setRangeCrosshairLockedOnData(false);
            moPlot.setRangeCrosshairVisible(false);
            int numSeries = this.legendPaint.length;
            for (int i = 0; i < numSeries; ++i) {
                renderer.setSeriesPaint(i, this.legendPaint[i]);
            }
            if (this.isWhite) {
                incrPlot.setBackgroundPaint((Paint)Color.white);
                cumPlot.setBackgroundPaint((Paint)Color.white);
                moPlot.setBackgroundPaint((Paint)Color.white);
                this.legendPane.setBackground(Color.white);
            } else {
                incrPlot.setBackgroundPaint((Paint)Color.black);
                cumPlot.setBackgroundPaint((Paint)Color.black);
                moPlot.setBackgroundPaint((Paint)Color.black);
                this.legendPane.setBackground(Color.black);
            }
            incrPlot.setRenderer((XYItemRenderer)renderer);
            cumPlot.setRenderer((XYItemRenderer)renderer);
            moPlot.setRenderer((XYItemRenderer)renderer);
            JFreeChart incrChart = new JFreeChart(title, JFreeChart.DEFAULT_TITLE_FONT, (Plot)incrPlot, false);
            JFreeChart cumChart = new JFreeChart(title, JFreeChart.DEFAULT_TITLE_FONT, (Plot)cumPlot, false);
            JFreeChart moChart = new JFreeChart(title, JFreeChart.DEFAULT_TITLE_FONT, (Plot)moPlot, false);
            incrChart.setBackgroundPaint((Paint)this.lightBlue);
            cumChart.setBackgroundPaint((Paint)this.lightBlue);
            moChart.setBackgroundPaint((Paint)this.lightBlue);
            this.incrPanel = new ChartPanel(incrChart, true, true, true, true, false);
            this.cumPanel = new ChartPanel(cumChart, true, true, true, true, false);
            this.moPanel = new ChartPanel(moChart, true, true, true, true, false);
            this.legendPane.removeAll();
            this.legendPane.setEditable(false);
            this.setLegend = new SimpleAttributeSet();
            this.setLegend.addAttribute(StyleConstants.CharacterConstants.Bold, Boolean.TRUE);
            int numOfColors = incrPlot.getSeriesCount();
            StyledDocument doc = this.legendPane.getStyledDocument();
            try {
                doc.remove(0, doc.getLength());
                int i = 0;
                int j = 0;
                while (i < numOfColors) {
                    if (j == this.legendColor.length) {
                        j = 0;
                    }
                    this.legend = new String(i + 1 + ") " + ((XY_DataSet)this.incrFunctions.get(i)).getName() + ": " + ((XY_DataSet)this.incrFunctions.get(i)).getInfo() + "\n\n");
                    this.setLegend = new SimpleAttributeSet();
                    StyleConstants.setFontSize(this.setLegend, 12);
                    StyleConstants.setForeground(this.setLegend, this.legendColor[j]);
                    doc.insertString(doc.getLength(), this.legend, this.setLegend);
                    ++i;
                    ++j;
                }
            }
            catch (BadLocationException e) {
                return;
            }
            this.incrPanel.setBorder(BorderFactory.createEtchedBorder(1));
            this.incrPanel.setMouseZoomable(true);
            this.incrPanel.setDisplayToolTips(true);
            this.incrPanel.setHorizontalAxisTrace(false);
            this.incrPanel.setVerticalAxisTrace(false);
            this.cumPanel.setBorder(BorderFactory.createEtchedBorder(1));
            this.cumPanel.setMouseZoomable(true);
            this.cumPanel.setDisplayToolTips(true);
            this.cumPanel.setHorizontalAxisTrace(false);
            this.cumPanel.setVerticalAxisTrace(false);
            this.moPanel.setBorder(BorderFactory.createEtchedBorder(1));
            this.moPanel.setMouseZoomable(true);
            this.moPanel.setDisplayToolTips(true);
            this.moPanel.setHorizontalAxisTrace(false);
            this.moPanel.setVerticalAxisTrace(false);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Invalid Plot", 0);
            return;
        }
        this.graphOn = false;
        this.togglePlot();
    }

    protected void togglePlot() {
        String S = "MagFreqDistTesterApplet: togglePlot(): ";
        this.innerPlotPanel.removeAll();
        int loc = this.mainSplitPane.getDividerLocation();
        this.titleSize = this.titlePanel.getHeight() + 6;
        int newLoc = loc;
        if (this.graphOn) {
            this.toggleButton.setText("Show Plot");
            this.graphOn = false;
            if (!this.titlePanel.isVisible()) {
                this.titlePanel.setVisible(true);
            }
            this.innerPlotPanel.add((Component)this.dataScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, this.plotInsets, 0, 0));
        } else {
            this.graphOn = true;
            this.toggleButton.setText("Show Data");
            if (this.incrPanel != null) {
                if (this.titlePanel.isVisible()) {
                    this.titlePanel.setVisible(false);
                }
                this.innerPlotPanel.add((Component)this.incrPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
                this.innerPlotPanel.add((Component)this.cumPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
                this.innerPlotPanel.add((Component)this.moPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
                this.innerPlotPanel.add((Component)this.legendScrollPane, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            } else {
                if (!this.titlePanel.isVisible()) {
                    this.titlePanel.setVisible(true);
                }
                this.innerPlotPanel.add((Component)this.dataScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, this.plotInsets, 0, 0));
            }
        }
        this.mainSplitPane.setDividerLocation(newLoc);
        this.validate();
        this.repaint();
    }

    void clearButton_actionPerformed(ActionEvent e) {
        this.clearButton();
    }

    void clearButton() {
        this.clearPlot(true);
    }

    void toggleButton_actionPerformed(ActionEvent e) {
        this.togglePlot();
    }

    void rangeComboBox_actionPerformed(ActionEvent e) {
        String str = (String)this.rangeComboBox.getSelectedItem();
        if (str.equalsIgnoreCase(INCR_AUTO_SCALE)) {
            this.incrCustomAxis = false;
        } else if (str.equalsIgnoreCase(CUM_AUTO_SCALE)) {
            this.cumCustomAxis = false;
        } else if (str.equalsIgnoreCase(MO_AUTO_SCALE)) {
            this.moCustomAxis = false;
        } else if (str.equalsIgnoreCase(AUTO_SCALE_ALL)) {
            this.incrCustomAxis = false;
            this.cumCustomAxis = false;
            this.moCustomAxis = false;
        }
        if (!str.equalsIgnoreCase(CUSTOM_SCALE)) {
            this.addGraphPanel();
        }
        if (str.equalsIgnoreCase(CUSTOM_SCALE) && this.incrXAxis != null && this.incrYAxis != null) {
            Range rIncrX = this.incrXAxis.getRange();
            double xIncrMin = rIncrX.getLowerBound();
            double xIncrMax = rIncrX.getUpperBound();
            Range rIncrY = this.incrYAxis.getRange();
            double yIncrMin = rIncrY.getLowerBound();
            double yIncrMax = rIncrY.getUpperBound();
            Range rCumX = this.cumXAxis.getRange();
            double xCumMin = rCumX.getLowerBound();
            double xCumMax = rCumX.getUpperBound();
            Range rCumY = this.cumYAxis.getRange();
            double yCumMin = rCumY.getLowerBound();
            double yCumMax = rCumY.getUpperBound();
            Range rMoX = this.moXAxis.getRange();
            double xMoMin = rMoX.getLowerBound();
            double xMoMax = rMoX.getUpperBound();
            Range rMoY = this.moYAxis.getRange();
            double yMoMin = rMoY.getLowerBound();
            double yMoMax = rMoY.getUpperBound();
            MagFreqDistAxisScale axisScale = new MagFreqDistAxisScale(this, xIncrMin, xIncrMax, yIncrMin, yIncrMax, xCumMin, xCumMax, yCumMin, yCumMax, xMoMin, xMoMax, yMoMin, yMoMax);
            axisScale.setLocation(this.getX() + this.getWidth() / 2, this.getY() + this.getHeight() / 2);
            axisScale.pack();
            axisScale.setVisible(true);
        }
    }

    public void setXRange(double xIncrMin, double xIncrMax, double xCumMin, double xCumMax, double xMoMin, double xMoMax) {
        this.xIncrMin = xIncrMin;
        this.xIncrMax = xIncrMax;
        this.xCumMin = xCumMin;
        this.xCumMax = xCumMax;
        this.xMoMin = xMoMin;
        this.xMoMax = xMoMax;
        this.incrCustomAxis = true;
        this.moCustomAxis = true;
        this.cumCustomAxis = true;
    }

    public void setYRange(double yIncrMin, double yIncrMax, double yCumMin, double yCumMax, double yMoMin, double yMoMax) {
        this.yIncrMin = yIncrMin;
        this.yIncrMax = yIncrMax;
        this.yCumMin = yCumMin;
        this.yCumMax = yCumMax;
        this.yMoMin = yMoMin;
        this.yMoMax = yMoMax;
        this.incrCustomAxis = true;
        this.moCustomAxis = true;
        this.cumCustomAxis = true;
        this.addGraphPanel();
    }

    void jCheckSumDist_actionPerformed(ActionEvent e) {
        int k = 0;
        if (this.jCheckSumDist.isSelected()) {
            this.legendColor[k] = Color.red;
            this.legendPaint[k++] = Color.red;
            double min = this.magDistEditor.getMin();
            double max = this.magDistEditor.getMax();
            int num = this.magDistEditor.getNum();
            this.summedMagFreqDist = new SummedMagFreqDist(min, max, num);
            int size = this.incrFunctions.size();
            try {
                for (int i = 0; i < size; ++i) {
                    this.summedMagFreqDist.addIncrementalMagFreqDist((IncrementalMagFreqDist)this.incrFunctions.get(i));
                }
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, "min, max, and num must be the same to sum the distributions");
                this.jCheckSumDist.setSelected(false);
                return;
            }
            this.insertSummedDistribution();
        } else {
            this.incrFunctions.remove(0);
            this.toCumFunctions.remove(0);
            this.toMoFunctions.remove(0);
        }
        this.legendColor[k] = Color.blue;
        this.legendPaint[k++] = Color.blue;
        this.legendColor[k] = Color.green;
        this.legendPaint[k++] = Color.green;
        this.legendColor[k] = Color.orange;
        this.legendPaint[k++] = Color.orange;
        this.legendColor[k] = Color.magenta;
        this.legendPaint[k++] = Color.magenta;
        this.legendColor[k] = Color.cyan;
        this.legendPaint[k++] = Color.cyan;
        this.legendColor[k] = Color.pink;
        this.legendPaint[k++] = Color.pink;
        this.legendColor[k] = Color.yellow;
        this.legendPaint[k++] = Color.yellow;
        this.legendColor[k] = Color.darkGray;
        this.legendPaint[k++] = Color.darkGray;
        this.pointsTextArea.setText(INCR_RATE + " vs. " + MAG + "\n--------------------------\n" + this.incrFunctions.toString());
        this.pointsTextArea.append("\n" + CUM_RATE + " vs. " + MAG + "\n-------------------------\n" + this.toCumFunctions.toString());
        this.pointsTextArea.append("\n" + MO_RATE + " vs. " + MAG + "\n-----------------------\n" + this.toMoFunctions.toString());
        this.addGraphPanel();
    }

    private void insertSummedDistribution() {
        XY_DataSetList cloneIncrFunctions = this.incrFunctions.deepClone();
        XY_DataSetList cloneCumFunctions = this.toCumFunctions.deepClone();
        XY_DataSetList cloneMoFunctions = this.toMoFunctions.deepClone();
        this.incrFunctions.clear();
        this.toCumFunctions.clear();
        this.toMoFunctions.clear();
        this.incrFunctions.add(this.summedMagFreqDist);
        this.toCumFunctions.add(this.summedMagFreqDist.getCumRateDist());
        this.toMoFunctions.add(this.summedMagFreqDist.getMomentRateDist());
        int size = cloneIncrFunctions.size();
        for (int i = 0; i < size; ++i) {
            this.incrFunctions.add((XY_DataSet)cloneIncrFunctions.get(i));
            this.toCumFunctions.add((XY_DataSet)cloneCumFunctions.get(i));
            this.toMoFunctions.add((XY_DataSet)cloneMoFunctions.get(i));
        }
    }

    void imgLabel_mouseClicked(MouseEvent e) {
    }

    static {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

