/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.mapping;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.SystemUtils;
import org.opensha.commons.data.xyz.ArbDiscrGeoDataSet;
import org.opensha.commons.data.xyz.GeoDataSet;
import org.opensha.commons.data.xyz.XYZ_DataSet;
import org.opensha.commons.exceptions.GMT_MapException;
import org.opensha.commons.mapping.gmt.GMT_Map;
import org.opensha.commons.mapping.gmt.GMT_MapGenerator;
import org.opensha.commons.util.FileUtils;
import org.opensha.commons.util.RunScript;
import org.opensha.commons.util.ServerPrefUtils;
import org.opensha.sha.mapping.GMT_MapGeneratorForShakeMaps;

public class GMT_HazusMapServlet
extends HttpServlet {
    private static final String GMT_SCRIPT_FILE = "gmtScript.txt";
    public static final String GMT_URL_PATH = "https://" + ServerPrefUtils.SERVER_PREFS.getHostName() + "/gmtData/";
    public static final File GMT_DATA_DIR = new File(ServerPrefUtils.SERVER_PREFS.getTempDir(), "gmtData");
    private GMT_MapGenerator gmt = new GMT_MapGenerator();

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ObjectOutputStream outputToApplet = new ObjectOutputStream((OutputStream)response.getOutputStream());
        Object outFile = null;
        try {
            if (!GMT_DATA_DIR.exists()) {
                GMT_DATA_DIR.mkdir();
            }
            ObjectInputStream inputFromApplet = new ObjectInputStream((InputStream)request.getInputStream());
            String dirName = (String)inputFromApplet.readObject();
            GMT_Map[] maps = (GMT_Map[])inputFromApplet.readObject();
            String metadata = (String)inputFromApplet.readObject();
            String metadataFileName = (String)inputFromApplet.readObject();
            String mapImagePath = GMT_HazusMapServlet.createMap(this.gmt, maps, dirName, metadata, metadataFileName);
            outputToApplet.writeObject(mapImagePath);
            outputToApplet.close();
        }
        catch (Throwable t) {
            t.printStackTrace();
            outputToApplet.writeObject(new RuntimeException(t));
            outputToApplet.close();
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    public static String createMap(GMT_MapGenerator gmt, GMT_Map[] maps, String plotDirName, String metadata, String metadataFileName) throws IOException, GMT_MapException {
        File newDir = null;
        String currentMilliSec = "" + System.currentTimeMillis();
        if (plotDirName != null) {
            File f = new File((String)plotDirName);
            int fileCounter = 1;
            while (f.exists()) {
                String tempDirName = (String)plotDirName + fileCounter;
                f = new File(tempDirName);
                ++fileCounter;
            }
            newDir = new File(GMT_DATA_DIR, f.getName());
        } else {
            plotDirName = currentMilliSec;
            newDir = new File(GMT_DATA_DIR, currentMilliSec);
        }
        newDir.mkdir();
        String gmtScriptFile = String.valueOf(newDir) + "/gmtScript.txt";
        FileWriter fw = new FileWriter(gmtScriptFile);
        BufferedWriter bw = new BufferedWriter(fw);
        ArrayList<String> hazusFileNames = new ArrayList<String>();
        for (int i = 0; i < 4; ++i) {
            String hazusPrefix;
            String imt;
            GMT_Map map = maps[i];
            if (i == 0) {
                imt = "SA";
                hazusPrefix = "sa03";
            } else if (i == 1) {
                imt = "SA";
                hazusPrefix = "sa10";
            } else if (i == 2) {
                imt = "PGA";
                hazusPrefix = "pga";
            } else {
                imt = "PGV";
                hazusPrefix = "pgv";
            }
            ArrayList<String> gmtMapScript = gmt.getGMT_ScriptLines(map, newDir.getAbsolutePath());
            hazusFileNames.add(hazusPrefix + ".shp");
            hazusFileNames.add(hazusPrefix + ".shx");
            hazusFileNames.add(hazusPrefix + ".dbf");
            GMT_MapGeneratorForShakeMaps.addHAZUS_Lines(gmtMapScript, map, imt, hazusPrefix);
            int size = gmtMapScript.size();
            for (int j = 0; j < size; ++j) {
                bw.write(gmtMapScript.get(j) + "\n");
            }
            GeoDataSet griddedData = map.getGriddedData();
            size = griddedData.size();
            ArbDiscrGeoDataSet.writeXYZFile((XYZ_DataSet)griddedData, String.valueOf(newDir) + "/" + new File(map.getXyzFileName()).getName());
        }
        bw.close();
        String[] command = new String[]{"sh", "-c", "/bin/bash " + gmtScriptFile};
        RunScript.runScript(command);
        String metadataFile = String.valueOf(newDir) + "/" + new File(metadataFileName).getName();
        fw = new FileWriter(metadataFile);
        bw = new BufferedWriter(fw);
        bw.write(" " + metadata + "\n");
        bw.close();
        FileUtils.createZipFile(newDir.getAbsolutePath());
        String hazusZipName = String.valueOf(newDir) + "/HAZUS.zip";
        FileUtils.createZipFile(hazusZipName, newDir.getAbsolutePath(), hazusFileNames);
        String mapImagePath = GMT_URL_PATH + (String)plotDirName + SystemUtils.FILE_SEPARATOR;
        return mapImagePath;
    }
}

