/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.param;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.ListIterator;
import org.dom4j.Element;
import org.opensha.commons.exceptions.ConstraintException;
import org.opensha.commons.exceptions.EditableException;
import org.opensha.commons.exceptions.ParameterException;
import org.opensha.commons.param.AbstractParameter;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.constraint.ParameterConstraint;
import org.opensha.commons.param.editor.AbstractParameterEditorOld;
import org.opensha.commons.param.impl.DoubleParameter;
import org.opensha.commons.param.impl.EvenlyDiscretizedFuncParameter;
import org.opensha.commons.param.impl.IntegerParameter;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.sha.magdist.ArbIncrementalMagFreqDist;
import org.opensha.sha.magdist.GaussianMagFreqDist;
import org.opensha.sha.magdist.GutenbergRichterMagFreqDist;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import org.opensha.sha.magdist.SingleMagFreqDist;
import org.opensha.sha.magdist.YC_1985_CharMagFreqDist;
import org.opensha.sha.param.MagDistStringParameter;
import org.opensha.sha.param.MagPDF_Constraint;
import org.opensha.sha.param.editor.MagPDF_ParameterEditor;

public class MagPDF_Parameter
extends AbstractParameter
implements Serializable {
    protected static final String C = "MagPDF_Parameter";
    protected static final boolean D = false;
    public static final String DISTRIBUTION_NAME = "Distribution Type";
    public static final String MIN = new String("Min");
    public static final String MIN_INFO = new String("Minimum magnitude of the discetized function");
    public static final String MAX = new String("Max");
    public static final String MAX_INFO = new String("Maximum magnitude of the discetized function");
    public static final String NUM = new String("Num");
    public static final String NUM_INFO = new String("Number of points in  the discetized function");
    public static final String GR_MAG_UPPER = new String("Mag Upper");
    public static final String GR_MAG_UPPER_INFO = new String("Magnitude of the last non-zero rate");
    public static final String GR_MAG_LOWER = new String("Mag Lower");
    public static final String GR_MAG_LOWER_INFO = new String("Magnitude of the first non-zero rate");
    public static final String GR_BVALUE = new String("b Value");
    public static final String BVALUE_INFO = new String("b in: log(rate) = a-b*magnitude");
    public static final String MAG = new String("Mag");
    public static final String YC_DELTA_MAG_CHAR = new String("Delta Mag Char");
    public static final String YC_DELTA_MAG_CHAR_INFO = new String("Width of the characteristic part (below Mag Upper)");
    public static final String YC_MAG_PRIME = new String("Mag Prime");
    public static final String YC_MAG_PRIME_INFO = new String("Last magnitude of the GR part");
    public static final String YC_DELTA_MAG_PRIME = new String("Delta Mag Prime");
    public static final String YC_DELTA_MAG_PRIME_INFO = new String("Distance below Mag Prime where rate on GR equals that on the char. part");
    public static final String MEAN = new String("Mean");
    public static final String STD_DEV = new String("Std Dev");
    public static final String TRUNCATION_REQ = new String("Truncation Type");
    public static final String TRUNCATE_UPPER_ONLY = new String("Upper");
    public static final String TRUNCATE_ON_BOTH_SIDES = new String("Upper and Lower");
    public static final String TRUNCATE_NUM_OF_STD_DEV = new String("Truncation Level(# of Std Devs)");
    public static final String NONE = new String("None");
    private ParameterList parameterList = new ParameterList();
    private EvenlyDiscretizedFuncParameter evenlyDiscrtizedFunc;
    public static final String ARB_INCR_PARAM_NAME = " Arb. Incremental Mag Dist";
    private transient AbstractParameterEditorOld paramEdit = null;

    public MagPDF_Parameter(String name) {
        super(name, null, null, null);
        this.initAdjustableParams();
    }

    public MagPDF_Parameter(String name, ArrayList allowedMagDists) throws ConstraintException {
        super(name, new MagPDF_Constraint(allowedMagDists), null, null);
        this.initAdjustableParams();
    }

    public MagPDF_Parameter(String name, MagPDF_Constraint constraint) throws ConstraintException {
        super(name, constraint, null, null);
        this.initAdjustableParams();
    }

    public MagPDF_Parameter(String name, IncrementalMagFreqDist value) {
        super(name, null, null, value);
        this.initAdjustableParams();
    }

    public MagPDF_Parameter(String name, ArrayList allowedMagDists, IncrementalMagFreqDist value) throws ConstraintException {
        super(name, new MagPDF_Constraint(allowedMagDists), null, value);
        this.initAdjustableParams();
    }

    public MagPDF_Parameter(String name, MagPDF_Constraint constraint, IncrementalMagFreqDist value) throws ConstraintException {
        super(name, constraint, null, value);
        this.initAdjustableParams();
    }

    @Override
    public void setConstraint(ParameterConstraint constraint) throws ParameterException, EditableException {
        String S = "MagPDF_Parameter: setConstraint(): ";
        this.checkEditable(S);
        if (!(constraint instanceof MagPDF_Constraint)) {
            throw new ParameterException(S + "This parameter only accepts a MagPDF_Constraint, unable to set the constraint.");
        }
        super.setConstraint(constraint);
    }

    public ArrayList getAllowedMagPDFs() {
        if (this.constraint != null) {
            return ((MagPDF_Constraint)this.constraint).getAllowedMagDists();
        }
        return null;
    }

    @Override
    public int compareTo(Object obj) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("This method not implemented yet");
    }

    @Override
    public void setValue(IncrementalMagFreqDist value) throws ConstraintException, ParameterException {
        this.setValue(value);
    }

    @Override
    public boolean isAllowed(IncrementalMagFreqDist d) {
        return this.isAllowed(d);
    }

    @Override
    public boolean equals(Object obj) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("This method not implemented yet");
    }

    @Override
    public Object clone() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("This method not implemented yet");
    }

    @Override
    public String getType() {
        String type = C;
        return type;
    }

    public ParameterList getAdjustableParams() {
        return this.parameterList;
    }

    private void initAdjustableParams() {
        MagDistStringParameter distributionName = new MagDistStringParameter(DISTRIBUTION_NAME, this.getAllowedMagPDFs(), (String)this.getAllowedMagPDFs().get(0));
        DoubleParameter minParameter = new DoubleParameter(MIN, 0.0);
        minParameter.setInfo(MIN_INFO);
        DoubleParameter maxParameter = new DoubleParameter(MAX, 10.0);
        maxParameter.setInfo(MAX_INFO);
        IntegerParameter numParameter = new IntegerParameter(NUM, 0, Integer.MAX_VALUE, (Integer)101);
        numParameter.setInfo(NUM_INFO);
        DoubleParameter magLower = new DoubleParameter(GR_MAG_LOWER, 5.0);
        magLower.setInfo(GR_MAG_LOWER_INFO);
        DoubleParameter magUpper = new DoubleParameter(GR_MAG_UPPER, 8.0);
        magUpper.setInfo(GR_MAG_UPPER_INFO);
        DoubleParameter bValue = new DoubleParameter(GR_BVALUE, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, (Double)1.0);
        bValue.setInfo(BVALUE_INFO);
        DoubleParameter mag = new DoubleParameter(MAG, 8.0);
        DoubleParameter mean = new DoubleParameter(MEAN, 8.0);
        DoubleParameter stdDev = new DoubleParameter(STD_DEV, 0.0, Double.POSITIVE_INFINITY, (Double)0.25);
        ArrayList<String> vStrings = new ArrayList<String>();
        vStrings.add(NONE);
        vStrings.add(TRUNCATE_UPPER_ONLY);
        vStrings.add(TRUNCATE_ON_BOTH_SIDES);
        StringParameter truncType = new StringParameter(TRUNCATION_REQ, vStrings, TRUNCATE_UPPER_ONLY);
        DoubleParameter truncLevel = new DoubleParameter(TRUNCATE_NUM_OF_STD_DEV, 0.0, Double.POSITIVE_INFINITY, (Double)1.0);
        DoubleParameter deltaMagChar = new DoubleParameter(YC_DELTA_MAG_CHAR, 0.0, Double.POSITIVE_INFINITY, (Double)1.0);
        deltaMagChar.setInfo(YC_DELTA_MAG_CHAR_INFO);
        DoubleParameter magPrime = new DoubleParameter(YC_MAG_PRIME, 7.0);
        magPrime.setInfo(YC_MAG_PRIME_INFO);
        DoubleParameter deltaMagPrime = new DoubleParameter(YC_DELTA_MAG_PRIME, 0.0, Double.POSITIVE_INFINITY, (Double)1.0);
        deltaMagPrime.setInfo(YC_DELTA_MAG_PRIME_INFO);
        this.parameterList.addParameter(distributionName);
        this.parameterList.addParameter(minParameter);
        this.parameterList.addParameter(numParameter);
        this.parameterList.addParameter(maxParameter);
        this.parameterList.addParameter(magLower);
        this.parameterList.addParameter(magUpper);
        this.parameterList.addParameter(bValue);
        this.parameterList.addParameter(deltaMagChar);
        this.parameterList.addParameter(magPrime);
        this.parameterList.addParameter(deltaMagPrime);
        this.parameterList.addParameter(mean);
        this.parameterList.addParameter(stdDev);
        this.parameterList.addParameter(truncType);
        this.parameterList.addParameter(truncLevel);
        this.parameterList.addParameter(mag);
        this.initArbIncrementalMagFreqDist();
        this.parameterList.addParameter(this.evenlyDiscrtizedFunc);
    }

    private void initArbIncrementalMagFreqDist() {
        ArbIncrementalMagFreqDist arbIncrDist = new ArbIncrementalMagFreqDist(0.0, 10.0, 101);
        this.evenlyDiscrtizedFunc = new EvenlyDiscretizedFuncParameter(ARB_INCR_PARAM_NAME, arbIncrDist);
    }

    public void setMagDist(ParameterList newParamList) {
        ListIterator<Parameter<?>> it = newParamList.getParametersIterator();
        while (it.hasNext()) {
            Parameter<?> tempParam = it.next();
            this.parameterList.getParameter(tempParam.getName()).setValue(tempParam.getValue());
        }
        this.setMagDist();
    }

    public void setMagDist() {
        IncrementalMagFreqDist magDist;
        ParameterList independentParamList;
        block32: {
            String S = "MagPDF_Parameter: getMagDist():";
            String distributionName = this.parameterList.getParameter(DISTRIBUTION_NAME).getValue().toString();
            independentParamList = new ParameterList();
            independentParamList.addParameter(this.parameterList.getParameter(DISTRIBUTION_NAME));
            magDist = null;
            try {
                int trialInt;
                Double min = (Double)this.parameterList.getParameter(MIN).getValue();
                Double max = (Double)this.parameterList.getParameter(MAX).getValue();
                Integer num = (Integer)this.parameterList.getParameter(NUM).getValue();
                if (min > max) {
                    throw new RuntimeException("Min Value cannot be less than the Max Value");
                }
                independentParamList.addParameter(this.parameterList.getParameter(MIN));
                independentParamList.addParameter(this.parameterList.getParameter(MAX));
                independentParamList.addParameter(this.parameterList.getParameter(NUM));
                if (distributionName.equalsIgnoreCase(SingleMagFreqDist.NAME)) {
                    SingleMagFreqDist single = new SingleMagFreqDist((double)min, max, num);
                    double mag = (Double)this.parameterList.getParameter(MAG).getValue();
                    if (mag > max || mag < min) {
                        throw new RuntimeException("Value of Mag must lie between the min and max value");
                    }
                    independentParamList.addParameter(this.parameterList.getParameter(MAG));
                    try {
                        single.setMagAndRate(mag, 1.0);
                    }
                    catch (RuntimeException e) {
                        throw new RuntimeException("The chosen magnitude must fall on one of the discrete x-axis values");
                    }
                    magDist = single;
                    break block32;
                }
                if (distributionName.equalsIgnoreCase(GaussianMagFreqDist.NAME)) {
                    Double mean = (Double)this.parameterList.getParameter(MEAN).getValue();
                    Double stdDev = (Double)this.parameterList.getParameter(STD_DEV).getValue();
                    String truncTypeValue = this.parameterList.getParameter(TRUNCATION_REQ).getValue().toString();
                    if (mean > max || mean < min) {
                        throw new RuntimeException("Value of Mean must lie between the min and max value");
                    }
                    independentParamList.addParameter(this.parameterList.getParameter(MEAN));
                    independentParamList.addParameter(this.parameterList.getParameter(STD_DEV));
                    independentParamList.addParameter(this.parameterList.getParameter(TRUNCATION_REQ));
                    int truncType = 0;
                    if (truncTypeValue.equalsIgnoreCase(TRUNCATE_UPPER_ONLY)) {
                        truncType = 1;
                    } else if (truncTypeValue.equalsIgnoreCase(TRUNCATE_ON_BOTH_SIDES)) {
                        truncType = 2;
                    }
                    Double truncLevel = Double.NaN;
                    if (truncType != 0) {
                        truncLevel = (Double)this.parameterList.getParameter(TRUNCATE_NUM_OF_STD_DEV).getValue();
                        independentParamList.addParameter(this.parameterList.getParameter(TRUNCATE_NUM_OF_STD_DEV));
                    }
                    GaussianMagFreqDist gaussian = new GaussianMagFreqDist((double)min, max, num);
                    gaussian.setAllButTotMoRate(mean, stdDev, 1.0, truncLevel, truncType);
                    magDist = gaussian;
                    break block32;
                }
                if (distributionName.equalsIgnoreCase(GutenbergRichterMagFreqDist.NAME)) {
                    GutenbergRichterMagFreqDist gR = new GutenbergRichterMagFreqDist((double)min, max, num);
                    Double bValue = (Double)this.parameterList.getParameter(GR_BVALUE).getValue();
                    Double magLower = (Double)this.parameterList.getParameter(GR_MAG_LOWER).getValue();
                    if (magLower > max || magLower < min) {
                        throw new RuntimeException("Value of MagLower must lie between the min and max value");
                    }
                    Double magUpper = (Double)this.parameterList.getParameter(GR_MAG_UPPER).getValue();
                    if (magUpper > max || magUpper < min) {
                        throw new RuntimeException("Value of MagUpper must lie between the min and max value");
                    }
                    if (magLower > magUpper) {
                        throw new RuntimeException("Value of MagLower must be <= to MagUpper");
                    }
                    try {
                        gR.setAllButTotMoRate(magLower, magUpper, 1.0, bValue);
                    }
                    catch (RuntimeException e) {
                        throw new RuntimeException("magUpper and MagLower must fall on one of the discrete x-axis values");
                    }
                    independentParamList.addParameter(this.parameterList.getParameter(GR_MAG_UPPER));
                    independentParamList.addParameter(this.parameterList.getParameter(GR_MAG_LOWER));
                    independentParamList.addParameter(this.parameterList.getParameter(GR_BVALUE));
                    magDist = gR;
                    break block32;
                }
                if (!distributionName.equalsIgnoreCase(YC_1985_CharMagFreqDist.NAME)) break block32;
                double magLower = (Double)this.parameterList.getParameter(GR_MAG_LOWER).getValue();
                double magUpper = (Double)this.parameterList.getParameter(GR_MAG_UPPER).getValue();
                double deltaMagChar = (Double)this.parameterList.getParameter(YC_DELTA_MAG_CHAR).getValue();
                double magPrime = (Double)this.parameterList.getParameter(YC_MAG_PRIME).getValue();
                double deltaMagPrime = (Double)this.parameterList.getParameter(YC_DELTA_MAG_PRIME).getValue();
                double bValue = (Double)this.parameterList.getParameter(GR_BVALUE).getValue();
                if (magLower > max || magLower < min) {
                    throw new RuntimeException("Value of MagLower must lie between the min and max value");
                }
                if (magUpper > max || magUpper < min) {
                    throw new RuntimeException("Value of MagUpper must lie between the min and max value");
                }
                YC_1985_CharMagFreqDist yc = new YC_1985_CharMagFreqDist((double)min, max, num);
                try {
                    trialInt = yc.getXIndex(magLower);
                }
                catch (RuntimeException e) {
                    throw new RuntimeException("MagLower must fall on one of the discrete x-axis values");
                }
                try {
                    trialInt = yc.getXIndex(magUpper);
                }
                catch (RuntimeException e) {
                    throw new RuntimeException("MagUpper must fall on one of the discrete x-axis values");
                }
                try {
                    trialInt = yc.getXIndex(magPrime);
                }
                catch (RuntimeException e) {
                    throw new RuntimeException("MagPrime must fall on one of the discrete x-axis values");
                }
                try {
                    trialInt = yc.getXIndex(magPrime - deltaMagPrime);
                }
                catch (RuntimeException e) {
                    throw new RuntimeException("MagPrime-DeltaMagPrime must fall on one of the discrete x-axis values");
                }
                try {
                    trialInt = yc.getXIndex(magUpper - deltaMagChar);
                }
                catch (RuntimeException e) {
                    throw new RuntimeException("MagUpper-DeltaMagChar must fall on one of the discrete x-axis values");
                }
                independentParamList.addParameter(this.parameterList.getParameter(GR_MAG_LOWER));
                independentParamList.addParameter(this.parameterList.getParameter(GR_MAG_UPPER));
                independentParamList.addParameter(this.parameterList.getParameter(YC_DELTA_MAG_CHAR));
                independentParamList.addParameter(this.parameterList.getParameter(YC_MAG_PRIME));
                independentParamList.addParameter(this.parameterList.getParameter(YC_DELTA_MAG_PRIME));
                independentParamList.addParameter(this.parameterList.getParameter(GR_BVALUE));
                yc.setAllButTotMoRate(magLower, magUpper, deltaMagChar, magPrime, deltaMagPrime, bValue, 1.0);
                yc.normalizeByTotalRate();
                magDist = yc;
            }
            catch (NumberFormatException e) {
                throw new NumberFormatException("Value entered must be a valid Numerical Value");
            }
            catch (NullPointerException e) {
                throw new NullPointerException("Enter All values");
            }
        }
        this.setValue(magDist);
        this.setIndependentParameters(independentParamList);
    }

    @Override
    public String getMetadataString() {
        return this.getDependentParamMetadataString();
    }

    @Override
    public boolean setIndividualParamValueFromXML(Element el) {
        return false;
    }

    @Override
    public AbstractParameterEditorOld getEditor() {
        if (this.paramEdit == null) {
            this.paramEdit = new MagPDF_ParameterEditor(this);
        }
        return this.paramEdit;
    }

    @Override
    public boolean isEditorBuilt() {
        return this.paramEdit != null;
    }
}

