/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.simulators;

import com.google.common.base.Preconditions;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.sha.earthquake.FocalMechanism;
import org.opensha.sha.faultSurface.RuptureSurface;
import org.opensha.sha.simulators.SimulatorElement;
import org.opensha.sha.simulators.TriangularElementSurface;
import org.opensha.sha.simulators.Vertex;

public class TriangularElement
extends SimulatorElement {
    private Location center;
    private double[] lengths;
    private TriangularElementSurface surf;

    public TriangularElement(int id, Vertex[] vertices, String sectionName, int faultID, int sectionID, int numAlongStrike, int numDownDip, double slipRate, double aseisFactor, FocalMechanism focalMechanism) {
        super(id, vertices, sectionName, faultID, sectionID, numAlongStrike, numDownDip, slipRate, aseisFactor, focalMechanism);
        Preconditions.checkArgument((vertices.length == 3 ? 1 : 0) != 0, (Object)"TriangularElement: vertices.length should equal 3");
    }

    private synchronized double[] getLengths() {
        if (this.lengths == null) {
            this.lengths = new double[3];
            for (int i = 0; i < 3; ++i) {
                int i1 = i;
                int i2 = i == 2 ? 0 : i + 1;
                this.lengths[i] = LocationUtils.linearDistanceFast(this.vertices[i1], this.vertices[i2]) * 1000.0;
            }
        }
        return this.lengths;
    }

    @Override
    public synchronized double getArea() {
        double[] lengths = this.getLengths();
        double s = 0.5 * (lengths[0] + lengths[1] + lengths[2]);
        return Math.sqrt(s * (s - lengths[0]) * (s - lengths[1]) * (s - lengths[2]));
    }

    @Override
    public double getAveDAS() {
        return (this.vertices[0].getDAS() + this.vertices[1].getDAS() + this.vertices[2].getDAS()) / 3.0;
    }

    @Override
    public double getAveDepth() {
        return this.getCenterLocation().getDepth();
    }

    @Override
    public synchronized RuptureSurface getSurface() {
        if (this.surf == null) {
            Vertex[] v = this.getVertices();
            this.surf = new TriangularElementSurface(v[0], v[1], v[2]);
        }
        return this.surf;
    }

    @Override
    public synchronized Location getCenterLocation() {
        if (this.center == null) {
            double aveLat = (this.vertices[0].getLatitude() + this.vertices[1].getLatitude() + this.vertices[2].getLatitude()) / 3.0;
            double aveLon = (this.vertices[0].getLongitude() + this.vertices[1].getLongitude() + this.vertices[2].getLongitude()) / 3.0;
            double aveDep = (this.vertices[0].getDepth() + this.vertices[1].getDepth() + this.vertices[2].getDepth()) / 3.0;
            this.center = new Location(aveLat, aveLon, aveDep);
        }
        return this.center;
    }
}

