/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.simulators;

import java.util.ListIterator;
import org.apache.commons.math3.stat.StatUtils;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.geo.LocationVector;
import org.opensha.commons.geo.Region;
import org.opensha.commons.util.DataUtils;
import org.opensha.sha.faultSurface.FaultTrace;
import org.opensha.sha.faultSurface.RuptureSurface;

class TriangularElementSurface
implements RuptureSurface {
    private Location a;
    private Location b;
    private Location c;
    private Location center;
    private LocationList perimeter;
    private double ab;
    private double bc;
    private double ca;
    private double perimeterLen;
    private double area;

    public TriangularElementSurface(Location a, Location b, Location c) {
        this.a = a;
        this.b = b;
        this.c = c;
        this.center = new Location(TriangularElementSurface.mean(a.getLatitude(), b.getLatitude(), c.getLatitude()), TriangularElementSurface.mean(a.getLongitude(), b.getLongitude(), c.getLongitude()), TriangularElementSurface.mean(a.getDepth(), b.getDepth(), c.getDepth()));
        this.perimeter = new LocationList();
        this.perimeter.add(a);
        this.perimeter.add(b);
        this.perimeter.add(c);
        this.ab = LocationUtils.linearDistanceFast(a, b);
        this.bc = LocationUtils.linearDistanceFast(b, c);
        this.ca = LocationUtils.linearDistanceFast(c, a);
        this.perimeterLen = this.ab + this.bc + this.ca;
        double s = this.perimeterLen / 2.0;
        this.area = Math.sqrt(s * (s - this.ab) * (s - this.bc) * (s - this.ca));
    }

    private static double mean(double ... vals) {
        return StatUtils.mean((double[])vals);
    }

    private static double min(double ... vals) {
        return StatUtils.min((double[])vals);
    }

    @Override
    public double getAveDip() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public double getAveStrike() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public double getAveLength() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public double getAveWidth() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public double getArea() {
        return this.area;
    }

    @Override
    public double getAreaInsideRegion(Region region) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public LocationList getEvenlyDiscritizedListOfLocsOnSurface() {
        return this.perimeter;
    }

    @Override
    public ListIterator<Location> getLocationsIterator() {
        return this.perimeter.listIterator();
    }

    @Override
    public LocationList getEvenlyDiscritizedPerimeter() {
        return this.perimeter;
    }

    @Override
    public FaultTrace getEvenlyDiscritizedUpperEdge() {
        return null;
    }

    @Override
    public LocationList getEvenlyDiscritizedLowerEdge() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public double getAveGridSpacing() {
        return TriangularElementSurface.mean(this.ab, this.bc, this.ca);
    }

    @Override
    public double getDistanceRup(Location siteLoc) {
        return TriangularElementSurface.min(LocationUtils.linearDistanceFast(this.a, siteLoc), LocationUtils.linearDistanceFast(this.b, siteLoc), LocationUtils.linearDistanceFast(this.c, siteLoc), LocationUtils.linearDistanceFast(this.center, siteLoc));
    }

    @Override
    public double getQuickDistance(Location siteLoc) {
        return this.getDistanceRup(siteLoc);
    }

    @Override
    public double getDistanceJB(Location siteLoc) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public double getDistanceSeis(Location siteLoc) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public double getDistanceX(Location siteLoc) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public double getAveRupTopDepth() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public double getAveDipDirection() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public FaultTrace getUpperEdge() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public LocationList getPerimeter() {
        return this.perimeter;
    }

    @Override
    public Location getFirstLocOnUpperEdge() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public Location getLastLocOnUpperEdge() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public double getFractionOfSurfaceInRegion(Region region) {
        double third = 0.3333333333333333;
        double ret = 0.0;
        if (region.contains(this.a)) {
            ret += third;
        }
        if (region.contains(this.b)) {
            ret += third;
        }
        if (region.contains(this.c)) {
            ret += third;
        }
        return ret;
    }

    @Override
    public String getInfo() {
        return "TriangularElementSurface[" + String.valueOf(this.a) + ", " + String.valueOf(this.b) + ", " + String.valueOf(this.c) + "]";
    }

    @Override
    public boolean isPointSurface() {
        return false;
    }

    @Override
    public double getMinDistance(RuptureSurface surface) {
        DataUtils.MinMaxAveTracker track = new DataUtils.MinMaxAveTracker();
        for (Location loc : surface.getEvenlyDiscritizedListOfLocsOnSurface()) {
            track.addValue(this.getDistanceRup(loc));
        }
        return track.getMin();
    }

    @Override
    public RuptureSurface getMoved(LocationVector v) {
        Location a2 = LocationUtils.location(this.a, v);
        Location b2 = LocationUtils.location(this.b, v);
        Location c2 = LocationUtils.location(this.c, v);
        return new TriangularElementSurface(a2, b2, c2);
    }

    @Override
    public RuptureSurface copyShallow() {
        return new TriangularElementSurface(this.a, this.b, this.c);
    }
}

