/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.simulators.distCalc;

import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.geo.LocationVector;
import org.opensha.commons.geo.Region;
import org.opensha.sha.faultSurface.FaultTrace;
import org.opensha.sha.faultSurface.RuptureSurface;
import org.opensha.sha.faultSurface.cache.CacheEnabledSurface;
import org.opensha.sha.faultSurface.cache.SurfaceCachingPolicy;
import org.opensha.sha.faultSurface.cache.SurfaceDistanceCache;
import org.opensha.sha.faultSurface.cache.SurfaceDistances;
import org.opensha.sha.simulators.SimulatorElement;
import org.opensha.sha.simulators.SimulatorEvent;
import org.opensha.sha.simulators.Vertex;
import org.opensha.sha.simulators.distCalc.SimRuptureDistCalcUtils;

public class SimEventCumDistFuncSurface
implements CacheEnabledSurface {
    private SimulatorEvent event;
    private SimRuptureDistCalcUtils.Scalar scalar;
    private double fractThreshold;
    private double absThreshold;
    private double fractThresholdX;
    private List<SimulatorElement> elems;
    private double[] slips;
    private SurfaceDistanceCache cache = SurfaceCachingPolicy.build(this);
    private double dip = Double.NaN;
    private double zTOR = Double.NaN;
    private double ddw = Double.NaN;
    private double area = Double.NaN;
    private SimRuptureDistCalcUtils.LocationElementDistanceCacheFactory locCacheFactory;

    public SimEventCumDistFuncSurface(SimulatorEvent event, SimRuptureDistCalcUtils.Scalar scalar, double fractThreshold, double absThreshold, double fractThresholdX) {
        this(event, scalar, fractThreshold, absThreshold, fractThresholdX, new SimRuptureDistCalcUtils.LocationElementDistanceCacheFactory());
    }

    public SimEventCumDistFuncSurface(SimulatorEvent event, SimRuptureDistCalcUtils.Scalar scalar, double fractThreshold, double absThreshold, double fractThresholdX, SimRuptureDistCalcUtils.LocationElementDistanceCacheFactory locCacheFactory) {
        this.event = event;
        this.scalar = scalar;
        this.fractThreshold = fractThreshold;
        this.absThreshold = absThreshold;
        this.fractThresholdX = fractThresholdX;
        this.locCacheFactory = locCacheFactory;
        this.elems = event.getAllElements();
        this.slips = event.getAllElementSlips();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkInitAvgQuantities() {
        if (Double.isNaN(this.dip)) {
            SimEventCumDistFuncSurface simEventCumDistFuncSurface = this;
            synchronized (simEventCumDistFuncSurface) {
                double dip;
                if (Double.isFinite(this.dip)) {
                    return;
                }
                double sumDipWeight = 0.0;
                double sumWeightedDip = 0.0;
                HashMap<Integer, double[]> sectDepthsMap = new HashMap<Integer, double[]>();
                HashMap<Integer, Double> sectDipsMap = new HashMap<Integer, Double>();
                HashMap<Integer, Double> sectWeights = new HashMap<Integer, Double>();
                double area = 0.0;
                for (int i = 0; i < this.elems.size(); ++i) {
                    SimulatorElement elem = this.elems.get(i);
                    area += elem.getArea();
                    double scalarVal = this.scalar.calc(elem, this.slips[i]);
                    sumDipWeight += scalarVal;
                    sumWeightedDip += scalarVal * elem.getFocalMechanism().getDip();
                    int id = elem.getSectionID();
                    if (id < 0) {
                        id = -(elem.getFaultID() + 1);
                    }
                    double[] sectDepths = (double[])sectDepthsMap.get(id);
                    Double sectDip = (Double)sectDipsMap.get(id);
                    Double sectWeight = (Double)sectWeights.get(id);
                    if (sectDepths == null) {
                        sectDepths = new double[]{Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY};
                        sectDip = 0.0;
                        sectWeight = 0.0;
                    }
                    for (Vertex loc : elem.getVertices()) {
                        sectDepths[0] = Double.min(sectDepths[0], loc.depth);
                        sectDepths[1] = Double.max(sectDepths[1], loc.depth);
                    }
                    sectDepthsMap.put(id, sectDepths);
                    sectDip = sectDip + scalarVal * elem.getFocalMechanism().getDip();
                    sectDipsMap.put(id, sectDip);
                    sectWeight = sectWeight + scalarVal;
                    sectWeights.put(id, sectWeight);
                }
                if (sectDepthsMap.size() == 1) {
                    double[] depths = (double[])sectDepthsMap.values().iterator().next();
                    double sectDip = (Double)sectDipsMap.values().iterator().next() / (Double)sectWeights.values().iterator().next();
                    this.zTOR = depths[0];
                    this.ddw = (depths[1] - depths[0]) / Math.sin(sectDip * Math.PI / 180.0);
                } else {
                    double sumZtors = 0.0;
                    double sumDDWs = 0.0;
                    double sumWeights = 0.0;
                    Iterator iterator = sectDepthsMap.keySet().iterator();
                    while (iterator.hasNext()) {
                        int id = (Integer)iterator.next();
                        double[] depths = (double[])sectDepthsMap.get(id);
                        double weight = (Double)sectWeights.get(id);
                        double dip2 = (Double)sectDipsMap.get(id) / weight;
                        double ddw = (depths[1] - depths[0]) / Math.sin(dip2 * Math.PI / 180.0);
                        sumZtors += depths[0] * weight;
                        sumDDWs += ddw * weight;
                        sumWeights += weight;
                    }
                    this.zTOR = sumZtors / sumWeights;
                    this.ddw = sumDDWs / sumWeights;
                }
                this.area = area * 1.0E-6;
                if (this.zTOR < 0.01 && this.zTOR > -0.01) {
                    this.zTOR = 0.0;
                }
                if ((dip = sumWeightedDip / sumDipWeight) != 90.0 && dip < 90.1 && dip > 89.9) {
                    dip = 90.0;
                }
                this.dip = dip;
            }
        }
    }

    @Override
    public SurfaceDistances calcDistances(Location loc) {
        SimRuptureDistCalcUtils.LocationElementDistanceCache siteLocDistCache = this.locCacheFactory.getCache(loc);
        DiscretizedFunc rJBFunc = SimRuptureDistCalcUtils.calcDistScalarFunc(this.event, loc, siteLocDistCache, SimRuptureDistCalcUtils.DistanceType.R_JB, this.scalar);
        double distanceJB = this.calcDistance(rJBFunc);
        DiscretizedFunc rRupFunc = SimRuptureDistCalcUtils.calcDistScalarFunc(this.event, loc, siteLocDistCache, SimRuptureDistCalcUtils.DistanceType.R_RUP, this.scalar);
        double distanceRup = this.calcDistance(rRupFunc);
        DiscretizedFunc rSeisFunc = SimRuptureDistCalcUtils.calcDistScalarFunc(this.event, loc, siteLocDistCache, SimRuptureDistCalcUtils.DistanceType.R_SEIS, this.scalar);
        double distanceSeis = rSeisFunc == null ? Double.NaN : this.calcDistance(rSeisFunc);
        double maxDistJBforX = SimEventCumDistFuncSurface.calcDistance(rJBFunc, this.fractThresholdX, Double.NaN);
        double wtFootwall = 0.0;
        double wtHangingwall = 0.0;
        for (int i = 0; i < this.slips.length; ++i) {
            SimulatorElement elem = this.elems.get(i);
            SimRuptureDistCalcUtils.FootwallAwareSurfaceDistances elemDists = siteLocDistCache.getDistances(elem);
            double rJB = elemDists.getDistanceJB();
            if (!(rJB <= maxDistJBforX)) continue;
            double weight = this.scalar.calc(elem, this.slips[i]);
            if (elemDists.isOnFootfall()) {
                wtFootwall += weight;
                continue;
            }
            wtHangingwall += weight;
        }
        boolean footwall = (float)wtFootwall >= (float)wtHangingwall;
        SimRuptureDistCalcUtils.FootwallAwareSurfaceDistances dists = new SimRuptureDistCalcUtils.FootwallAwareSurfaceDistances(distanceRup, distanceJB, distanceSeis, footwall);
        return dists;
    }

    private double calcDistance(DiscretizedFunc scalarDistCmlFunc) {
        return SimEventCumDistFuncSurface.calcDistance(scalarDistCmlFunc, this.fractThreshold, this.absThreshold);
    }

    private static double calcDistance(DiscretizedFunc scalarDistCmlFunc, double fractThreshold, double absThreshold) {
        double fractTarget = fractThreshold * scalarDistCmlFunc.getY(scalarDistCmlFunc.size() - 1);
        double targetVal = absThreshold > 0.0 ? Double.min(absThreshold, fractThreshold) : fractTarget;
        for (Point2D pt : scalarDistCmlFunc) {
            if (!(pt.getY() >= targetVal)) continue;
            return pt.getX();
        }
        return Double.NaN;
    }

    @Override
    public ListIterator<Location> getLocationsIterator() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public LocationList getEvenlyDiscritizedPerimeter() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public LocationList getPerimeter() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public boolean isPointSurface() {
        return false;
    }

    @Override
    public double calcQuickDistance(Location loc) {
        Location closest = null;
        double minSqCartesian = Double.POSITIVE_INFINITY;
        for (SimulatorElement elem : this.event.getAllElements()) {
            Location center = elem.getCenterLocation();
            double latDiff = center.lat - loc.lat;
            double lonDiff = center.lon - loc.lon;
            double sqCartesian = latDiff * latDiff + lonDiff * lonDiff;
            if (!(sqCartesian < minSqCartesian)) continue;
            minSqCartesian = sqCartesian;
            closest = center;
        }
        return LocationUtils.horzDistanceFast(loc, closest);
    }

    @Override
    public double calcDistanceX(Location loc) {
        return this.getDistanceX(loc);
    }

    @Override
    public void clearCache() {
        this.cache.clearCache();
    }

    @Override
    public double getAveDip() {
        this.checkInitAvgQuantities();
        return this.dip;
    }

    @Override
    public double getAveStrike() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public double getAveLength() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public double getAveWidth() {
        this.checkInitAvgQuantities();
        return this.ddw;
    }

    @Override
    public double getArea() {
        this.checkInitAvgQuantities();
        return this.area;
    }

    @Override
    public double getAreaInsideRegion(Region region) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public LocationList getEvenlyDiscritizedListOfLocsOnSurface() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public FaultTrace getEvenlyDiscritizedUpperEdge() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public LocationList getEvenlyDiscritizedLowerEdge() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public double getAveGridSpacing() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public double getQuickDistance(Location siteLoc) {
        return this.cache.getQuickDistance(siteLoc);
    }

    @Override
    public double getDistanceRup(Location siteLoc) {
        return this.cache.getSurfaceDistances(siteLoc).getDistanceRup();
    }

    @Override
    public double getDistanceJB(Location siteLoc) {
        return this.cache.getSurfaceDistances(siteLoc).getDistanceJB();
    }

    @Override
    public double getDistanceSeis(Location siteLoc) {
        return this.cache.getSurfaceDistances(siteLoc).getDistanceSeis();
    }

    @Override
    public double getDistanceX(Location siteLoc) {
        SimRuptureDistCalcUtils.FootwallAwareSurfaceDistances dists = (SimRuptureDistCalcUtils.FootwallAwareSurfaceDistances)this.cache.getSurfaceDistances(siteLoc);
        return dists.isOnFootfall() ? -dists.getDistanceJB() : dists.getDistanceJB();
    }

    @Override
    public double getAveRupTopDepth() {
        this.checkInitAvgQuantities();
        return this.zTOR;
    }

    @Override
    public double getAveDipDirection() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public FaultTrace getUpperEdge() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public Location getFirstLocOnUpperEdge() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public Location getLastLocOnUpperEdge() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public double getFractionOfSurfaceInRegion(Region region) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public String getInfo() {
        return null;
    }

    @Override
    public double getMinDistance(RuptureSurface surface) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public RuptureSurface getMoved(LocationVector v) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public RuptureSurface copyShallow() {
        return new SimEventCumDistFuncSurface(this.event, this.scalar, this.fractThreshold, this.absThreshold, this.fractThresholdX);
    }
}

