/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.simulators.iden;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.opensha.sha.simulators.SimulatorEvent;
import org.opensha.sha.simulators.iden.RuptureIdentifier;
import org.opensha.sha.simulators.iden.TimeWindow;
import org.opensha.sha.simulators.utils.SimulatorUtils;

public class EventsInWindowsMatcher {
    private List<? extends SimulatorEvent> events;
    private RuptureIdentifier rupIden;
    private double minWindowDurationYears;
    private double windowDurationYears;
    private boolean randomizeEventTimes;
    private List<SimulatorEvent> eventsInWindows;
    private List<Double> timeFromStarts;
    private List<TimeWindow> timeWindows;
    private HashSet<Integer> matchIDs;
    private double totalWindowDurationYears;

    public EventsInWindowsMatcher(List<? extends SimulatorEvent> events, RuptureIdentifier rupIden, double minWindowDurationYears, double windowDurationYears, boolean randomizeEventTimes) {
        this.events = events;
        this.rupIden = rupIden;
        this.minWindowDurationYears = minWindowDurationYears;
        this.windowDurationYears = windowDurationYears;
        this.randomizeEventTimes = randomizeEventTimes;
        this.update();
    }

    private List<? extends SimulatorEvent> update() {
        TimeWindow window;
        List<? extends SimulatorEvent> matches;
        this.eventsInWindows = Lists.newArrayList();
        this.timeFromStarts = Lists.newArrayList();
        if (this.events == null || this.events.isEmpty()) {
            return null;
        }
        if (this.randomizeEventTimes) {
            double startTime = this.events.get(0).getTime();
            double simDuration = SimulatorUtils.getSimulationDuration(this.events);
            ArrayList<? extends SimulatorEvent> randomizedEvents = new ArrayList<SimulatorEvent>();
            for (SimulatorEvent simulatorEvent : this.events) {
                double time = startTime + Math.random() * simDuration;
                SimulatorEvent r = simulatorEvent.cloneNewTime(time, simulatorEvent.getID());
                randomizedEvents.add(r);
            }
            Collections.sort(randomizedEvents);
            this.events = randomizedEvents;
        }
        if ((matches = this.rupIden.getMatches(this.events)).isEmpty()) {
            System.out.println("No matches found!");
            return Lists.newArrayList();
        }
        double duration = this.windowDurationYears * 3.1536E7;
        double minDuration = this.minWindowDurationYears * 3.1536E7;
        this.timeWindows = Lists.newArrayList();
        double simEndTime = this.events.get(this.events.size() - 1).getTime();
        double windowDurationSum = 0.0;
        int overlaps = 0;
        TimeWindow prev = null;
        this.matchIDs = new HashSet();
        for (SimulatorEvent simulatorEvent : matches) {
            double noOverlapDuration;
            double start = simulatorEvent.getTime();
            double end = start + duration;
            start += minDuration;
            if (end > simEndTime) {
                end = simEndTime;
            }
            double noOverlapStart = start;
            if (prev != null && noOverlapStart < prev.getEnd()) {
                noOverlapStart = prev.getEnd();
                ++overlaps;
            }
            Preconditions.checkState(((noOverlapDuration = end - noOverlapStart) >= 0.0 ? 1 : 0) != 0);
            windowDurationSum += noOverlapDuration;
            this.matchIDs.add(simulatorEvent.getID());
            window = new TimeWindow(start, end, simulatorEvent.getID());
            this.timeWindows.add(window);
            prev = window;
        }
        this.totalWindowDurationYears = windowDurationSum / 3.1536E7;
        double rate = 1.0 / this.totalWindowDurationYears;
        System.out.println("Got " + matches.size() + " matches in " + this.timeWindows.size() + " windows (" + overlaps + " overlaps).");
        System.out.println("Total window duration: " + this.totalWindowDurationYears + " years");
        System.out.println("In-window event rate: " + rate);
        int windowIndex = 0;
        int numEventsInWindows = 0;
        block2: for (SimulatorEvent simulatorEvent : this.events) {
            double time = simulatorEvent.getTime();
            while (time > this.timeWindows.get(windowIndex).getEnd()) {
                if (++windowIndex < this.timeWindows.size()) continue;
                break block2;
            }
            TimeWindow matchingWindow = null;
            for (int i = windowIndex; i < this.timeWindows.size() && !(window = this.timeWindows.get(i)).isBefore(time); ++i) {
                if (window.isAfter(time) || window.isInitiator(simulatorEvent.getID())) continue;
                matchingWindow = window;
            }
            if (matchingWindow == null) continue;
            ++numEventsInWindows;
            this.eventsInWindows.add(simulatorEvent);
            double matchTime = simulatorEvent.getTime() - matchingWindow.getStart();
            Preconditions.checkState((matchTime > 0.0 ? 1 : 0) != 0);
            Preconditions.checkState((matchTime < duration ? 1 : 0) != 0);
            this.timeFromStarts.add(simulatorEvent.getTime() - matchingWindow.getStart());
        }
        System.out.println("Found " + numEventsInWindows + " events in the given windows/mag range");
        return this.eventsInWindows;
    }

    public List<? extends SimulatorEvent> getInputEvents() {
        return this.events;
    }

    public RuptureIdentifier getRupIden() {
        return this.rupIden;
    }

    public double getMinWindowDurationYears() {
        return this.minWindowDurationYears;
    }

    public double getWindowDurationYears() {
        return this.windowDurationYears;
    }

    public boolean isRandomizeEventTimes() {
        return this.randomizeEventTimes;
    }

    public List<SimulatorEvent> getEventsInWindows() {
        return this.eventsInWindows;
    }

    public List<Double> getEventTimesFromWindowStarts() {
        return this.timeFromStarts;
    }

    public List<TimeWindow> getTimeWindows() {
        return this.timeWindows;
    }

    public HashSet<Integer> getMatchIDs() {
        return this.matchIDs;
    }

    public double getTotalWindowDurationYears() {
        return this.totalWindowDurationYears;
    }
}

