/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.simulators.parsers;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.google.common.io.LittleEndianDataInputStream;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.IntBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import org.apache.commons.math3.geometry.Vector;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.opensha.commons.calc.FaultMomentCalc;
import org.opensha.commons.eq.MagUtils;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.geo.LocationVector;
import org.opensha.commons.geo.utm.UTM;
import org.opensha.commons.geo.utm.WGS84;
import org.opensha.commons.util.DataUtils;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.sha.earthquake.FocalMechanism;
import org.opensha.sha.simulators.EventRecord;
import org.opensha.sha.simulators.RSQSimEvent;
import org.opensha.sha.simulators.RSQSimEventRecord;
import org.opensha.sha.simulators.RectangularElement;
import org.opensha.sha.simulators.SimulatorElement;
import org.opensha.sha.simulators.TriangularElement;
import org.opensha.sha.simulators.Vertex;
import org.opensha.sha.simulators.iden.MagRangeRuptureIdentifier;
import org.opensha.sha.simulators.iden.RuptureIdentifier;
import org.opensha.sha.simulators.utils.SimulatorUtils;

public class RSQSimFileReader {
    private static EventRecordTimeComparator recordTimeComp = new EventRecordTimeComparator();
    private static final int ITERABLE_PRELOAD_CAPACITY = 10000;

    public static List<SimulatorElement> readGeometryFile(File geomFile, int longZone, char latZone) throws IOException {
        return RSQSimFileReader.readGeometryFile(new FileInputStream(geomFile), longZone, latZone);
    }

    public static List<SimulatorElement> readGeometryFile(URL url, int longZone, char latZone) throws IOException {
        return RSQSimFileReader.readGeometryFile(url.openStream(), longZone, latZone);
    }

    public static List<SimulatorElement> readGeometryFile(InputStream is, int longZone, char latZone) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        String line = reader.readLine();
        while (line != null && line.startsWith("#")) {
            line = reader.readLine();
        }
        boolean triangular = RSQSimFileReader.isTriangular(line);
        ArrayList elements = Lists.newArrayList();
        int elemID = 1;
        int vertexID = 1;
        while (line != null) {
            StringTokenizer tok = new StringTokenizer(line);
            try {
                FocalMechanism focalMechanism;
                double aseisFactor;
                int numDownDip;
                int numAlongStrike;
                if (triangular) {
                    String sectNumStr;
                    double x1 = Double.parseDouble(tok.nextToken());
                    double y1 = Double.parseDouble(tok.nextToken());
                    double z1 = Double.parseDouble(tok.nextToken());
                    Location loc1 = RSQSimFileReader.utmToLoc(longZone, latZone, x1, y1, z1);
                    double x2 = Double.parseDouble(tok.nextToken());
                    double y2 = Double.parseDouble(tok.nextToken());
                    double z2 = Double.parseDouble(tok.nextToken());
                    Location loc2 = RSQSimFileReader.utmToLoc(longZone, latZone, x2, y2, z2);
                    double x3 = Double.parseDouble(tok.nextToken());
                    double y3 = Double.parseDouble(tok.nextToken());
                    double z3 = Double.parseDouble(tok.nextToken());
                    Location loc3 = RSQSimFileReader.utmToLoc(longZone, latZone, x3, y3, z3);
                    double rake = Double.parseDouble(tok.nextToken());
                    String slipRateStr = tok.nextToken();
                    double slipRate = slipRateStr.equals("NA") ? 0.0 : Double.parseDouble(slipRateStr);
                    int sectNum = -1;
                    String sectName = null;
                    if (tok.hasMoreTokens() && !(sectNumStr = tok.nextToken()).equals("NA")) {
                        if (sectNumStr.endsWith(".0")) {
                            sectNumStr = sectNumStr.substring(0, sectNumStr.length() - 2);
                        }
                        sectNum = Integer.parseInt(sectNumStr);
                        if (tok.hasMoreTokens()) {
                            sectName = tok.nextToken();
                        }
                    }
                    Vertex[] vertices = new Vertex[]{new Vertex(loc1.getLatitude(), loc1.getLongitude(), loc1.getDepth(), vertexID++), new Vertex(loc2.getLatitude(), loc2.getLongitude(), loc2.getDepth(), vertexID++), new Vertex(loc3.getLatitude(), loc3.getLongitude(), loc3.getDepth(), vertexID++)};
                    numAlongStrike = -1;
                    numDownDip = -1;
                    aseisFactor = 0.0;
                    focalMechanism = RSQSimFileReader.calcTriangularMech(new Vector3D(x1, y1, z1), new Vector3D(x2, y2, z2), new Vector3D(x3, y3, z3), rake);
                    TriangularElement elem = new TriangularElement(elemID++, vertices, sectName, -1, sectNum, numAlongStrike, numDownDip, slipRate *= 3.1536E7, aseisFactor, focalMechanism);
                    elements.add(elem);
                } else {
                    double x = Double.parseDouble(tok.nextToken());
                    double y = Double.parseDouble(tok.nextToken());
                    double z = Double.parseDouble(tok.nextToken());
                    double l = Double.parseDouble(tok.nextToken());
                    double w = Double.parseDouble(tok.nextToken());
                    Location center = RSQSimFileReader.utmToLoc(longZone, latZone, x, y, z);
                    double strike = Double.parseDouble(tok.nextToken());
                    double dip = Double.parseDouble(tok.nextToken());
                    double rake = Double.parseDouble(tok.nextToken());
                    double slipRate = Double.parseDouble(tok.nextToken());
                    int sectNum = -1;
                    String sectName = null;
                    if (tok.hasMoreTokens()) {
                        sectNum = Integer.parseInt(tok.nextToken());
                        if (tok.hasMoreTokens()) {
                            sectName = tok.nextToken();
                        }
                    }
                    double halfWidthKM = w * 0.5 / 1000.0;
                    double halfLengthKM = l * 0.5 / 1000.0;
                    Vertex[] vertices = new Vertex[4];
                    LocationVector v = new LocationVector(strike, halfLengthKM, 0.0);
                    Location centerLeft = LocationUtils.location(center, v);
                    v.reverse();
                    Location centerRight = LocationUtils.location(center, v);
                    if (dip == 90.0) {
                        vertices[0] = new Vertex(centerRight.getLatitude(), centerRight.getLongitude(), center.getDepth() + halfWidthKM, vertexID++);
                        vertices[1] = new Vertex(centerRight.getLatitude(), centerRight.getLongitude(), center.getDepth() - halfWidthKM, vertexID++);
                        vertices[2] = new Vertex(centerLeft.getLatitude(), centerLeft.getLongitude(), center.getDepth() - halfWidthKM, vertexID++);
                        vertices[3] = new Vertex(centerLeft.getLatitude(), centerLeft.getLongitude(), center.getDepth() + halfWidthKM, vertexID++);
                    } else {
                        double dipDir = strike + 90.0;
                        double dipDirRad = Math.toRadians(dipDir);
                        double widthKM = w / 1000.0;
                        double horizontal = widthKM * Math.cos(dipDirRad);
                        double vertical = widthKM * Math.sin(dipDirRad);
                        v = new LocationVector(dipDir, horizontal, vertical);
                        Location botLeft = LocationUtils.location(centerLeft, v);
                        Location botRight = LocationUtils.location(centerRight, v);
                        v.reverse();
                        Location topLeft = LocationUtils.location(centerLeft, v);
                        Location topRight = LocationUtils.location(centerRight, v);
                        vertices[0] = new Vertex(topLeft.getLatitude(), topLeft.getLongitude(), topLeft.getDepth(), vertexID++);
                        vertices[1] = new Vertex(botLeft.getLatitude(), botLeft.getLongitude(), botLeft.getDepth(), vertexID++);
                        vertices[2] = new Vertex(botRight.getLatitude(), botRight.getLongitude(), botRight.getDepth(), vertexID++);
                        vertices[3] = new Vertex(topRight.getLatitude(), topRight.getLongitude(), topRight.getDepth(), vertexID++);
                    }
                    numAlongStrike = -1;
                    numDownDip = -1;
                    aseisFactor = 0.0;
                    focalMechanism = new FocalMechanism(strike, dip, rake);
                    boolean perfectRect = (float)l == (float)w;
                    RectangularElement elem = new RectangularElement(elemID++, vertices, sectName, -1, sectNum, numAlongStrike, numDownDip, slipRate *= 3.1536E7, aseisFactor, focalMechanism, perfectRect);
                    elements.add(elem);
                }
            }
            catch (RuntimeException e) {
                System.err.println("Error parsing geometry: " + e.getMessage() + "\n\tOffending line: " + line);
                throw e;
            }
            line = reader.readLine();
        }
        boolean subsections = true;
        HashMap faultIDsMap = Maps.newHashMap();
        int curFaultID = 1;
        for (SimulatorElement elem : elements) {
            String sectName = elem.getSectionName();
            if (sectName == null || !sectName.contains("Subsection")) {
                subsections = false;
                break;
            }
            String faultName = sectName.substring(0, sectName.indexOf("Subsection"));
            while (faultName.endsWith(",")) {
                faultName = faultName.substring(0, faultName.length() - 1);
            }
            Integer faultID = (Integer)faultIDsMap.get(faultName);
            if (faultID == null) {
                faultID = curFaultID++;
                faultIDsMap.put(faultName, faultID);
            }
            faultIDsMap.put(sectName, faultID);
        }
        if (subsections) {
            for (SimulatorElement elem : elements) {
                elem.setFaultID((Integer)faultIDsMap.get(elem.getSectionName()));
            }
        }
        return elements;
    }

    private static boolean isTriangular(String line) {
        StringTokenizer tok = new StringTokenizer(line);
        int num = tok.countTokens();
        Preconditions.checkState((num >= 9 ? 1 : 0) != 0);
        if (num < 11) {
            return false;
        }
        ArrayList tokens = Lists.newArrayList();
        while (tok.hasMoreTokens()) {
            tokens.add(tok.nextToken());
        }
        String tok11 = (String)tokens.get(10);
        try {
            Double.parseDouble(tok11);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static FocalMechanism calcTriangularMech(Vector3D c1, Vector3D c2, Vector3D c3, double rake) {
        double strike;
        Vector3D dx2;
        Vector3D dx1 = c2.subtract((Vector)c1);
        Vector3D nu = Vector3D.crossProduct((Vector3D)dx1, (Vector3D)(dx2 = c3.subtract((Vector)c1)));
        if (nu.getZ() < 0.0) {
            nu = nu.scalarMultiply(-1.0);
        }
        double area = 0.5 * Math.sqrt(nu.dotProduct((Vector)nu));
        nu.scalarMultiply(1.0 / (2.0 * area));
        for (strike = -57.29577951308232 * Math.atan2(nu.getY(), nu.getX()); strike < 0.0; strike += 360.0) {
        }
        double dip = 90.0 - 57.29577951308232 * Math.atan2(nu.getZ(), Math.sqrt(nu.getX() * nu.getX() + nu.getY() * nu.getY()));
        return new FocalMechanism(strike, dip, rake);
    }

    private static Location utmToLoc(int longZone, char latZone, double x, double y, double z) {
        UTM utm = new UTM(longZone, latZone, x, y);
        WGS84 wgs84 = new WGS84(utm);
        double lat = wgs84.getLatitude();
        double lon = wgs84.getLongitude();
        if (longZone > 50 && lon < 0.0) {
            lon += 360.0;
        }
        return new Location(lat, lon, -z / 1000.0);
    }

    public static void main(String[] args) throws IOException {
        File dir = new File("/home/kevin/Simulators/catalogs/SWminAdefaultB");
        File geomFile = new File(dir, "UCERF3.D3.1.1km.tri.2.flt");
        List<SimulatorElement> elements = RSQSimFileReader.readGeometryFile(geomFile, 11, 'S');
        System.out.println("Loaded " + elements.size() + " elements");
        DataUtils.MinMaxAveTracker strikeTrack = new DataUtils.MinMaxAveTracker();
        DataUtils.MinMaxAveTracker dipTrack = new DataUtils.MinMaxAveTracker();
        for (SimulatorElement e : elements) {
            FocalMechanism mech = e.getFocalMechanism();
            strikeTrack.addValue(mech.getStrike());
            dipTrack.addValue(mech.getDip());
            if (!(Math.random() < 0.001)) continue;
            System.out.println(e.getID() + ". " + e.getSectionName() + " Mech: s=" + mech.getStrike() + "\td=" + mech.getDip() + "\tr=" + mech.getRake());
        }
        System.out.println("Strikes: " + String.valueOf(strikeTrack));
        System.out.println("Dips: " + String.valueOf(dipTrack));
        System.exit(0);
        File eventsDir = dir;
        List<RSQSimEvent> events = RSQSimFileReader.readEventsFile(eventsDir, elements);
        System.out.println("Loaded " + events.size() + " events");
        System.out.println("Duration: " + SimulatorUtils.getSimulationDurationYears(events) + " years");
        for (double minMag : new double[]{6.0, 6.5, 7.0}) {
            List<RSQSimEvent> subEvents = new MagRangeRuptureIdentifier(minMag, 10.0).getMatches(events);
            System.out.println(subEvents.size() + " events M>=" + minMag);
            DataUtils.MinMaxAveTracker ptsTrack = new DataUtils.MinMaxAveTracker();
            for (RSQSimEvent e : subEvents) {
                ptsTrack.addValue(e.getNumElements());
            }
            System.out.println("Points: " + String.valueOf(ptsTrack));
        }
    }

    public static List<RSQSimEvent> readEventsFile(File file, List<SimulatorElement> elements) throws IOException {
        return RSQSimFileReader.readEventsFile(file, elements, null);
    }

    public static List<RSQSimEvent> readEventsFile(File file, List<SimulatorElement> elements, Collection<? extends RuptureIdentifier> rupIdens) throws IOException {
        return RSQSimFileReader.readEventsFile(file, elements, rupIdens, false);
    }

    public static List<RSQSimEvent> readEventsFile(File file, List<SimulatorElement> elements, Collection<? extends RuptureIdentifier> rupIdens, boolean skipSlipsAndTimes) throws IOException {
        if (file.isDirectory()) {
            for (File sub : file.listFiles()) {
                if (!sub.getName().endsWith(".eList")) continue;
                System.out.println("Found eList file in directory: " + sub.getAbsolutePath());
                return RSQSimFileReader.readEventsFile(sub, elements, rupIdens, skipSlipsAndTimes);
            }
            throw new FileNotFoundException("Couldn't find eList file in given directory");
        }
        String name = file.getName();
        Preconditions.checkArgument((boolean)name.endsWith("List"), (Object)"Must supply either directory containing all list files, or one of the files themselves");
        File dir = file.getParentFile();
        String prefix = name.substring(0, name.lastIndexOf("."));
        System.out.println("Detected prefix: " + prefix);
        File eListFile = new File(dir, prefix + ".eList");
        Preconditions.checkState((boolean)eListFile.exists(), (String)"Couldn't find eList file with prefix %s: %s", (Object)prefix, (Object)eListFile.getAbsolutePath());
        File pListFile = new File(dir, prefix + ".pList");
        Preconditions.checkState((boolean)pListFile.exists(), (String)"Couldn't find eList file with prefix %s: %s", (Object)prefix, (Object)pListFile.getAbsolutePath());
        File dListFile = new File(dir, prefix + ".dList");
        Preconditions.checkState((boolean)dListFile.exists(), (String)"Couldn't find dList file with prefix %s: %s", (Object)prefix, (Object)dListFile.getAbsolutePath());
        File tListFile = new File(dir, prefix + ".tList");
        Preconditions.checkState((boolean)tListFile.exists(), (String)"Couldn't find tList file with prefix %s: %s", (Object)prefix, (Object)tListFile.getAbsolutePath());
        return RSQSimFileReader.readEventsFile(new FileInputStream(eListFile), new FileInputStream(pListFile), new FileInputStream(dListFile), new FileInputStream(tListFile), elements, rupIdens, RSQSimFileReader.isBigEndian(pListFile, elements), skipSlipsAndTimes);
    }

    public static List<RSQSimEvent> readEventsFile(File eListFile, File pListFile, File dListFile, File tListFile, List<SimulatorElement> elements) throws IOException {
        return RSQSimFileReader.readEventsFile(eListFile, pListFile, dListFile, tListFile, elements, null, RSQSimFileReader.isBigEndian(pListFile, elements));
    }

    public static List<RSQSimEvent> readEventsFile(File eListFile, File pListFile, File dListFile, File tListFile, List<SimulatorElement> elements, Collection<? extends RuptureIdentifier> rupIdens) throws IOException {
        return RSQSimFileReader.readEventsFile(eListFile, pListFile, dListFile, tListFile, elements, rupIdens, RSQSimFileReader.isBigEndian(pListFile, elements));
    }

    public static List<RSQSimEvent> readEventsFile(File eListFile, File pListFile, File dListFile, File tListFile, List<SimulatorElement> elements, Collection<? extends RuptureIdentifier> rupIdens, boolean bigEndian) throws IOException {
        return RSQSimFileReader.readEventsFile(new FileInputStream(eListFile), new FileInputStream(pListFile), new FileInputStream(dListFile), new FileInputStream(tListFile), elements, rupIdens, bigEndian, false);
    }

    public static boolean isBigEndian(File pListFile, List<SimulatorElement> elements) throws IOException {
        RandomAccessFile raFile;
        long len;
        if (pListFile.isDirectory()) {
            for (File file : pListFile.listFiles()) {
                if (!file.getName().endsWith(".pList")) continue;
                pListFile = file;
                break;
            }
        }
        int numVals = (len = (raFile = new RandomAccessFile(pListFile, "r")).length()) > Integer.MAX_VALUE ? 0x1FFFFFFF : (int)(len / 4L);
        int numToCheck = 100;
        boolean bigEndian = true;
        boolean littleEndian = true;
        byte[] recordBuffer = new byte[4];
        IntBuffer littleRecord = ByteBuffer.wrap(recordBuffer).order(ByteOrder.LITTLE_ENDIAN).asIntBuffer();
        IntBuffer bigRecord = ByteBuffer.wrap(recordBuffer).order(ByteOrder.BIG_ENDIAN).asIntBuffer();
        Random r = new Random();
        for (int i = 0; i < numToCheck; ++i) {
            long pos = (long)r.nextInt(numVals) * 4L;
            raFile.seek(pos);
            raFile.read(recordBuffer);
            int littleEndianID = littleRecord.get(0);
            int bigEndianID = bigRecord.get(0);
            bigEndian = bigEndian && RSQSimFileReader.isValidPatchID(bigEndianID, elements);
            littleEndian = littleEndian && RSQSimFileReader.isValidPatchID(littleEndianID, elements);
        }
        raFile.close();
        Preconditions.checkState((bigEndian || littleEndian ? 1 : 0) != 0, (Object)"Couldn't detect endianness - bad patch IDs?");
        Preconditions.checkState((!bigEndian || !littleEndian ? 1 : 0) != 0, (Object)"Passed both big and little endian tests???");
        return bigEndian;
    }

    public static boolean isValidPatchID(int patchID, List<SimulatorElement> elements) {
        int minID = elements.get(0).getID();
        int maxID = elements.get(elements.size() - 1).getID();
        return patchID >= minID && patchID <= maxID;
    }

    private static List<RSQSimEvent> readEventsFile(InputStream eListStream, InputStream pListStream, InputStream dListStream, InputStream tListStream, List<SimulatorElement> elements, Collection<? extends RuptureIdentifier> rupIdens, boolean bigEndian, boolean skipSlipsAndTimes) throws IOException {
        ArrayList events = Lists.newArrayList();
        RSQSimFileReader.populateEvents(eListStream, pListStream, dListStream, tListStream, elements, rupIdens, bigEndian, events, skipSlipsAndTimes);
        return events;
    }

    private static void populateEvents(InputStream eListStream, InputStream pListStream, InputStream dListStream, InputStream tListStream, List<SimulatorElement> elements, Collection<? extends RuptureIdentifier> rupIdens, boolean bigEndian, Collection<RSQSimEvent> events, boolean skipSlipsAndTimes) throws IOException {
        DataInputStream tIn;
        DataInputStream dIn;
        DataInputStream pIn;
        DataInputStream eIn;
        if (!(eListStream instanceof BufferedInputStream)) {
            eListStream = new BufferedInputStream(eListStream);
        }
        if (!(pListStream instanceof BufferedInputStream)) {
            pListStream = new BufferedInputStream(pListStream);
        }
        if (!(dListStream instanceof BufferedInputStream)) {
            dListStream = new BufferedInputStream(dListStream);
        }
        if (!(tListStream instanceof BufferedInputStream)) {
            tListStream = new BufferedInputStream(tListStream);
        }
        if (skipSlipsAndTimes) {
            System.out.println("Skipping individual patch slips and times to conserve memory");
        }
        if (bigEndian) {
            eIn = new DataInputStream(eListStream);
            pIn = new DataInputStream(pListStream);
            dIn = new DataInputStream(dListStream);
            tIn = new DataInputStream(tListStream);
        } else {
            eIn = new LittleEndianDataInputStream(eListStream);
            pIn = new LittleEndianDataInputStream(pListStream);
            dIn = new LittleEndianDataInputStream(dListStream);
            tIn = new LittleEndianDataInputStream(tListStream);
        }
        int curEventID = -1;
        HashMap curRecordMap = Maps.newHashMap();
        HashMap patchToPrevRecordMap = Maps.newHashMap();
        HashSet<Integer> eventIDsLoaded = new HashSet<Integer>();
        int numNegSlips = 0;
        Object prevEvent = null;
        try {
            while (true) {
                Object event;
                int eventID = eIn.readInt();
                int patchID = pIn.readInt();
                double slip = dIn.readDouble();
                double time = tIn.readDouble();
                if (prevEvent != null && time < ((RSQSimEvent)prevEvent).getNextEventTime()) {
                    ((RSQSimEvent)prevEvent).setNextEventTime(time);
                }
                if (slip < 0.0) {
                    if (numNegSlips == 0) {
                        System.err.println("WARNING: Negative slip present in dList file.");
                    }
                    if (numNegSlips < 10) {
                        System.err.println("\teventID=" + eventID + "\tpatchID=" + patchID + "\tslip=" + slip);
                    } else if (numNegSlips == 10) {
                        System.err.println("Future negetive slip warning supressed");
                    }
                    ++numNegSlips;
                }
                Preconditions.checkState((boolean)RSQSimFileReader.isValidPatchID(patchID, elements));
                SimulatorElement element = elements.get(patchID - 1);
                Preconditions.checkState((element.getID() == patchID ? 1 : 0) != 0, (Object)"Elements not sequential");
                double elementMoment = FaultMomentCalc.getMoment(element.getArea(), slip);
                if (eventID != curEventID) {
                    if (prevEvent != null && events instanceof BlockingDeque) {
                        try {
                            ((BlockingDeque)events).putLast(prevEvent);
                        }
                        catch (InterruptedException e) {
                            ExceptionUtils.throwAsRuntimeException(e);
                        }
                    }
                    if (!curRecordMap.isEmpty()) {
                        Preconditions.checkState((!eventIDsLoaded.contains(curEventID) ? 1 : 0) != 0, (String)"Duplicate eventID found, file is out of order or corrupt. Trying to process new event with ID %s, but that ID has already been processed. Next eventID=%s", (int)curEventID, (int)eventID);
                        eventIDsLoaded.add(curEventID);
                        event = RSQSimFileReader.buildEvent(curEventID, curRecordMap, rupIdens);
                        if (event != null) {
                            ((RSQSimEvent)event).setNextEventTime(time);
                            if (!(events instanceof BlockingDeque)) {
                                events.add((RSQSimEvent)event);
                            }
                            prevEvent = event;
                        } else {
                            prevEvent = null;
                            boolean possible = false;
                            for (RuptureIdentifier ruptureIdentifier : rupIdens) {
                                if (!ruptureIdentifier.furtherMatchesPossible()) continue;
                                possible = true;
                                break;
                            }
                            if (!possible) {
                                curRecordMap.clear();
                                break;
                            }
                        }
                    }
                    curRecordMap.clear();
                    curEventID = eventID;
                }
                if ((event = (RSQSimEventRecord)curRecordMap.get(element.getSectionID())) == null) {
                    event = new RSQSimEventRecord(elements);
                    curRecordMap.put(element.getSectionID(), event);
                    ((EventRecord)event).setTime(time);
                    ((RSQSimEventRecord)event).setMoment(0.0);
                    ((EventRecord)event).setSectionID(element.getSectionID());
                    ((RSQSimEventRecord)event).setFirstPatchToSlip(patchID);
                }
                if (skipSlipsAndTimes) {
                    if (slip > 0.0) {
                        ((EventRecord)event).addElement(patchID);
                    }
                } else {
                    ((EventRecord)event).addSlip(patchID, slip, time);
                    if (time < ((EventRecord)event).getTime()) {
                        ((RSQSimEventRecord)event).setFirstPatchToSlip(patchID);
                        ((EventRecord)event).setTime(time);
                    }
                }
                ((RSQSimEventRecord)event).setMoment(((RSQSimEventRecord)event).getMoment() + elementMoment);
                patchToPrevRecordMap.put(patchID, event);
            }
        }
        catch (EOFException e) {
            // empty catch block
        }
        if (numNegSlips > 0) {
            System.err.println("WARNING: found " + numNegSlips + " total negative slips!");
        }
        if (prevEvent != null && events instanceof BlockingDeque) {
            try {
                ((BlockingDeque)events).putLast(prevEvent);
            }
            catch (InterruptedException e) {
                ExceptionUtils.throwAsRuntimeException(e);
            }
        }
        if (!curRecordMap.isEmpty()) {
            Preconditions.checkState((!eventIDsLoaded.contains(curEventID) ? 1 : 0) != 0, (String)"Duplicate eventID found, file is out of order or corrupt: %s", (int)curEventID);
            eventIDsLoaded.add(curEventID);
            RSQSimEvent event = RSQSimFileReader.buildEvent(curEventID, curRecordMap, rupIdens);
            if (event != null) {
                event.setNextEventTime(Double.POSITIVE_INFINITY);
                if (events instanceof BlockingDeque) {
                    try {
                        ((BlockingDeque)events).putLast(event);
                    }
                    catch (InterruptedException e) {
                        ExceptionUtils.throwAsRuntimeException(e);
                    }
                } else {
                    events.add(event);
                }
            }
        }
        ((FilterInputStream)eIn).close();
        ((FilterInputStream)pIn).close();
        ((FilterInputStream)dIn).close();
        ((FilterInputStream)tIn).close();
        if (events instanceof List) {
            Collections.sort((List)events);
        }
    }

    private static void listFileDebug(File file, int numToPrint, boolean bigEndian, boolean integer) throws IOException {
        BufferedInputStream fin = new BufferedInputStream(new FileInputStream(file));
        System.out.println(file.getName() + " big endian? " + bigEndian);
        DataInputStream dataIn = bigEndian ? new DataInputStream(fin) : new LittleEndianDataInputStream((InputStream)fin);
        try {
            for (int count = 0; count != numToPrint; ++count) {
                Number val = integer ? (Number)dataIn.readInt() : (Number)dataIn.readDouble();
                System.out.println(count + ":\t" + String.valueOf(val));
            }
        }
        catch (EOFException e) {
            // empty catch block
        }
        ((FilterInputStream)dataIn).close();
    }

    private static RSQSimEvent buildEvent(int eventID, Map<Integer, RSQSimEventRecord> records, Collection<? extends RuptureIdentifier> rupIdens) {
        ArrayList recordsForEvent = Lists.newArrayList(records.values());
        Collections.sort(recordsForEvent, recordTimeComp);
        double totMoment = 0.0;
        for (EventRecord rec : recordsForEvent) {
            totMoment += rec.getMoment();
        }
        double mag = MagUtils.momentToMag(totMoment);
        for (RSQSimEventRecord rec : recordsForEvent) {
            rec.setMagnitude(mag);
            rec.setTime(((RSQSimEventRecord)recordsForEvent.get(0)).getTime());
            rec.setID(eventID);
            double recordArea = 0.0;
            for (SimulatorElement elem : rec.getElements()) {
                recordArea += elem.getArea();
            }
            rec.setArea(recordArea);
        }
        RSQSimEvent event = new RSQSimEvent(recordsForEvent);
        if (rupIdens != null) {
            boolean keep = false;
            for (RuptureIdentifier ruptureIdentifier : rupIdens) {
                if (!ruptureIdentifier.isMatch(event)) continue;
                keep = true;
                break;
            }
            if (!keep) {
                return null;
            }
        }
        return event;
    }

    public static Iterable<RSQSimEvent> getEventsIterable(File file, List<SimulatorElement> elements) throws IOException {
        return RSQSimFileReader.getEventsIterable(file, elements, null);
    }

    public static Iterable<RSQSimEvent> getEventsIterable(File file, List<SimulatorElement> elements, Collection<? extends RuptureIdentifier> rupIdens) throws IOException {
        return RSQSimFileReader.getEventsIterable(file, elements, rupIdens, false);
    }

    public static Iterable<RSQSimEvent> getEventsIterable(File file, List<SimulatorElement> elements, Collection<? extends RuptureIdentifier> rupIdens, boolean skipSlipsAndTimes) throws IOException {
        if (file.isDirectory()) {
            for (File sub : file.listFiles()) {
                if (!sub.getName().endsWith(".eList")) continue;
                System.out.println("Found eList file in directory: " + sub.getAbsolutePath());
                return RSQSimFileReader.getEventsIterable(sub, elements, rupIdens, skipSlipsAndTimes);
            }
            throw new FileNotFoundException("Couldn't find eList file in given directory");
        }
        String name = file.getName();
        Preconditions.checkArgument((boolean)name.endsWith("List"), (Object)"Must supply either directory containing all list files, or one of the files themselves");
        File dir = file.getParentFile();
        String prefix = name.substring(0, name.lastIndexOf("."));
        System.out.println("Detected prefix: " + prefix);
        File eListFile = new File(dir, prefix + ".eList");
        Preconditions.checkState((boolean)eListFile.exists(), (String)"Couldn't find eList file with prefix %s: %s", (Object)prefix, (Object)eListFile.getAbsolutePath());
        File pListFile = new File(dir, prefix + ".pList");
        Preconditions.checkState((boolean)pListFile.exists(), (String)"Couldn't find eList file with prefix %s: %s", (Object)prefix, (Object)pListFile.getAbsolutePath());
        File dListFile = new File(dir, prefix + ".dList");
        Preconditions.checkState((boolean)dListFile.exists(), (String)"Couldn't find dList file with prefix %s: %s", (Object)prefix, (Object)dListFile.getAbsolutePath());
        File tListFile = new File(dir, prefix + ".tList");
        Preconditions.checkState((boolean)tListFile.exists(), (String)"Couldn't find tList file with prefix %s: %s", (Object)prefix, (Object)tListFile.getAbsolutePath());
        return new RSQSimEventsIterable(new FileInputStream(eListFile), new FileInputStream(pListFile), new FileInputStream(dListFile), new FileInputStream(tListFile), elements, rupIdens, RSQSimFileReader.isBigEndian(pListFile, elements), skipSlipsAndTimes);
    }

    public static File findByExt(File dir, String ext) throws FileNotFoundException {
        for (File file : dir.listFiles()) {
            if (!file.getName().endsWith(ext)) continue;
            return file;
        }
        throw new FileNotFoundException("No files ending in '" + ext + "' found in " + dir.getAbsolutePath());
    }

    public static int getNumEvents(File eListFile) throws IOException {
        if (eListFile.isDirectory()) {
            eListFile = RSQSimFileReader.findByExt(eListFile, ".eList");
        }
        RandomAccessFile raFile = new RandomAccessFile(eListFile, "r");
        byte[] recordBuffer = new byte[4];
        IntBuffer littleRecord = ByteBuffer.wrap(recordBuffer).order(ByteOrder.LITTLE_ENDIAN).asIntBuffer();
        IntBuffer bigRecord = ByteBuffer.wrap(recordBuffer).order(ByteOrder.BIG_ENDIAN).asIntBuffer();
        long len = raFile.length();
        long numVals = len / (long)recordBuffer.length;
        boolean bigEndian = true;
        boolean littleEndian = true;
        long pos = 0L;
        int prevLittle = -1;
        int prevBig = -1;
        int checkLoops = 0;
        while (bigEndian && littleEndian) {
            raFile.seek(pos);
            raFile.read(recordBuffer);
            int littleID = littleRecord.get(0);
            int bigID = bigRecord.get(0);
            if (prevLittle != -1 && prevBig != -1) {
                if (littleID < prevLittle) {
                    littleEndian = false;
                }
                if (bigID < prevBig) {
                    bigEndian = false;
                }
            }
            prevLittle = littleID;
            prevBig = bigID;
            pos += (long)recordBuffer.length;
            ++checkLoops;
        }
        Preconditions.checkState((bigEndian || littleEndian ? 1 : 0) != 0);
        raFile.seek(0L);
        raFile.read(recordBuffer);
        int firstID = littleEndian ? littleRecord.get(0) : bigRecord.get(0);
        raFile.seek((numVals - 1L) * (long)recordBuffer.length);
        raFile.read(recordBuffer);
        int lastID = littleEndian ? littleRecord.get(0) : bigRecord.get(0);
        raFile.close();
        return lastID - firstID;
    }

    public static double getDurationYears(File tListFile) throws IOException {
        if (tListFile.isDirectory()) {
            tListFile = RSQSimFileReader.findByExt(tListFile, ".tList");
        }
        RandomAccessFile raFile = new RandomAccessFile(tListFile, "r");
        byte[] recordBuffer = new byte[8];
        DoubleBuffer littleRecord = ByteBuffer.wrap(recordBuffer).order(ByteOrder.LITTLE_ENDIAN).asDoubleBuffer();
        DoubleBuffer bigRecord = ByteBuffer.wrap(recordBuffer).order(ByteOrder.BIG_ENDIAN).asDoubleBuffer();
        long len = raFile.length();
        long numVals = len / (long)recordBuffer.length;
        boolean bigEndian = true;
        boolean littleEndian = true;
        long pos = 0L;
        double prevLittle = Double.NaN;
        double prevBig = Double.NaN;
        int checkLoops = 0;
        while (bigEndian && littleEndian) {
            raFile.seek(pos);
            raFile.read(recordBuffer);
            double littleTime = littleRecord.get(0);
            double bigTime = bigRecord.get(0);
            if (!Double.isNaN(prevLittle) && !Double.isNaN(prevBig)) {
                if (!RSQSimFileReader.validTimes(prevLittle, littleTime)) {
                    littleEndian = false;
                }
                if (!RSQSimFileReader.validTimes(prevBig, bigTime)) {
                    bigEndian = false;
                }
            }
            prevLittle = littleTime;
            prevBig = bigTime;
            pos += (long)recordBuffer.length;
            ++checkLoops;
        }
        Preconditions.checkState((bigEndian || littleEndian ? 1 : 0) != 0);
        raFile.seek(0L);
        raFile.read(recordBuffer);
        double firstTime = littleEndian ? littleRecord.get(0) : bigRecord.get(0);
        raFile.seek((numVals - 1L) * (long)recordBuffer.length);
        raFile.read(recordBuffer);
        double lastTime = littleEndian ? littleRecord.get(0) : bigRecord.get(0);
        raFile.close();
        return (lastTime - firstTime) / 3.1536E7;
    }

    private static final boolean validTimes(double prevTime, double time) {
        if ((float)time >= (float)prevTime) {
            return true;
        }
        return prevTime - time < 60.0;
    }

    public static File getParamFile(File catalogDir) throws IOException {
        File bruceInFile = new File(catalogDir, "multiparam.in");
        if (bruceInFile.exists()) {
            return bruceInFile;
        }
        for (File file : catalogDir.listFiles()) {
            String name = file.getName();
            if (!name.endsWith(".in") || !RSQSimFileReader.isParamFile(file)) continue;
            return file;
        }
        return null;
    }

    private static boolean isParamFile(File file) throws IOException {
        int max = 1000;
        int count = 0;
        for (String line : Files.readLines((File)file, (Charset)Charset.defaultCharset())) {
            if ((line = line.trim()).startsWith("A_1")) {
                return true;
            }
            if (count++ <= max) continue;
            return false;
        }
        return false;
    }

    public static Map<String, String> readParams(File paramFile) throws IOException {
        System.out.println("Loading params from " + paramFile.getAbsolutePath());
        HashMap<String, String> params = new HashMap<String, String>();
        for (String line : Files.readLines((File)paramFile, (Charset)Charset.defaultCharset())) {
            if (!(line = line.trim()).contains("=")) continue;
            int ind = line.indexOf("=");
            String key = line.substring(0, ind).trim();
            String val = line.substring(ind + 1).trim();
            params.put(key, val);
        }
        return params;
    }

    private static class EventRecordTimeComparator
    implements Comparator<RSQSimEventRecord> {
        private EventRecordTimeComparator() {
        }

        @Override
        public int compare(RSQSimEventRecord o1, RSQSimEventRecord o2) {
            return Double.compare(o1.getTime(), o2.getTime());
        }
    }

    private static class RSQSimEventsIterable
    implements Iterable<RSQSimEvent> {
        private InputStream eListStream;
        private InputStream pListStream;
        private InputStream dListStream;
        private InputStream tListStream;
        private List<SimulatorElement> elements;
        private Collection<? extends RuptureIdentifier> rupIdens;
        private boolean bigEndian;
        private boolean skipSlipsAndTimes;

        private RSQSimEventsIterable(InputStream eListStream, InputStream pListStream, InputStream dListStream, InputStream tListStream, List<SimulatorElement> elements, Collection<? extends RuptureIdentifier> rupIdens, boolean bigEndian, boolean skipSlipsAndTimes) {
            this.eListStream = eListStream;
            this.pListStream = pListStream;
            this.dListStream = dListStream;
            this.tListStream = tListStream;
            this.elements = elements;
            this.rupIdens = rupIdens;
            this.bigEndian = bigEndian;
            this.skipSlipsAndTimes = skipSlipsAndTimes;
        }

        @Override
        public Iterator<RSQSimEvent> iterator() {
            final LinkedBlockingDeque<RSQSimEvent> deque = new LinkedBlockingDeque<RSQSimEvent>(10000);
            Thread loadThread = new Thread(this){
                final /* synthetic */ RSQSimEventsIterable this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    try {
                        RSQSimFileReader.populateEvents(this.this$0.eListStream, this.this$0.pListStream, this.this$0.dListStream, this.this$0.tListStream, this.this$0.elements, this.this$0.rupIdens, this.this$0.bigEndian, deque, this.this$0.skipSlipsAndTimes);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            };
            loadThread.start();
            return new RSQSimEventsIterator(deque, loadThread);
        }
    }

    private static class RSQSimEventsIterator
    implements Iterator<RSQSimEvent> {
        private BlockingDeque<RSQSimEvent> deque;
        private Thread loadThread;

        private RSQSimEventsIterator(BlockingDeque<RSQSimEvent> deque, Thread loadThread) {
            this.deque = deque;
            this.loadThread = loadThread;
        }

        @Override
        public boolean hasNext() {
            this.waitUntilReady();
            return !this.deque.isEmpty();
        }

        @Override
        public RSQSimEvent next() {
            this.waitUntilReady();
            Preconditions.checkState((this.deque.size() <= 10000 ? 1 : 0) != 0);
            return (RSQSimEvent)this.deque.removeFirst();
        }

        private void waitUntilReady() {
            while (this.deque.isEmpty() && this.loadThread.isAlive()) {
            }
        }
    }
}

