/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.simulators.srf;

import com.google.common.base.Preconditions;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.math3.stat.StatUtils;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;
import org.jfree.chart.annotations.XYTextAnnotation;
import org.jfree.chart.ui.TextAnchor;
import org.jfree.data.Range;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DefaultXY_DataSet;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.geo.Location;
import org.opensha.commons.gui.plot.HeadlessGraphPanel;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotSpec;
import org.opensha.commons.gui.plot.PlotSymbol;
import org.opensha.sha.earthquake.FocalMechanism;
import org.opensha.sha.simulators.RSQSimEvent;
import org.opensha.sha.simulators.SimulatorElement;
import org.opensha.sha.simulators.iden.EventIDsRupIden;
import org.opensha.sha.simulators.parsers.RSQSimFileReader;
import org.opensha.sha.simulators.srf.RSQSimEventSlipTimeFunc;
import org.opensha.sha.simulators.srf.RSQSimState;
import org.opensha.sha.simulators.srf.RSQSimStateTime;
import org.opensha.sha.simulators.srf.RSQSimStateTransitionFileReader;
import org.opensha.sha.simulators.srf.SRF_PointData;

public class RSQSimSRFGenerator {
    public static List<SRF_PointData> buildSRF(RSQSimEventSlipTimeFunc func, List<SimulatorElement> patches, double dt, SRFInterpolationMode mode) {
        ArrayList<SRF_PointData> srfs = new ArrayList<SRF_PointData>();
        for (SimulatorElement patch : patches) {
            srfs.add(RSQSimSRFGenerator.buildSRF(func, patch, dt, mode));
        }
        return srfs;
    }

    public static SRF_PointData buildSRF(RSQSimEventSlipTimeFunc func, SimulatorElement patch, double dt, SRFInterpolationMode mode) {
        func = func.asRelativeTimeFunc();
        Location loc = patch.getCenterLocation();
        int patchID = patch.getID();
        double tStart = func.getTimeOfFirstSlip(patchID);
        Preconditions.checkState((boolean)Double.isFinite(tStart), (String)"Non-finite tStart for patch %s? %s", (Object)patchID, (Object)tStart);
        double tEnd = func.getTimeOfLastSlip(patchID);
        Preconditions.checkState((boolean)Double.isFinite(tEnd), (String)"Non-finite tEnd for patch %s? %s", (Object)patchID, (Object)tEnd);
        ArrayList<Taper> tapers = null;
        if (mode == SRFInterpolationMode.LIN_TAPER_VEL) {
            tapers = new ArrayList<Taper>();
            for (RSQSimStateTime trans : func.getTransitions(patchID)) {
                if (trans.state != RSQSimState.EARTHQUAKE_SLIP) continue;
                double s = trans.absoluteTime;
                double d = trans.getDuration();
                double e = s + d;
                double taperLen = d * 0.1;
                double upTaperStart = s - 0.5 * taperLen;
                double upTaperEnd = s + 0.5 * taperLen;
                double downTaperStart = e - 0.5 * taperLen;
                double downTaperEnd = e + 0.5 * taperLen;
                tStart = Math.min(tStart, upTaperStart);
                tEnd = Math.max(tEnd, downTaperEnd);
                double slipVel = func.getVelocity(trans);
                Preconditions.checkState((Double.isFinite(slipVel) && slipVel > 0.0 ? 1 : 0) != 0, (String)"Bad slipVel for patch %s? %s", (Object)patchID, (Object)slipVel);
                tapers.add(new Taper(upTaperStart, upTaperEnd, downTaperStart, downTaperEnd, slipVel));
            }
        }
        FocalMechanism focal = patch.getFocalMechanism();
        double totSlip = func.getCumulativeEventSlip(patchID, func.getEndTime());
        int numSteps = (int)Math.ceil((tEnd - tStart) / dt);
        double[] slipVels = new double[numSteps];
        double curTotSlip = 0.0;
        for (int i = 0; i < numSteps; ++i) {
            double time = tStart + dt * (double)i;
            switch (mode.ordinal()) {
                case 0: {
                    slipVels[i] = func.getVelocity(patchID, time);
                    break;
                }
                case 1: {
                    double slipStart = func.getCumulativeEventSlip(patchID, time);
                    double slipEnd = func.getCumulativeEventSlip(patchID, time + dt);
                    slipVels[i] = (slipEnd - slipStart) / dt;
                    break;
                }
                case 2: {
                    for (Taper taper : tapers) {
                        int n = i;
                        slipVels[n] = slipVels[n] + taper.getVel(time);
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown interpolation mode: " + String.valueOf((Object)mode));
                }
            }
            curTotSlip += slipVels[i] * dt;
        }
        return new SRF_PointData(loc, focal, patch.getArea(), tStart, dt, totSlip, slipVels);
    }

    public static void plotSlip(File outputDir, String prefix, RSQSimEvent event, RSQSimEventSlipTimeFunc func, SimulatorElement patch, double dt, boolean pub, SRFInterpolationMode ... modes) throws IOException {
        ArrayList<ArbitrarilyDiscretizedFunc> slipFuncs = new ArrayList<ArbitrarilyDiscretizedFunc>();
        ArrayList<PlotCurveCharacterstics> slipChars = new ArrayList<PlotCurveCharacterstics>();
        ArrayList<DefaultXY_DataSet> velFuncs = new ArrayList<DefaultXY_DataSet>();
        ArrayList<PlotCurveCharacterstics> velChars = new ArrayList<PlotCurveCharacterstics>();
        func = func.asRelativeTimeFunc();
        int patchID = patch.getID();
        PlotCurveCharacterstics actualChar = pub ? new PlotCurveCharacterstics(PlotLineType.DASHED, 3.0f, PlotSymbol.FILLED_CIRCLE, 5.0f, Color.GRAY) : new PlotCurveCharacterstics(PlotLineType.SOLID, 4.0f, PlotSymbol.FILLED_CIRCLE, 5.0f, Color.BLACK);
        DiscretizedFunc origSlipFunc = func.getSlipFunc(patchID);
        ArbitrarilyDiscretizedFunc shiftedSlipFunc = new ArbitrarilyDiscretizedFunc();
        for (Point2D pt : origSlipFunc) {
            shiftedSlipFunc.set(pt.getX(), pt.getY());
        }
        shiftedSlipFunc.setName("Actual");
        slipFuncs.add(shiftedSlipFunc);
        slipChars.add(actualChar);
        DefaultXY_DataSet actualVelFunc = new DefaultXY_DataSet();
        double firstSlip = Double.NaN;
        double lastSlip = 0.0;
        for (RSQSimStateTime trans : func.getTransitions(patchID)) {
            double vel = trans.state == RSQSimState.EARTHQUAKE_SLIP ? func.getVelocity(trans) : 0.0;
            if (actualVelFunc.size() == 0) {
                actualVelFunc.set(trans.absoluteTime, 0.0);
                firstSlip = trans.absoluteTime;
            }
            actualVelFunc.set(trans.absoluteTime, vel);
            if (trans.hasDuration()) {
                double endTime = trans.absoluteTime + trans.getDuration();
                actualVelFunc.set(endTime, vel);
                lastSlip = endTime;
                continue;
            }
            lastSlip = trans.absoluteTime;
        }
        actualVelFunc.set(actualVelFunc.getMaxX(), 0.0);
        velFuncs.add(actualVelFunc);
        velChars.add(actualChar);
        DecimalFormat slipDF = new DecimalFormat("0.000");
        ArrayList<XYTextAnnotation> slipAnns = new ArrayList<XYTextAnnotation>();
        double annX = 0.1;
        double totSlip = func.getCumulativeEventSlip(patchID, func.getEndTime());
        double slipMaxY = totSlip * 1.05;
        Font annFont = new Font("SansSerif", 1, 24);
        XYTextAnnotation totAnn = new XYTextAnnotation("Total Slip: " + slipDF.format(totSlip), annX, slipMaxY * (1.0 - 0.05 * (double)slipFuncs.size()));
        totAnn.setTextAnchor(TextAnchor.TOP_LEFT);
        totAnn.setFont(annFont);
        slipAnns.add(totAnn);
        double eventLen = func.getEndTime();
        if (event != null) {
            double eventTime = event.getTime();
            int[] ids = event.getAllElementIDs();
            double[] slips = event.getAllElementSlips();
            double[] times = event.getAllElementTimes();
            for (int i = 0; i < ids.length && !pub; ++i) {
                if (ids[i] != patch.getID()) continue;
                double deltaT = times[i] - eventTime;
                ArbitrarilyDiscretizedFunc listFunc = new ArbitrarilyDiscretizedFunc();
                listFunc.setName("List File Slip");
                listFunc.set(deltaT, slips[i]);
                listFunc.set(eventLen, slips[i]);
                slipFuncs.add(listFunc);
                slipChars.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 3.0f, Color.GREEN.darker()));
                XYTextAnnotation listAnn = new XYTextAnnotation("List File Slip: " + slipDF.format(slips[i]), annX, slipMaxY * (1.0 - 0.06 * (double)slipFuncs.size()));
                listAnn.setTextAnchor(TextAnchor.TOP_LEFT);
                listAnn.setFont(annFont);
                listAnn.setPaint((Paint)Color.GREEN.darker());
                slipAnns.add(listAnn);
                break;
            }
        }
        for (SRFInterpolationMode mode : modes) {
            Color c;
            SRF_PointData srf = RSQSimSRFGenerator.buildSRF(func, patch, dt, mode);
            if (pub) {
                c = Color.BLACK;
            } else {
                switch (mode.ordinal()) {
                    case 0: {
                        c = Color.RED;
                        break;
                    }
                    case 1: {
                        c = Color.GREEN.darker();
                        break;
                    }
                    case 2: {
                        c = Color.CYAN;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown interpolation mode: " + String.valueOf((Object)mode));
                    }
                }
            }
            PlotCurveCharacterstics srfChar = new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, c);
            double[] slips = srf.getCumulativeSlips1();
            double[] vels = srf.getVelocities1();
            ArbitrarilyDiscretizedFunc slipFunc = new ArbitrarilyDiscretizedFunc();
            slipFunc.setName(pub ? "Discretized" : mode.toString());
            for (int i = 0; i < slips.length; ++i) {
                slipFunc.set(srf.getTime(i), slips[i]);
            }
            slipFuncs.add(slipFunc);
            slipChars.add(srfChar);
            XYTextAnnotation srfAnn = new XYTextAnnotation("Interp " + mode.name + " Slip: " + slipDF.format(slipFunc.getMaxY()), annX, slipMaxY * (1.0 - 0.06 * (double)slipFuncs.size()));
            srfAnn.setTextAnchor(TextAnchor.TOP_LEFT);
            srfAnn.setFont(annFont);
            srfAnn.setPaint((Paint)c);
            slipAnns.add(srfAnn);
            eventLen = Math.max(eventLen, slipFunc.getMaxX());
            DefaultXY_DataSet velFunc = new DefaultXY_DataSet();
            velFunc.setName(mode.toString());
            for (int i = 0; i < vels.length; ++i) {
                if (i == 0) {
                    velFunc.set(srf.getTime(i), 0.0);
                }
                velFunc.set(srf.getTime(i), vels[i]);
                velFunc.set(srf.getTime(i + 1), vels[i]);
            }
            velFunc.set(velFunc.getMaxX(), 0.0);
            velFuncs.add(velFunc);
            velChars.add(srfChar);
        }
        String title = pub ? null : "SRF Validation";
        String xAxisLabel = "Time (seconds)";
        PlotSpec slipSpec = new PlotSpec(slipFuncs, slipChars, title, xAxisLabel, "Cumulative Slip (m)");
        slipSpec.setLegendVisible(true);
        if (!pub) {
            slipSpec.setPlotAnnotations(slipAnns);
        }
        PlotSpec velSpec = new PlotSpec(velFuncs, velChars, title, xAxisLabel, "Velocity (m/s)");
        velSpec.setLegendVisible(false);
        ArrayList<PlotSpec> specs = new ArrayList<PlotSpec>();
        specs.add(slipSpec);
        specs.add(velSpec);
        Range xAxisRange = new Range(0.0, eventLen);
        if (pub) {
            double minX = Math.max(0.0, Math.floor(firstSlip - 0.5));
            double maxX = Math.min(eventLen, Math.ceil(lastSlip + 0.5));
            xAxisRange = new Range(minX, maxX);
        }
        HeadlessGraphPanel gp = new HeadlessGraphPanel();
        gp.setTickLabelFontSize(18);
        gp.setAxisLabelFontSize(20);
        gp.setPlotLabelFontSize(21);
        gp.setBackgroundColor(Color.WHITE);
        ArrayList<Range> xRanges = new ArrayList<Range>();
        xRanges.add(xAxisRange);
        ArrayList<Range> yRanges = new ArrayList<Range>();
        yRanges.add(new Range(0.0, slipMaxY));
        yRanges.add(new Range(0.0, func.getMaxSlipVel() * 1.05));
        gp.drawGraphPanel(specs, false, false, xRanges, null);
        Preconditions.checkState((outputDir.exists() || outputDir.mkdir() ? 1 : 0) != 0);
        File file = new File(outputDir, prefix);
        gp.getChartPanel().setSize(1000, 1000);
        gp.saveAsPNG(file.getAbsolutePath() + ".png");
        gp.saveAsPDF(file.getAbsolutePath() + ".pdf");
    }

    public static void plotSlip(File outputDir, String prefix, SRF_PointData patch, double maxTime, boolean zoom) throws IOException {
        ArrayList<ArbitrarilyDiscretizedFunc> slipFuncs = new ArrayList<ArbitrarilyDiscretizedFunc>();
        ArrayList<PlotCurveCharacterstics> slipChars = new ArrayList<PlotCurveCharacterstics>();
        ArrayList<ArbitrarilyDiscretizedFunc> velFuncs = new ArrayList<ArbitrarilyDiscretizedFunc>();
        ArrayList<PlotCurveCharacterstics> velChars = new ArrayList<PlotCurveCharacterstics>();
        PlotCurveCharacterstics totalChar = new PlotCurveCharacterstics(PlotLineType.SOLID, 4.0f, PlotSymbol.FILLED_CIRCLE, 5.0f, Color.BLACK);
        PlotCurveCharacterstics comp1Char = new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.RED);
        PlotCurveCharacterstics comp2Char = new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.GREEN);
        PlotCurveCharacterstics comp3Char = new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLUE);
        double[] vels = patch.getTotalVelocities();
        double[] slips = patch.getTotalCumulativeSlips();
        boolean multiComp = true;
        ArbitrarilyDiscretizedFunc totalSlipFunc = new ArbitrarilyDiscretizedFunc("Overall");
        slipFuncs.add(totalSlipFunc);
        slipChars.add(totalChar);
        ArbitrarilyDiscretizedFunc comp1SlipFunc = null;
        ArbitrarilyDiscretizedFunc comp2SlipFunc = null;
        ArbitrarilyDiscretizedFunc comp3SlipFunc = null;
        if (multiComp) {
            comp1SlipFunc = new ArbitrarilyDiscretizedFunc("u1");
            slipFuncs.add(comp1SlipFunc);
            slipChars.add(comp1Char);
            comp2SlipFunc = new ArbitrarilyDiscretizedFunc("u2");
            slipFuncs.add(comp2SlipFunc);
            slipChars.add(comp2Char);
            comp3SlipFunc = new ArbitrarilyDiscretizedFunc("u3");
            slipFuncs.add(comp3SlipFunc);
            slipChars.add(comp3Char);
        }
        for (int i = 0; i < slips.length; ++i) {
            double time = patch.getTime(i);
            totalSlipFunc.set(time, slips[i]);
            if (!multiComp) continue;
            if (patch.getCumulativeSlips1().length > i) {
                comp1SlipFunc.set(time, patch.getCumulativeSlips1()[i]);
            }
            if (patch.getCumulativeSlips2().length > i) {
                comp2SlipFunc.set(time, patch.getCumulativeSlips2()[i]);
            }
            if (patch.getCumulativeSlips3().length <= i) continue;
            comp3SlipFunc.set(time, patch.getCumulativeSlips3()[i]);
        }
        ArbitrarilyDiscretizedFunc totalVelFunc = new ArbitrarilyDiscretizedFunc("Overall");
        velFuncs.add(totalVelFunc);
        velChars.add(totalChar);
        ArbitrarilyDiscretizedFunc comp1VelFunc = null;
        ArbitrarilyDiscretizedFunc comp2VelFunc = null;
        ArbitrarilyDiscretizedFunc comp3VelFunc = null;
        if (multiComp) {
            comp1VelFunc = new ArbitrarilyDiscretizedFunc("u1");
            velFuncs.add(comp1VelFunc);
            velChars.add(comp1Char);
            comp2VelFunc = new ArbitrarilyDiscretizedFunc("u2");
            velFuncs.add(comp2VelFunc);
            velChars.add(comp2Char);
            comp3VelFunc = new ArbitrarilyDiscretizedFunc("u3");
            velFuncs.add(comp3VelFunc);
            velChars.add(comp3Char);
        }
        for (int i = 0; i < vels.length; ++i) {
            double time = patch.getTime(i);
            totalVelFunc.set(time, vels[i]);
            if (!multiComp) continue;
            if (patch.getVelocities1().length > i) {
                comp1VelFunc.set(time, patch.getVelocities1()[i]);
            }
            if (patch.getVelocities2().length > i) {
                comp2VelFunc.set(time, patch.getVelocities2()[i]);
            }
            if (patch.getVelocities3().length <= i) continue;
            comp3VelFunc.set(time, patch.getVelocities3()[i]);
        }
        String title = "SRF Patch History";
        String xAxisLabel = "Time (seconds)";
        PlotSpec slipSpec = new PlotSpec(slipFuncs, slipChars, title, xAxisLabel, "Cumulative Slip (m)");
        slipSpec.setLegendVisible(true);
        PlotSpec velSpec = new PlotSpec(velFuncs, velChars, title, xAxisLabel, "Velocity (m/s)");
        velSpec.setLegendVisible(false);
        ArrayList<PlotSpec> specs = new ArrayList<PlotSpec>();
        specs.add(slipSpec);
        specs.add(velSpec);
        Range xAxisRange = new Range(0.0, maxTime);
        if (zoom) {
            double minX = Math.max(0.0, Math.floor(totalSlipFunc.getMinX() - 0.5));
            double maxX = Math.min(maxTime, Math.ceil(totalSlipFunc.getMaxX() + 0.5));
            xAxisRange = new Range(minX, maxX);
        }
        HeadlessGraphPanel gp = new HeadlessGraphPanel();
        gp.setTickLabelFontSize(18);
        gp.setAxisLabelFontSize(20);
        gp.setPlotLabelFontSize(21);
        gp.setBackgroundColor(Color.WHITE);
        ArrayList<Range> xRanges = new ArrayList<Range>();
        xRanges.add(xAxisRange);
        ArrayList<Range> yRanges = new ArrayList<Range>();
        yRanges.add(new Range(0.0, patch.getTotalSlip()));
        yRanges.add(new Range(0.0, StatUtils.max((double[])patch.getTotalVelocities()) * 1.05));
        gp.drawGraphPanel(specs, false, false, xRanges, null);
        Preconditions.checkState((outputDir.exists() || outputDir.mkdir() ? 1 : 0) != 0);
        File file = new File(outputDir, prefix);
        gp.getChartPanel().setSize(1000, 1000);
        gp.saveAsPNG(file.getAbsolutePath() + ".png");
        gp.saveAsPDF(file.getAbsolutePath() + ".pdf");
    }

    public static void main(String[] args) throws IOException {
        File catalogDir = new File("/data/kevin/simulators/catalogs/bruce/rundir4841");
        File geomFile = new File(catalogDir, "zfault_Deepen.in");
        File transFile = new File(catalogDir, "transV..out");
        RSQSimStateTransitionFileReader.TransVersion version = transFile.getName().toLowerCase().contains("transv") ? RSQSimStateTransitionFileReader.TransVersion.TRANSV : RSQSimStateTransitionFileReader.TransVersion.CONSOLIDATED_RELATIVE;
        int[] eventIDs = new int[]{755070, 2441060};
        double[] timeScalars = new double[]{1.0};
        boolean[] velScales = new boolean[]{false};
        boolean plotIndividual = true;
        int plotMod = 10;
        boolean writeSRF = false;
        double slipVel = 1.0;
        File outputDir = new File(catalogDir, "event_srfs");
        Preconditions.checkState((outputDir.exists() || outputDir.mkdir() ? 1 : 0) != 0);
        System.out.println("Loading geometry...");
        List<SimulatorElement> elements = RSQSimFileReader.readGeometryFile(geomFile, 11, 'S');
        ArrayList<EventIDsRupIden> loadIdens = new ArrayList<EventIDsRupIden>();
        loadIdens.add(new EventIDsRupIden(eventIDs));
        System.out.println("Loading events...");
        List<RSQSimEvent> events = RSQSimFileReader.readEventsFile(catalogDir, elements, loadIdens);
        System.out.println("Loaded " + events.size() + " events");
        Preconditions.checkState((events.size() == eventIDs.length ? 1 : 0) != 0);
        RSQSimStateTransitionFileReader transReader = new RSQSimStateTransitionFileReader(transFile, elements, version);
        SRFInterpolationMode[] modes = new SRFInterpolationMode[]{SRFInterpolationMode.ADJ_VEL};
        double[] dts = new double[]{1.0};
        double srfVersion = 1.0;
        int patchDigits = ("" + elements.size()).length();
        for (RSQSimEvent event : events) {
            System.out.println("Event: " + event.getID() + ", M" + (float)event.getMagnitude());
            int eventID = event.getID();
            HashMap<Integer, Double> slipVels = new HashMap<Integer, Double>();
            for (int elemID : event.getAllElementIDs()) {
                slipVels.put(elemID, slipVel);
            }
            RSQSimEventSlipTimeFunc func = new RSQSimEventSlipTimeFunc(transReader.getTransitions(event));
            String eventStr = "event_" + eventID;
            SummaryStatistics patchSlipEventDurations = new SummaryStatistics();
            SummaryStatistics patchFractSlippingDurations = new SummaryStatistics();
            SummaryStatistics patchSlipTotalDurations = new SummaryStatistics();
            SummaryStatistics patchCounts = new SummaryStatistics();
            Iterator iterator = slipVels.keySet().iterator();
            while (iterator.hasNext()) {
                int patchID = (Integer)iterator.next();
                List<RSQSimStateTime> patchTrans = func.getTransitions(patchID);
                int count = 0;
                double totSlippingDuration = 0.0;
                for (RSQSimStateTime state : patchTrans) {
                    if (state.state != RSQSimState.EARTHQUAKE_SLIP) continue;
                    ++count;
                    double duration = state.getDuration();
                    patchSlipEventDurations.addValue(duration);
                    totSlippingDuration += duration;
                }
                double totDuration = func.getTimeOfLastSlip(patchID) - func.getTimeOfFirstSlip(patchID);
                patchSlipTotalDurations.addValue(totDuration);
                patchFractSlippingDurations.addValue(totSlippingDuration / totDuration);
                patchCounts.addValue((double)count);
            }
            System.out.println("Patches slipped an average of " + (float)patchCounts.getMean() + " times (range: " + (int)patchCounts.getMin() + " => " + (int)patchCounts.getMax() + ")");
            System.out.println("Each slip event has an average duration of " + (float)patchSlipEventDurations.getMean() + "s and a range of " + (float)patchSlipEventDurations.getMin() + "s to " + (float)patchSlipEventDurations.getMax() + "s");
            System.out.println("The average total duration (from beginning of first slip to end of last slip on an individual patch) is " + (float)patchSlipTotalDurations.getMean() + "s (range: " + (float)patchSlipTotalDurations.getMin() + "s => " + (float)patchSlipTotalDurations.getMax() + "s)");
            System.out.println("Of the duration (as defined above), patches are slipping (on average) " + (float)(100.0 * patchFractSlippingDurations.getMean()) + " % of the time (range: " + (float)(100.0 * patchFractSlippingDurations.getMin()) + "% => " + (float)(100.0 * patchFractSlippingDurations.getMax()) + "%)");
            for (Object dt : (Iterator)dts) {
                ArrayList<SimulatorElement> patches = event.getAllElements();
                for (double timeScale : timeScalars) {
                    boolean[] myVelScales = timeScale == 1.0 ? new boolean[]{false} : velScales;
                    for (boolean velScale : myVelScales) {
                        String prefix = eventStr + "_" + (float)dt + "s";
                        RSQSimEventSlipTimeFunc myFunc = func;
                        if (timeScale != 1.0) {
                            prefix = prefix + "_timeScale" + (float)timeScale;
                            if (velScale) {
                                prefix = prefix + "_velScale";
                            }
                            myFunc = func.getTimeScaledFunc(timeScale, velScale);
                        }
                        File eventOutputDir = new File(outputDir, prefix);
                        System.out.println("dt=" + (double)dt + " => " + outputDir.getAbsolutePath());
                        Preconditions.checkState((eventOutputDir.exists() || eventOutputDir.mkdir() ? 1 : 0) != 0);
                        if (plotIndividual) {
                            System.out.println("Plotting patch slip/vel functions");
                            for (int i = 0; i < patches.size(); ++i) {
                                if (i % plotMod > 0) continue;
                                SimulatorElement patch = patches.get(i);
                                prefix = "" + patch.getID();
                                while (prefix.length() < patchDigits) {
                                    prefix = "0" + prefix;
                                }
                                prefix = "patch_" + prefix;
                                RSQSimSRFGenerator.plotSlip(eventOutputDir, prefix, event, myFunc, patch, (double)dt, false, modes);
                            }
                        }
                        if (!writeSRF) continue;
                        for (SRFInterpolationMode mode : modes) {
                            File srfFile = new File(eventOutputDir.getAbsolutePath() + "_" + mode.name() + ".srf");
                            System.out.println("Generating SRF for dt=" + (float)dt + ", " + String.valueOf((Object)mode));
                            List<SRF_PointData> srf = RSQSimSRFGenerator.buildSRF(myFunc, patches, (double)dt, mode);
                            SRF_PointData.writeSRF(srfFile, srf, srfVersion);
                        }
                    }
                }
            }
        }
    }

    public static enum SRFInterpolationMode {
        NONE("None"),
        ADJ_VEL("Adj. Velocity"),
        LIN_TAPER_VEL("Linear Taper");

        private String name;

        private SRFInterpolationMode(String name) {
            this.name = name;
        }
    }

    private static class Taper {
        private double upTaperStart;
        private double upTaperEnd;
        private double downTaperStart;
        private double downTaperEnd;
        private double vel;

        public Taper(double upTaperStart, double upTaperEnd, double downTaperStart, double downTaperEnd, double vel) {
            this.upTaperStart = upTaperStart;
            this.upTaperEnd = upTaperEnd;
            Preconditions.checkState((upTaperEnd > upTaperStart ? 1 : 0) != 0);
            this.downTaperStart = downTaperStart;
            this.downTaperEnd = downTaperEnd;
            Preconditions.checkState((downTaperEnd > downTaperStart ? 1 : 0) != 0);
            Preconditions.checkState((downTaperStart > upTaperEnd ? 1 : 0) != 0);
            this.vel = vel;
        }

        public double getVel(double time) {
            if (time < this.upTaperStart || time > this.downTaperEnd) {
                return 0.0;
            }
            if (time < this.upTaperEnd) {
                double fract = (time - this.upTaperStart) / (this.upTaperEnd - this.upTaperStart);
                return fract * this.vel;
            }
            if (time > this.downTaperStart) {
                double fract = (time - this.downTaperStart) / (this.downTaperEnd - this.downTaperStart);
                return (1.0 - fract) * this.vel;
            }
            return this.vel;
        }
    }
}

