/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.simulators.srf;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Range;
import com.google.common.collect.Table;
import com.google.common.primitives.Ints;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.sha.simulators.EventRecord;
import org.opensha.sha.simulators.RSQSimEvent;
import org.opensha.sha.simulators.RSQSimEventRecord;
import org.opensha.sha.simulators.SimulatorElement;
import org.opensha.sha.simulators.iden.EventIDsRupIden;
import org.opensha.sha.simulators.parsers.RSQSimFileReader;
import org.opensha.sha.simulators.srf.RSQSimState;
import org.opensha.sha.simulators.srf.RSQSimStateTime;

public class RSQSimStateTransitionFileReader {
    private RandomAccessFile raFile;
    private long numTransitions;
    private ByteOrder byteOrder;
    private byte[] doubleBytes = new byte[8];
    private DoubleBuffer doubleBuff;
    private byte[] floatBytes = new byte[4];
    private FloatBuffer floatBuff;
    private byte[] intBytes = new byte[4];
    private IntBuffer intBuff;
    private double firstTime = Double.NaN;
    private double lastTime = Double.NaN;
    private double[] timeMarkers;
    private long[] indexMarkers;
    private int transPerRead;
    private long curIndex;
    private byte[] fullBuffer;
    private RSQSimStateTime[] curTrans;
    private int batchReads = 0;
    private int backwardReads = 0;
    private TransVersion version;
    private int bytesPerRecord;
    private Map<Integer, Double> patchFixedVels;
    private static final boolean binary_search_within_bucket = false;
    private static final int num_time_func_precalcs = 1000;
    private static final int max_trans_per_read = Integer.MAX_VALUE;
    private static double MAX_POST_READ = 604800.0;
    private boolean retainNegatives = false;
    private boolean quiet;
    private static DecimalFormat timeDF = new DecimalFormat("0.000");

    public RSQSimStateTransitionFileReader(File file, ByteOrder byteOrder, TransVersion version) throws IOException {
        this(file, byteOrder, null, version);
    }

    public RSQSimStateTransitionFileReader(File file, List<SimulatorElement> elements) throws IOException {
        this(file, null, elements, null);
    }

    public RSQSimStateTransitionFileReader(File file, List<SimulatorElement> elements, TransVersion version) throws IOException {
        this(file, null, elements, version);
    }

    public RSQSimStateTransitionFileReader(File file, List<SimulatorElement> elements, ByteOrder byteOrder) throws IOException {
        this(file, byteOrder, elements, null);
    }

    private RSQSimStateTransitionFileReader(File file, ByteOrder byteOrder, List<SimulatorElement> elements, TransVersion version) throws IOException {
        this.raFile = new RandomAccessFile(file, "r");
        long length = this.raFile.length();
        this.version = version;
        this.byteOrder = byteOrder;
        if (byteOrder == null || version == null) {
            this.detectEndianAndVersion(elements);
        }
        this.bytesPerRecord = this.version.bytesPerRecord;
        this.numTransitions = length / (long)this.bytesPerRecord;
        if (length % (long)this.bytesPerRecord > 0L) {
            System.err.println("Warning, unexpected number of bytes in transitions file, possibly truncated. Extra: " + length % (long)this.bytesPerRecord);
        }
        System.out.println("Detected " + this.numTransitions + " transitions");
        ByteBuffer doubleRecord = ByteBuffer.wrap(this.doubleBytes);
        doubleRecord.order(byteOrder);
        this.doubleBuff = doubleRecord.asDoubleBuffer();
        ByteBuffer floatRecord = ByteBuffer.wrap(this.floatBytes);
        floatRecord.order(byteOrder);
        this.floatBuff = floatRecord.asFloatBuffer();
        ByteBuffer intRecord = ByteBuffer.wrap(this.intBytes);
        intRecord.order(byteOrder);
        this.intBuff = intRecord.asIntBuffer();
    }

    private void detectEndianAndVersion(List<SimulatorElement> elements) throws IOException {
        DoubleBuffer doubleRecord;
        ByteOrder[] testOrders;
        TransVersion[] testVersions;
        if (this.version == null) {
            System.out.println("Need to detect transition file version");
            testVersions = TransVersion.values();
        } else {
            testVersions = new TransVersion[]{this.version};
        }
        boolean D = false;
        if (this.byteOrder == null) {
            System.out.println("Need to detect transition file byte order");
            testOrders = new ByteOrder[]{ByteOrder.LITTLE_ENDIAN, ByteOrder.BIG_ENDIAN};
        } else {
            testOrders = new ByteOrder[]{this.byteOrder};
        }
        int numTestsEach = 100;
        Random r = new Random();
        byte[] intRecordBuffer = new byte[4];
        byte[] doubleRecordBuffer = new byte[8];
        HashBasedTable testResults = HashBasedTable.create();
        HashBasedTable testFailPatches = HashBasedTable.create();
        for (TransVersion testVersion : testVersions) {
            for (ByteOrder testOrder : testOrders) {
                IntBuffer intRecord = ByteBuffer.wrap(intRecordBuffer).order(testOrder).asIntBuffer();
                doubleRecord = ByteBuffer.wrap(doubleRecordBuffer).order(testOrder).asDoubleBuffer();
                if (D) {
                    System.out.println("Testing " + String.valueOf((Object)testVersion) + ", " + String.valueOf(testOrder));
                }
                boolean valid = true;
                long numVals = this.raFile.length() / (long)testVersion.bytesPerRecord;
                Preconditions.checkState((numVals > 1L ? 1 : 0) != 0, (Object)"Not enough values to test");
                if (numVals > Integer.MAX_VALUE) {
                    numVals = Integer.MAX_VALUE;
                }
                ArbitrarilyDiscretizedFunc indexTimeFunc = new ArbitrarilyDiscretizedFunc();
                for (int i = 0; i < numTestsEach && valid; ++i) {
                    long patchPos;
                    long timePos;
                    long index = r.nextInt((int)numVals);
                    long pos = index * (long)testVersion.bytesPerRecord;
                    switch (testVersion.ordinal()) {
                        case 0: {
                            timePos = pos;
                            patchPos = pos + 8L;
                            break;
                        }
                        case 1: {
                            timePos = pos;
                            patchPos = pos + 8L;
                            break;
                        }
                        case 2: {
                            timePos = pos;
                            patchPos = pos + 16L;
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unsupported transition version: " + String.valueOf((Object)this.version));
                        }
                    }
                    this.raFile.seek(timePos);
                    this.raFile.read(doubleRecordBuffer);
                    double absTime = doubleRecord.get(0);
                    indexTimeFunc.set(index, absTime);
                    this.raFile.seek(patchPos);
                    this.raFile.read(intRecordBuffer);
                    int patchID = intRecord.get(0) + 1;
                    valid = RSQSimFileReader.isValidPatchID(patchID, elements);
                    if (!valid) {
                        testFailPatches.put((Object)testVersion, (Object)testOrder, (Object)patchID);
                    }
                    if (!D || i >= 5) continue;
                    System.out.println(i + ". p=" + patchID + "\tt=" + absTime);
                }
                if (D) {
                    System.out.println("\tpatch valid? " + valid);
                }
                for (int n = 1; valid && n < indexTimeFunc.size(); ++n) {
                    boolean bl = valid = indexTimeFunc.getY(n) >= indexTimeFunc.getY(n - 1);
                    if (!D || valid) continue;
                    System.out.println("\tINVALD: indexTimeFunc.getY(" + n + ")=" + indexTimeFunc.getY(n) + ", indexTimeFunc.getY(" + (n - 1) + ")=" + indexTimeFunc.getY(n - 1));
                }
                if (D) {
                    System.out.println("\tfully valid? " + valid);
                }
                testResults.put((Object)testVersion, (Object)testOrder, (Object)valid);
            }
        }
        boolean anyValid = false;
        for (Table.Cell cell : testResults.cellSet()) {
            if (!((Boolean)cell.getValue()).booleanValue()) continue;
            Preconditions.checkState((!anyValid ? 1 : 0) != 0, (String)"Multiple valid trans file configurations found, cannot detect. Both of these are valid:\n\t%s, %s\n\t%s, %s", (Object)((Object)this.version), (Object)this.byteOrder, (Object)cell.getRowKey(), (Object)cell.getColumnKey());
            this.version = (TransVersion)((Object)cell.getRowKey());
            this.byteOrder = (ByteOrder)cell.getColumnKey();
            anyValid = true;
            System.out.println("Detected " + String.valueOf((Object)this.version) + ", " + String.valueOf(this.byteOrder));
        }
        if (!anyValid) {
            System.out.println("Failed to detect! Debugging, firstPatch=" + elements.get(0).getID() + ", lastPatch=" + elements.get(elements.size() - 1).getID());
            System.out.println("Failed patch IDs for each configuration:");
            for (TransVersion testVersion : testVersions) {
                for (ByteOrder testOrder : testOrders) {
                    System.out.println(String.valueOf((Object)testVersion) + ", " + String.valueOf(testOrder) + ":\t" + String.valueOf(testFailPatches.get((Object)testVersion, (Object)testOrder)));
                }
            }
            long[] debugPositions = new long[]{0L, 8L, 12L, 16L, 20L, 21L};
            for (ByteOrder testOrder : testOrders) {
                System.out.println("Debugging detection with " + String.valueOf(testOrder));
                byte[] buffer = new byte[8];
                IntBuffer intRecord = ByteBuffer.wrap(buffer).order(testOrder).asIntBuffer();
                FloatBuffer floatRecord = ByteBuffer.wrap(buffer).order(testOrder).asFloatBuffer();
                doubleRecord = ByteBuffer.wrap(buffer).order(testOrder).asDoubleBuffer();
                for (long pos : debugPositions) {
                    System.out.println("POSITION: " + pos);
                    this.raFile.seek(pos);
                    this.raFile.read(buffer);
                    System.out.println("\tByte:\t" + buffer[0]);
                    System.out.println("\tInt:\t" + intRecord.get(0));
                    System.out.println("\tFloat:\t" + floatRecord.get(0));
                    System.out.println("\tDouble:\t" + doubleRecord.get(0));
                }
            }
        }
        Preconditions.checkState((boolean)anyValid, (Object)"Could not detect transition file type");
    }

    private synchronized void initTimeMarkers() throws IOException {
        int timeIndexSize = 1000;
        if ((long)timeIndexSize > this.numTransitions) {
            timeIndexSize = (int)this.numTransitions;
        }
        this.timeMarkers = new double[timeIndexSize];
        this.indexMarkers = new long[timeIndexSize];
        long numEach = this.numTransitions / (long)timeIndexSize;
        System.out.println("Initializing " + timeIndexSize + " time/index markers (" + numEach + " each bin)");
        this.transPerRead = numEach > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)numEach;
        for (int i = 0; i < timeIndexSize; ++i) {
            long index = numEach * (long)i;
            this.timeMarkers[i] = this.read((long)index, (int)1)[0].absoluteTime;
            this.indexMarkers[i] = index;
            if (i <= 0) continue;
            Preconditions.checkState((this.timeMarkers[i] >= this.timeMarkers[i - 1] ? 1 : 0) != 0, (String)"File is out of order: %s, %s", (Object)this.timeMarkers[i - 1], (Object)this.timeMarkers[i]);
        }
        System.out.println("Done initializing time/index markers: [" + this.timeMarkers[0] / 3.1536E7 + " " + this.timeMarkers[this.timeMarkers.length - 1] / 3.1536E7 + "]");
    }

    public void setPatchFixedVelocities(Map<Integer, Double> patchFixedVels) {
        this.patchFixedVels = patchFixedVels;
    }

    public void setRetainNegativeSlips(boolean retainNegatives) {
        this.retainNegatives = retainNegatives;
    }

    public TransVersion getVersion() {
        return this.version;
    }

    public synchronized RSQSimStateTime[] read(long index, int num) throws IOException {
        RSQSimStateTime[] ret;
        byte[] buffer;
        Preconditions.checkState((index >= 0L ? 1 : 0) != 0, (String)"Bad index: %s", (long)index);
        long seek = index * (long)this.bytesPerRecord;
        this.raFile.seek(seek);
        if (index + (long)num > this.numTransitions) {
            num = (int)(this.numTransitions - index);
        }
        int len = this.bytesPerRecord * num;
        if (num == this.transPerRead && (this.curTrans == null || this.curTrans.length == num)) {
            if (this.fullBuffer == null) {
                this.fullBuffer = new byte[len];
            }
            buffer = this.fullBuffer;
            if (this.curTrans == null) {
                this.curTrans = new RSQSimStateTime[num];
            } else {
                Preconditions.checkState((this.curTrans.length == num ? 1 : 0) != 0, (String)"Reusing curTrans, but it's of wrong len: %s != %s", (int)this.curTrans.length, (int)num);
            }
            ret = this.curTrans;
        } else {
            buffer = new byte[len];
            ret = new RSQSimStateTime[num];
        }
        this.raFile.readFully(buffer, 0, len);
        for (int i = 0; i < num; ++i) {
            try {
                float velocity;
                RSQSimState state;
                byte stateInt;
                int eventID;
                int patchID;
                float relativeTime;
                double absoluteTime;
                int srcPos = i * this.bytesPerRecord;
                if (this.version == TransVersion.ORIGINAL || this.version == TransVersion.TRANSV) {
                    absoluteTime = this.readDouble(buffer, srcPos);
                    relativeTime = Float.NaN;
                    patchID = this.readInt(buffer, srcPos += 8) + 1;
                    eventID = -1;
                    stateInt = buffer[srcPos += 4];
                    ++srcPos;
                    state = RSQSimState.forInt(stateInt);
                    if (this.version == TransVersion.TRANSV) {
                        velocity = (float)this.readDouble(buffer, srcPos);
                    } else {
                        Preconditions.checkNotNull(this.patchFixedVels, (Object)"Old transitions format, must set individual patch velocities with setPatchFixedVelocities(Map<Integer,Double)");
                        Double patchVel = this.patchFixedVels.get(patchID);
                        Preconditions.checkNotNull((Object)patchVel, (String)"No velocity for patch %s", (int)patchID);
                        velocity = patchVel.floatValue();
                    }
                } else if (this.version == TransVersion.CONSOLIDATED_RELATIVE) {
                    absoluteTime = this.readDouble(buffer, srcPos);
                    relativeTime = this.readFloat(buffer, srcPos += 8);
                    eventID = this.readInt(buffer, srcPos += 4);
                    patchID = this.readInt(buffer, srcPos += 4) + 1;
                    stateInt = buffer[srcPos += 4];
                    state = RSQSimState.forInt(stateInt);
                    velocity = this.readFloat(buffer, ++srcPos);
                } else {
                    throw new IllegalStateException("Unsupported transition version: " + String.valueOf((Object)this.version));
                }
                if (i > 0) {
                    Preconditions.checkState((absoluteTime >= ret[i - 1].absoluteTime ? 1 : 0) != 0, (String)"File is out of order: %s, %s", (Object)ret[i - 1].absoluteTime, (Object)absoluteTime);
                }
                if (velocity < 0.0f && state == RSQSimState.EARTHQUAKE_SLIP && !this.retainNegatives) {
                    System.err.println("WARNING: Bad (negative) velocity, setting to 1e-6 as temporary fix");
                    velocity = 1.0E-6f;
                }
                ret[i] = new RSQSimStateTime(absoluteTime, relativeTime, eventID, patchID, state, velocity);
                continue;
            }
            catch (Exception e) {
                System.out.println();
                System.out.flush();
                String message = "Error reading transition index " + (index + (long)i) + ". Read began at index " + index + " (pos=" + seek + "), this is transition " + i + " of " + num + " in this read";
                if (e instanceof IOException) {
                    throw new IOException(message, e);
                }
                throw new RuntimeException(message, e);
            }
        }
        return ret;
    }

    private double readDouble(byte[] buffer, int index) {
        System.arraycopy(buffer, index, this.doubleBytes, 0, 8);
        return this.doubleBuff.get(0);
    }

    private float readFloat(byte[] buffer, int index) {
        System.arraycopy(buffer, index, this.floatBytes, 0, 4);
        return this.floatBuff.get(0);
    }

    private int readInt(byte[] buffer, int index) {
        System.arraycopy(buffer, index, this.intBytes, 0, 4);
        return this.intBuff.get(0);
    }

    private static void debug_read(File file, long startIndex, int num, ByteOrder byteOrder, TransVersion version) throws IOException {
        RandomAccessFile raFile = new RandomAccessFile(file, "r");
        int bytesPerRecord = version.bytesPerRecord;
        long seek = startIndex * (long)bytesPerRecord;
        System.out.println("Seeking to: " + seek);
        raFile.seek(seek);
        byte[] doubleBytes = new byte[8];
        byte[] floatBytes = new byte[4];
        byte[] intBytes = new byte[4];
        ByteBuffer doubleRecord = ByteBuffer.wrap(doubleBytes);
        doubleRecord.order(byteOrder);
        DoubleBuffer doubleBuff = doubleRecord.asDoubleBuffer();
        ByteBuffer floatRecord = ByteBuffer.wrap(floatBytes);
        floatRecord.order(byteOrder);
        FloatBuffer floatBuff = floatRecord.asFloatBuffer();
        ByteBuffer intRecord = ByteBuffer.wrap(intBytes);
        intRecord.order(byteOrder);
        IntBuffer intBuff = intRecord.asIntBuffer();
        int len = bytesPerRecord * num;
        byte[] buffer = new byte[len];
        raFile.readFully(buffer, 0, len);
        for (int i = 0; i < num; ++i) {
            double time;
            int srcPos = i * bytesPerRecord;
            if (version == TransVersion.ORIGINAL || version == TransVersion.TRANSV) {
                System.arraycopy(buffer, srcPos, doubleBytes, 0, 8);
                time = doubleBuff.get(0);
                System.arraycopy(buffer, srcPos += 8, intBytes, 0, 4);
                int patch = intBuff.get(0);
                byte stateInt = buffer[srcPos += 4];
                ++srcPos;
                if (version == TransVersion.TRANSV) {
                    System.arraycopy(buffer, srcPos, doubleBytes, 0, 8);
                    srcPos += 8;
                    double vel = doubleBuff.get(0);
                    System.out.println(startIndex + (long)i + ":\t" + time + "\t" + patch + "\t" + stateInt + "\t" + vel);
                    continue;
                }
                System.out.println(startIndex + (long)i + ":\t" + time + "\t" + patch + "\t" + stateInt);
                continue;
            }
            if (version == TransVersion.CONSOLIDATED_RELATIVE) {
                System.arraycopy(buffer, srcPos, doubleBytes, 0, 8);
                time = doubleBuff.get(0);
                System.arraycopy(buffer, srcPos += 8, doubleBytes, 0, 8);
                double relTime = doubleBuff.get(0);
                System.arraycopy(buffer, srcPos += 8, intBytes, 0, 4);
                int event = intBuff.get(0);
                System.arraycopy(buffer, srcPos += 4, intBytes, 0, 4);
                int patch = intBuff.get(0);
                byte stateInt = buffer[srcPos += 4];
                System.arraycopy(buffer, ++srcPos, floatBytes, 0, 4);
                srcPos += 8;
                float vel = floatBuff.get(0);
                System.out.println(startIndex + (long)i + ":\t" + time + "\t" + relTime + "\t" + event + "\t" + patch + "\t" + stateInt + "\t" + vel);
                continue;
            }
            raFile.close();
            throw new IllegalStateException("Unsupported transition version: " + String.valueOf((Object)version));
        }
        raFile.close();
    }

    private static void debug_read_all_transV(File file, ByteOrder byteOrder) throws IOException {
        RandomAccessFile raFile = new RandomAccessFile(file, "r");
        int bytesPerRecord = TransVersion.TRANSV.bytesPerRecord;
        byte[] doubleBytes = new byte[8];
        byte[] intBytes = new byte[4];
        ByteBuffer doubleRecord = ByteBuffer.wrap(doubleBytes);
        doubleRecord.order(byteOrder);
        DoubleBuffer doubleBuff = doubleRecord.asDoubleBuffer();
        ByteBuffer intRecord = ByteBuffer.wrap(intBytes);
        intRecord.order(byteOrder);
        IntBuffer intBuff = intRecord.asIntBuffer();
        long file_length = raFile.length();
        long num = file_length / (long)bytesPerRecord;
        int numPerBuffer = 10000;
        int bufferLen = bytesPerRecord * numPerBuffer;
        byte[] buffer = new byte[bufferLen];
        long transitionIndex = 0L;
        long filePos = 0L;
        int numBad = 0;
        block0: while (transitionIndex <= num) {
            for (int i = 0; i < numPerBuffer; ++i) {
                if (transitionIndex == num) break block0;
                if (i == 0) {
                    long numLeft = num - transitionIndex;
                    int numToRead = (int)Long.min(numLeft, numPerBuffer);
                    raFile.readFully(buffer, 0, numToRead * bytesPerRecord);
                }
                int srcPos = i * bytesPerRecord;
                System.arraycopy(buffer, srcPos, doubleBytes, 0, 8);
                double time = doubleBuff.get(0);
                System.arraycopy(buffer, srcPos += 8, intBytes, 0, 4);
                int patch = intBuff.get(0);
                byte stateInt = buffer[srcPos += 4];
                System.arraycopy(buffer, ++srcPos, doubleBytes, 0, 8);
                srcPos += 8;
                double vel = doubleBuff.get(0);
                if (stateInt == 2 && vel <= 0.0) {
                    System.out.println("Bad velocity at transition " + transitionIndex + " at pos=" + (filePos + (long)(i * bytesPerRecord)));
                    for (int j = i - 1; j < numPerBuffer && j <= i + 1; ++j) {
                        srcPos = j * bytesPerRecord;
                        System.arraycopy(buffer, srcPos, doubleBytes, 0, 8);
                        time = doubleBuff.get(0);
                        System.arraycopy(buffer, srcPos += 8, intBytes, 0, 4);
                        patch = intBuff.get(0);
                        stateInt = buffer[srcPos += 4];
                        System.arraycopy(buffer, ++srcPos, doubleBytes, 0, 8);
                        srcPos += 8;
                        vel = doubleBuff.get(0);
                        System.out.println("\t" + (transitionIndex + (long)(j - i)) + ":\t" + time + "\t" + patch + "\t" + stateInt + "\t" + vel);
                        ++numBad;
                    }
                }
                ++transitionIndex;
                filePos += (long)srcPos;
            }
        }
        System.out.println("Num bad: " + numBad);
        raFile.close();
    }

    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    private synchronized RSQSimStateTime readTransition(long index) throws IOException {
        if (this.timeMarkers == null) {
            this.initTimeMarkers();
        }
        long arrayIndex = index - this.curIndex;
        if (this.curTrans != null && arrayIndex >= 0L && arrayIndex < Integer.MAX_VALUE && arrayIndex < (long)this.curTrans.length) {
            return this.curTrans[(int)arrayIndex];
        }
        if (!this.quiet) {
            System.out.print("Caching " + this.transPerRead + " transitions at index " + index + "...");
        }
        this.curIndex = index;
        this.curTrans = this.read(index, this.transPerRead);
        ++this.batchReads;
        if (arrayIndex < 0L) {
            ++this.backwardReads;
        }
        if (!this.quiet) {
            System.out.println("DONE");
        }
        return this.curTrans[0];
    }

    public List<RSQSimStateTime> getTransitions(double startTime, double endTime) throws IOException {
        ArrayList<RSQSimStateTime> trans = new ArrayList<RSQSimStateTime>();
        long index = this.getIndexBefore(startTime);
        HashMap<Integer, RSQSimStateTime> prevPatchTrans = new HashMap<Integer, RSQSimStateTime>();
        int numOpenSlip = 0;
        while (index < this.numTransitions) {
            RSQSimStateTime transition = this.readTransition(index++);
            double time = transition.absoluteTime;
            if (time < startTime) continue;
            int patchID = transition.patchID;
            if (prevPatchTrans.containsKey(patchID)) {
                RSQSimStateTime prevTrans = (RSQSimStateTime)prevPatchTrans.remove(patchID);
                prevTrans.setNextTransition(transition);
                if (prevTrans.state == RSQSimState.EARTHQUAKE_SLIP) {
                    --numOpenSlip;
                }
            }
            if (time <= endTime) {
                if (transition.state == RSQSimState.EARTHQUAKE_SLIP) {
                    ++numOpenSlip;
                }
                prevPatchTrans.put(patchID, transition);
                trans.add(transition);
                continue;
            }
            if (numOpenSlip != 0 && !(time > endTime + MAX_POST_READ)) continue;
            break;
        }
        if (numOpenSlip != 0) {
            System.err.println("WARNING: " + numOpenSlip + " EARTHQUAKE_SLIP transitions don't have durations");
        }
        return trans;
    }

    public synchronized Iterable<RSQSimStateTime> getTransitionsIterable(double startTime, double endTime) throws IOException {
        return this.getTransitionsIterable((Range<Double>)Range.closed((Comparable)Double.valueOf(startTime), (Comparable)Double.valueOf(endTime)));
    }

    public synchronized Iterable<RSQSimStateTime> getTransitionsIterable(Range<Double> timeRange) throws IOException {
        if (this.timeMarkers == null) {
            this.initTimeMarkers();
        }
        final TransIterator it = new TransIterator(timeRange);
        return new Iterable<RSQSimStateTime>(){
            final /* synthetic */ RSQSimStateTransitionFileReader this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Iterator<RSQSimStateTime> iterator() {
                return it;
            }
        };
    }

    public Map<Integer, List<RSQSimStateTime>> getTransitions(RSQSimEvent event) throws IOException {
        return this.getTransitions(event, null);
    }

    public Map<Integer, List<RSQSimStateTime>> getTransitions(RSQSimEvent event, List<RSQSimStateTime> transList) throws IOException {
        int patchID;
        HashMap<Integer, List<RSQSimStateTime>> patchTransitions = new HashMap<Integer, List<RSQSimStateTime>>();
        double startTime = event.getTime();
        double nextEventTime = event.getNextEventTime();
        Preconditions.checkState((!Double.isNaN(nextEventTime) ? 1 : 0) != 0);
        if (transList != null) {
            Preconditions.checkState((boolean)transList.isEmpty(), (Object)"passed in transList should be empty (will be populated in order)");
        }
        for (EventRecord rec : event) {
            Preconditions.checkState((boolean)(rec instanceof RSQSimEventRecord));
            RSQSimEventRecord rsRecord = (RSQSimEventRecord)rec;
            int[] recPatchIDs = rsRecord.getElementIDs();
            Preconditions.checkNotNull((Object)recPatchIDs);
            for (int i = 0; i < recPatchIDs.length; ++i) {
                patchTransitions.put(recPatchIDs[i], new ArrayList());
            }
        }
        double maxEndTime = startTime + MAX_POST_READ;
        int eventID = event.getID();
        long index = this.getIndexBefore(startTime);
        int debugEventID = 53897;
        boolean debug = debugEventID == eventID;
        int numPreReads = 0;
        int numDuringReads = 0;
        int numPostReads = 0;
        int numAssociated = 0;
        if (debug) {
            System.out.println("Reading transitions for event " + event.getID() + ", a M" + (float)event.getMagnitude() + " at " + startTime + ", next event is at " + nextEventTime);
            System.out.println("\tEvent patches: " + Joiner.on((String)",").join((Iterable)Ints.asList((int[])event.getAllElementIDs())));
        }
        int numOpen = 0;
        while (index < this.numTransitions) {
            boolean thisEvent;
            RSQSimStateTime prevTrans;
            RSQSimStateTime trans = this.readTransition(index++);
            patchID = trans.patchID;
            double time = trans.absoluteTime;
            boolean related = patchTransitions.containsKey(patchID);
            if (trans.eventID >= 0) {
                if (trans.eventID < eventID) {
                    if (debug) {
                        System.out.println(index + " is BEFORE: " + String.valueOf(trans) + " related ? " + related);
                    }
                    ++numPreReads;
                    continue;
                }
                if (trans.eventID > eventID) {
                    if (debug) {
                        System.out.println(index + " is AFTER: " + String.valueOf(trans) + ", closing " + numOpen + " patches. related ? " + related);
                    }
                    ++numPostReads;
                    if (time > maxEndTime || numOpen == 0) {
                        break;
                    }
                } else {
                    ++numDuringReads;
                }
                if (debug) {
                    System.out.println(index + " is DURING: " + String.valueOf(trans) + " related ? " + related);
                }
            } else {
                if (time < startTime) {
                    if (debug) {
                        System.out.println(index + " is BEFORE: " + String.valueOf(trans) + " related ? " + related);
                    }
                    ++numPreReads;
                    continue;
                }
                if (time >= nextEventTime) {
                    if (debug) {
                        System.out.println(index + " is AFTER: " + String.valueOf(trans) + ", closing " + numOpen + " patches. related ? " + related);
                    }
                    ++numPostReads;
                    if (numOpen == 0) {
                        break;
                    }
                } else {
                    if (debug) {
                        System.out.println(index + " is DURING: " + String.valueOf(trans) + " related ? " + related);
                    }
                    ++numDuringReads;
                }
                if (time >= maxEndTime) {
                    ++numPostReads;
                    break;
                }
            }
            if (!related) continue;
            List patchTimes = (List)patchTransitions.get(patchID);
            RSQSimStateTime rSQSimStateTime = prevTrans = patchTimes.isEmpty() ? null : (RSQSimStateTime)patchTimes.get(patchTimes.size() - 1);
            if (prevTrans != null) {
                if (prevTrans.state == RSQSimState.EARTHQUAKE_SLIP) {
                    --numOpen;
                }
                prevTrans.setNextTransition(trans);
            }
            if (trans.state == RSQSimState.LOCKED && (prevTrans == null || prevTrans.state == RSQSimState.LOCKED)) continue;
            if (trans.eventID < 0) {
                thisEvent = time < nextEventTime;
            } else {
                boolean bl = thisEvent = eventID == trans.eventID;
                if (thisEvent) {
                    Preconditions.checkState(((float)time <= (float)nextEventTime && (float)time >= (float)startTime ? 1 : 0) != 0, (String)"Matched transitions with eventIDs, but times don't make sense.\n\tTrans time: %s, event time: %s, next event time: %s\n\ttrans: %s", (Object)time, (Object)startTime, (Object)nextEventTime, (Object)trans);
                }
            }
            if (!thisEvent && trans.state == RSQSimState.LOCKED && time == nextEventTime) {
                boolean bl = thisEvent = prevTrans != null && prevTrans.state != RSQSimState.LOCKED;
            }
            if (!thisEvent) continue;
            if (!Double.isFinite(trans.relativeTime)) {
                float relativeTime = (float)(trans.absoluteTime - startTime);
                trans = new RSQSimStateTime(trans.absoluteTime, relativeTime, eventID, patchID, trans.state, trans.velocity);
            }
            if (trans.eventID < 0) {
                trans = new RSQSimStateTime(trans.absoluteTime, trans.relativeTime, eventID, patchID, trans.state, trans.velocity);
            }
            if (transList != null) {
                transList.add(trans);
            }
            patchTimes.add(trans);
            ++numAssociated;
            if (trans.state != RSQSimState.EARTHQUAKE_SLIP) continue;
            ++numOpen;
        }
        Iterator iterator = patchTransitions.keySet().iterator();
        while (iterator.hasNext()) {
            patchID = (Integer)iterator.next();
            List patchTimes = (List)patchTransitions.get(patchID);
            if (!patchTimes.isEmpty()) {
                RSQSimStateTime patchTime = (RSQSimStateTime)patchTimes.get(patchTimes.size() - 1);
                if (patchTime.state == RSQSimState.NUCLEATING_SLIP || patchTime.state == RSQSimState.EARTHQUAKE_SLIP) {
                    Preconditions.checkState((boolean)patchTime.hasDuration(), (String)"Duration not populated for patch %s in event %s", (int)patchID, (int)eventID);
                }
                int lastIndex = 0;
                RSQSimState prevState = null;
                for (int i = 0; i < patchTimes.size(); ++i) {
                    RSQSimState myState = ((RSQSimStateTime)patchTimes.get((int)i)).state;
                    if (myState == RSQSimState.EARTHQUAKE_SLIP) {
                        lastIndex = i;
                    } else if (prevState != null && prevState == RSQSimState.EARTHQUAKE_SLIP && myState == RSQSimState.LOCKED) {
                        lastIndex = i;
                    }
                    prevState = myState;
                }
                while (patchTimes.size() > lastIndex + 1) {
                    patchTimes.remove(patchTimes.size() - 1);
                }
            }
            if (!debug) continue;
            System.out.println("Patch " + patchID + " has " + patchTimes.size() + " transitions");
        }
        if (debug) {
            System.out.println("Read stats:");
            System.out.println("\t" + numPreReads + " transitions read before event");
            System.out.println("\t" + numDuringReads + " transitions read during event");
            System.out.println("\t" + numPostReads + " transitions read after event");
            System.out.println("\t" + numAssociated + " transitions were associated with event");
        }
        return patchTransitions;
    }

    public synchronized long getIndexBefore(double time) throws IOException {
        if (this.timeMarkers == null) {
            this.initTimeMarkers();
        }
        if (time < this.timeMarkers[0]) {
            return 0L;
        }
        int bucketIndex = Arrays.binarySearch(this.timeMarkers, time);
        if (bucketIndex < 0) {
            bucketIndex = -bucketIndex - 2;
        }
        Preconditions.checkState((bucketIndex >= 0 && bucketIndex < this.timeMarkers.length ? 1 : 0) != 0);
        if (time == this.timeMarkers[bucketIndex] && bucketIndex > 0) {
            --bucketIndex;
        }
        long minIndex = this.indexMarkers[bucketIndex];
        if (this.curTrans != null && minIndex - this.curIndex < (long)(Integer.MAX_VALUE - this.curTrans.length)) {
            for (long nextArrayIndex = 1L + minIndex - this.curIndex; nextArrayIndex >= 0L && nextArrayIndex < (long)this.curTrans.length && this.curTrans[(int)nextArrayIndex].absoluteTime < time; ++nextArrayIndex) {
                ++minIndex;
            }
        }
        return minIndex;
    }

    public synchronized double getFirstTransitionTime() throws IOException {
        if (Double.isNaN(this.firstTime)) {
            this.firstTime = this.read((long)0L, (int)1)[0].absoluteTime;
        }
        return this.firstTime;
    }

    public synchronized double getLastTransitionTime() throws IOException {
        if (Double.isNaN(this.lastTime)) {
            this.lastTime = this.read((long)(this.numTransitions - 1L), (int)1)[0].absoluteTime;
        }
        return this.lastTime;
    }

    public static void printTransitions(RSQSimEvent e, Map<Integer, List<RSQSimStateTime>> transitions) {
        RSQSimStateTransitionFileReader.printTransitions(e, transitions, System.out);
    }

    public static void printTransitions(RSQSimEvent e, Map<Integer, List<RSQSimStateTime>> transitions, PrintStream stream) {
        stream.println("Transitions for event " + e.getID() + " (M" + (float)e.getMagnitude() + ") at time " + e.getTimeInYears() + " yr");
        for (int patchID : e.getAllElementIDs()) {
            List<RSQSimStateTime> patchTrans = transitions.get(patchID);
            stream.println("PATCH " + patchID);
            for (RSQSimStateTime trans : patchTrans) {
                double start = trans.relativeTime;
                double end = trans.hasDuration() ? start + trans.getDuration() : Double.NaN;
                RSQSimState state = trans.state;
                String str = "\t" + timeDF.format(start) + "s\t=>\t" + timeDF.format(end) + "s\t" + String.valueOf((Object)state) + "\t[" + timeDF.format(end - start) + "s";
                if (state == RSQSimState.EARTHQUAKE_SLIP) {
                    str = str + ", " + timeDF.format(trans.velocity) + " m/s";
                }
                str = str + "]";
                stream.println(str);
            }
        }
        stream.flush();
    }

    public static void main(String[] args) throws IOException {
        TransVersion version = null;
        if (args.length == 1 && args[0].equals("--hardcoded")) {
            File dir = new File("/data-0/kevin/simulators/catalogs/rundir4983_stitched/plausibility_filtered");
            File geomFile = new File(dir.getParentFile(), "zfault_Deepen.in");
            File transFile = new File(dir, "trans.filtered.out");
            String str = "--print-rup " + transFile.getAbsolutePath() + " " + geomFile.getAbsolutePath() + " 6537";
            args = (String[])Iterables.toArray((Iterable)Splitter.on((String)" ").split((CharSequence)str), String.class);
        }
        if (args.length > 0 && args[0].equals("--debug")) {
            File file;
            if (args.length != 5) {
                System.err.println("USAGE: --debug <trans-file> <start-index> <num> <little/big>");
                System.exit(2);
            }
            version = (file = new File(args[1])).getName().toLowerCase().contains("transv") ? TransVersion.TRANSV : TransVersion.CONSOLIDATED_RELATIVE;
            long startIndex = Long.parseLong(args[2]);
            int num = Integer.parseInt(args[3]);
            ByteOrder byteOrder = null;
            if (args[4].toLowerCase().startsWith("little")) {
                byteOrder = ByteOrder.LITTLE_ENDIAN;
            } else if (args[4].toLowerCase().startsWith("big")) {
                byteOrder = ByteOrder.LITTLE_ENDIAN;
            } else {
                System.out.println("Expected 'little' or 'big'");
                System.exit(2);
            }
            System.out.println("Version: " + String.valueOf((Object)version));
            if (version == TransVersion.TRANSV && num <= 0) {
                System.out.println("Debugging bad velocities");
                RSQSimStateTransitionFileReader.debug_read_all_transV(file, byteOrder);
            } else {
                System.out.println("Reading " + num + " starting at " + startIndex);
                RSQSimStateTransitionFileReader.debug_read(file, startIndex, num, byteOrder, version);
            }
            System.exit(0);
        } else if (args.length > 0 && args[0].equals("--print-rup")) {
            File transFile;
            if (args.length < 4) {
                System.err.println("USAGE: --print-rup <trans-file> <geom-file> <rup-index-1> [...<rup-index-N>]");
                System.exit(2);
            }
            version = (transFile = new File(args[1]).getAbsoluteFile()).getName().toLowerCase().contains("transv") ? TransVersion.TRANSV : TransVersion.CONSOLIDATED_RELATIVE;
            File catalogDir = transFile.getParentFile();
            File geomFile = new File(args[2]);
            int[] rupIDs = new int[args.length - 3];
            for (int i = 0; i < rupIDs.length; ++i) {
                rupIDs[i] = Integer.parseInt(args[3 + i]);
            }
            System.out.println("Loading geometry...");
            List<SimulatorElement> elements = RSQSimFileReader.readGeometryFile(geomFile, 11, 'S');
            System.out.println("Loaded " + elements.size() + " elements");
            ArrayList<EventIDsRupIden> loadIdens = new ArrayList<EventIDsRupIden>();
            EventIDsRupIden loadIden = new EventIDsRupIden(rupIDs);
            loadIdens.add(loadIden);
            System.out.println("Loading events...");
            List<RSQSimEvent> events = RSQSimFileReader.readEventsFile(catalogDir, elements, loadIdens);
            System.out.println("Loaded " + events.size() + " events");
            RSQSimStateTransitionFileReader transReader = new RSQSimStateTransitionFileReader(transFile, elements, version);
            System.out.println("Transition file starts at " + transReader.getFirstTransitionTime() + " seconds");
            System.out.println("Transition file ends at " + transReader.getLastTransitionTime() + " seconds");
            for (RSQSimEvent e : events) {
                System.out.println("************************************************");
                double secsFromEnd = transReader.getLastTransitionTime() - e.getTime();
                System.out.println("Event " + e.getID() + " at t=" + e.getTime() + " s (" + (float)secsFromEnd + " s from end of trans file)");
                Map<Integer, List<RSQSimStateTime>> transitions = transReader.getTransitions(e);
                RSQSimStateTransitionFileReader.printTransitions(e, transitions);
                System.out.println("************************************************");
            }
            System.exit(0);
        }
    }

    public static enum TransVersion {
        ORIGINAL(13),
        TRANSV(21),
        CONSOLIDATED_RELATIVE(25);

        public final int bytesPerRecord;

        private TransVersion(int bytesPerRecord) {
            this.bytesPerRecord = bytesPerRecord;
        }
    }

    private class TransIterator
    implements Iterator<RSQSimStateTime> {
        private long index;
        private Range<Double> timeRange;
        private double startTime;
        private double maxTime;
        private LinkedList<RSQSimStateTime> curList;
        private Map<Integer, RSQSimStateTime> patchPrevSlips;

        public TransIterator(Range<Double> timeRange) throws IOException {
            this.timeRange = timeRange;
            this.startTime = (Double)timeRange.lowerEndpoint();
            this.index = this.startTime < RSQSimStateTransitionFileReader.this.timeMarkers[0] ? 0L : RSQSimStateTransitionFileReader.this.getIndexBefore(this.startTime);
            this.curList = new LinkedList();
            this.patchPrevSlips = new HashMap<Integer, RSQSimStateTime>();
            this.maxTime = (Double)timeRange.upperEndpoint() + MAX_POST_READ;
        }

        @Override
        public synchronized boolean hasNext() {
            if (!this.curList.isEmpty()) {
                return true;
            }
            if (this.index >= RSQSimStateTransitionFileReader.this.numTransitions) {
                return false;
            }
            try {
                RSQSimStateTime trans = RSQSimStateTransitionFileReader.this.readTransition(this.index);
                double time = trans.absoluteTime;
                while (time <= this.startTime && !this.timeRange.contains((Comparable)Double.valueOf(time))) {
                    ++this.index;
                    if (this.index >= RSQSimStateTransitionFileReader.this.numTransitions) {
                        return false;
                    }
                    trans = RSQSimStateTransitionFileReader.this.readTransition(this.index);
                    time = trans.absoluteTime;
                }
                return this.timeRange.contains((Comparable)Double.valueOf(time));
            }
            catch (IOException e) {
                throw ExceptionUtils.asRuntimeException(e);
            }
        }

        private boolean isFirstReady() {
            RSQSimStateTime first = this.curList.peekFirst();
            return first.hasDuration() || first.state != RSQSimState.EARTHQUAKE_SLIP || this.curList.peekLast().absoluteTime - first.absoluteTime > MAX_POST_READ;
        }

        @Override
        public synchronized RSQSimStateTime next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            while (this.index < RSQSimStateTransitionFileReader.this.numTransitions && (this.curList.isEmpty() || !this.isFirstReady())) {
                try {
                    RSQSimStateTime trans = RSQSimStateTransitionFileReader.this.readTransition(this.index);
                    ++this.index;
                    if (this.patchPrevSlips.containsKey(trans.patchID)) {
                        RSQSimStateTime prevTrans = this.patchPrevSlips.remove(trans.patchID);
                        prevTrans.setNextTransition(trans);
                    }
                    if (this.timeRange.contains((Comparable)Double.valueOf(trans.absoluteTime))) {
                        this.patchPrevSlips.put(trans.patchID, trans);
                        this.curList.add(trans);
                    } else if (trans.absoluteTime > this.maxTime) {
                        System.err.println("Didn't close all patches but read past max post read, bailing");
                        break;
                    }
                    if (this.index != RSQSimStateTransitionFileReader.this.numTransitions || this.isFirstReady()) continue;
                    System.err.println("Didn't close all patches but read through to end of transitions file");
                }
                catch (IOException e) {
                    throw ExceptionUtils.asRuntimeException(e);
                }
            }
            return this.curList.removeFirst();
        }
    }
}

